/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.archiving.ArchivalTempFileCache;
import com.cognos.cm.archiving.DataDescriptorPropertyValueBuilder;
import com.cognos.cm.archiving.IArchivedProperty;
import com.cognos.cm.archiving.IDataDescriptorPropertyValueBuilder;
import com.cognos.cm.contentTasks.actions.CleanupAction;
import com.cognos.cm.contentTasks.actions.CollectConfigurableMetadataAction;
import com.cognos.cm.contentTasks.actions.ContentObjectArchivalAction;
import com.cognos.cm.contentTasks.actions.IArchivalTaskActionBuilder;
import com.cognos.cm.contentTasks.actions.RepositoryDataSizeCounter;
import com.cognos.cm.contentTasks.actions.RepositoryTimer;
import com.cognos.cm.contentTasks.cleanupTask.ArchivalTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.ArchiveDataDescriptorBuilder;
import com.cognos.cm.contentTasks.cleanupTask.ArchiveWriteDataOptionsBuilder;
import com.cognos.cm.contentTasks.cleanupTask.DataObjectBuilder;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.IDataDescriptorBuilder;
import com.cognos.cm.contentTasks.cleanupTask.IStoreWithLockManager;
import com.cognos.cm.contentTasks.cleanupTask.OutputDataObjectBuilder;
import com.cognos.cm.contentTasks.cleanupTask.WriteDataOptionsBuilder;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.AllInOneCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.externalRepository.RepositoryConnectionProvider;
import com.cognos.cm.externalRepository.RepositoryHttpClientFactory;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.repositoryPluginAPI.IRepositoryDataSizeCounter;
import com.cognos.cm.repositoryPluginAPI.IRepositoryTimer;
import com.cognos.cm.repositoryPluginAPI.IRepositoryUserAgentFactory;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMTempFileCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ArchivalTaskActionBuilder
implements IArchivalTaskActionBuilder {
    static final String REPOSITORY_URL_NAMESPACE = "repository:";
    private final ArchivalTaskContext taskContext;
    private final RepositoryConnectionProvider repositoryConnectionProvider;
    private DataObjectBuilder objectBuilder;
    private WriteDataOptionsBuilder optionsBuilder;
    private IDataDescriptorBuilder descriptorBuilder;
    private IDataDescriptorPropertyValueBuilder propertyValueBuilder;
    private String repositoryConnectionName;
    private CMTempFileCache tempFileCache;
    private IRepositoryUserAgentFactory userAgentFactory;
    public static Counter inRepository = new AllInOneCounter().makeThreadLocal();
    private static Timer timer = new Timer(inRepository);
    public static Counter repositoryDataSize = new AccumulatingCounter().makeThreadLocal();

    public ArchivalTaskActionBuilder(ArchivalTaskContext taskContext, String repositoryConnectionName, RepositoryConnectionProvider repositoryConnectionProvider) {
        this.taskContext = taskContext;
        this.repositoryConnectionName = repositoryConnectionName;
        this.repositoryConnectionProvider = repositoryConnectionProvider;
    }

    @Override
    public void initialize() {
        this.tempFileCache = ArchivalTempFileCache.get();
        this.setArchivalBuilders();
        this.userAgentFactory = this.createUserAgentFactory();
    }

    protected IRepositoryUserAgentFactory createUserAgentFactory() {
        return new RepositoryHttpClientFactory();
    }

    private void setArchivalBuilders() {
        this.setOutputDataObjectBuilder(new OutputDataObjectBuilder(this.getStoreWithLockManager(), this.tempFileCache));
        this.setArchiveDataDescriptorBuilder(new ArchiveDataDescriptorBuilder());
        this.setWriteDataOptionsBuilder(new ArchiveWriteDataOptionsBuilder());
        this.setPropertyValueBuilder(new DataDescriptorPropertyValueBuilder(this.tempFileCache));
    }

    protected IStoreWithLockManager getStoreWithLockManager() {
        return this.getTaskContext().getStoreWithLockManager();
    }

    private ArchivalTaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public IContentObjectAction createObjectArchivalAction(RepositoryConnection connection) throws CMException {
        Properties options = new Properties();
        this.optionsBuilder.setBaseOptions(options);
        return new ContentObjectArchivalAction(this.getTaskContext(), connection, this.objectBuilder, this.descriptorBuilder, this.optionsBuilder);
    }

    @Override
    public IContentObjectAction createCleanupAction() {
        return new CleanupAction(this.getTaskContext());
    }

    private CMStore getStore() {
        return this.getStoreWithLockManager().getStore();
    }

    private void setOutputDataObjectBuilder(DataObjectBuilder objectBuilder2) {
        this.objectBuilder = objectBuilder2;
    }

    private void setWriteDataOptionsBuilder(WriteDataOptionsBuilder optionsBuilder2) {
        this.optionsBuilder = optionsBuilder2;
    }

    private void setArchiveDataDescriptorBuilder(IDataDescriptorBuilder descriptorBuilder2) {
        this.descriptorBuilder = descriptorBuilder2;
    }

    private void setPropertyValueBuilder(IDataDescriptorPropertyValueBuilder propertyValueBuilder2) {
        this.propertyValueBuilder = propertyValueBuilder2;
    }

    @Override
    public RepositoryConnection getArchiveConnection(int tenantID) throws CMException {
        String repositoryConnectionName = this.getRepositoryConnectionName();
        RepositoryConnection connection = this.repositoryConnectionProvider.getRepositoryConnection(this.getStore(), repositoryConnectionName, tenantID, "CM", null, this.userAgentFactory);
        IRepositoryTimer repositoryTimer = this.createRepositoryTimer();
        connection.setTimeCounter(repositoryTimer);
        RepositoryDataSizeCounter repositoryWrittenBytes = this.createRepositoryDataSizeCounter();
        connection.setDataSizeCounter((IRepositoryDataSizeCounter)repositoryWrittenBytes);
        return connection;
    }

    RepositoryDataSizeCounter createRepositoryDataSizeCounter() {
        return new RepositoryDataSizeCounter(repositoryDataSize);
    }

    IRepositoryTimer createRepositoryTimer() {
        RepositoryTimer repositoryTimer = new RepositoryTimer(timer);
        return repositoryTimer;
    }

    String getRepositoryConnectionName() {
        return this.repositoryConnectionName;
    }

    @Override
    public IContentObjectAction createCollectMetadataAction(CMObjectClass objectClass, Collection<IArchivedProperty> archivedProperties) {
        Map<CMProperty, IArchivedProperty> mappedProperties = this.mapProperties(archivedProperties, objectClass);
        return this.createCollectMetadataAction(this.getTaskContext(), mappedProperties);
    }

    protected CollectConfigurableMetadataAction createCollectMetadataAction(ArchivalTaskContext context, Map<CMProperty, IArchivedProperty> properties) {
        return new CollectConfigurableMetadataAction(context, properties, this.propertyValueBuilder);
    }

    private Map<CMProperty, IArchivedProperty> mapProperties(Collection<IArchivedProperty> archivedProperties, CMObjectClass cmObjClass) {
        HashMap<CMProperty, IArchivedProperty> mappedProperties = new HashMap<CMProperty, IArchivedProperty>();
        for (IArchivedProperty property : archivedProperties) {
            String propertyName = property.getName();
            CMProperty cmProperty = cmObjClass.getProperty(propertyName);
            if (cmProperty == null) {
                throw new IllegalStateException("Property '" + propertyName + "' does not exist for class '" + cmObjClass.getName() + "'");
            }
            mappedProperties.put(cmProperty, property);
        }
        return mappedProperties;
    }
}

