/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.constants.ArchiveStatus;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.actions.TaskObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.ITaskContext;
import com.cognos.cm.dbstore.ArchiveStatusUpdater;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.IArchiveStatusUpdater;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;

public class ArchiveStatusAction
extends TaskObjectAction {
    static final String ACTIONCLASSNAME = "archiveStatus";
    private ArchiveStatus status;
    private IArchiveStatusUpdater archiveStatusUpdater;
    private IActionReporter actionReporter;

    public ArchiveStatusAction(ArchiveStatus status, ITaskContext taskContext, IActionReporter actionReporter) {
        super(taskContext);
        this.status = status;
        this.archiveStatusUpdater = this.getArchiveStatusUpdater();
        this.actionReporter = actionReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String objectSearchPath) throws CMException {
        CMStore store = this.getStore();
        ICMLockManager lockManager = this.getLockManager();
        boolean manageTransactionsInternally = !store.inTransaction();
        ICMStorePath searchStorePath = this.getStorePath(objectSearchPath);
        lockManager.requestLocks(searchStorePath);
        CMStoreQueryResults results = null;
        try {
            if (manageTransactionsInternally) {
                store.beginTransaction();
            }
            if ((results = store.executeQuery(searchStorePath, new CMProperty[]{CMProperty._ARCHIVESTATUS}, null, 0, 0, null)).next()) {
                int objectID = results.getObjectID();
                String currentStatus = ((CMString)results.getValue(0)).getValue();
                if (this.updateStatus(currentStatus)) {
                    try {
                        if (this.simulatedException.doCreateSimulatedException(AdvancedSettings.CLEANUPTASKTESTVARIABLE, ACTIONCLASSNAME)) {
                            this.simulatedException.throwNewSimulatedException(this.getClass().getName());
                        }
                        this.archiveStatusUpdater.updateArchiveStatus(objectID, this.status, store);
                        this.reportSuccess(objectSearchPath);
                    }
                    catch (Throwable ex) {
                        this.reportFailureThrowable(objectSearchPath, ex);
                        throw new CMException(ex, "cmArchiveStatusFailureMessage", this.createParameters(objectSearchPath));
                    }
                }
            }
            if (manageTransactionsInternally) {
                store.commitTransaction();
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
            if (manageTransactionsInternally && store.inTransaction()) {
                store.rollbackTransaction();
            }
            lockManager.releaseLocks();
            this.simulatedException.incrementCounter();
        }
    }

    private void reportSuccess(String objectSearchPath) throws CMException {
        this.actionReporter.reportSuccess("cmArchiveStatusSuccessMessage", this.createParameters(objectSearchPath));
    }

    private void reportFailureThrowable(String objectSearchPath, Throwable e) throws CMException {
        this.actionReporter.reportFailureThrowable("cmArchiveStatusFailureMessage", e, this.createParameters(objectSearchPath));
    }

    private CMException.Parm[] createParameters(String objectSearchPath) {
        return new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath), new CMException.Parm("ARCHIVESTATUS", this.status.getValue())};
    }

    protected boolean updateStatus(String currentStatus) {
        return true;
    }

    protected IArchiveStatusUpdater getArchiveStatusUpdater() {
        return new ArchiveStatusUpdater();
    }

    protected ICMStorePath getStorePath(String objectSearchPath) throws CMStoreParseException {
        return new CMStoreXPath(objectSearchPath);
    }
}

