/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.archiving.IArchivedProperty;
import com.cognos.cm.archiving.IArchivedPropertyValueSetter;
import com.cognos.cm.archiving.IDataDescriptorPropertyValueBuilder;
import com.cognos.cm.contentTasks.actions.TaskObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.ArchivalTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.ArchiveDataDescriptor;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;

public class CollectConfigurableMetadataAction
extends TaskObjectAction {
    private static final String ACTIONCLASSNAME = "collectMetadata";
    private final CMProperty[] properties;
    private final Map<CMProperty, IArchivedProperty> propertiesMap;
    private final IDataDescriptorPropertyValueBuilder propertValueBuilder;

    public CollectConfigurableMetadataAction(ArchivalTaskContext taskContext, Map<CMProperty, IArchivedProperty> properties, IDataDescriptorPropertyValueBuilder propertValueBuilder) {
        super(taskContext);
        this.propertiesMap = properties;
        this.properties = this.createPropertiesArray(properties);
        this.propertValueBuilder = propertValueBuilder;
    }

    protected CMProperty[] createPropertiesArray(Map<CMProperty, ?> reportProps) {
        Set<CMProperty> set = reportProps.keySet();
        CMProperty[] properties = new CMProperty[set.size()];
        properties = set.toArray(properties);
        return properties;
    }

    @Override
    public void execute(String searchPath) throws CMException {
        block10: {
            CMStoreXPath reportStorePath = new CMStoreXPath(searchPath);
            CMStoreQueryResults queryResults = null;
            try {
                this.getLockManager().requestLocks(reportStorePath);
                queryResults = this.getStore().executeQuery(reportStorePath, this.properties, null, 0, this.getTaskContext().getTaskSecurityContext().getPermissions(), null, 0, 0);
                if (this.simulatedException.doCreateSimulatedException(AdvancedSettings.CLEANUPTASKTESTVARIABLE, ACTIONCLASSNAME)) {
                    this.simulatedException.throwNewSimulatedException(this.toString());
                }
                if (queryResults.next()) {
                    for (int index = 0; index < this.properties.length; ++index) {
                        CMProperty cmProperty = this.properties[index];
                        int objectId = queryResults.getObjectID();
                        IArchivedProperty archivedProperty = this.propertiesMap.get(cmProperty);
                        Object propertyValueObject = queryResults.getValue(index);
                        boolean wasAcquired = queryResults.wasAcquired();
                        this.setValue(archivedProperty, propertyValueObject, wasAcquired, objectId, cmProperty);
                    }
                    break block10;
                }
                throw new CMException("cmObjectNotFoundPath");
            }
            catch (CMException ce) {
                this.getTaskErrorReporter().reportFailure(searchPath, ce, "cmCollectMetadataFailureMessage");
                throw ce;
            }
            catch (Throwable t) {
                this.getTaskErrorReporter().reportFailureThrowable(searchPath, t, "cmCollectMetadataFailureMessage");
                throw new CMException(t, "cmCollectMetadataFailureMessage");
            }
            finally {
                if (queryResults != null) {
                    queryResults.release();
                }
                this.getLockManager().releaseLocks();
                this.simulatedException.incrementCounter();
            }
        }
    }

    private void setValue(IArchivedProperty property, Object propertyValueObject, boolean wasAcquired, int objectId, CMProperty cmProperty) throws CMException {
        if (propertyValueObject != null) {
            propertyValueObject = property.useTempFile() ? this.wrapValueForTempFile(propertyValueObject, objectId, cmProperty) : this.wrapValue(propertyValueObject);
        }
        IArchivedPropertyValueSetter setter = property.getPropertyValueSetter();
        setter.setValue((IDataDescriptor)this.getContextArchiveDataDescriptor(), propertyValueObject, wasAcquired, cmProperty);
    }

    private Object wrapValue(Object propertyValueObject) {
        if (propertyValueObject instanceof Reader) {
            propertyValueObject = this.propertValueBuilder.createReaderPropertyValue((Reader)propertyValueObject);
        } else if (propertyValueObject instanceof InputStream) {
            propertyValueObject = this.propertValueBuilder.createInputStreamPropertyValue((InputStream)propertyValueObject);
        }
        return propertyValueObject;
    }

    private Object wrapValueForTempFile(Object propertyValueObject, int objectId, CMProperty cmProperty) throws CMException {
        propertyValueObject = this.toInputStreamOrReader(propertyValueObject);
        try {
            if (propertyValueObject instanceof InputStream) {
                propertyValueObject = this.propertValueBuilder.createTempFileInputStreamPropertyValue((InputStream)propertyValueObject, cmProperty, objectId);
            } else if (propertyValueObject instanceof Reader) {
                propertyValueObject = this.propertValueBuilder.createTempFileInputStreamPropertyValue((Reader)propertyValueObject, cmProperty, objectId);
            }
            return propertyValueObject;
        }
        catch (CMException e) {
            throw new CMException(e, "cmErrorWritingTempFile");
        }
    }

    private Object toInputStreamOrReader(Object propertyValueObject) {
        if (propertyValueObject instanceof CMString) {
            return new StringReader(((CMString)propertyValueObject).getValue());
        }
        if (propertyValueObject instanceof InputStream || propertyValueObject instanceof Reader) {
            return propertyValueObject;
        }
        return new StringReader(propertyValueObject.toString());
    }

    public ArchiveDataDescriptor getContextArchiveDataDescriptor() {
        return (ArchiveDataDescriptor)this.getTaskContext().getDataDescriptor();
    }

    @Override
    protected ArchivalTaskContext getTaskContext() {
        return (ArchivalTaskContext)super.getTaskContext();
    }
}

