/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.contentTasks.actions.TaskObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.ArchivalTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.DataObjectBuilder;
import com.cognos.cm.contentTasks.cleanupTask.IDataDescriptorBuilder;
import com.cognos.cm.contentTasks.cleanupTask.WriteDataOptionsBuilder;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.OperationResult;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryMessage;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import java.util.Properties;

public class ContentObjectArchivalAction
extends TaskObjectAction {
    private static final String ACTIONCLASSNAME = "archive";
    RepositoryConnection connection;
    DataObjectBuilder objectBuilder;
    IDataDescriptorBuilder descriptorBuilder;
    WriteDataOptionsBuilder optionsBuilder;

    public ContentObjectArchivalAction(ArchivalTaskContext taskContext, RepositoryConnection connection, DataObjectBuilder objectBuilder, IDataDescriptorBuilder descriptorBuilder, WriteDataOptionsBuilder optionsBuilder) {
        super(taskContext);
        this.connection = connection;
        this.objectBuilder = objectBuilder;
        this.descriptorBuilder = descriptorBuilder;
        this.optionsBuilder = optionsBuilder;
    }

    @Override
    public void execute(String objectSearchPath) throws CMException {
        try {
            OperationResult saveDataResult;
            DataObject dataObject = this.objectBuilder.createDataObject(objectSearchPath);
            ArchivalTaskContext actionContext = this.getTaskContext();
            actionContext.getDataDescriptor().addProperty((IDataDescriptorProperty)new DataDescriptorProperty(this.getDataPropertyName(), (Object)dataObject));
            IDataDescriptor descriptor = this.descriptorBuilder.createDataDescriptor(this.getTaskContext());
            String reportDefaultNameProperty = this.getDataDescriptorPropertyValue(this.getDefaultnamePropertyName());
            Properties options = this.optionsBuilder.createWriteDataOptions(reportDefaultNameProperty);
            if (this.simulatedException.doCreateSimulatedException(AdvancedSettings.CLEANUPTASKTESTVARIABLE, ACTIONCLASSNAME)) {
                this.simulatedException.throwNewSimulatedException(this.toString());
            }
            if (!(saveDataResult = this.connection.writeData(descriptor, options)).isSuccess()) {
                String messageString = "";
                if (saveDataResult.hasMessage() && saveDataResult.getMessage() != null) {
                    RepositoryMessage message = saveDataResult.getMessage();
                    messageString = message.getMessage();
                }
                throw new CMException("cmSaveToRepositoryPluginErrorMessage", new CMException.Parm("ERRORSTRING", messageString));
            }
        }
        catch (CMException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CMException(e, "cmSaveToRepositoryPluginErrorMessage", new CMException.Parm("ERRORSTRING", e.getLocalizedMessage()));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.simulatedException.incrementCounter();
        }
    }

    private String getDataPropertyName() {
        return "data";
    }

    protected String getDefaultnamePropertyName() {
        return CMProperty.DEFAULTNAME.getName();
    }

    protected String getFormatPropertyName() {
        return CMProperty.FORMAT.getName();
    }

    protected IDataDescriptor getDataDescriptor() {
        return this.getTaskContext().getDataDescriptor();
    }

    protected String getDataDescriptorPropertyValue(String name) {
        IDataDescriptorProperty property = this.getDataDescriptor().getProperty(name);
        if (property != null) {
            return property.getStringValue();
        }
        return null;
    }

    @Override
    protected ArchivalTaskContext getTaskContext() {
        return (ArchivalTaskContext)super.getTaskContext();
    }
}

