/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.contentTasks.actions.ActionReporter;
import com.cognos.cm.contentTasks.actions.AddToArchiveAndDeleteWorkflowAction;
import com.cognos.cm.contentTasks.actions.AddToDeleteWorkflowAction;
import com.cognos.cm.contentTasks.actions.AddToWorkflowAction;
import com.cognos.cm.contentTasks.actions.ArchivableRunnableAction;
import com.cognos.cm.contentTasks.actions.ArchivableVersionAction;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.actions.ITaskActionBuilder;
import com.cognos.cm.contentTasks.actions.KeepGoingDescendantsAction;
import com.cognos.cm.contentTasks.actions.OnHoldAction;
import com.cognos.cm.contentTasks.actions.SequenceAction;
import com.cognos.cm.contentTasks.actions.SkipActionReporter;
import com.cognos.cm.contentTasks.actions.UpdateRetentionRulesAction;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRuleFactory;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilter;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilterFactory;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSelectionRule;
import com.cognos.cm.dbstore.properties.CMDbStoreRetentionRuleArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMRetentionRuleArray;
import com.cognos.cm.properties.ICMObjectClasses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ObjectTaskActionBuilder
implements ITaskActionBuilder {
    private final CleanupTaskContext taskContext;
    private final ContentObjectSelectionRuleFactory ruleFactory;
    private final IContentFilterFactory filterFactory;
    private CMRetentionRuleArray retentionRules;
    private CMRetentionRuleArray applicableRetentionRules;
    private boolean updateContextObjects;
    private boolean doNotWriteToRepository;
    private IActionReporter addToworkflowReporter;
    private IActionReporter onHoldReporter;
    private IActionReporter updateRetentionsReporter;
    private IActionReporter skipAddToworkflowReporter;
    private HashSet<CMObjectClass> classesWithApplicationControlledRetentions = new HashSet();

    public ObjectTaskActionBuilder(CleanupTaskContext taskContext, CMRetentionRuleArray retentionRules, ContentObjectSelectionRuleFactory ruleFactory, IContentFilterFactory filterFactory, boolean updateContextObjects, boolean doNotWriteToRepository) {
        this.taskContext = taskContext;
        this.ruleFactory = ruleFactory;
        this.filterFactory = filterFactory;
        this.retentionRules = retentionRules;
        this.updateContextObjects = updateContextObjects;
        this.doNotWriteToRepository = doNotWriteToRepository;
        this.classesWithApplicationControlledRetentions.add(CMObjectClass.DATASET2);
        this.classesWithApplicationControlledRetentions.add(CMObjectClass.UPLOADEDFILE);
    }

    @Override
    public void initialize() {
        if (this.isArchivalRequired()) {
            if (this.retentionRules != null) {
                this.applicableRetentionRules = new CMDbStoreRetentionRuleArray();
                for (int i = 0; i < this.retentionRules.getSize(); ++i) {
                    CMRetentionRule rule = (CMRetentionRule)this.retentionRules.getItem(i);
                    if (!rule.getObjectClass().isArchivableVersion()) continue;
                    this.applicableRetentionRules.add(rule);
                }
            }
        } else {
            this.applicableRetentionRules = this.retentionRules;
        }
    }

    @Override
    public IContentObjectAction createActionForOptions() {
        UpdateRetentionRulesAction updateRetentionRulesAction;
        ArrayList<IContentObjectAction> runnableObjectActions = new ArrayList<IContentObjectAction>();
        if (this.applicableRetentionRules != null) {
            runnableObjectActions.addAll(this.createRetentionsAction());
        }
        if (this.isArchivalRequired()) {
            runnableObjectActions.addAll(this.createArchivalRunnableActions());
        }
        if (this.updateContextObjects && (updateRetentionRulesAction = this.createUpdateRetentionRulesAction()) != null) {
            runnableObjectActions.add(updateRetentionRulesAction);
        }
        return this.createActionOnContainerObject(new SequenceAction(runnableObjectActions));
    }

    private UpdateRetentionRulesAction createUpdateRetentionRulesAction() {
        if (this.applicableRetentionRules.getSize() == 0) {
            return null;
        }
        return new UpdateRetentionRulesAction(this.applicableRetentionRules, this.taskContext, this.isArchivalRequired(), this.getUpdateRetentionsReporter(), this.classesWithApplicationControlledRetentions);
    }

    private IActionReporter getUpdateRetentionsReporter() {
        if (this.updateRetentionsReporter == null) {
            this.updateRetentionsReporter = new ActionReporter(this.taskContext.getTaskErrorReporter(), "cmTotalUpdateRetentionRulesMessage");
        }
        return this.updateRetentionsReporter;
    }

    private boolean isArchivalRequired() {
        return !this.doNotWriteToRepository;
    }

    private IContentObjectAction createActionOnContainerObject(IContentObjectAction objectAction) {
        IContentObjectSelectionRule rule = this.ruleFactory.createSelectionRuleForParentClasses(this.getChildClasses(), this.classesWithApplicationControlledRetentions);
        IContentFilter filter = this.filterFactory.createFilterForRule(rule, this.taskContext);
        KeepGoingDescendantsAction action = new KeepGoingDescendantsAction(filter, objectAction, this.taskContext.getTaskErrorReporter());
        return action;
    }

    private CMObjectClass[] getChildClasses() {
        HashSet<CMObjectClass> childClasses = new HashSet<CMObjectClass>();
        if (this.applicableRetentionRules != null) {
            childClasses.addAll(this.getRetentionObjectClasses(this.applicableRetentionRules));
        }
        if (this.isArchivalRequired()) {
            childClasses.addAll(this.getObjectClasses().getArchivableVersionClasses());
        }
        return childClasses.toArray(new CMObjectClass[childClasses.size()]);
    }

    private Collection<CMObjectClass> getRetentionObjectClasses(CMRetentionRuleArray rules) {
        ArrayList<CMObjectClass> objectClasses = new ArrayList<CMObjectClass>(rules.getSize());
        for (int i = 0; i < rules.getSize(); ++i) {
            CMRetentionRule rule = (CMRetentionRule)rules.getItem(i);
            objectClasses.add(rule.getObjectClass());
        }
        return objectClasses;
    }

    private ArrayList<IContentObjectAction> createArchivalRunnableActions() {
        ArrayList<CMObjectClass> archivableVersionClasses = new ArrayList<CMObjectClass>(this.getObjectClasses().getArchivableVersionClasses());
        if (this.applicableRetentionRules != null) {
            archivableVersionClasses.removeAll(this.getRetentionObjectClasses(this.applicableRetentionRules));
        }
        ArrayList<IContentObjectAction> archivalRunnableActions = new ArrayList<IContentObjectAction>();
        AddToWorkflowAction archivingRequiredVersionAction = new AddToWorkflowAction("archive", this.taskContext, this.getAddToWorkflowReporter());
        for (CMObjectClass archivableVersionClass : archivableVersionClasses) {
            ContentObjectSelectionRule versionSelectionRule = this.ruleFactory.createObjectClassSelectionRule(archivableVersionClass.getName());
            IContentFilter versionFilter = this.filterFactory.createFilterForRule(versionSelectionRule, this.taskContext);
            archivalRunnableActions.add(this.createArchivableRunnableAction(archivableVersionClass, versionFilter, archivingRequiredVersionAction, null, this.getSkipAddToWorkflowReporter()));
        }
        return archivalRunnableActions;
    }

    private IActionReporter getSkipAddToWorkflowReporter() {
        if (this.skipAddToworkflowReporter == null) {
            this.skipAddToworkflowReporter = new SkipActionReporter(this.taskContext.getTaskErrorReporter(), "cmTotalsSkipAddToFlowForCleanupMessage");
        }
        return this.skipAddToworkflowReporter;
    }

    private IActionReporter getAddToWorkflowReporter() {
        if (this.addToworkflowReporter == null) {
            this.addToworkflowReporter = new ActionReporter(this.taskContext.getTaskErrorReporter(), "cmTotalsAddToFlowForCleanupMessage");
        }
        return this.addToworkflowReporter;
    }

    private ArrayList<IContentObjectAction> createRetentionsAction() {
        ArrayList<IContentObjectAction> retentionsActions = new ArrayList<IContentObjectAction>();
        for (int i = 0; i < this.applicableRetentionRules.getSize(); ++i) {
            CMRetentionRule rule = (CMRetentionRule)this.applicableRetentionRules.getItem(i);
            retentionsActions.add(this.createActionForRetentionRule(rule));
        }
        return retentionsActions;
    }

    private IContentObjectAction createActionForRetentionRule(CMRetentionRule rule) {
        CMObjectClass retentionRuleObjectClass = rule.getObjectClass();
        ArrayList<IContentObjectAction> retentionRuleActions = new ArrayList<IContentObjectAction>();
        if (this.isArchivalRequired()) {
            if (retentionRuleObjectClass.isArchivableVersion()) {
                retentionRuleActions.add(this.createRetentionArchiveAndKeepAction(rule));
                retentionRuleActions.add(this.createRetentionArchiveAndDeleteAction(rule));
            }
        } else {
            retentionRuleActions.add(this.createRetentionDeleteAction(rule));
        }
        return new SequenceAction(retentionRuleActions);
    }

    private IContentObjectAction createRetentionArchiveAndKeepAction(CMRetentionRule rule) {
        IContentObjectSelectionRule versionSelectionRule = this.ruleFactory.createRetentionSelectionRule(rule);
        IContentFilter versionFilter = this.filterFactory.createRetentionContentFilter(versionSelectionRule, true, this.taskContext);
        AddToWorkflowAction archivingRequiredVersionAction = new AddToWorkflowAction("archive", this.taskContext, this.getAddToWorkflowReporter());
        return this.createArchivableRunnableAction(rule.getObjectClass(), versionFilter, archivingRequiredVersionAction, null, this.getSkipAddToWorkflowReporter());
    }

    private IContentObjectAction createRetentionArchiveAndDeleteAction(CMRetentionRule rule) {
        IContentObjectSelectionRule versionSelectionRule = this.ruleFactory.createRetentionSelectionRule(rule);
        IContentFilter versionFilter = this.filterFactory.createRetentionContentFilter(versionSelectionRule, false, this.taskContext);
        AddToArchiveAndDeleteWorkflowAction archivingRequiredVersionAction = new AddToArchiveAndDeleteWorkflowAction(this.taskContext, this.getAddToWorkflowReporter());
        AddToDeleteWorkflowAction archivingNotRequiredVersionAction = new AddToDeleteWorkflowAction(this.taskContext, this.getAddToWorkflowReporter());
        return this.createArchivableRunnableAction(rule.getObjectClass(), versionFilter, archivingRequiredVersionAction, archivingNotRequiredVersionAction, this.getSkipAddToWorkflowReporter());
    }

    private IContentObjectAction createArchivableRunnableAction(CMObjectClass versionObjectClass, IContentFilter versionFilter, IContentObjectAction archivingRequiredVersionAction, IContentObjectAction archivingNotRequiredVersionAction, IActionReporter actionReporter) {
        OnHoldAction archivableClassObjectAction = new OnHoldAction(this.taskContext, this.getOnHoldReporter());
        ArrayList<CMObjectClass> archivableClasses = this.getObjectClasses().getArchivableClasses();
        ContentObjectSelectionRule archivableClassesSelectionRule = this.ruleFactory.createObjectClassSelectionRule(this.ruleFactory.objectClassesListToNamesArray(archivableClasses));
        IContentFilter archivableDescendantClassesFilter = this.filterFactory.createFilterForRule(archivableClassesSelectionRule, this.taskContext);
        ArchivableVersionAction versionAction = new ArchivableVersionAction(archivableDescendantClassesFilter, archivableClassObjectAction);
        return new ArchivableRunnableAction(versionFilter, versionAction, versionObjectClass, this.taskContext, archivingRequiredVersionAction, archivingNotRequiredVersionAction, actionReporter);
    }

    private IActionReporter getOnHoldReporter() {
        if (this.onHoldReporter == null) {
            this.onHoldReporter = new ActionReporter(this.taskContext.getTaskErrorReporter(), "cmTotalArchiveStatusMessage");
        }
        return this.onHoldReporter;
    }

    private IContentObjectAction createRetentionDeleteAction(CMRetentionRule rule) {
        AddToDeleteWorkflowAction versionAction = new AddToDeleteWorkflowAction(this.taskContext, this.getAddToWorkflowReporter());
        IContentObjectSelectionRule versionSelectionRule = this.ruleFactory.createRetentionSelectionRule(rule);
        IContentFilter versionFilter = this.filterFactory.createRetentionContentFilter(versionSelectionRule, false, this.taskContext);
        KeepGoingDescendantsAction retentionDeleteAction = new KeepGoingDescendantsAction(versionFilter, versionAction, this.taskContext.getTaskErrorReporter());
        return retentionDeleteAction;
    }

    protected ICMObjectClasses getObjectClasses() {
        return this.taskContext.getStoreWithLockManager().getStore().getObjectClasses();
    }
}

