/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.constants.ArchiveStatus;
import com.cognos.cm.contentTasks.actions.ArchiveStatusAction;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.actions.IOnHoldAction;
import com.cognos.cm.contentTasks.cleanupTask.ITaskContext;
import com.cognos.cm.server.CMException;

public class OnHoldAction
extends ArchiveStatusAction
implements IOnHoldAction {
    private boolean lastObjectShouldBeUpdated;
    private boolean lastObjectPutOnHold;

    public OnHoldAction(ITaskContext taskContext, IActionReporter actionReporter) {
        super(ArchiveStatus.HOLD, taskContext, actionReporter);
    }

    @Override
    public void execute(String objectSearchPath) throws CMException {
        this.lastObjectPutOnHold = false;
        this.executeObject(objectSearchPath);
        if (this.lastObjectShouldBeUpdated) {
            this.lastObjectPutOnHold = true;
        }
    }

    public void executeObject(String objectSearchPath) throws CMException {
        super.execute(objectSearchPath);
    }

    @Override
    public boolean lastObjectPutOnHold() {
        return this.lastObjectPutOnHold;
    }

    @Override
    protected boolean updateStatus(String currentStatus) {
        this.lastObjectShouldBeUpdated = false;
        if (this.isArchivingNeeded(currentStatus)) {
            this.lastObjectShouldBeUpdated = true;
        }
        return this.lastObjectShouldBeUpdated;
    }

    private boolean isArchivingNeeded(String currentStatus) {
        return !currentStatus.equals(ArchiveStatus.ARCHIVED.getValue()) && !currentStatus.equals(ArchiveStatus.NOARCHIVINGTRIGGER.getValue());
    }
}

