/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.actions;

import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.actions.TaskObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTaskContext;
import com.cognos.cm.dbstore.properties.CMDbStoreRetentionRuleArray;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMRetentionRuleArray;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ExpirationTimeUpdater;
import com.cognos.cm.server.IExpirationTimeUpdater;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.ArrayList;
import java.util.Set;

public class UpdateRetentionRulesAction
extends TaskObjectAction {
    static final String ACTIONCLASSNAME = "UpdateRetentionRulesAction";
    private CMRetentionRuleArray retentionRules;
    private boolean checkForRepositoryRule;
    private IActionReporter actionReporter;
    private Set<CMObjectClass> classesWithApplicationControlledRetentions;

    public UpdateRetentionRulesAction(CMRetentionRuleArray retentionRules, CleanupTaskContext taskContext, boolean checkForRepositoryRule, IActionReporter actionReporter, Set<CMObjectClass> filterClasses) {
        super(taskContext);
        this.retentionRules = retentionRules;
        this.checkForRepositoryRule = checkForRepositoryRule;
        this.actionReporter = actionReporter;
        this.classesWithApplicationControlledRetentions = filterClasses;
    }

    @Override
    public void execute(String objectSearchPath) throws CMException {
        CMStore store = this.getStore();
        ICMLockManager lockManager = this.getLockManager();
        IExpirationTimeUpdater expirationTimeUpdater = this.createExpirationTimeUpdater(store);
        ICMStorePath objectStorePath = this.createStorePath(objectSearchPath);
        objectStorePath.setLockManagerUsageFlag(13);
        try {
            lockManager.requestLocks(objectStorePath);
            store.beginTransaction();
            CMObjectClass runnableObjectClass = this.queryObjectClass(store, objectStorePath);
            if (!this.shouldClassRetentionsBeUpdated(runnableObjectClass)) {
                return;
            }
            CMRetentionRuleArray applicableRetentionRuleArray = this.newCMDbStoreRetentionRuleArray();
            for (CMObjectClass objectClass : runnableObjectClass.getValidChildObjectCleasses()) {
                CMRetentionRule objectClassRule = this.retentionRules.getRule(objectClass);
                if (objectClassRule == null) continue;
                if (this.checkForRepositoryRule) {
                    if (!this.getTaskContext().getRepositoryRules().hasRepositoryRuleForClass(objectStorePath, objectClass)) continue;
                    applicableRetentionRuleArray.add(objectClassRule);
                    continue;
                }
                applicableRetentionRuleArray.add(objectClassRule);
            }
            if (this.simulatedException.doCreateSimulatedException(AdvancedSettings.CLEANUPTASKTESTVARIABLE, ACTIONCLASSNAME)) {
                this.simulatedException.throwNewSimulatedException(this.getClass().getName());
            }
            if (applicableRetentionRuleArray.getSize() > 0) {
                CMRetentionRuleArray currentRetentionRuleArray = this.queryRetentions(store, objectStorePath);
                CMRetentionRuleArray mergedRetentionRuleArray = this.mergeRetentionRules(currentRetentionRuleArray, applicableRetentionRuleArray);
                this.updateRetentions(store, objectStorePath, mergedRetentionRuleArray);
                this.reportSuccess(objectSearchPath);
            }
            store.commitTransaction();
            if (applicableRetentionRuleArray.getSize() > 0) {
                this.updateExpirationTimes(objectSearchPath, store, expirationTimeUpdater, applicableRetentionRuleArray);
            }
        }
        catch (Throwable ex) {
            this.reportFailureThrowable(objectSearchPath, ex);
            throw new CMException(ex, "cmUpdateRetentionRulesFailureMessage", this.createParameters(objectSearchPath));
        }
        finally {
            this.simulatedException.incrementCounter();
            if (store.inTransaction()) {
                store.rollbackTransaction();
            }
            lockManager.releaseLocks();
        }
    }

    private boolean shouldClassRetentionsBeUpdated(CMObjectClass cls) {
        return cls != null && !this.classesWithApplicationControlledRetentions.contains(cls);
    }

    private CMException.Parm[] createParameters(String objectSearchPath) {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath)};
        return parms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMObjectClass queryObjectClass(CMStore store, ICMStorePath objectStorePath) throws CMException {
        CMStoreQueryResults queryResults = null;
        try {
            queryResults = store.executeQuery(objectStorePath, new CMProperty[]{CMProperty.OBJECTCLASS}, null, 0, 1, null);
            if (queryResults.next()) {
                CMObjectClass cMObjectClass = (CMObjectClass)queryResults.getValue(0);
                return cMObjectClass;
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMRetentionRuleArray queryRetentions(CMStore store, ICMStorePath objectStorePath) throws CMException {
        CMStoreQueryResults queryResults = null;
        try {
            queryResults = store.executeQuery(objectStorePath, new CMProperty[]{CMProperty.RETENTIONS}, null, 0, 1, null);
            if (queryResults.next()) {
                CMRetentionRuleArray cMRetentionRuleArray = (CMRetentionRuleArray)queryResults.getValue(0);
                return cMRetentionRuleArray;
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
        }
        return null;
    }

    private CMRetentionRuleArray mergeRetentionRules(CMRetentionRuleArray currentRetentionRuleArray, CMRetentionRuleArray applicableRetentionRuleArray) {
        int i;
        CMDbStoreRetentionRuleArray mergedRetentionRuleArray = new CMDbStoreRetentionRuleArray();
        for (i = 0; i < applicableRetentionRuleArray.getSize(); ++i) {
            mergedRetentionRuleArray.add(applicableRetentionRuleArray.getRule(i));
        }
        if (currentRetentionRuleArray != null) {
            for (i = 0; i < currentRetentionRuleArray.getSize(); ++i) {
                if (applicableRetentionRuleArray.getRule(currentRetentionRuleArray.getRule(i).getObjectClass()) != null) continue;
                mergedRetentionRuleArray.add(currentRetentionRuleArray.getRule(i));
            }
        }
        return mergedRetentionRuleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRetentions(CMStore store, ICMStorePath objectStorePath, CMRetentionRuleArray retentionRuleArray) throws CMException {
        CMStoreQueryResults results = null;
        ArrayList<CMProperty> propNames = new ArrayList<CMProperty>();
        ArrayList<Object> propValues = new ArrayList<Object>();
        try {
            results = store.executeQuery(objectStorePath, null, null, 7, 512, null);
            if (results != null && results.next()) {
                propNames.add(CMProperty.RETENTIONS);
                propValues.add(retentionRuleArray);
                results.reset();
                store.update(results, propNames, propValues);
            }
        }
        finally {
            if (results != null) {
                results.release();
            }
        }
    }

    private void updateExpirationTimes(String objectSearchPath, CMStore store, IExpirationTimeUpdater expirationTimeUpdater, CMRetentionRuleArray applicableRetentionRuleArray) throws CMException {
        for (int i = 0; i < applicableRetentionRuleArray.getSize(); ++i) {
            store.beginTransaction();
            expirationTimeUpdater.updateExpirationTime(applicableRetentionRuleArray.getRule(i), objectSearchPath, true);
            store.commitTransaction();
        }
    }

    @Override
    protected CleanupTaskContext getTaskContext() {
        return (CleanupTaskContext)super.getTaskContext();
    }

    protected ICMStorePath createStorePath(String searchPath) throws CMStoreParseException {
        return new CMStoreXPath(searchPath);
    }

    protected IExpirationTimeUpdater createExpirationTimeUpdater(CMStore store) {
        return new ExpirationTimeUpdater(store);
    }

    protected CMRetentionRuleArray newCMDbStoreRetentionRuleArray() {
        return new CMDbStoreRetentionRuleArray();
    }

    private void reportFailureThrowable(String objectSearchPath, Throwable t) throws CMException {
        this.actionReporter.reportFailureThrowable("cmUpdateRetentionRulesFailureMessage", t, objectSearchPath);
    }

    private void reportSuccess(String objectSearchPath) throws CMException {
        this.actionReporter.reportSuccess("cmUpdateRetentionRulesSuccessMessage", objectSearchPath);
    }
}

