/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.contentTasks.IRunnableErrorsReporter;
import com.cognos.cm.contentTasks.Task;
import com.cognos.cm.contentTasks.actions.ITaskActionBuilder;
import com.cognos.cm.contentTasks.actions.ObjectTaskActionBuilder;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTaskContext;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTaskRunOptions;
import com.cognos.cm.contentTasks.cleanupTask.ContentFilterFactory;
import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRuleFactory;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilter;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilterFactory;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectAction;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSet;
import com.cognos.cm.contentTasks.cleanupTask.IStoreWithLockManager;
import com.cognos.cm.contentTasks.cleanupTask.RepositoryRulesTempCache;
import com.cognos.cm.contentTasks.cleanupTask.TaskErrorReporter;
import com.cognos.cm.contentTasks.cleanupTask.TaskSecurityContext;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.properties.CMRetentionRuleArray;
import com.cognos.cm.properties.ICMObjectClasses;
import com.cognos.cm.server.CMException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CleanupTask
extends Task {
    private static final String DIRECTORY_CLASS_NAME = "directory";
    private static final String CONTENT_CLASS_NAME = "content";
    private static final String ROOT_SEARCH_PATH = "/";
    private static final String ROOT_CLASS_NAME = "root";
    private static final String CONFIGURATION_CLASS_NAME = "configuration";
    private final IStoreWithLockManager store;
    private TaskErrorReporter taskErrorReporter;
    private ContentObjectSelectionRuleFactory ruleFactory;
    private IContentFilterFactory filterFactory;
    private CleanupTaskContext taskContext;
    private CleanupTaskRunOptions cleanupTaskRunOptions;
    private ITaskActionBuilder actionBuilder;

    public CleanupTask(IStoreWithLockManager storeWithLockManager, Map<String, Object> runOptions) {
        super(storeWithLockManager.getStore(), runOptions);
        this.store = storeWithLockManager;
    }

    @Override
    public Task.Lock getLock() {
        return new Task.LockNoOp();
    }

    @Override
    public IRunnableErrorsReporter getErrorsReporter() {
        return this.taskErrorReporter;
    }

    @Override
    public void setErrorsReporter(IRunnableErrorsReporter errorsReporter) {
        super.setErrorsReporter(errorsReporter);
        this.taskErrorReporter = new TaskErrorReporter(super.getErrorsReporter());
        this.taskErrorReporter.setAuditLevel(this.cleanupTaskRunOptions.getAuditLevel());
        this.taskContext.addTaskErrorReporter(this.taskErrorReporter);
    }

    @Override
    public void execute() throws CMException {
        this.setSucceeded(true);
        this.executeForContextObjects();
    }

    @Override
    public void initialize() throws CMException {
        this.cleanupTaskRunOptions = this.createCleanupTaskRunOptions();
        this.filterFactory = this.createFilterFactory();
        this.ruleFactory = new ContentObjectSelectionRuleFactory(this.getStore().getObjectClasses());
        this.taskContext = this.createTaskContext();
        this.parseAndValidateRunOptions();
        this.addProtectedObjectsToTaskContext();
        this.actionBuilder = this.createActionBuilder();
        this.actionBuilder.initialize();
    }

    protected CleanupTaskRunOptions createCleanupTaskRunOptions() {
        return new CleanupTaskRunOptions();
    }

    protected IContentFilterFactory createFilterFactory() {
        return new ContentFilterFactory();
    }

    protected ITaskActionBuilder createActionBuilder() {
        return new ObjectTaskActionBuilder(this.taskContext, this.getRetentionRules(), this.ruleFactory, this.filterFactory, this.cleanupTaskRunOptions.isUpdateContextObjectsSpecified(), this.isDoNotWriteToRepositorySpecified());
    }

    private void execute(String searchPath) {
        IContentObjectAction action = this.actionBuilder.createActionForOptions();
        try {
            action.execute(searchPath);
            this.setSucceededFlag();
        }
        catch (CMException ex) {
            this.setSucceeded(false);
        }
    }

    private void setSucceededFlag() {
        if (this.isSucceeded()) {
            this.setSucceeded(!this.taskErrorReporter.isError());
        }
    }

    private void reportTotalsAndResetCounters(String searchPath) throws CMException {
        this.taskErrorReporter.reportTotalSuccessAndError(searchPath);
        this.resetCounters();
    }

    private void resetCounters() {
        this.taskErrorReporter.resetErrorsCounter();
        this.taskErrorReporter.resetSuccessCounter();
    }

    private void parseAndValidateRunOptions() throws CMException {
        this.cleanupTaskRunOptions.parseAndValidateRunOptions(this);
    }

    private CleanupTaskContext createTaskContext() {
        CleanupTaskContext taskContext = new CleanupTaskContext();
        taskContext.addTaskSecurityContext(new TaskSecurityContext(32768));
        taskContext.addStoreWithLockManager(this.store);
        taskContext.addRepositoryRules(new RepositoryRulesTempCache());
        return taskContext;
    }

    private void addProtectedObjectsToTaskContext() throws CMException {
        if (this.cleanupTaskRunOptions.getContentTaskObjectSearchPath() != null) {
            HashMap<String, String> protectedObjects = new HashMap<String, String>();
            ContentObjectSelectionRule historiesRule = this.ruleFactory.createObjectClassSelectionRule(this.getHistoryClassName());
            IContentFilter historiesFilter = this.filterFactory.createFilterForRule(historiesRule, this.taskContext);
            IContentObjectSet histories = historiesFilter.getObjects(this.cleanupTaskRunOptions.getContentTaskObjectSearchPath());
            while (histories.next()) {
                String searchPath = histories.getSearchPath();
                protectedObjects.put(searchPath, searchPath);
            }
            this.taskContext.addProtectedObjects(protectedObjects);
        }
    }

    protected String getHistoryClassName() {
        return CMObjectClass.HISTORY.getName();
    }

    private void executeForContextObjects() throws CMException {
        ArrayList<String> taskContextSearchPaths = this.cleanupTaskRunOptions.getTaskContextSearchPaths();
        for (String contextSearchPath : taskContextSearchPaths) {
            ArrayList<String> splitContextSearchPaths = this.splitContext(contextSearchPath);
            for (String splitContextSearchPath : splitContextSearchPaths) {
                this.execute(splitContextSearchPath);
                this.reportTotalsAndResetCounters(splitContextSearchPath);
            }
        }
    }

    private ArrayList<String> splitContext(String contextSearchPath) throws CMException {
        if (this.isEntireContentStore(contextSearchPath)) {
            return this.getEntireContentStoreParts();
        }
        ArrayList<String> searchPaths = new ArrayList<String>();
        searchPaths.add(contextSearchPath);
        return searchPaths;
    }

    private ArrayList<String> getEntireContentStoreParts() throws CMException {
        ArrayList<String> partsArray = new ArrayList<String>();
        HashSet<CMObjectClass> selectableObjectClasses = new HashSet<CMObjectClass>();
        if (this.getRetentionRules() != null) {
            selectableObjectClasses.addAll(Arrays.asList(this.getRetentionRulesObjectClasses()));
        }
        if (this.isArchivalRequired()) {
            selectableObjectClasses.addAll(this.getObjectClasses().getArchivableVersionClasses());
        }
        CMObjectClasses objectClasses = this.getStore().getObjectClasses();
        CMObjectClass[] excludeClasses = new CMObjectClass[]{objectClasses.getClassByName(CONTENT_CLASS_NAME), objectClasses.getClassByName(DIRECTORY_CLASS_NAME), objectClasses.getClassByName(CONFIGURATION_CLASS_NAME)};
        CMObjectClass[] parentClasses = new CMObjectClass[]{objectClasses.getClassByName(ROOT_CLASS_NAME)};
        IContentObjectSelectionRule rule = this.ruleFactory.createSelectionRuleForAscendantClasses(new ArrayList(selectableObjectClasses).toArray(new CMObjectClass[selectableObjectClasses.size()]), parentClasses, excludeClasses);
        this.addSearchPathsForRule(partsArray, rule, ROOT_SEARCH_PATH);
        ContentObjectSelectionRule noPredicateRule = new ContentObjectSelectionRule("");
        this.addSearchPathsForRule(partsArray, noPredicateRule, "/content");
        this.addSearchPathsForRule(partsArray, noPredicateRule, "/directory");
        return partsArray;
    }

    protected void addSearchPathsForRule(ArrayList<String> partsArray, IContentObjectSelectionRule rule, String parentSearchPath) throws CMException {
        IContentFilter filter = this.filterFactory.createChildrenContentFilter(rule, this.taskContext);
        IContentObjectSet objects = filter.getObjects(parentSearchPath);
        while (objects.next()) {
            partsArray.add(objects.getSearchPath());
        }
    }

    private boolean isEntireContentStore(String contextSearchPath) {
        return contextSearchPath.equalsIgnoreCase(ROOT_SEARCH_PATH);
    }

    private CMRetentionRuleArray getRetentionRules() {
        return this.cleanupTaskRunOptions.getRetentionRules();
    }

    private CMObjectClass[] getRetentionRulesObjectClasses() {
        CMObjectClass[] retentionRulesObjectClasses = new CMObjectClass[this.getRetentionRules().getSize()];
        for (int i = 0; i < this.getRetentionRules().getSize(); ++i) {
            CMRetentionRule rule = (CMRetentionRule)this.getRetentionRules().getItem(i);
            retentionRulesObjectClasses[i] = rule.getObjectClass();
        }
        return retentionRulesObjectClasses;
    }

    private boolean isArchivalRequired() {
        return !this.isDoNotWriteToRepositorySpecified();
    }

    private boolean isDoNotWriteToRepositorySpecified() {
        return this.cleanupTaskRunOptions.isDoNotWriteToRepositorySpecified();
    }

    protected CleanupTaskContext getCleanupTaskContext() {
        return this.taskContext;
    }

    protected ICMObjectClasses getObjectClasses() {
        return this.taskContext.getStoreWithLockManager().getStore().getObjectClasses();
    }
}

