/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.cleanupTask.CleanupTask;
import com.cognos.cm.properties.CMRetentionRuleArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.ArchivingUtil;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;

public class CleanupTaskRunOptions {
    private String contentTaskObjectSearchPath;
    private CMRetentionRuleArray retentionRules;
    private ArrayList<String> taskContextSearchPaths;
    private String auditLevel;
    private boolean updateContextObjects;
    private boolean doNotWriteToRepository;

    public void parseAndValidateRunOptions(CleanupTask task) throws CMException {
        this.parseContentTaskObjectRunOption(task);
        this.validateContentTaskObjectRunOption();
        this.parseContextRunOption(task);
        this.validateContextRunOption();
        this.parseRetentionRulesRunOption(task);
        this.parseAuditLevelRunOption(task);
        this.validateAuditLevelRunOption();
        this.parseUpdateContextObjectRunOptions(task);
        this.validateUpdateContextObjectRunOptions();
        this.parseDoNotWriteToRepository(task);
        this.validateDoNotWriteToRepository();
    }

    private void parseContentTaskObjectRunOption(CleanupTask task) {
        this.contentTaskObjectSearchPath = (String)task.getRunOptionValue("objectPath");
    }

    private void validateContentTaskObjectRunOption() {
    }

    private void parseContextRunOption(CleanupTask task) throws CMException {
        this.taskContextSearchPaths = task.getTaskContext(ContentTaskOption.cleanupContentContext);
    }

    private void validateContextRunOption() throws CMException {
        if (this.taskContextSearchPaths == null || this.taskContextSearchPaths.size() == 0) {
            throw new CMException("cmInvalidRunOption", new CMException.Parm("Name", ContentTaskOption.cleanupContentContext.name()));
        }
    }

    private void parseRetentionRulesRunOption(CleanupTask task) throws CMException {
        String retentionsOption = (String)task.getRunOptionValue(ContentTaskOption.cleanupContentRetentionRules);
        if (retentionsOption == null) {
            return;
        }
        XMLElement retentionsElement = CMXMLUtils.convertXMLString2XMLElement(retentionsOption);
        retentionsElement = retentionsElement.getChild(0);
        this.retentionRules = RequestHandler.parseRetentionRuleArray(task.getStore().getObjectClasses(), retentionsElement, ContentTaskOption.cleanupContentRetentionRules.name());
    }

    private void parseUpdateContextObjectRunOptions(CleanupTask task) throws CMException {
        this.updateContextObjects = false;
        if (task.hasOption(ContentTaskOption.cleanupContentUpdateContextObjects)) {
            this.updateContextObjects = task.isBooleanOptionOn(ContentTaskOption.cleanupContentUpdateContextObjects);
        }
    }

    private void validateUpdateContextObjectRunOptions() throws CMException {
        if (this.updateContextObjects && (this.retentionRules == null || this.retentionRules.getSize() <= 0)) {
            throw new CMException("cmCleanupContentUpdateContextObjectsWithNoRetentions");
        }
    }

    private void parseDoNotWriteToRepository(CleanupTask task) throws CMException {
        this.doNotWriteToRepository = false;
        if (task.hasOption(ContentTaskOption.cleanupContentDoNotWriteToRepository)) {
            this.doNotWriteToRepository = task.isBooleanOptionOn(ContentTaskOption.cleanupContentDoNotWriteToRepository);
        }
    }

    private void validateDoNotWriteToRepository() throws CMException {
        if (!this.doNotWriteToRepository && !this.isRepositoryIntegrationInstalled()) {
            throw new CMException("cmRequiredComponentNotInstalled", new CMException.Parm("Component", "repositoryIntegration"));
        }
    }

    protected boolean isRepositoryIntegrationInstalled() {
        ArchivingUtil archivingUtil = new ArchivingUtil();
        return archivingUtil.isRepositoryIntegrationInstalled();
    }

    private void parseAuditLevelRunOption(CleanupTask task) throws CMException {
        this.auditLevel = task.getTaskStringOptionValue(ContentTaskOption.cleanupContentAuditLevel.name());
    }

    private void validateAuditLevelRunOption() {
        if (this.auditLevel == null) {
            this.auditLevel = "minimal";
        }
    }

    public CMRetentionRuleArray getRetentionRules() {
        return this.retentionRules;
    }

    public String getContentTaskObjectSearchPath() {
        return this.contentTaskObjectSearchPath;
    }

    public String getAuditLevel() {
        return this.auditLevel;
    }

    public ArrayList<String> getTaskContextSearchPaths() {
        return this.taskContextSearchPaths;
    }

    public boolean isUpdateContextObjectsSpecified() {
        return this.updateContextObjects;
    }

    public boolean isDoNotWriteToRepositorySpecified() {
        return this.doNotWriteToRepository;
    }
}

