/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSet;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilter;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSet;
import com.cognos.cm.contentTasks.cleanupTask.ITaskContext;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMString;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;

public abstract class ContentFilter
implements IContentFilter {
    protected CMStorePathFactory pathFactory = new CMStorePathFactory();
    private final ContentObjectSelectionRule rule_;
    private ITaskContext taskContext;
    private boolean useStoreIDInSearchPath;

    public ContentFilter(ContentObjectSelectionRule rule, ITaskContext taskContext, boolean useStoreIDInSearchPath) {
        this.rule_ = rule;
        this.taskContext = taskContext;
        this.useStoreIDInSearchPath = useStoreIDInSearchPath;
    }

    private CMStore getStore() {
        return this.taskContext.getStoreWithLockManager().getStore();
    }

    private ICMLockManager getLockManager() {
        return this.taskContext.getStoreWithLockManager().getLockManager();
    }

    private ITaskContext getTaskContext() {
        return this.taskContext;
    }

    public ContentObjectSelectionRule getRule() {
        return this.rule_;
    }

    @Override
    public IContentObjectSet getObjects(String containerSearchPath) throws CMException {
        String searchPath = this.getObjectsLocation(containerSearchPath) + this.rule_.getSearchPathPredicate();
        return this.createObjectSet(searchPath);
    }

    abstract String getObjectsLocation(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IContentObjectSet createObjectSet(String searchPath) throws CMException {
        ContentObjectSet set = new ContentObjectSet();
        CMStoreQueryResults queryResults = null;
        try {
            CMStoreXPath storeSearchPath = this.pathFactory.createCMStoreXPath(searchPath);
            CMProperty[] prop = new CMProperty[]{this.getProperty()};
            this.getLockManager().requestLocks(storeSearchPath);
            queryResults = this.getStore().executeQuery(storeSearchPath, prop, null, 0, this.getTaskContext().getTaskSecurityContext().getPermissions(), null, 0, 0);
            while (queryResults.next()) {
                CMString propValueObject = (CMString)queryResults.getValue(0);
                set.addObjectWithSearchPath(this.getSearchPath(propValueObject));
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
            this.getLockManager().releaseLocks();
        }
        return set;
    }

    private String getSearchPath(CMString propValueObject) {
        if (this.useStoreIDInSearchPath) {
            return CMStoreXPath.encodeStoreIdToPathString(propValueObject.getValue());
        }
        return propValueObject.getValue();
    }

    private CMProperty getProperty() {
        if (this.useStoreIDInSearchPath) {
            return CMProperty.STOREID;
        }
        return CMProperty.SEARCHPATH;
    }
}

