/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSelectionRule;
import java.util.ArrayList;
import java.util.Iterator;

public class ContentObjectSelectionRule
implements IContentObjectSelectionRule {
    public static final String AT = "@";
    public static final String EQUALS = "=";
    public static final String NOT = "!";
    public static final String OBJECT_CLASS_PROPERTY_NAME = "objectClass";
    public static final String PREDICATE_OR = " or ";
    public static final String PREDICATE_AND = " and ";
    public static final String PREDICATE_CLOSE_BRACKET = "]";
    public static final String PREDICATE_OPEN_BRACKET = "[";
    public static final String SINGLE_QUOTE = "'";
    private String predicate;

    public ContentObjectSelectionRule(String predicate) {
        this.predicate = predicate;
    }

    public String getSearchPathPredicate() {
        return this.predicate;
    }

    public void appendSearchPathPredicate(String predicate) {
        this.predicate = this.predicate + predicate;
    }

    public static String getPredicateConditionForProperty(String propertyName, String propertyValue) {
        return AT + propertyName + EQUALS + SINGLE_QUOTE + propertyValue + SINGLE_QUOTE;
    }

    public static String getNotPredicateConditionForProperty(String propertyName, String propertyValue) {
        return AT + propertyName + NOT + EQUALS + SINGLE_QUOTE + propertyValue + SINGLE_QUOTE;
    }

    public static String getPredicateConditionForObjectClass(String objectClassName) {
        return ContentObjectSelectionRule.getPredicateConditionForProperty(OBJECT_CLASS_PROPERTY_NAME, objectClassName);
    }

    public static String getPredicateForObjectClass(String objectClassName) {
        String predicate = PREDICATE_OPEN_BRACKET + ContentObjectSelectionRule.getPredicateConditionForObjectClass(objectClassName) + PREDICATE_CLOSE_BRACKET;
        return predicate;
    }

    public static String getPredicateForObjectClasses(String[] objectClassNames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PREDICATE_OPEN_BRACKET);
        boolean firstCondition = true;
        for (int i = 0; i < objectClassNames.length; ++i) {
            if (!firstCondition) {
                buffer.append(PREDICATE_OR);
            }
            buffer.append(ContentObjectSelectionRule.getPredicateConditionForObjectClass(objectClassNames[i]));
            firstCondition = false;
        }
        buffer.append(PREDICATE_CLOSE_BRACKET);
        return buffer.toString();
    }

    public static String getPredicateForProperty(String propertyName, String propertyValue) {
        String predicate = PREDICATE_OPEN_BRACKET + ContentObjectSelectionRule.getPredicateConditionForProperty(propertyName, propertyValue) + PREDICATE_CLOSE_BRACKET;
        return predicate;
    }

    public static String getORPredicateForPropertyValues(String propertyName, ArrayList<String> propertyValues) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PREDICATE_OPEN_BRACKET);
        boolean firstCondition = true;
        Iterator<String> it = propertyValues.iterator();
        while (it.hasNext()) {
            if (!firstCondition) {
                buffer.append(PREDICATE_OR);
            }
            String formatPredicate = ContentObjectSelectionRule.getPredicateConditionForProperty(propertyName, it.next());
            buffer.append(formatPredicate);
            firstCondition = false;
        }
        buffer.append(PREDICATE_CLOSE_BRACKET);
        return buffer.toString();
    }

    public static String getANDPredicateForNotPropertyValues(String propertyName, ArrayList<String> propertyValues) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PREDICATE_OPEN_BRACKET);
        boolean firstCondition = true;
        Iterator<String> it = propertyValues.iterator();
        while (it.hasNext()) {
            if (!firstCondition) {
                buffer.append(PREDICATE_AND);
            }
            String formatPredicate = ContentObjectSelectionRule.getNotPredicateConditionForProperty(propertyName, it.next());
            buffer.append(formatPredicate);
            firstCondition = false;
        }
        buffer.append(PREDICATE_CLOSE_BRACKET);
        return buffer.toString();
    }
}

