/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.NoObjectsContentObjectSelectionRule;
import com.cognos.cm.contentTasks.cleanupTask.RetentionContentObjectSelectionRule;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMRetentionRule;
import java.util.ArrayList;
import java.util.Set;

public class ContentObjectSelectionRuleFactory {
    private final CMObjectClasses cmObjectClasses;

    public ContentObjectSelectionRuleFactory(CMObjectClasses cmObjectClasses) {
        this.cmObjectClasses = cmObjectClasses;
    }

    public ContentObjectSelectionRule createObjectClassSelectionRule(String objectClassName) {
        String predicate = ContentObjectSelectionRule.getPredicateForObjectClass(objectClassName);
        ContentObjectSelectionRule selectionRule = new ContentObjectSelectionRule(predicate);
        return selectionRule;
    }

    public ContentObjectSelectionRule createObjectClassSelectionRule(String[] objectClassNames) {
        String predicate = ContentObjectSelectionRule.getPredicateForObjectClasses(objectClassNames);
        ContentObjectSelectionRule selectionRule = new ContentObjectSelectionRule(predicate);
        return selectionRule;
    }

    public IContentObjectSelectionRule createSelectionRuleForParentClasses(CMObjectClass[] childClasses, Set<CMObjectClass> filter) {
        ArrayList<CMObjectClass> parentClasses = this.findParentClasses(childClasses, filter);
        if (parentClasses.isEmpty()) {
            return new NoObjectsContentObjectSelectionRule();
        }
        String[] classNames = this.objectClassesListToNamesArray(parentClasses);
        String predicate = ContentObjectSelectionRule.getPredicateForObjectClasses(classNames);
        return new ContentObjectSelectionRule(predicate);
    }

    private ArrayList<CMObjectClass> findParentClasses(CMObjectClass[] childClasses, Set<CMObjectClass> skip) {
        ArrayList<CMObjectClass> result = new ArrayList<CMObjectClass>();
        block0: for (CMObjectClass cls : this.cmObjectClasses.getAllClasses()) {
            if (skip.contains(cls)) continue;
            for (CMObjectClass child : childClasses) {
                if (!cls.isValidChildClass(child)) continue;
                result.add(cls);
                continue block0;
            }
        }
        return result;
    }

    public IContentObjectSelectionRule createSelectionRuleForAscendantClasses(CMObjectClass[] childClasses, CMObjectClass[] parentClasses, CMObjectClass[] excludeClasses) {
        ArrayList<CMObjectClass> allClassesArray = this.findAllAscendantClasses(childClasses);
        this.filterByParentClasses(allClassesArray, parentClasses);
        this.excludeClassesFromArray(allClassesArray, excludeClasses);
        if (allClassesArray.size() <= 0) {
            return new NoObjectsContentObjectSelectionRule();
        }
        String[] classNames = this.objectClassesListToNamesArray(allClassesArray);
        String predicate = ContentObjectSelectionRule.getPredicateForObjectClasses(classNames);
        return new ContentObjectSelectionRule(predicate);
    }

    private void filterByParentClasses(ArrayList<CMObjectClass> allClassNamesArray, CMObjectClass[] parentClasses) {
        for (int i = 0; i < parentClasses.length; ++i) {
            for (int c = allClassNamesArray.size() - 1; c >= 0; --c) {
                CMObjectClass objectClass = allClassNamesArray.get(c);
                if (parentClasses[i].isValidChildClass(objectClass)) continue;
                allClassNamesArray.remove(c);
            }
        }
    }

    private void excludeClassesFromArray(ArrayList<CMObjectClass> allClassNamesArray, CMObjectClass[] excludeClasses) {
        for (int i = 0; i < excludeClasses.length; ++i) {
            for (int c = allClassNamesArray.size() - 1; c >= 0; --c) {
                String className = allClassNamesArray.get(c).getName();
                if (!excludeClasses[i].getName().equals(className)) continue;
                allClassNamesArray.remove(c);
            }
        }
    }

    private ArrayList<CMObjectClass> findAllAscendantClasses(CMObjectClass[] childClasses) {
        ArrayList<CMObjectClass> allClassesArray = new ArrayList<CMObjectClass>();
        ArrayList<CMObjectClass> childrenClassArray = new ArrayList<CMObjectClass>();
        ArrayList<CMObjectClass> parentClassArray = new ArrayList<CMObjectClass>();
        int c = 0;
        for (c = 0; c < childClasses.length; ++c) {
            childrenClassArray.add(childClasses[c]);
        }
        CMObjectClass[] allClasses = this.cmObjectClasses.getAllClasses();
        while (childrenClassArray.size() > 0) {
            for (int i = 0; i < allClasses.length; ++i) {
                boolean isValidParent = false;
                for (c = 0; !isValidParent && c < childrenClassArray.size(); ++c) {
                    if (!allClasses[i].isValidChildClass((CMObjectClass)childrenClassArray.get(c))) continue;
                    isValidParent = true;
                }
                if (!isValidParent || this.isInObjectClassArray(allClassesArray, allClasses[i])) continue;
                parentClassArray.add(allClasses[i]);
                allClassesArray.add(allClasses[i]);
            }
            childrenClassArray.clear();
            childrenClassArray.addAll(parentClassArray);
            parentClassArray.clear();
        }
        return allClassesArray;
    }

    private boolean isInObjectClassArray(ArrayList<CMObjectClass> allClassesArray, CMObjectClass objectClass) {
        return allClassesArray.contains(objectClass);
    }

    public String[] objectClassesListToNamesArray(ArrayList<CMObjectClass> objectClasses) {
        String[] classNames = new String[objectClasses.size()];
        for (int i = 0; i < classNames.length; ++i) {
            classNames[i] = objectClasses.get(i).getName();
        }
        return classNames;
    }

    public IContentObjectSelectionRule createRetentionSelectionRule(CMRetentionRule retentionRule) {
        return new RetentionContentObjectSelectionRule(retentionRule);
    }
}

