/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.multipart.ResponseFileAttachment;
import com.cognos.cm.properties.DataPropertyHelper;
import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMInputStreamWithSize;
import java.io.InputStream;
import java.util.Properties;

public class OutputDataObject
implements DataObject {
    private final ResponseFileAttachment dataFile;
    private DataPropertyHelper dataPropertyHelper;
    private CMInputStreamWithSize is;

    public OutputDataObject() {
        this.dataFile = null;
    }

    public OutputDataObject(ResponseFileAttachment dataFile, DataPropertyHelper dataPropertyHelper) {
        this.dataFile = dataFile;
        this.dataPropertyHelper = dataPropertyHelper;
    }

    public InputStream getDataStream() throws RepositoryException {
        try {
            this.prepareInputStream();
        }
        catch (CMException ex) {
            throw new RepositoryException(ex.getMessage(), (Throwable)ex);
        }
        return this.is;
    }

    private void prepareInputStream() throws CMException {
        if (this.is == null && this.dataFile != null) {
            try {
                this.is = this.dataFile.prepareInputStreamForWriteEntire();
            }
            catch (Exception ex) {
                throw new CMException(ex, "cmErrorWritingTempFile");
            }
        }
    }

    public Properties getProperties() throws RepositoryException {
        try {
            this.prepareInputStream();
        }
        catch (CMException ex) {
            throw new RepositoryException(ex.getMessage());
        }
        Properties properties = new Properties();
        if (this.dataFile != null && this.dataFile.getContentType() != null) {
            properties.put("Content-Type", this.dataFile.getContentType());
        }
        if (this.is != null) {
            properties.put("Content-Length", String.valueOf(this.is.length()));
        }
        return properties;
    }

    public void release() {
        if (this.dataFile != null) {
            this.dataFile.release();
        }
        if (this.dataPropertyHelper != null) {
            this.dataPropertyHelper.remove();
        }
    }

    public long getDataLength() throws RepositoryException {
        try {
            this.prepareInputStream();
        }
        catch (CMException ex) {
            throw new RepositoryException(ex.getMessage());
        }
        long dataLength = -1L;
        if (this.is != null) {
            dataLength = this.is.length();
        }
        return dataLength;
    }
}

