/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.contentTasks.cleanupTask.DataObjectBuilder;
import com.cognos.cm.contentTasks.cleanupTask.IStoreWithLockManager;
import com.cognos.cm.contentTasks.cleanupTask.OutputDataObject;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multipart.ResponseFileAttachment;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.DataPropertyHelper;
import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMTempFileCache;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.perfMonitor.PerfMeasure;
import com.cognos.perfMonitor.PerfMonitor;
import java.util.HashMap;
import java.util.Map;

public class OutputDataObjectBuilder
implements DataObjectBuilder {
    private static final PerfMeasure PERF_DATA_READS = PerfMonitor.getMeasure((String)"com.cognos.cm.ContentTasks.Class.data.reads", (String)"The number of archival task action class data reads and their size", (int)5);
    private final IStoreWithLockManager storeWithLockManager;
    private final CMTempFileCache tempFileCache;
    private Map<String, CMProperty[]> dataProperties;
    private static int DATA_IDX = 0;
    private static int DATATYPE_IDX = DATA_IDX + 1;
    private static int DATASIZE_IDX = DATA_IDX + 2;
    private static int DATAISCOMPRESSED_IDX = DATA_IDX + 3;

    public OutputDataObjectBuilder(IStoreWithLockManager store, CMTempFileCache tempFileCache) {
        this.storeWithLockManager = store;
        this.tempFileCache = tempFileCache;
        this.dataProperties = new HashMap<String, CMProperty[]>();
    }

    private CMStore getStore() {
        return this.storeWithLockManager.getStore();
    }

    private ICMLockManager getLockManager() {
        return this.storeWithLockManager.getLockManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataObject createDataObject(String objectSearchPath) throws CMException {
        CMStoreXPath storeIDPath = new CMStoreXPath(objectSearchPath);
        storeIDPath.setLockManagerUsageFlag(10);
        CMStoreQueryResults results = null;
        boolean attachCount = false;
        try {
            this.getLockManager().requestLocks(storeIDPath);
            results = this.getStore().executeQuery(storeIDPath, null, null, 0, 512, null);
            if (!results.next()) {
                throw new CMException("cmObjectNotFoundPath");
            }
            CMObjectClass objectClass = results.getObjectClass();
            this.setDataProperties(objectClass);
            results.release();
            results = null;
            results = this.getStore().executeQuery(storeIDPath, this.dataProperties.get(objectClass.getName()), null, 0, 512, null);
            if (!results.next()) {
                throw new CMException("cmObjectNotFoundPath");
            }
            Object dataPropertyValueObject = results.getValue(DATA_IDX);
            Object dataTypeObject = results.getValue(DATATYPE_IDX);
            Object dataIsCompressedObject = results.getValue(DATAISCOMPRESSED_IDX);
            Object dataSizeObject = results.getValue(DATASIZE_IDX);
            String contentType = dataTypeObject == null ? null : dataTypeObject.toString();
            boolean isInternalDataCompressed = dataIsCompressedObject == null ? false : CMXMLUtils.parseBooleanAttribute(dataIsCompressedObject.toString());
            long numTotalBytesRead = dataSizeObject == null ? 0L : Long.parseLong(dataSizeObject.toString());
            CMProperty dataProperty = this.dataProperties.get(objectClass.getName())[DATA_IDX];
            if (dataPropertyValueObject != null) {
                DataPropertyHelper helper = new DataPropertyHelper(this.tempFileCache, results, dataProperty, dataPropertyValueObject, contentType, isInternalDataCompressed);
                PERF_DATA_READS.incr(numTotalBytesRead);
                ResponseFileAttachment respAttach = this.createFileAttachment(helper, 0, isInternalDataCompressed, numTotalBytesRead);
                OutputDataObject outputDataObject = new OutputDataObject(respAttach, helper);
                return outputDataObject;
            }
            OutputDataObject outputDataObject = new OutputDataObject();
            return outputDataObject;
        }
        finally {
            if (results != null) {
                results.release();
            }
            this.getLockManager().releaseLocks();
        }
    }

    private ResponseFileAttachment createFileAttachment(DataPropertyHelper helper, int attachCount, boolean isInternalDataCompressed, long numTotalBytesRead) {
        boolean writeEverything = true;
        long nfirstDataByte = 0L;
        long nmaxDataBytes = 0L;
        boolean dataCompressed = false;
        ResponseFileAttachment respAttach = new ResponseFileAttachment(helper, null, attachCount++, numTotalBytesRead, 0L, 0L, false, true);
        respAttach.setContentType(helper.getContentType());
        respAttach.setContentTransferEncoding("8bit");
        respAttach.setIsGZipped(false);
        return respAttach;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDataProperties(CMObjectClass objectClass) {
        Map<String, CMProperty[]> map = this.dataProperties;
        synchronized (map) {
            if (this.dataProperties.get(objectClass.getName()) == null) {
                CMProperty[] dataProperties = new CMProperty[4];
                CMProperty[] outputClassProperties = objectClass.getProperties();
                for (int i = 0; i < outputClassProperties.length; ++i) {
                    CMProperty property = outputClassProperties[i];
                    if (property.hasMeaning(CMPropertyMeaning.DATA)) {
                        dataProperties[OutputDataObjectBuilder.DATA_IDX] = property;
                        continue;
                    }
                    if (property.hasMeaning(CMPropertyMeaning.DATASIZE)) {
                        dataProperties[OutputDataObjectBuilder.DATASIZE_IDX] = property;
                        continue;
                    }
                    if (property.hasMeaning(CMPropertyMeaning.DATATYPE)) {
                        dataProperties[OutputDataObjectBuilder.DATATYPE_IDX] = property;
                        continue;
                    }
                    if (!property.hasMeaning(CMPropertyMeaning._DATAISCOMPRESSED)) continue;
                    dataProperties[OutputDataObjectBuilder.DATAISCOMPRESSED_IDX] = property;
                }
                this.dataProperties.put(objectClass.getName(), dataProperties);
            }
        }
    }
}

