/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMRepositoryRule;
import com.cognos.cm.properties.CMRepositoryRuleArray;
import com.cognos.cm.properties.IRepositoryRules;
import com.cognos.cm.properties.RepositoryRules;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.HashMap;
import java.util.Map;

public class RepositoryRulesTempCache
implements IRepositoryRules {
    private Map<String, Map<String, String>> tempCache = new HashMap<String, Map<String, String>>();
    private RepositoryRules repositoryRules = this.createRepositoryRules();

    @Override
    public String getRepositoryDataSourceName(ICMStorePath searchStorePath, CMObjectClass repositoryRuleObjectClass) throws CMException {
        Map<String, String> dataSourceNames = this.getDataSourceNames(searchStorePath);
        return this.getDataSourceName(searchStorePath, repositoryRuleObjectClass, dataSourceNames);
    }

    @Override
    public String getRepositoryDataSourceName(ICMStorePath searchStorePath) throws CMException {
        Map<String, String> dataSourceNames = this.getDataSourceNames(searchStorePath);
        return this.getDataSourceName(searchStorePath, this.repositoryRules.getRepositoryRuleObjectClass(searchStorePath), dataSourceNames);
    }

    @Override
    public boolean hasRepositoryRule(ICMStorePath searchStorePath) throws CMException {
        return this.repositoryRules.hasRepositoryRule(this.getRepositoryDataSourceName(searchStorePath));
    }

    @Override
    public boolean hasRepositoryRuleForClass(ICMStorePath searchStorePath, CMObjectClass repositoryRuleObjectClass) throws CMException {
        return this.repositoryRules.hasRepositoryRule(this.getRepositoryDataSourceName(searchStorePath, repositoryRuleObjectClass));
    }

    private Map<String, String> getDataSourceNames(ICMStorePath searchStorePath) {
        String searchPath = searchStorePath.getOriginalPath();
        Map<String, String> dataSourceNames = this.tempCache.get(searchPath);
        if (dataSourceNames == null) {
            this.tempCache.put(searchPath, new HashMap());
        }
        return this.tempCache.get(searchPath);
    }

    private String getDataSourceName(ICMStorePath searchStorePath, CMObjectClass repositoryRuleObjectClass, Map<String, String> dataSourceNames) throws CMException {
        if (!dataSourceNames.containsKey(repositoryRuleObjectClass.getName())) {
            dataSourceNames.put(repositoryRuleObjectClass.getName(), this.repositoryRules.getRepositoryDataSourceName(searchStorePath, repositoryRuleObjectClass));
        }
        return dataSourceNames.get(repositoryRuleObjectClass.getName());
    }

    protected RepositoryRules createRepositoryRules() {
        return new RepositoryRules();
    }

    public void addEntry(String searchPath, CMRepositoryRuleArray repositoryRuleArray) {
        HashMap<String, String> dataSourceNames = new HashMap<String, String>();
        for (int i = 0; i < repositoryRuleArray.getSize(); ++i) {
            CMRepositoryRule repositoryRule = repositoryRuleArray.getRule(i);
            dataSourceNames.put(repositoryRule.getObjectClass().getName(), repositoryRule.getDataSourceName());
            this.tempCache.put(searchPath, dataSourceNames);
        }
    }

    public String getSearchPathOfObjectWithRepositoryRule(ICMStorePath searchStorePath, CMStore store) throws CMException {
        return this.repositoryRules.getSearchPathOfObjectWithRepositoryRule(searchStorePath, store);
    }
}

