/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.contentTasks.cleanupTask.ContentObjectSet;
import com.cognos.cm.contentTasks.cleanupTask.IContentFilter;
import com.cognos.cm.contentTasks.cleanupTask.IContentObjectSet;
import com.cognos.cm.contentTasks.cleanupTask.ITaskContext;
import com.cognos.cm.contentTasks.cleanupTask.RetentionContentObjectSelectionRule;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.RetentionRulesExecutor;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;

public class RetentionKeepContentFilter
implements IContentFilter {
    private final RetentionContentObjectSelectionRule rule;
    private final ITaskContext taskContext;

    public RetentionKeepContentFilter(RetentionContentObjectSelectionRule rule, ITaskContext taskContext) {
        this.rule = rule;
        this.taskContext = taskContext;
    }

    public RetentionContentObjectSelectionRule getRule() {
        return this.rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IContentObjectSet getObjects(String containerSearchPath) throws CMException {
        RetentionRulesExecutor retentionRulesExecutor = new RetentionRulesExecutor(this.getStore(), new CMStorePathFactory(), null);
        ContentObjectSet set = new ContentObjectSet();
        CMStoreQueryResults queryResults = null;
        try {
            CMStoreXPath storeSearchPath = new CMStoreXPath(containerSearchPath);
            this.getLockManager().requestLocks(storeSearchPath);
            queryResults = retentionRulesExecutor.getKeepRetentionRuleResults(this.getStore(), this.rule.getRetentionRule(), containerSearchPath);
            while (queryResults.next()) {
                int objectID = queryResults.getObjectID();
                String storeID = this.getStore().getObjectStoreID(objectID);
                set.addObjectWithSearchPath(CMStoreXPath.encodeStoreIdToPathString(storeID));
            }
        }
        finally {
            if (queryResults != null) {
                queryResults.release();
            }
            this.getLockManager().releaseLocks();
        }
        return set;
    }

    private CMStore getStore() {
        return this.taskContext.getStoreWithLockManager().getStore();
    }

    private ICMLockManager getLockManager() {
        return this.taskContext.getStoreWithLockManager().getLockManager();
    }
}

