/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.cleanupTask;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.contentTasks.IRunnableErrorsReporter;
import com.cognos.cm.contentTasks.actions.IActionReporter;
import com.cognos.cm.contentTasks.cleanupTask.ITaskErrorReporter;
import com.cognos.cm.server.CMException;
import java.util.ArrayList;

public class TaskErrorReporter
implements IRunnableErrorsReporter,
ITaskErrorReporter {
    private IRunnableErrorsReporter errorsReporter;
    private String auditLevel = "minimal";
    private ArrayList<IActionReporter> actionReporters;

    public TaskErrorReporter(IRunnableErrorsReporter errorsReporter) {
        this.errorsReporter = errorsReporter;
        this.actionReporters = new ArrayList();
    }

    public void resetErrorsCounter() {
        for (IActionReporter actionReporter : this.actionReporters) {
            actionReporter.resetFailureCounter();
        }
    }

    public void resetSuccessCounter() {
        for (IActionReporter actionReporter : this.actionReporters) {
            actionReporter.resetSuccessCounter();
        }
    }

    public void reportTotalSuccessAndError(String searchPath) throws CMException {
        for (IActionReporter actionReporter : this.actionReporters) {
            String totalSuccessAndErrors = actionReporter.getTotalSuccessAndFailuresMessage(searchPath);
            this.addHistoryDetail(totalSuccessAndErrors, "info");
        }
    }

    @Override
    public void addHistoryDetail(String detail, String severity) throws CMException {
        this.errorsReporter.addHistoryDetail(detail, severity);
    }

    @Override
    public void reportError(CMException ex, String severity) throws CMException {
        if (this.auditLevel.compareTo("trace") == 0 || this.auditLevel.compareTo("full") == 0 || this.auditLevel.compareTo("basic") == 0) {
            this.errorsReporter.reportError(ex, severity);
        }
    }

    @Override
    public void reportError(String errCode, String severity, CMException.Parm[] parms) throws CMException {
        if (this.auditLevel.compareTo("trace") == 0 || this.auditLevel.compareTo("full") == 0 || this.auditLevel.compareTo("basic") == 0) {
            this.errorsReporter.reportError(errCode, severity, parms);
        }
    }

    @Override
    public void reportErrorThrowable(String errCode, String severity, CMException.Parm[] parms, Throwable t) throws CMException {
        if (this.auditLevel.compareTo("trace") == 0 || this.auditLevel.compareTo("full") == 0 || this.auditLevel.compareTo("basic") == 0) {
            this.errorsReporter.reportErrorThrowable(errCode, severity, parms, t);
        }
    }

    @Override
    public void reportTaskError(CMException ex, String severity) throws CMException {
        this.reportError(ex, severity);
    }

    @Override
    public void reportTaskError(String errCode, String severity, CMException.Parm[] parms) throws CMException {
        this.reportError(errCode, severity, parms);
    }

    @Override
    public void reportTaskErrorThrowable(String errCode, String severity, CMException.Parm[] parms, Throwable t) throws CMException {
        this.reportErrorThrowable(errCode, severity, parms, t);
    }

    public void setAuditLevel(String auditLevel) {
        if (auditLevel != null) {
            this.auditLevel = auditLevel;
        }
    }

    @Override
    public void reportSuccess(String successMessage, CMException.Parm[] parms) throws CMException {
        if (this.auditLevel.compareTo("trace") == 0 || this.auditLevel.compareTo("full") == 0) {
            String concatenatedMessage = this.concatenateMessageAndParams(successMessage, parms);
            this.errorsReporter.addHistoryDetail(concatenatedMessage, "info");
        }
    }

    @Override
    public void reportSuccess(String message, String objectSearchPath) throws CMException {
        CMException.Parm[] parms = this.createObjectParameters(objectSearchPath);
        this.reportSuccess(message, parms);
    }

    private String concatenateMessageAndParams(String message, CMException.Parm[] parms) {
        return CMError.getMessage(message, parms, null);
    }

    public String getAuditLevel() {
        return this.auditLevel;
    }

    public CMException.Parm[] createObjectParameters(String objectSearchPath) {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath)};
        return parms;
    }

    public CMException.Parm[] createObjectExceptionParameters(String objectSearchPath, Throwable t) {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("OBJECT", objectSearchPath), new CMException.Parm("EXCEPTION", t)};
        return parms;
    }

    @Override
    public void reportFailure(String searchPath, Throwable t, String message) throws CMException {
        CMException.Parm[] parms = this.createObjectExceptionParameters(searchPath, t);
        this.reportError(message, "error", parms);
    }

    @Override
    public void reportFailureThrowable(String searchPath, Throwable t, String message) throws CMException {
        CMException.Parm[] parms = this.createObjectExceptionParameters(searchPath, t);
        this.reportErrorThrowable(message, "error", parms, t);
    }

    @Override
    public boolean isComplete() throws CMException {
        return false;
    }

    @Override
    public void addActionReporter(IActionReporter actionReporter) {
        this.actionReporters.add(actionReporter);
    }

    public boolean isError() {
        for (IActionReporter actionReporter : this.actionReporters) {
            if (actionReporter.getFailureCounter() <= 0L) continue;
            return true;
        }
        return false;
    }
}

