/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AllObjectsCmidAndStoreId {
    private int[] tenantIdFilter;

    public AllObjectsCmidAndStoreId(int[] tenantIdFilter) {
        this.tenantIdFilter = tenantIdFilter;
    }

    public void execute(CMDbConnection connection, AllObjectQueryListener listener) throws CMException {
        ICMDbStoreSqlGenerator sqlGenerator = connection.getSqlGenerator();
        SqlBuilder sql = new SqlBuilder(sqlGenerator);
        sql.select().aliasedColumn("objs", "CMID").separator().aliasedColumn("ids", "STOREID");
        sql.from().aliasedTable("objs", "CMOBJECTS").innerJoin().aliasedTable("ids", "CMSTOREIDS").onJoinConditionEquals("objs", "CMID", "ids", "CMID");
        if (this.tenantIdFilter != null && this.tenantIdFilter.length != 0) {
            sql.where().aliasedColumn("objs", "TENANTID").in(this.tenantIdFilter);
        }
        sql.orderBy().aliasedColumn("objs", "CMID");
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sql.toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                listener.foundObject(resultSet.getInt(1), resultSet.getString(2));
            }
        }
        catch (SQLException sqlE) {
            try {
                throw new CMException(sqlE);
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(statement);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(statement);
    }

    public static interface AllObjectQueryListener {
        public void foundObject(int var1, String var2);
    }
}

