/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.dbstore.CMDbSizeExecutable;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreMetadataUtil;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AllTablesCmidSize
extends CMDbSizeExecutable {
    protected SizedListener listener;
    private int[] tenantIdFilter;
    private Map<String, List<String>> ignoredColumns;

    public AllTablesCmidSize(CMDbStore store, int[] tenantIdFilter, Map<String, List<String>> ignoredColumns) {
        super(store);
        this.tenantIdFilter = tenantIdFilter;
        this.ignoredColumns = ignoredColumns;
        if (ignoredColumns == null) {
            this.ignoredColumns = Collections.emptyMap();
        }
    }

    public void calculate(SizedListener listener) throws CMException {
        this.listener = listener;
        HashSet<String> tables = new HashSet<String>(CMDbStoreMetadataUtil.getPropertyTablesList());
        this.execute(tables);
    }

    @Override
    protected boolean appendSqlForTable(SqlBuilder sql, String table, Map<String, HashMap<String, Object>> columns) throws CMException, SQLException {
        if (this.ignoredColumns.containsKey(table)) {
            columns = new HashMap<String, HashMap<String, Object>>(columns);
            List<String> columnsToIgnore = this.ignoredColumns.get(table);
            for (String column : columnsToIgnore) {
                columns.remove(column);
            }
        }
        sql.select().aliasedColumn("s", "CMID").separator();
        if (!this.appendSizeColumnsSql(sql, columns)) {
            return false;
        }
        sql.from().aliasedTable("s", table);
        if (this.tenantIdFilter != null && this.tenantIdFilter.length != 0) {
            sql.innerJoin().aliasedTable("objs", "CMOBJECTS").onJoinConditionEquals("s", "CMID", "objs", "CMID");
            sql.where().aliasedColumn("objs", "TENANTID").in(this.tenantIdFilter);
        }
        sql.groupBy().aliasedColumn("s", "CMID");
        return true;
    }

    @Override
    protected void bindParameters(PreparedStatement stmt) throws SQLException {
    }

    @Override
    protected void extractResult(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            this.listener.sized(resultSet.getInt(1), resultSet.getLong(2));
        }
    }

    public static interface SizedListener {
        public void sized(int var1, long var2);
    }
}

