/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.contentTasks.csutilization.AllObjectsCmidAndStoreId;
import com.cognos.cm.contentTasks.csutilization.AllTablesCmidSize;
import com.cognos.cm.contentTasks.csutilization.CSUtilizationProcessor;
import com.cognos.cm.contentTasks.csutilization.ContentStoreUtilizationConfiguration;
import com.cognos.cm.contentTasks.csutilization.OutputDataPropSizer;
import com.cognos.cm.contentTasks.csutilization.UtilizationWriter;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMEnvironment;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CSUtilizationAllObjects
implements CSUtilizationProcessor {
    private static final String[] HEADERS = new String[]{"tenantID", "objectName", "objectClass", "size (bytes)", "size in EOS (bytes)", "storeID", "parentStoreID"};
    private CMDbStore store;
    private TenantRegistry tenantRegistry;
    private ContentStoreUtilizationConfiguration configuration;
    private Map<Integer, SizeContainer> cmidToContainer;
    private int savedIsolationLevel;

    public CSUtilizationAllObjects(CMDbStore store) {
        this.store = store;
        this.tenantRegistry = store.getTenantRegistry();
        this.cmidToContainer = new HashMap<Integer, SizeContainer>();
    }

    @Override
    public void configure(ContentStoreUtilizationConfiguration config) {
        this.configuration = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UtilizationWriter writer) throws CMException {
        writer.setHeaders(HEADERS);
        CMDbConnection connection = this.store.getConnection();
        this.setDirtyReadIsolation(connection);
        try {
            AllObjectsCmidAndStoreId query2 = this.createAllObjectsQuery(this.configuration.getTenantFilter());
            query2.execute(connection, new AllObjectsCmidAndStoreId.AllObjectQueryListener(){

                @Override
                public void foundObject(int cmid, String storeId) {
                    CSUtilizationAllObjects.this.cmidToContainer.put(cmid, new SizeContainer(storeId));
                }
            });
            HashMap<String, List<String>> ignoredColumns = new HashMap<String, List<String>>();
            ignoredColumns.put("CMDATA", Collections.singletonList("DATAPROP"));
            AllTablesCmidSize sizer = this.createTableSizer(this.configuration.getTenantFilter(), ignoredColumns);
            sizer.calculate(new AllTablesCmidSize.SizedListener(){

                @Override
                public void sized(int cmid, long size) {
                    SizeContainer container = (SizeContainer)CSUtilizationAllObjects.this.cmidToContainer.get(cmid);
                    if (container != null) {
                        container.incrementSize(size);
                    }
                }
            });
            OutputDataPropSizer outputSizer = this.createOutputDataPropSizer();
            outputSizer.execute(connection, new OutputDataPropSizer.OutputDataPropSizerListener(){

                @Override
                public void sized(int cmid, long size, boolean isEosSize) {
                    SizeContainer container = (SizeContainer)CSUtilizationAllObjects.this.cmidToContainer.get(cmid);
                    if (container != null) {
                        if (isEosSize) {
                            container.incrementEosSize(size);
                        } else {
                            container.incrementSize(size);
                        }
                    }
                }
            });
            this.produceFinalResult(writer, this.cmidToContainer);
        }
        finally {
            this.resetIsolation(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File produceFinalResult(UtilizationWriter writer, Map<Integer, SizeContainer> sizes) throws CMException {
        File resultFile = new File(CMEnvironment.getCRNLogsDir(), "cmUtilization_" + String.valueOf(CMDateUtils.getUTCTime()) + ".csv");
        try {
            int bufferSize = 16;
            ArrayList<InternalStoreId> buffer = new ArrayList<InternalStoreId>(bufferSize);
            for (SizeContainer container : sizes.values()) {
                buffer.add(container.storeId);
                if (buffer.size() < bufferSize) continue;
                this.queryAndOutputObjects(writer, buffer, sizes);
                buffer.clear();
            }
            if (!buffer.isEmpty()) {
                this.queryAndOutputObjects(writer, buffer, sizes);
            }
        }
        finally {
            writer.close();
        }
        return resultFile;
    }

    private void queryAndOutputObjects(UtilizationWriter writer, List<InternalStoreId> buffer, Map<Integer, SizeContainer> sizes) throws CMException {
        boolean hasTenantFilter = this.configuration.hasTenantFilter();
        Set<Integer> tenantIds = this.configuration.getTenantFilterAsSet();
        CMStoreQueryResults result = null;
        try {
            this.store.getLockManager().requestLocks(buffer, 10);
            result = this.store.executeQuery(buffer, new CMProperty[0], null, 0, 512, null);
            while (result.next()) {
                int objectId = result.getObjectID();
                SizeContainer container = sizes.get(objectId);
                if (container == null) continue;
                int tenantIdInt = result.getTenantID();
                if (hasTenantFilter && !tenantIds.contains(tenantIdInt)) continue;
                String tenantId = this.tenantRegistry.getTenantIdStringFromInt(tenantIdInt);
                String storeId = this.store.getCache().CMCacheGetStoreId(objectId, true);
                String parentStoreId = this.store.getCache().CMCacheGetStoreId(result.getParentObjectID(), true);
                writer.write(tenantId, result.getName(), result.getObjectClass().getName(), String.valueOf(container.size), String.valueOf(container.eosSize), storeId, parentStoreId);
            }
        }
        catch (IOException e) {
            throw new CMException(e);
        }
        finally {
            if (result != null) {
                result.release();
            }
            this.store.getLockManager().releaseLocks();
        }
    }

    private void resetIsolation(CMDbConnection connection) throws CMException {
        try {
            if (CMDbConnection.getDbmsInfo().getDbms() != 2) {
                connection.getConnection().setTransactionIsolation(this.savedIsolationLevel);
            }
        }
        catch (SQLException e) {
            throw new CMException(e);
        }
    }

    private void setDirtyReadIsolation(CMDbConnection connection) throws CMException {
        try {
            if (CMDbConnection.getDbmsInfo().getDbms() != 2) {
                this.savedIsolationLevel = connection.getConnection().getTransactionIsolation();
                connection.getConnection().setTransactionIsolation(1);
            }
        }
        catch (SQLException e) {
            throw new CMException(e);
        }
    }

    protected OutputDataPropSizer createOutputDataPropSizer() {
        return new OutputDataPropSizer(this.configuration.getTenantFilter());
    }

    protected AllTablesCmidSize createTableSizer(int[] tenantIdFilter, Map<String, List<String>> ignoredColumns) {
        return new AllTablesCmidSize(this.store, tenantIdFilter, ignoredColumns);
    }

    protected AllObjectsCmidAndStoreId createAllObjectsQuery(int[] tenantIdFilter) {
        return new AllObjectsCmidAndStoreId(tenantIdFilter);
    }

    private static class SizeContainer {
        private long size;
        private long eosSize;
        private InternalStoreId storeId;

        private SizeContainer(String storeIdString) {
            this.storeId = new InternalStoreId(storeIdString);
        }

        private void incrementSize(long delta) {
            this.size += delta;
        }

        private void incrementEosSize(long delta) {
            this.eosSize += delta;
        }
    }
}

