/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.contentTasks.csutilization.CSUtilizationProcessor;
import com.cognos.cm.contentTasks.csutilization.ContentStoreUtilizationConfiguration;
import com.cognos.cm.contentTasks.csutilization.UtilizationWriter;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreMetadataUtil;
import com.cognos.cm.dbstore.ObjectSizeByTenant;
import com.cognos.cm.dbstore.OutputSizeByTenant;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMTenantCountSizeInfo;
import com.cognos.cm.server.CMException;
import java.io.IOException;
import java.util.Map;
import java.util.SortedSet;

public class CSUtilizationByObjectClasses
implements CSUtilizationProcessor {
    private static final String[] HEADERS = new String[]{"tenantID", "objectClass", "instance count", "size (bytes)", "size in EOS (bytes)"};
    private CMDbStore store;
    private TenantRegistry registry;
    private int[] tenantIds;

    public CSUtilizationByObjectClasses(CMDbStore store) {
        this.store = store;
        this.registry = store.getTenantRegistry();
    }

    @Override
    public void configure(ContentStoreUtilizationConfiguration config) {
        this.tenantIds = config.getTenantFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UtilizationWriter writer) throws CMException {
        writer.setHeaders(HEADERS);
        Map<String, SortedSet<String>> tables = CMDbStoreMetadataUtil.getClassesMap();
        CMObjectClass[] allClasses = this.store.getObjectClasses().getAllClasses();
        String tenantOperatingOn = null;
        try {
            ObjectSizeByTenant executable = this.createSizeExecutable();
            for (CMObjectClass objectClass : allClasses) {
                Map<Integer, CMTenantCountSizeInfo> sizes;
                SortedSet<String> tablesForClass = tables.get(String.valueOf(objectClass.getID()));
                if (tablesForClass == null) continue;
                if (objectClass.equals(CMObjectClass.OUTPUT)) {
                    OutputSizeByTenant outputTask = this.createOutputObjectSizeTask();
                    sizes = outputTask.calculate(tablesForClass, objectClass);
                } else {
                    sizes = executable.calculate(tablesForClass, objectClass);
                }
                this.outputSizes(writer, tenantOperatingOn, sizes);
            }
        }
        finally {
            writer.close();
        }
    }

    private void outputSizes(UtilizationWriter writer, String tenantOperatingOn, Map<Integer, CMTenantCountSizeInfo> sizes) throws CMException {
        if (sizes != null) {
            try {
                for (CMTenantCountSizeInfo info : sizes.values()) {
                    tenantOperatingOn = this.registry.getTenantIdStringFromInt(info.getTenantId());
                    writer.write(tenantOperatingOn, info.getClassName(), String.valueOf(info.getCount()), String.valueOf(info.getSize()), String.valueOf(info.getSizeInEOS()));
                }
            }
            catch (IOException e) {
                CMException exception = new CMException((Exception)e, "fileWriteError", new CMException.Parm("file", writer.getFileNameForTenant(tenantOperatingOn)));
                CMIndications.logException(exception);
                throw exception;
            }
        }
    }

    protected OutputSizeByTenant createOutputObjectSizeTask() {
        OutputSizeByTenant outputTask = new OutputSizeByTenant(this.store, this.tenantIds);
        return outputTask;
    }

    protected ObjectSizeByTenant createSizeExecutable() {
        ObjectSizeByTenant executable = new ObjectSizeByTenant(this.store, this.tenantIds);
        return executable;
    }
}

