/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ContentStoreUtilizationConfiguration {
    private boolean filePerTenant;
    private int[] tenantFilter = null;
    private Granularity granularity = Granularity.classesPerTenant;

    public ContentStoreUtilizationConfiguration(boolean filePerTenant, int[] tenantFilter, Granularity granularity) {
        this.filePerTenant = filePerTenant;
        this.tenantFilter = tenantFilter;
        this.granularity = granularity;
    }

    public ContentStoreUtilizationConfiguration() {
    }

    public boolean isFilePerTenant() {
        return this.filePerTenant;
    }

    public void setFilePerTenant(boolean filePerTenant) {
        this.filePerTenant = filePerTenant;
    }

    public int[] getTenantFilter() {
        return this.tenantFilter;
    }

    public boolean hasTenantFilter() {
        return this.tenantFilter != null;
    }

    public boolean hasFilterAllFilter() {
        return this.hasTenantFilter() && this.tenantFilter.length == 0;
    }

    public Set<Integer> getTenantFilterAsSet() {
        if (!this.hasTenantFilter()) {
            return null;
        }
        HashSet<Integer> tenantIds = new HashSet<Integer>(this.tenantFilter.length);
        for (int i : this.tenantFilter) {
            tenantIds.add(i);
        }
        return tenantIds;
    }

    public void setTenantFilter(int[] tenantFilter) {
        this.tenantFilter = tenantFilter;
    }

    public Granularity getGranularity() {
        return this.granularity;
    }

    public void setGranularity(Granularity granularity) {
        this.granularity = granularity;
    }

    public static ContentStoreUtilizationConfiguration parse(TenantRegistry registry, String xml) throws CMException {
        ContentStoreUtilizationConfiguration config = new ContentStoreUtilizationConfiguration();
        XMLElement root = CMXMLUtils.convertXMLString2XMLElement(xml).getChild(0);
        config.setFilePerTenant(root.getOptionalChildBooleanValueWithName("filePerTenant", false));
        ContentStoreUtilizationConfiguration.parseTenantFilter(registry, config, root);
        ContentStoreUtilizationConfiguration.parseGranularity(config, root);
        return config;
    }

    private static void parseGranularity(ContentStoreUtilizationConfiguration config, XMLElement root) throws CMException {
        Granularity granularity = Granularity.classesPerTenant;
        String granularityString = root.getOptionalChildValueWithName("granularity");
        if (granularityString != null && !granularityString.isEmpty()) {
            try {
                granularity = Granularity.valueOf(granularityString);
            }
            catch (IllegalArgumentException e) {
                throw new CMException("cmBadPropValue", new CMException.Parm("Value", granularityString));
            }
        }
        config.setGranularity(granularity);
    }

    private static void parseTenantFilter(TenantRegistry registry, ContentStoreUtilizationConfiguration config, XMLElement root) throws CMException {
        int[] result = null;
        XMLElement tenantFilters = root.getOptionalChildWithName("tenantFilter");
        if (tenantFilters != null) {
            HashSet<String> allTenantIds = new HashSet<String>(registry.getTenantIdStrings());
            ArrayList<XMLElement> tenantElements = tenantFilters.getChildren();
            if (tenantElements != null && !tenantElements.isEmpty()) {
                HashSet<String> tenantSet = new HashSet<String>();
                for (XMLElement tenantEle : tenantElements) {
                    String tenant = tenantEle.value_ == null ? "" : tenantEle.value_;
                    if (!allTenantIds.remove(tenant)) continue;
                    tenantSet.add(tenant);
                }
                if (!allTenantIds.isEmpty()) {
                    result = new int[tenantSet.size()];
                    int i = 0;
                    for (String tenant : tenantSet) {
                        result[i++] = registry.getTenantIdIntFromString(tenant, false);
                    }
                }
            }
        }
        config.setTenantFilter(result);
    }

    static enum Granularity {
        classesPerTenant,
        perObject;

    }
}

