/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.contentTasks.Task;
import com.cognos.cm.contentTasks.csutilization.CSUtilizationAllObjects;
import com.cognos.cm.contentTasks.csutilization.CSUtilizationByObjectClasses;
import com.cognos.cm.contentTasks.csutilization.CSUtilizationProcessor;
import com.cognos.cm.contentTasks.csutilization.ContentStoreUtilizationConfiguration;
import com.cognos.cm.contentTasks.csutilization.PerTenantUtilizationWriter;
import com.cognos.cm.contentTasks.csutilization.SingleFileUtilizationWriter;
import com.cognos.cm.contentTasks.csutilization.UtilizationWriter;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.util.CMEnvironment;
import java.util.List;
import java.util.Map;

public class CreateContentStoreUtilizationInfo
extends Task {
    private ContentStoreUtilizationConfiguration configuration;
    private TenantRegistry registry;
    private UtilizationWriter writer;

    public CreateContentStoreUtilizationInfo(CMStore store, Map<String, Object> runOptions) throws CMException {
        this(store, runOptions, null);
    }

    @Override
    public Task.Lock getLock() {
        return new Task.LockNoOp();
    }

    public CreateContentStoreUtilizationInfo(CMStore store, Map<String, Object> runOptions, ContentStoreUtilizationConfiguration configuration) throws CMException {
        super(store, runOptions);
        this.registry = store.getTenantRegistry();
        this.configuration = configuration == null ? ContentStoreUtilizationConfiguration.parse(this.registry, this.getRunOptionValue(ContentTaskOption.createContentStoreUtilizationInfo).toString()) : configuration;
        this.writer = this.createUtilizationWriter();
    }

    protected UtilizationWriter createUtilizationWriter() {
        if (this.configuration.isFilePerTenant()) {
            return new PerTenantUtilizationWriter(CMEnvironment.getCRNLogsDir(), "cmUtilization", "csv");
        }
        return new SingleFileUtilizationWriter(CMEnvironment.getCRNLogsDir(), "cmUtilization", "csv");
    }

    @Override
    public void execute() throws CMException {
        if (!CMExecutionContext.get().getCurrentUserIsAdministrator()) {
            throw new CMException("cmMustBeSysAdmin");
        }
        if (this.configuration.hasFilterAllFilter()) {
            return;
        }
        CSUtilizationProcessor utilizationProcessor = this.createUtilizationProcessor();
        utilizationProcessor.configure(this.configuration);
        utilizationProcessor.process(this.writer);
        List<String> fileNames = this.writer.getFileNames();
        for (String fileName : fileNames) {
            this.reportError("csUtilizationSavedTo", "info", new CMException.Parm[]{new CMException.Parm("fileName", fileName)});
        }
    }

    protected CSUtilizationProcessor createUtilizationProcessor() {
        if (this.configuration.getGranularity().equals((Object)ContentStoreUtilizationConfiguration.Granularity.perObject)) {
            return new CSUtilizationAllObjects((CMDbStore)this.getStore());
        }
        return new CSUtilizationByObjectClasses((CMDbStore)this.getStore());
    }

    @Override
    public void initialize() throws CMException {
    }
}

