/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OutputDataPropSizer {
    private int[] forTenantsIds;

    public OutputDataPropSizer(int[] forTenantsIds) {
        this.forTenantsIds = forTenantsIds;
    }

    public void execute(CMDbConnection connection, OutputDataPropSizerListener listener) throws CMException {
        SqlBuilder builder = new SqlBuilder(connection.getSqlGenerator());
        this.buildSql(builder);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(builder.toString());
            this.bindTenantFilter(statement);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                int cmid = result.getInt(1);
                long size = result.getLong(2);
                boolean isEos = result.getInt(3) == 1;
                listener.sized(cmid, size, isEos);
            }
        }
        catch (SQLException e) {
            try {
                throw new CMException(e);
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(statement);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(statement);
    }

    private void bindTenantFilter(PreparedStatement statement) throws SQLException {
        if (this.filterByTenant()) {
            CMDbStoreDMLDef.bindInts(1, statement, this.forTenantsIds, 0, this.forTenantsIds.length);
        }
    }

    private void buildSql(SqlBuilder sql) {
        sql.select();
        sql.aliasedColumn("objs", "CMID").separator().aliasedColumn("data", "DATASIZE").separator();
        sql.caseWhen().aliasedColumn("data", "DATASIZE").notEquals().append("0").and().lobIsNull("data", "DATAPROP").caseEndAsBoolean();
        sql.from().aliasedTable("objs", "CMOBJECTS").innerJoin().aliasedTable("data", "CMDATA").onJoinConditionEquals("objs", "CMID", "data", "CMID");
        sql.where().aliasedColumn("objs", "CLASSID").equalsValue(CMObjectClass.OUTPUT.getID());
        if (this.filterByTenant()) {
            sql.and().aliasedColumn("objs", "TENANTID");
            CMDbStoreDMLDef.appendInBindVariables(sql.getSqlGenerator(), sql.getBuffer(), this.forTenantsIds.length);
        }
    }

    protected boolean filterByTenant() {
        return this.forTenantsIds != null && this.forTenantsIds.length > 0;
    }

    public static interface OutputDataPropSizerListener {
        public void sized(int var1, long var2, boolean var4);
    }
}

