/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.contentTasks.csutilization.UtilizationWriter;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.csv.CSVUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerTenantUtilizationWriter
extends UtilizationWriter {
    private Map<String, StringWriter> tenantToBuffer = new HashMap<String, StringWriter>();
    protected String timestamp = String.valueOf(CMDateUtils.getUTCTime());

    public PerTenantUtilizationWriter(File rootDir, String filePrefix, String fileExtension) {
        super(rootDir, filePrefix, fileExtension);
    }

    @Override
    public void write(String ... values) throws IOException {
        if (values.length < 1) {
            throw new IllegalArgumentException("Expected at least one argument");
        }
        String tenant = values[0];
        StringWriter writer = this.tenantToBuffer.get(tenant);
        if (writer == null) {
            writer = new StringWriter();
            this.tenantToBuffer.put(tenant, writer);
            CSVUtils.encodeAndWrite((Writer)writer, (String[])this.headers);
        }
        CSVUtils.encodeAndWrite((Writer)writer, (String[])values);
        if (this.bufferSizeExceeded(writer)) {
            this.flushToFile(writer, tenant);
        }
    }

    protected boolean bufferSizeExceeded(StringWriter writer) {
        return writer.getBuffer().length() > 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushToFile(StringWriter writer, String tenant) throws IOException {
        writer.close();
        Writer fileWriter = this.createWriter(this.getFileNameForTenant(tenant));
        try {
            fileWriter.write(writer.getBuffer().toString());
        }
        finally {
            CMStreamUtils.quietClose((Writer)fileWriter);
        }
        this.tenantToBuffer.put(tenant, new StringWriter());
    }

    @Override
    public String getFileNameForTenant(String tenantName) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.filePrefix).append("_");
        builder.append(this.timestamp);
        builder.append("_").append(tenantName == null ? "" : tenantName);
        builder.append(".").append(this.fileExtension);
        return builder.toString();
    }

    protected Writer createWriter(String fileName) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.rootDir, fileName), true), "UTF-8");
    }

    @Override
    public void close() throws CMException {
        String tenant = null;
        try {
            for (Map.Entry<String, StringWriter> entry : this.tenantToBuffer.entrySet()) {
                tenant = entry.getKey();
                StringWriter writer = entry.getValue();
                writer.flush();
                if (writer.getBuffer().length() <= 0) continue;
                this.flushToFile(writer, tenant);
            }
        }
        catch (IOException e) {
            throw new CMException((Exception)e, "fileWriteError", new CMException.Parm("file", this.getFileNameForTenant(tenant)));
        }
    }

    @Override
    public List<String> getFileNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String tenant : this.tenantToBuffer.keySet()) {
            result.add(this.getFileNameForTenant(tenant));
        }
        return result;
    }
}

