/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.contentTasks.csutilization;

import com.cognos.cm.contentTasks.csutilization.UtilizationWriter;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.csv.CSVUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class SingleFileUtilizationWriter
extends UtilizationWriter {
    private String fileName = this.createFileName();
    private Writer writer;

    public SingleFileUtilizationWriter(File rootDir, String filePrefix, String fileExtension) {
        super(rootDir, filePrefix, fileExtension);
    }

    @Override
    public void write(String ... values) throws IOException {
        if (this.writer == null) {
            this.writer = this.createWriter();
            CSVUtils.encodeAndWrite((Writer)this.writer, (String[])this.headers);
        }
        CSVUtils.encodeAndWrite((Writer)this.writer, (String[])values);
    }

    private String createFileName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.filePrefix).append("_");
        builder.append(this.getTimestamp());
        builder.append(".").append(this.fileExtension);
        return builder.toString();
    }

    protected String getTimestamp() {
        return String.valueOf(CMDateUtils.getUTCTime());
    }

    @Override
    public String getFileNameForTenant(String tenantName) {
        return this.fileName;
    }

    protected Writer createWriter() throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.rootDir, this.fileName)), "UTF-8");
    }

    @Override
    public void close() {
        CMStreamUtils.quietClose((Writer)this.writer);
    }

    @Override
    public List<String> getFileNames() {
        return Arrays.asList(this.fileName);
    }
}

