/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.UrlUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AdvancedSettingsDbLoader {
    private static final String advSettingsPropertyDef = "<property name='advancedSettings' table='CMOBJPROPS16' column='ADVSETTINGS' type='xs:anyType'/>";
    private static final String dispatcherPathPropertyDef = "<property name='dispatcherPath' table='CMOBJPROPS6' column='DISPATCHERPATH' type='xs:anyURI'/>";

    public String load() throws CMException {
        String advancedSettings = null;
        String dispatcherPath = this.determineDispatcherPath();
        advancedSettings = CMProperty.DISPATCHERPATH != null ? this.loadWhenUnderDispatcher(dispatcherPath) : this.loadInStandAlone(dispatcherPath);
        return advancedSettings;
    }

    private String determineDispatcherPath() throws CMException {
        IConfiguration config = ConfigurationFactory.getConfig();
        String dispatcherURL = config.getCognosProp("externalDispatcher");
        if (dispatcherURL == null) {
            return null;
        }
        return UrlUtils.convertURItoDispatcherPath(dispatcherURL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadWhenUnderDispatcher(String dispatcherPath) throws CMException {
        String advancedSettings;
        CMStoreQueryResults qresults = null;
        try {
            CMStore store = CMExecutionContext.get().getStore();
            qresults = this.queryForCmServiceAdvancedProperties(store, dispatcherPath);
            advancedSettings = this.readAdvancedSettingProperty(qresults);
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
        }
        return advancedSettings;
    }

    private CMStoreQueryResults queryForCmServiceAdvancedProperties(CMStore store, String dispatcherPath) throws CMStoreParseException, CMException {
        CMStorePath servicePath = this.createCMServicePath(dispatcherPath);
        CMProperty[] props = new CMProperty[]{CMProperty.ADVANCEDSETTINGS};
        CMStoreQueryResults qresults = store.executeQuery(servicePath, props, null, 0, 512, null);
        return qresults;
    }

    private CMStorePath createCMServicePath(String dispatcherPath) throws CMStoreParseException {
        String cmServicePath = "/configuration//dispatcher[@" + CMProperty.DISPATCHERPATH.getName() + "='" + dispatcherPath + "']/contentManagerService";
        CMStoreXPath servicePath = new CMStoreXPath(null, cmServicePath, false);
        return servicePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAdvancedSettingProperty(CMStoreQueryResults qresults) throws CMException {
        Object valueObj;
        String advancedSettings = null;
        if (qresults != null && qresults.next() && (valueObj = qresults.getValue(0)) != null) {
            if (valueObj instanceof Reader) {
                Reader stream = null;
                stream = (Reader)valueObj;
                try {
                    advancedSettings = CMStreamUtils.readReaderIntoString((Reader)stream);
                    stream.close();
                    stream = null;
                }
                catch (IOException iOException) {
                }
                finally {
                    CMStreamUtils.quietClose((Reader)stream);
                }
            } else {
                advancedSettings = qresults.getValue(0).toString();
            }
        }
        return advancedSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadInStandAlone(String dispatcherPath) throws CMException {
        if (dispatcherPath == null) {
            return null;
        }
        String advancedSettings = null;
        CMDbConnection con = CMDbStoreFactory.getAdminConnection();
        Statement stmt = null;
        try {
            CMDbProperty advSettingsProperty = new CMDbProperty(con.getConnection(), advSettingsPropertyDef);
            CMDbProperty dispPathProperty = new CMDbProperty(con.getConnection(), dispatcherPathPropertyDef);
            stmt = con.createStatement();
            if (CMDbConnection.dbms_ == 3) {
                con.beginTransaction();
            }
            String queryString = this.buildQueryString(dispatcherPath, advSettingsProperty, dispPathProperty);
            ResultSet rs = stmt.executeQuery(queryString);
            advancedSettings = this.getAdvancedSettings(advSettingsProperty, rs);
            this.cleanupResources(con, stmt);
            return advancedSettings;
        }
        catch (SQLException ex) {
            CMException cmex = CMDbStoreExceptionUtil.analyzeSQLException(con, ex, "cmStoreUnexpected");
            throw cmex;
            catch (Exception ex2) {
                String string = null;
                return string;
            }
        }
        finally {
            this.cleanupResources(con, stmt);
        }
    }

    private String buildQueryString(String dispatcherPath, CMDbProperty advSettingsProperty, CMDbProperty dispPathProperty) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("select ");
        buffer.append(advSettingsProperty.getColumn(0).getName());
        buffer.append(" from ");
        buffer.append(advSettingsProperty.getColumn(0).getTable());
        buffer.append(" where CMID in (select CMID from CMOBJECTS where CLASSID=47 and PCMID in (select CMID from ");
        buffer.append(dispPathProperty.getColumn(0).getTable());
        buffer.append(" where ");
        buffer.append(dispPathProperty.getColumn(0).getName());
        buffer.append("='");
        buffer.append(dispatcherPath);
        buffer.append("'");
        buffer.append("))");
        return buffer.toString();
    }

    private String getAdvancedSettings(CMDbProperty advSettingsProperty, ResultSet rs) throws SQLException {
        Object valueObj;
        String advancedSettings = null;
        if (rs.next() && (valueObj = CMDbStorePropertySerialization.getColumnByProperty(rs, 1, advSettingsProperty)) != null) {
            if (valueObj instanceof Reader) {
                Reader stream = (Reader)valueObj;
                advancedSettings = this.readAdvancedSettings(advancedSettings, stream);
            } else {
                advancedSettings = valueObj.toString();
            }
        }
        return advancedSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAdvancedSettings(String advancedSettings, Reader stream) {
        try {
            advancedSettings = CMStreamUtils.readReaderIntoString((Reader)stream);
            stream.close();
            stream = null;
        }
        catch (IOException iOException) {
        }
        finally {
            CMStreamUtils.quietClose((Reader)stream);
        }
        return advancedSettings;
    }

    private void cleanupResources(CMDbConnection con, Statement stmt) {
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (con != null && CMDbConnection.dbms_ == 3) {
            try {
                con.commitTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (con != null) {
            CMDbStoreFactory.releaseConnection(con);
        }
    }
}

