/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.constants.ArchiveStatus;
import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreUpdateDef;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.IArchiveStatusUpdater;
import java.sql.SQLException;

public class ArchiveStatusUpdater
implements IArchiveStatusUpdater {
    private static String canArchivableObjectsBeDeletedStatementBeginingStr = null;

    @Override
    public void updateArchiveStatus(int objectID, ArchiveStatus status, CMStore store) throws CMException, SQLException {
        if (!store.inTransaction()) {
            throw new IllegalStateException("updateArchiveStatus must be called within a transaction");
        }
        CMDbProperty prop = (CMDbProperty)CMProperty._ARCHIVESTATUS;
        CMDbStoreUpdateDef updateDef = new CMDbStoreUpdateDef(prop.getColumn(0).getTable());
        updateDef.addColumn(prop, status.getValue());
        CMDbStore dbStore = this.castToDbStore(store);
        CMDbConnection dbCon = dbStore.getConnection();
        updateDef.execute(dbCon, objectID);
    }

    protected CMDbStore castToDbStore(CMStore store) {
        if (!(store instanceof CMDbStore)) {
            throw new IllegalStateException("Store is not instance of CMDbStore");
        }
        return (CMDbStore)store;
    }

    @Override
    public boolean canObjectsBeDeleted(CMDbConnection con, int[] objectIDs) throws CMException, SQLException {
        if (objectIDs == null || objectIDs.length == 0) {
            return true;
        }
        CMDbStoreDMLDef updateDef = new CMDbStoreDMLDef("");
        String updateBeginStr = this.constructStatusUpdateForDeleteBeginSQLString(con);
        int numOfUnarchivedObjects = updateDef.executeInGroups(con, updateBeginStr, objectIDs, null);
        return numOfUnarchivedObjects <= 0;
    }

    private String constructStatusUpdateForDeleteBeginSQLString(CMDbConnection con) {
        if (canArchivableObjectsBeDeletedStatementBeginingStr == null) {
            CMDbColumn archiveStatusColumn = ((CMDbProperty)CMProperty._ARCHIVESTATUS).getColumn(0);
            String tableName = archiveStatusColumn.getTable();
            String columnName = archiveStatusColumn.getName();
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            StringBuffer stmtBuffer = new StringBuffer();
            stmtBuffer.append(sqlGenerator.createUpdateFromTableSetSql(tableName));
            stmtBuffer.append(columnName);
            stmtBuffer.append(sqlGenerator.createEqualsSql());
            stmtBuffer.append(columnName);
            stmtBuffer.append(sqlGenerator.createWhereSql());
            stmtBuffer.append(columnName);
            stmtBuffer.append(sqlGenerator.createEqualsSql());
            stmtBuffer.append(ArchiveStatus.HOLD.getId());
            stmtBuffer.append(sqlGenerator.createAndSql());
            canArchivableObjectsBeDeletedStatementBeginingStr = stmtBuffer.toString();
        }
        return canArchivableObjectsBeDeletedStatementBeginingStr;
    }
}

