/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMTempFileLRUCache;
import com.cognos.cm.util.CMThreadPoolRunnable;
import com.cognos.cmutils.tempcache.CMTempFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.Statement;

public class CMDbAsyncLOBReadRunnable
implements CMThreadPoolRunnable {
    private int objectId_;
    private Object key_;
    private CMTempFileLRUCache tempFileCache_;
    private boolean bStopRequested_;
    private CMDbConnection connection_;
    public Exception exception_;
    private Object syncExceptionObject_ = new Object();
    private Statement selectStmt_;
    private ResultSet rs_;
    private Reader reader_;
    private InputStream inputStream_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMDbAsyncLOBReadRunnable(CMTempFileLRUCache tempFileCache, int objectId, CMProperty property) throws CMException {
        this.tempFileCache_ = tempFileCache;
        this.objectId_ = objectId;
        this.key_ = this.tempFileCache_.getNewTempFileCacheKey(this.objectId_, property);
        try {
            this.connection_ = CMDbStoreFactory.getConnection();
            CMDbStoreSelectDef selectDef = new CMDbStoreSelectDef(this.connection_, null, new CMProperty[]{property}, null);
            String selectClause = selectDef.getSelectStmt();
            if (selectClause == null) {
                Object object = this.syncExceptionObject_;
                synchronized (object) {
                    this.exception_ = new IllegalStateException("AsynchReadData selectStmt couldn't be null");
                }
            }
            StringBuffer selectStmtWithWhereClause = new StringBuffer();
            selectStmtWithWhereClause.append(selectClause);
            String whereClause = selectDef.getWhereClause();
            if (whereClause != null) {
                selectStmtWithWhereClause.append(whereClause);
                selectStmtWithWhereClause.append(" and o.CMID=");
            } else {
                selectStmtWithWhereClause.append(" where o.CMID=");
            }
            selectStmtWithWhereClause.append(String.valueOf(this.objectId_));
            this.selectStmt_ = this.connection_.createStatement();
            this.rs_ = this.selectStmt_.executeQuery(selectStmtWithWhereClause.toString());
            if (this.rs_.next()) {
                Object valueObject = CMDbStorePropertySerialization.getColumnByProperty(this.rs_, 2, property);
                if (valueObject instanceof InputStream) {
                    this.inputStream_ = (InputStream)valueObject;
                } else if (valueObject instanceof Reader) {
                    this.reader_ = (Reader)valueObject;
                }
            }
        }
        catch (Exception ex) {
            Object object = this.syncExceptionObject_;
            synchronized (object) {
                this.exception_ = ex;
            }
            throw new CMException(ex, "cmDataReadFail");
        }
    }

    @Override
    public Object getKey() {
        return this.key_;
    }

    @Override
    public void stop() {
        this.bStopRequested_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exception getException() {
        Object object = this.syncExceptionObject_;
        synchronized (object) {
            return this.exception_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.bStopRequested_) {
            Object object = this.syncExceptionObject_;
            synchronized (object) {
                this.exception_ = new IllegalStateException("CMDbAsyncLOBReadRunnable cannot run after stop has been requested.");
            }
        }
        try {
            boolean bDoneReading = false;
            CMTempFile tempfile = this.tempFileCache_.get(this.key_);
            OutputStream outputStream = null;
            try {
                outputStream = tempfile.getOutputStream();
                while (!this.bStopRequested_) {
                    block37: {
                        if (bDoneReading) return;
                        tempfile.getLock().acquireWrite();
                        if (this.inputStream_ != null) {
                            long numTotalBytesRead = 0L;
                            long chunksize = AdvancedSettings.ASYNCDATAREAD_BYTECHUNKSIZE;
                            try {
                                byte[] inputData = new byte[32768];
                                int nBytesRead = this.inputStream_.read(inputData);
                                while (nBytesRead > 0 && !this.bStopRequested_) {
                                    tempfile.incrContentSize(nBytesRead);
                                    this.tempFileCache_.freeSpaceForBytes(nBytesRead);
                                    outputStream.write(inputData, 0, nBytesRead);
                                    if ((numTotalBytesRead += (long)nBytesRead) >= chunksize) break;
                                    nBytesRead = this.inputStream_.read(inputData);
                                }
                                if (nBytesRead <= 0) {
                                    bDoneReading = true;
                                }
                                break block37;
                            }
                            catch (Exception e) {
                                throw new CMException(e, "cmDataReadFail");
                            }
                        }
                        if (this.reader_ != null) {
                            OutputStreamWriter outputStreamW = null;
                            long chunksize = AdvancedSettings.ASYNCDATAREAD_CHARCHUNKSIZE;
                            long numTotalBytesRead = 0L;
                            try {
                                try {
                                    outputStreamW = new OutputStreamWriter(outputStream, "UTF-8");
                                }
                                catch (Exception ex) {
                                    outputStreamW = new OutputStreamWriter(outputStream);
                                }
                                char[] buffer = new char[32768];
                                int numRead = 0;
                                numRead = this.reader_.read(buffer);
                                while (numRead > 0 && !this.bStopRequested_) {
                                    tempfile.incrContentSize(numRead);
                                    this.tempFileCache_.freeSpaceForBytes(numRead);
                                    outputStreamW.write(buffer, 0, numRead);
                                    if ((numTotalBytesRead += (long)numRead) >= chunksize) break;
                                    numRead = this.reader_.read(buffer);
                                }
                                if (numRead <= 0) {
                                    bDoneReading = true;
                                }
                            }
                            catch (Exception e) {
                                throw new CMException(e, "cmDataReadFail");
                            }
                            finally {
                                if (outputStreamW != null) {
                                    try {
                                        outputStreamW.flush();
                                    }
                                    catch (IOException ex) {
                                        throw new CMException(ex, "cmDataReadFail");
                                    }
                                }
                            }
                        }
                    }
                    tempfile.notifyMoreWritten();
                    tempfile.getLock().release();
                }
                return;
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                tempfile.close();
                this.tempFileCache_.bytesWritten(tempfile);
                tempfile.release();
            }
        }
        catch (Exception ex) {
            Object object = this.syncExceptionObject_;
            synchronized (object) {
                this.exception_ = ex;
                return;
            }
        }
        finally {
            this.release();
        }
    }

    public void release() {
        if (this.reader_ != null) {
            try {
                this.reader_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader_ = null;
        }
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
        if (this.rs_ != null) {
            try {
                this.rs_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rs_ = null;
        }
        if (this.selectStmt_ != null) {
            try {
                this.selectStmt_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.selectStmt_ = null;
        }
        if (this.connection_ != null) {
            CMDbStoreFactory.releaseConnection(this.connection_);
            this.connection_ = null;
        }
    }

    public void finalize() throws Throwable {
        this.release();
    }
}

