/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreNonObjectAddDef;
import com.cognos.cm.dbstore.CMDbStoreNonObjectUpdateDef;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCADataStore;
import com.cognos.cm.store.CMCADataStoreException;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;

public class CMDbCAStore
extends CMCADataStore {
    private static volatile boolean initialized_;
    private static CMDbProperty CAKEY;
    private static CMDbProperty CADATA;
    private static String singleKeyWhereClause_;
    private static final String CAKEYDEF = "<property name='_CAkey' table='CMCAKEYS' column='CAKEY' type='xs:string'/>";
    private static final String CADATADEF = "<property name='_CAdata' table='CMCAKEYS' column='DATA' type='xs:base64Binary'/>";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getData(String key) throws CMCADataStoreException {
        PreparedStatement stmt;
        CMDbConnection con;
        block30: {
            ResultSet rs2333332;
            CMDbCAStore.storeInitializedTest();
            con = CMDbCAStore.getConnection();
            stmt = null;
            stmt = con.prepareStatement("select DATA from CMCAKEYS where " + singleKeyWhereClause_);
            CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, CAKEY, key);
            if (CMDbConnection.getDbmsInfo().readLOBinTransaction()) {
                con.beginTransaction();
            }
            if ((rs2333332 = stmt.executeQuery()).next()) {
                Object data = CMDbStorePropertySerialization.getColumnByProperty(rs2333332, 1, CADATA);
                if (data == null) {
                    byte[] byArray = null;
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (con.inTransaction()) {
                        try {
                            con.commitTransaction();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    CMDbStoreFactory.releaseConnection(con);
                    return byArray;
                }
                if (data instanceof byte[]) {
                    byte[] byArray = (byte[])data;
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (con.inTransaction()) {
                        try {
                            con.commitTransaction();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    CMDbStoreFactory.releaseConnection(con);
                    return byArray;
                }
                if (data instanceof InputStream) {
                    byte[] byArray = CMStreamUtils.readInputStreamIntoByteArray((InputStream)((InputStream)data));
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (con.inTransaction()) {
                        try {
                            con.commitTransaction();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    CMDbStoreFactory.releaseConnection(con);
                    return byArray;
                }
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (!con.inTransaction()) break block30;
            try {
                con.commitTransaction();
            }
            catch (SQLException rs2333332) {
                // empty catch block
            }
        }
        CMDbStoreFactory.releaseConnection(con);
        return null;
        catch (SQLException ex) {
            CMDbCAStore.handleSQLException(con, ex);
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                throw new CMCADataStoreException(3, ex2);
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (con.inTransaction()) {
                try {
                    con.commitTransaction();
                }
                catch (SQLException ex) {}
            }
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(String key, byte[] data) throws CMCADataStoreException {
        CMDbCAStore.storeInitializedTest();
        CMDbConnection con = CMDbCAStore.getConnection();
        boolean bSucceeded = false;
        try {
            this.doAdd(con, key, data);
            bSucceeded = true;
        }
        catch (CMCADataStoreException ex) {
            if (ex.getCode() == 7) {
                this.doUpdate(con, key, data);
                bSucceeded = true;
            }
        }
        finally {
            if (bSucceeded) {
                this.incrementFreshness(con);
            }
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateData(String key, byte[] data) throws CMCADataStoreException {
        CMDbCAStore.storeInitializedTest();
        CMDbConnection con = CMDbCAStore.getConnection();
        try {
            boolean bl = this.doUpdate(con, key, data);
            return bl;
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) throws CMCADataStoreException, CMException {
        boolean bSucceeded;
        block6: {
            bSucceeded = false;
            CMDbCAStore.storeInitializedTest();
            CMDbConnection con = CMDbCAStore.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement("delete from CMCAKEYS where " + singleKeyWhereClause_);
                CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, CAKEY, key);
                boolean bl = bSucceeded = CMDbConnection.executeUpdate(stmt) > 0;
                if (bSucceeded) {
                    this.incrementFreshness(con);
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            catch (SQLException ex) {
                CMDbCAStore.handleSQLException(con, ex);
                break block6;
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMDbStoreFactory.releaseConnection(con);
            }
            CMDbStoreFactory.releaseConnection(con);
        }
        return bSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllDataKeys() throws CMCADataStoreException {
        CMDbCAStore.storeInitializedTest();
        CMDbConnection con = CMDbCAStore.getConnection();
        Statement stmt = null;
        ArrayList<String> results = new ArrayList<String>();
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select CAKEY from CMCAKEYS");
            while (rs.next()) {
                results.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            CMDbCAStore.handleSQLException(con, ex);
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            CMDbStoreFactory.releaseConnection(con);
        }
        return results.toArray(new String[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String key, byte[] data) throws CMCADataStoreException {
        CMDbCAStore.storeInitializedTest();
        CMDbConnection con = CMDbCAStore.getConnection();
        try {
            if (!this.doUpdate(con, key, data)) {
                this.doAdd(con, key, data);
            }
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    @Override
    public Vector<Object> getAllData() throws CMCADataStoreException {
        CMDbCAStore.storeInitializedTest();
        CMDbConnection con = CMDbCAStore.getConnection();
        Statement stmt = null;
        Vector<Object> results = new Vector<Object>();
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select DATA from CMCAKEYS");
            if (CMDbConnection.getDbmsInfo().readLOBinTransaction()) {
                con.beginTransaction();
            }
            while (rs.next()) {
                Object data = CMDbStorePropertySerialization.getColumnByProperty(rs, 1, CADATA);
                if (data == null) continue;
                if (data instanceof byte[]) {
                    results.addElement(data);
                }
                if (!(data instanceof InputStream)) continue;
                results.addElement(CMStreamUtils.readInputStreamIntoByteArray((InputStream)((InputStream)data)));
            }
            if (con.inTransaction()) {
                con.commitTransaction();
            }
        }
        catch (SQLException ex) {
            CMDbCAStore.handleSQLException(con, ex);
        }
        catch (Exception ex) {
            throw new CMCADataStoreException(3, ex);
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (con.inTransaction()) {
                try {
                    con.commitTransaction();
                }
                catch (SQLException ex) {}
            }
            CMDbStoreFactory.releaseConnection(con);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer freshness() throws CMCADataStoreException {
        Integer result;
        block6: {
            CMDbCAStore.storeInitializedTest();
            CMDbConnection con = CMDbCAStore.getConnection();
            Statement stmt = null;
            result = null;
            try {
                stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery("select PROPINTVALUE from CMCAPROPS where PROPNAME = 'FRESHNESS'");
                if (rs.next()) {
                    result = new Integer(rs.getInt(1));
                    break block6;
                }
                throw new CMCADataStoreException(8);
            }
            catch (SQLException ex) {
                CMDbCAStore.handleSQLException(con, ex);
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMDbStoreFactory.releaseConnection(con);
            }
        }
        return result;
    }

    @Override
    public boolean isInitialized() {
        return initialized_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(CMDbConnection con, String key, byte[] data) throws CMCADataStoreException {
        try {
            con.beginTransaction();
            CMDbStoreNonObjectAddDef addDef = new CMDbStoreNonObjectAddDef("CMCAKEYS", CAKEY);
            addDef.addColumn(CADATA, data);
            addDef.execute(con, key);
            con.commitTransaction();
        }
        catch (Exception ex) {
            CMDbCAStore.handleSQLException(con, ex);
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdate(CMDbConnection con, String key, byte[] data) throws CMCADataStoreException {
        boolean successful = false;
        try {
            con.beginTransaction();
            CMDbStoreNonObjectUpdateDef updateDef = new CMDbStoreNonObjectUpdateDef("CMCAKEYS", CAKEY);
            updateDef.addColumn(CADATA, data);
            successful = updateDef.execute(con, " where " + singleKeyWhereClause_, new CMDbProperty[]{CAKEY}, new Object[]{key}) > 0;
            con.commitTransaction();
        }
        catch (Exception ex) {
            CMDbCAStore.handleSQLException(con, ex);
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
        return successful;
    }

    private static final CMDbConnection getConnection() throws CMCADataStoreException {
        try {
            return CMDbStoreFactory.getAdminConnection();
        }
        catch (CMStoreNotAvailable ex) {
            throw new CMCADataStoreException(2, ex.getException());
        }
    }

    private static final void handleSQLException(CMDbConnection con, Exception ex) throws CMCADataStoreException {
        int code = 3;
        if (ex instanceof SQLException) {
            if (CMIndications.logEnabled("Trace.CM.SQL", 30000)) {
                CMIndications.CMTrace("cmSQLConnectionException", new CMException.Parm[]{new CMException.Parm("Exception", ex.getMessage()), new CMException.Parm("ConID", "null")});
            }
            if (CMDbConnection.isConnectionProblem((SQLException)ex)) {
                code = 2;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            } else if (CMDbConnection.isConstraintViolation((SQLException)ex)) {
                code = 7;
            }
        }
        throw new CMCADataStoreException(code, ex);
    }

    private static final void storeInitializedTest() throws CMCADataStoreException {
        if (!CMDbStoreFactory.initedContentIndependentAfterLock_) {
            throw new CMCADataStoreException(1);
        }
        if (!initialized_) {
            CMDbCAStore.initialize();
        }
    }

    private static final synchronized void initialize() throws CMCADataStoreException {
        if (initialized_) {
            return;
        }
        CMDbConnection con = CMDbCAStore.getConnection();
        try {
            CAKEY = new CMDbProperty(con.getConnection(), CAKEYDEF);
            CADATA = new CMDbProperty(con.getConnection(), CADATADEF);
            boolean ciWrap = false;
            StringBuffer whereClause = new StringBuffer(1024);
            if (CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive()) {
                whereClause.append("UPPER(");
                ciWrap = true;
            }
            whereClause.append(CAKEY.getColumn(0).getName());
            if (ciWrap) {
                whereClause.append(")");
            }
            if (ciWrap && CMDbConnection.dbms_ == 3) {
                whereClause.append("=UPPER(cast(? as varchar(4000)))");
            } else if (ciWrap && CMDbConnection.dbms_ == 8) {
                whereClause.append("=UPPER(cast(? as lvarchar(4000)))");
            } else {
                whereClause.append(ciWrap ? "=UPPER(?)" : "=?");
            }
            singleKeyWhereClause_ = whereClause.toString();
        }
        catch (Exception ex) {
            throw new CMCADataStoreException(3, ex);
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
        initialized_ = true;
    }

    private void incrementFreshness(CMDbConnection con) throws CMCADataStoreException {
        try {
            Statement stmt = con.createStatement();
            CMDbConnection.executeUpdate(stmt, "update CMCAPROPS set PROPINTVALUE = PROPINTVALUE + 1 where PROPNAME = 'FRESHNESS'");
        }
        catch (Exception ex) {
            CMDbCAStore.handleSQLException(con, ex);
        }
    }
}

