/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbClassDef;
import com.cognos.cm.dbstore.CMDbPropertyDef;
import com.cognos.cm.dbstore.CMDbPropertyDefXMLImpl;
import com.cognos.cm.util.DOMUtils;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CMDbClassDefXMLImpl
implements CMDbClassDef {
    Element root;

    public CMDbClassDefXMLImpl(Element el) {
        this.root = el;
    }

    @Override
    public String getAttribute(String name) {
        return this.root.getAttribute(name);
    }

    @Override
    public CMDbClassDef getSuperClass(String className) {
        CMDbClassDefXMLImpl superDef = null;
        Element childElement = DOMUtils.element(this.root, className);
        if (childElement != null) {
            superDef = new CMDbClassDefXMLImpl(childElement);
        }
        return superDef;
    }

    @Override
    public Iterator<CMDbPropertyDef> getPropertyIterator() {
        return new PropertyIterator(DOMUtils.elementIterator(this.root, "property"));
    }

    @Override
    public Iterator<CMDbPropertyDef> getClassReferencesIterator() {
        return new PropertyIterator(DOMUtils.elementIterator(this.root, "classRef"));
    }

    @Override
    public boolean hasProperty(String propertyName) {
        Iterator<CMDbPropertyDef> iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            CMDbPropertyDef nameElement = iterator.next();
            String nameAttribute = nameElement.getAttribute("name");
            if (nameAttribute == null || nameAttribute.compareTo(propertyName) != 0) continue;
            return true;
        }
        return false;
    }

    class PropertyIterator
    implements Iterator<CMDbPropertyDef> {
        Iterator<Node> xmlIterator;

        PropertyIterator(Iterator<Node> iterator) {
            this.xmlIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.xmlIterator.hasNext();
        }

        @Override
        public CMDbPropertyDef next() {
            return new CMDbPropertyDefXMLImpl((Element)this.xmlIterator.next());
        }

        @Override
        public void remove() {
            this.xmlIterator.remove();
        }
    }
}

