/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnectionTransactionAction;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDB2zOSSqlGenerator;
import com.cognos.cm.dbstore.CMDbStoreDefaultSqlGenerator;
import com.cognos.cm.dbstore.CMDbStorePrepStmtCache;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMDbTempTableId;
import com.cognos.cm.dbstore.CMDbmsInfo;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMStore;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class CMDbConnection
implements ICMDbConnection {
    public static final int DBMS_UNKNOWN = 0;
    public static final int DBMS_MSSQLSERVER = 1;
    public static final int DBMS_ORACLE = 2;
    public static final int DBMS_DB2 = 3;
    public static final int DBMS_SYBASE = 4;
    public static final int DBMS_DERBY = 5;
    public static final int DBMS_INFORMIX = 8;
    public static final int DBMSSUBTYPE_DB2ZOS = 6;
    public static final int DBMSSUBTYPE_DB2LUW = 7;
    public static CMDbmsInfo dbmsInfo = new CMDbmsInfo();
    public static int dbms_ = 0;
    private static CMDbStoreDefaultSqlGenerator sqlGenerator;
    private static Method getCLOBStream_;
    private static Method getBLOBStream_;
    private CMStore store = null;
    private AtomicInteger uniqueId = new AtomicInteger(0);
    private int currStartId = this.uniqueId.get();
    public CMDbStorePrepStmtCache stmtCache_ = null;
    protected boolean isInitialized_ = false;
    private Connection connection_;
    private long creationTime_;
    private boolean inTransaction_;
    private int blobID_;
    private boolean isChecked_ = true;
    private boolean isDiscarded_ = false;
    private CMException exception_ = null;
    private ArrayList<CMDbConnectionTransactionAction> transactionActions_;

    public static CMDbmsInfo getDbmsInfo() {
        return dbmsInfo;
    }

    @Override
    public int getDbms() {
        return dbmsInfo.getDbms();
    }

    public boolean getDbmsIsCaseSensitive() {
        return dbmsInfo.getDbmsIsCaseSensitive();
    }

    public static void initMetaData(Connection con, String connectString) throws SQLException {
        dbmsInfo.setConfiguration(ConfigurationFactory.getConfig());
        dbmsInfo.load(con, connectString);
        dbms_ = dbmsInfo.getDbms();
        CMDbConnection.createSqlGenerator(dbmsInfo.getDbms(), dbmsInfo.getDbmsSubtype());
        if (dbmsInfo.getDbmsName().equalsIgnoreCase("oracle") && dbmsInfo.getIsThinDriver()) {
            try {
                Class<?> lobSupport = Class.forName("com.cognos.cm.dbstore.CMDbStoreOracleLOBSupport");
                getCLOBStream_ = lobSupport.getDeclaredMethod("getCLOBStream", ResultSet.class, Integer.TYPE);
                getBLOBStream_ = lobSupport.getDeclaredMethod("getBLOBStream", ResultSet.class, Integer.TYPE);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to load Oracle LOB support, missing or bad Java class com.cognos.cm.dbstore.CMDbStoreOracleLOBSupport");
            }
        }
    }

    protected static void createSqlGenerator(int dbType, int dbSubType) {
        if (dbType == 3 && dbSubType == 6) {
            sqlGenerator = new CMDbStoreDB2zOSSqlGenerator();
            return;
        }
        sqlGenerator = new CMDbStoreDefaultSqlGenerator();
    }

    @Override
    public ICMDbStoreSqlGenerator getSqlGenerator() {
        return sqlGenerator;
    }

    public static boolean isConstraintViolation(SQLException e) {
        String sSQLState = e.getSQLState();
        return sSQLState != null && sSQLState.startsWith("23") || e.getErrorCode() == 2627 || e.getErrorCode() == 547;
    }

    public static boolean isStringTruncationProblem(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState.equals("22001") || dbms_ == 2 && (e.getErrorCode() == 1401 || e.getErrorCode() == 17070 || e.getErrorCode() == 12899);
    }

    public static boolean isDataProblem(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState != null && sqlState.startsWith("22") || dbms_ == 2 && (e.getErrorCode() == 1401 || e.getErrorCode() == 17070 || e.getErrorCode() == 12899);
    }

    public static boolean isConnectionProblem(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState == null) {
            if (dbms_ == 2 ? e.getErrorCode() == 17002 || e.getErrorCode() == 17008 : dbms_ == 1 && e.getErrorCode() == 0) {
                return true;
            }
        } else {
            if (sqlState.startsWith("08")) {
                return true;
            }
            if (dbms_ == 2) {
                try {
                    int sqlStateValue = Integer.parseInt(sqlState);
                    if (sqlStateValue >= 60000 && sqlStateValue < 100000) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (dbms_ == 3) {
                if (sqlState.equals("40003")) {
                    return true;
                }
                if (sqlState.equals("S1000") && e.getMessage().indexOf("CLI0601E") >= 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public CMDbConnection() {
    }

    public CMDbConnection(Connection con, boolean suppressTempTables) throws SQLException {
        this();
        this.initialize(con, suppressTempTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Connection con, boolean suppressTempTables) throws SQLException {
        Statement connectionSetupStmt;
        this.isInitialized_ = true;
        this.connection_ = con;
        this.creationTime_ = System.currentTimeMillis();
        if (dbms_ == 8) {
            this.connection_.setHoldability(1);
            this.connection_.setTransactionIsolation(2);
            connectionSetupStmt = null;
            try {
                connectionSetupStmt = this.connection_.createStatement();
                connectionSetupStmt.execute("SET LOCK MODE TO WAIT " + AdvancedSettings.DBLOCKWAITTIMEOUT_INFORMIX);
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(connectionSetupStmt);
            }
        }
        if (dbms_ == 1 && AdvancedSettings.DBLOCKWAITTIMEOUT_MSSQLSERVER != -1) {
            connectionSetupStmt = null;
            try {
                connectionSetupStmt = this.connection_.createStatement();
                connectionSetupStmt.execute("SET LOCK_TIMEOUT " + AdvancedSettings.DBLOCKWAITTIMEOUT_MSSQLSERVER);
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(connectionSetupStmt);
            }
        }
        if (!(suppressTempTables || dbms_ != 1 && dbms_ != 3 && dbms_ != 4 && dbms_ != 5 && dbms_ != 8)) {
            Statement stmt = con.createStatement();
            try {
                String[] createTemporaryTableSqls = this.getSqlGenerator().createCreateTemporaryTableSqls();
                for (int i = 0; i < createTemporaryTableSqls.length; ++i) {
                    if (createTemporaryTableSqls[i].length() <= 0) continue;
                    stmt.execute(createTemporaryTableSqls[i]);
                }
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        this.stmtCache_ = new CMDbStorePrepStmtCache(this);
        this.transactionActions_ = new ArrayList();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        this.assertInitialized();
        return this.stmtCache_.prepareStatement(sql, resultSetType);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertInitialized();
        return this.connection_.prepareCall(sql);
    }

    public PreparedStatement getPreparedStatement(String name, String sql) throws SQLException {
        this.assertInitialized();
        return this.stmtCache_.getPreparedStatement(name, sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertInitialized();
        Statement stmt = this.connection_.createStatement();
        stmt = this.getProxyStatement(stmt);
        return stmt;
    }

    public Statement createStatement(int type, int concurrency) throws SQLException {
        this.assertInitialized();
        Statement stmt = this.connection_.createStatement(type, concurrency);
        stmt = this.getProxyStatement(stmt);
        return stmt;
    }

    private Statement getProxyStatement(Statement realStmt) throws SQLException {
        return this.stmtCache_.getProxyStatement(realStmt);
    }

    @Override
    public void beginTransaction() throws SQLException {
        this.assertInitialized();
        if (CMIndicationGlobals.bDbConnection_TraceSQLStatements) {
            CMIndications.CMTrace("cmSQLConnectionOp", new CMException.Parm[]{new CMException.Parm("SQL", "begin transaction"), new CMException.Parm("ConID", Integer.toString(System.identityHashCode(this.connection_)))});
        }
        if (dbms_ == 4) {
            if (!this.inTransaction_) {
                Statement stmt = this.createStatement();
                try {
                    stmt.execute("begin transaction");
                }
                finally {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                }
            }
        } else {
            this.connection_.setAutoCommit(false);
        }
        this.inTransaction_ = true;
    }

    @Override
    public void commitTransaction() throws SQLException {
        this.assertInitialized();
        if (CMIndicationGlobals.bDbConnection_TraceSQLStatements) {
            CMIndications.CMTrace("cmSQLConnectionOp", new CMException.Parm[]{new CMException.Parm("SQL", "commit transaction"), new CMException.Parm("ConID", Integer.toString(System.identityHashCode(this.connection_)))});
        }
        try {
            this.connection_.commit();
            this.commitTransactionActions();
        }
        finally {
            try {
                if (dbms_ != 4) {
                    this.connection_.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {}
            this.inTransaction_ = false;
            this.blobID_ = 0;
            this.transactionActions_.clear();
        }
    }

    @Override
    public void rollbackTransaction() throws SQLException {
        this.assertInitialized();
        if (this.store != null) {
            try {
                this.store.doRollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (CMIndicationGlobals.bDbConnection_TraceSQLStatements) {
            CMIndications.CMTrace("cmSQLConnectionOp", new CMException.Parm[]{new CMException.Parm("SQL", "rollback transaction"), new CMException.Parm("ConID", Integer.toString(System.identityHashCode(this.connection_)))});
        }
        try {
            if (!this.connection_.isClosed()) {
                this.connection_.rollback();
                this.rollbackTransactionActions();
            }
        }
        finally {
            try {
                if (!this.connection_.isClosed() && dbms_ != 4) {
                    this.connection_.setAutoCommit(true);
                }
            }
            catch (SQLException sQLException) {}
            this.inTransaction_ = false;
            this.blobID_ = 0;
            this.transactionActions_.clear();
        }
    }

    @Override
    public void addTransactionAction(CMDbConnectionTransactionAction action) {
        this.transactionActions_.add(action);
    }

    private void commitTransactionActions() {
        for (CMDbConnectionTransactionAction transactionAction : this.transactionActions_) {
            transactionAction.commit();
        }
    }

    private void rollbackTransactionActions() {
        for (CMDbConnectionTransactionAction transactionAction : this.transactionActions_) {
            transactionAction.rollback();
        }
    }

    @Override
    public boolean inTransaction() {
        return this.inTransaction_;
    }

    public boolean isClosed() throws SQLException {
        this.assertInitialized();
        return this.connection_.isClosed();
    }

    @Override
    public void close() throws SQLException {
        block9: {
            if (this.connection_ == null) {
                return;
            }
            if (CMIndicationGlobals.bDbConnection_TraceSQLStatements) {
                CMIndications.CMTrace("cmSQLConnectionOp", new CMException.Parm[]{new CMException.Parm("SQL", "close connection"), new CMException.Parm("ConID", Integer.toString(System.identityHashCode(this.connection_)))});
            }
            try {
                if (this.connection_.isClosed()) break block9;
                try {
                    if (this.inTransaction_) {
                        this.connection_.rollback();
                        this.rollbackTransactionActions();
                    }
                }
                finally {
                    this.connection_.close();
                }
            }
            finally {
                this.inTransaction_ = false;
                this.stmtCache_.release();
                this.transactionActions_.clear();
            }
        }
    }

    public Connection getConnection() {
        this.assertInitialized();
        return this.connection_;
    }

    public int getID() {
        this.assertInitialized();
        return System.identityHashCode(this.connection_);
    }

    public DatabaseMetaData getMetadata() throws SQLException {
        if (this.connection_ != null) {
            return this.connection_.getMetaData();
        }
        return null;
    }

    public static final int executeUpdate(PreparedStatement stmt) throws SQLException, CMException {
        CMExecutionContext.checkCancelOrTimeOut();
        if (dbms_ == 3) {
            try {
                return stmt.executeUpdate();
            }
            catch (SQLException ex) {
                String sqlState = ex.getSQLState();
                if (sqlState == null || !sqlState.equals("02000")) {
                    throw ex;
                }
                return 0;
            }
        }
        return stmt.executeUpdate();
    }

    public static final int executeUpdate(Statement stmt, String sqlText) throws SQLException {
        if (dbms_ == 3) {
            try {
                return stmt.executeUpdate(sqlText);
            }
            catch (SQLException ex) {
                String sqlState = ex.getSQLState();
                if (sqlState == null || !sqlState.equals("02000")) {
                    throw ex;
                }
                return 0;
            }
        }
        return stmt.executeUpdate(sqlText);
    }

    public static OutputStream getBlobStream(ResultSet rs, int colIdx) throws SQLException {
        try {
            return (OutputStream)getBLOBStream_.invoke(null, rs, new Integer(colIdx));
        }
        catch (InvocationTargetException ex) {
            Throwable realEx = ex.getTargetException();
            if (realEx instanceof SQLException) {
                throw (SQLException)realEx;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof Error) {
                throw (Error)realEx;
            }
            throw new IllegalStateException("Unexpected error during dynamic dispatch of getBlobStream: " + realEx.toString());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unexpected error during dynamic dispatch of getBlobStream: " + ex.toString());
        }
    }

    public static Writer getClobStream(ResultSet rs, int colIdx) throws SQLException {
        try {
            return (Writer)getCLOBStream_.invoke(null, rs, new Integer(colIdx));
        }
        catch (InvocationTargetException ex) {
            Throwable realEx = ex.getTargetException();
            if (realEx instanceof SQLException) {
                throw (SQLException)realEx;
            }
            if (realEx instanceof RuntimeException) {
                throw (RuntimeException)realEx;
            }
            if (realEx instanceof Error) {
                throw (Error)realEx;
            }
            throw new IllegalStateException("Unexpected error during dynamic dispatch of getClobStream: " + realEx.toString());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unexpected error during dynamic dispatch of getBlobStream: " + ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer storeTempBlob(CMDbProperty prop, Object value) throws SQLException, CMException {
        this.assertInitialized();
        if (dbms_ != 2 || !dbmsInfo.getIsThinDriver()) {
            throw new IllegalStateException("StoreTempBlob should only be called when using the Oracle thin driver");
        }
        CMDbColumn lobColumn = prop.getColumn(prop.getLOBColumnIndex());
        if (lobColumn == null) {
            throw new IllegalStateException("StoreTempBlob should only be called for properties stored in a lob column");
        }
        PreparedStatement stmt = null;
        int curLobID = this.blobID_++;
        String selectStmt = this.getSqlGenerator().createSelectFromCMTMPLOBSSql(lobColumn.getDbType());
        try {
            stmt = this.prepareStatement(this.getSqlGenerator().createInsertIntoCMTMPLOBSSql());
            stmt.setInt(1, curLobID);
            stmt.executeUpdate();
            stmt.close();
            stmt = this.prepareStatement(selectStmt);
            stmt.setInt(1, curLobID);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                CMDbStorePropertySerialization.bindParameterByProperty(rs, 1, prop, value);
            }
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(stmt);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return new Integer(curLobID);
    }

    public CMDbTempTableId getTmpTableId() {
        this.assertInitialized();
        CMDbTempTableId tempTableId = new CMDbTempTableId(this.uniqueId.getAndIncrement());
        return tempTableId;
    }

    public synchronized void reset() throws SQLException {
        int nextUniqueId;
        this.assertInitialized();
        this.exception_ = null;
        if (this.inTransaction_) {
            this.rollbackTransaction();
        }
        if ((nextUniqueId = this.uniqueId.get()) != this.currStartId) {
            Statement stmt = this.createStatement();
            try {
                if (dbms_ == 1 || dbms_ == 4) {
                    stmt.execute("truncate table #CMTMPIDS");
                    stmt.execute("truncate table #CMTMPCOPYIDS");
                } else if (dbms_ == 2 || dbms_ == 8) {
                    stmt.execute("truncate table CMTMPIDS");
                    stmt.execute("truncate table CMTMPCOPYIDS");
                } else if (dbms_ == 3 || dbms_ == 5) {
                    stmt.execute("delete from SESSION.CMTMPIDS");
                    stmt.execute("delete from SESSION.CMTMPCOPYIDS");
                }
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            this.currStartId = nextUniqueId;
        }
    }

    public boolean isChecked() {
        return this.isChecked_;
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked_ = isChecked;
    }

    public long getCreationTime() {
        return this.creationTime_;
    }

    public void discardOnReturnToPool() {
        this.isDiscarded_ = true;
    }

    public boolean isDiscarded() {
        return this.isDiscarded_;
    }

    public static int getMaxObjectsInline() {
        switch (dbms_) {
            case 3: {
                return AdvancedSettings.DBMAXINLINECMIDS_DB2;
            }
            case 4: {
                return AdvancedSettings.DBMAXINLINECMIDS_SYBASE;
            }
        }
        return AdvancedSettings.DBMAXINLINECMIDS;
    }

    public static int getMaxRefObjectsInline() {
        switch (dbms_) {
            case 3: {
                return AdvancedSettings.DBMAX_REFERENCED_OBJECTS_INLINECMIDS_DB2;
            }
            case 4: {
                return AdvancedSettings.DBMAX_REFERENCED_OBJECTS_INLINECMIDS_SYBASE;
            }
        }
        return AdvancedSettings.DBMAX_REFERENCED_OBJECTS_INLINECMIDS;
    }

    public static int getMaxObjectsInUpdate() {
        switch (dbms_) {
            case 3: {
                return AdvancedSettings.DBMAXUPDATECMIDS_DB2;
            }
            case 4: {
                return AdvancedSettings.DBMAXUPDATECMIDS_SYBASE;
            }
        }
        return AdvancedSettings.DBMAXUPDATECMIDS;
    }

    public boolean isInitialized() {
        return this.isInitialized_;
    }

    public static boolean schemaHasParentFK() {
        return dbmsInfo.getSchemaHasParentFK();
    }

    public void setException(CMException ex) {
        this.exception_ = ex;
    }

    public void setStore(CMStore cmStore) {
        this.store = cmStore;
    }

    public CMException getException() {
        return this.exception_;
    }

    private void assertInitialized() {
        if (!this.isInitialized_) {
            throw new IllegalStateException("CMDbConnection is not initialized.");
        }
    }
}

