/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreMultipleCMsUtil;
import com.cognos.cm.dbstore.CMDriverManager;
import com.cognos.cm.dbstore.ICMDbConnectionParameters;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreConnectionProblemReporter;
import com.cognos.cm.util.UrlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.pool.BasePoolableObjectFactory;

public class CMDbConnectionFactory
extends BasePoolableObjectFactory {
    private String thisCMURI_;
    private final ICMDbConnectionParameters connParameters;
    private CMStoreConnectionProblemReporter problemReporter_;
    private boolean checkConsistency_ = true;
    private volatile long expiryTime_;

    public CMDbConnectionFactory(ICMDbConnectionParameters connParameters, String thisCMURI, CMStoreConnectionProblemReporter problemReporter) {
        this.connParameters = connParameters;
        this.thisCMURI_ = thisCMURI;
        this.problemReporter_ = problemReporter;
    }

    public Object makeObject() throws Exception {
        if (this.thisCMURI_ == null) {
            throw new CMException("cmMissingLocalCMURL");
        }
        CMDbConnection dbCon = new CMDbConnection();
        return dbCon;
    }

    public void initializeConnection(CMDbConnection dbCon) throws Exception {
        String dbCMURI;
        if (dbCon.isInitialized()) {
            return;
        }
        if (this.thisCMURI_ == null) {
            throw new CMException("cmMissingLocalCMURL");
        }
        Connection con = CMDriverManager.getConnection(this.connParameters);
        dbCon.initialize(con, false);
        if (!(AdvancedSettings.PROTOTYPE_ENABLESTANDBYREADERS || (dbCMURI = CMDbStoreMultipleCMsUtil.getInstance().getRunningContentStoreName(dbCon)) != null && UrlUtils.contentManagerNamesEqual(dbCMURI, this.thisCMURI_))) {
            this.problemReporter_.connectionInconsistent(dbCon);
            if (this.checkConsistency_) {
                con.close();
                throw new CMException("cmErrGetActiveCM");
            }
        }
        dbCon.setIsChecked(this.checkConsistency_);
    }

    public void passivateObject(Object obj) throws Exception {
    }

    public boolean validateObject(Object obj) {
        try {
            CMDbConnection conn = (CMDbConnection)obj;
            if (!conn.isInitialized()) {
                return true;
            }
            return !conn.isClosed() && conn.getCreationTime() >= this.getExpiryTime() && !conn.isDiscarded();
        }
        catch (SQLException ex) {
            return false;
        }
    }

    public void destroyObject(Object obj) throws Exception {
        CMDbConnection conn = (CMDbConnection)obj;
        if (!conn.isInitialized()) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkConsistency(boolean bDoCheck) {
        this.checkConsistency_ = bDoCheck;
    }

    public void resetExpiryTime() {
        this.expiryTime_ = System.currentTimeMillis();
    }

    public long getExpiryTime() {
        return this.expiryTime_;
    }
}

