/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cm.dbstore.ICMDbConnectionParameters;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.util.CMDbStoreEncryptHelper;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CMDbConnectionParameters
implements ICMDbConnectionParameters {
    private String connectURL_;
    private String dbUserName_;
    private String dbPassword_;
    private int maxConnectionAttempts_ = 1;
    private int secondsBetweenConnectionAttempts_;
    private CMDbStoreEncryptHelper helper_;
    private final IConfiguration config;

    public CMDbConnectionParameters(IConfiguration config) throws CMConfigurationException {
        this.config = config;
        this.connectURL_ = config.getDatabaseConnect();
        if (this.connectURL_ == null || this.connectURL_.length() == 0) {
            throw new CMConfigurationException("cmNoCSConnectStr");
        }
        if (config.isEncryptionEnabled()) {
            StringBuffer tmp = new StringBuffer(this.connectURL_);
            String ssl = this.getSSLUrlFromAdvancedProperties(config);
            if (config.getDatabaseType().equalsIgnoreCase("Microsoft") || config.getDatabaseType().equalsIgnoreCase("MicrosoftWinAuth")) {
                if (ssl == null) {
                    ssl = ConfigurationFactory.getConfig().getInternalProp("CMDatabaseMicrosoftSSL");
                }
                tmp.append(ssl);
            } else if (config.getDatabaseType().equalsIgnoreCase("DB2") || config.getDatabaseType().equalsIgnoreCase("Informix")) {
                if (ssl == null) {
                    ssl = ConfigurationFactory.getConfig().getInternalProp("CMDatabaseDB2SSL");
                }
                tmp.append(ssl);
            } else if (config.getDatabaseType().equalsIgnoreCase("OracleAdvanced")) {
                this.addOraclePKIProvider();
            }
            this.connectURL_ = tmp.toString();
        }
        String auditMsg = "DB connection string: " + this.connectURL_;
        Map<String, String> advancedConnectionParameters = this.getConnectionAdvancedParameters();
        if (advancedConnectionParameters != null && advancedConnectionParameters.size() > 0) {
            auditMsg = auditMsg + ". DB connection advanced parameters: " + advancedConnectionParameters;
        }
        CMIndications.Audit_Message(auditMsg);
        this.helper_ = new CMDbStoreEncryptHelper();
        try {
            this.dbUserName_ = this.helper_.encrypt(config.getDatabaseDecryptedProp("user"));
            this.dbPassword_ = this.helper_.encrypt(config.getDatabaseDecryptedProp("password"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CMConfigurationException((Throwable)e);
        }
        catch (CAMCryptoException e) {
            throw new CMConfigurationException(e);
        }
        this.setupConnectionRetryParameters(config);
    }

    private String getSSLUrlFromAdvancedProperties(IConfiguration config) {
        return config.getConfigAdvancedProp("CM_SSL_URL");
    }

    private void addOraclePKIProvider() {
        try {
            String oraclePKIProviderClassPath = ConfigurationFactory.getConfig().getInternalProp("OraclePKIProvider");
            Security.addProvider((Provider)Class.forName(oraclePKIProviderClassPath).newInstance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setupConnectionRetryParameters(IConfiguration config) {
        this.maxConnectionAttempts_ = Integer.parseInt("1");
        this.secondsBetweenConnectionAttempts_ = Integer.parseInt("30");
        try {
            int maxConnect = Integer.parseInt(config.getConfigAdvancedProp("CM_MAX_CONNECTION_ATTEMPTS"));
            if (maxConnect > -1) {
                this.maxConnectionAttempts_ = maxConnect;
            }
        }
        catch (NumberFormatException maxConnect) {
            // empty catch block
        }
        try {
            int interval = Integer.parseInt(config.getConfigAdvancedProp("CM_CONNECTION_ATTEMPT_INTERVAL"));
            if (interval > -1) {
                this.secondsBetweenConnectionAttempts_ = interval;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getConnectionURL() {
        return this.connectURL_;
    }

    @Override
    public String getUserName() throws CAMCryptoException {
        return this.helper_.decrypt(this.dbUserName_);
    }

    @Override
    public String getPassword() throws CAMCryptoException {
        return this.helper_.decrypt(this.dbPassword_);
    }

    @Override
    public int getMaxConnectionAttempts() {
        return this.maxConnectionAttempts_;
    }

    @Override
    public int getSecondsBetweenConnectionAttempts() {
        return this.secondsBetweenConnectionAttempts_;
    }

    @Override
    public Map<String, String> getConnectionAdvancedParameters() {
        String dbType = this.config.getDatabaseType();
        String defaultConnectionParameters = this.config.getInternalProp(dbType + ".connection.parameters");
        HashMap<String, String> connectionParams = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)defaultConnectionParameters)) {
            String[] nameValuePairs;
            for (String nameValuePair : nameValuePairs = defaultConnectionParameters.split(";")) {
                String[] prop = nameValuePair.split("=");
                connectionParams.put(prop[0], prop[1]);
            }
        }
        connectionParams.putAll(this.config.getConnectionAdvancedParameters());
        return connectionParams;
    }
}

