/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbConnectionFactory;
import com.cognos.cm.dbstore.ICMDbConnectionParameters;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AdvancedSettingsObserver;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreConnection;
import com.cognos.cm.store.CMStoreConnectionProblemReporter;
import com.cognos.cm.store.CMStoreNotAvailable;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class CMDbConnectionPool
implements AdvancedSettingsObserver,
CMStoreConnectionProblemReporter {
    private static final int MAXCONNECTIONS_LOWER_LIMIT = 7;
    private static final int DEF_TESTS_PER_EVICT_RUN = -2;
    private final int maxDBConnections_;
    private GenericObjectPool connectionPool_;
    private GenericObjectPool connectionNotCheckedPool_;
    private boolean bConnectPoolInitialized_ = false;
    private int maxConnections_;
    private long maxConWait_;
    private long minIdleTime_;
    private long cleanUpTime_;
    private CMStoreConnectionProblemReporter problemReporter_;
    private CMDbConnectionFactory connFactory_;
    private CMDbConnectionFactory connNotCheckedFactory_;

    public CMDbConnectionPool(ICMDbConnectionParameters connParameters, int maxSize, String thisCMURI) {
        this.maxDBConnections_ = maxSize <= 0 ? Integer.MAX_VALUE : maxSize;
        this.connFactory_ = new CMDbConnectionFactory(connParameters, thisCMURI, this);
        this.connNotCheckedFactory_ = new CMDbConnectionFactory(connParameters, thisCMURI, this);
        this.connNotCheckedFactory_.checkConsistency(false);
        this.connectionPool_ = new GenericObjectPool((PoolableObjectFactory)this.connFactory_);
        this.connectionNotCheckedPool_ = new GenericObjectPool((PoolableObjectFactory)this.connNotCheckedFactory_);
        this.setPoolProperties();
        AdvancedSettings.addObserver(this);
        this.bConnectPoolInitialized_ = true;
    }

    public CMDbConnection get() throws CMStoreNotAvailable {
        try {
            CMDbConnection con = (CMDbConnection)this.connectionPool_.borrowObject();
            this.connFactory_.initializeConnection(con);
            return con;
        }
        catch (Exception e) {
            if (e instanceof NoSuchElementException) {
                throw new CMStoreNotAvailable(new CMException("cmDatabaseTimeout"));
            }
            throw new CMStoreNotAvailable(e);
        }
    }

    public CMDbConnection getForAdministration() throws CMStoreNotAvailable {
        try {
            CMDbConnection con = (CMDbConnection)this.connectionNotCheckedPool_.borrowObject();
            this.connNotCheckedFactory_.initializeConnection(con);
            return con;
        }
        catch (Exception e) {
            if (e instanceof NoSuchElementException) {
                throw new CMStoreNotAvailable(new CMException("cmDatabaseTimeout"));
            }
            throw new CMStoreNotAvailable(e);
        }
    }

    public void release(CMDbConnection x) {
        try {
            if (x.isClosed()) {
                this.connectionPool_.clear();
                this.connFactory_.resetExpiryTime();
                this.connectionNotCheckedPool_.clear();
                this.connNotCheckedFactory_.resetExpiryTime();
            } else {
                this.passivateConnection(x);
                if (x.isChecked()) {
                    this.connectionPool_.returnObject((Object)x);
                } else {
                    this.connectionNotCheckedPool_.returnObject((Object)x);
                }
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void passivateConnection(CMDbConnection conn) throws SQLException {
        if (!conn.isInitialized()) {
            return;
        }
        conn.reset();
    }

    public void close() {
        try {
            this.connectionPool_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void setPoolProperties() {
        int origMaxConnections = this.maxConnections_;
        long origMaxConWait = this.maxConWait_;
        long origMinIdleTime = this.minIdleTime_;
        long origCleanUpTime = this.cleanUpTime_;
        this.maxConnections_ = AdvancedSettings.DBCONNECTPOOLMAX < 0 ? this.maxDBConnections_ : (AdvancedSettings.DBCONNECTPOOLMAX <= this.maxDBConnections_ ? AdvancedSettings.DBCONNECTPOOLMAX : this.maxDBConnections_);
        if (this.maxConnections_ < 7) {
            this.maxConnections_ = 7;
        }
        this.maxConWait_ = AdvancedSettings.DBCONNECTPOOLTIMEOUT <= Integer.MAX_VALUE ? (long)AdvancedSettings.DBCONNECTPOOLTIMEOUT : Integer.MAX_VALUE;
        this.minIdleTime_ = AdvancedSettings.DBCONNECTPOOLIDLETIME <= Integer.MAX_VALUE ? (long)AdvancedSettings.DBCONNECTPOOLIDLETIME : Integer.MAX_VALUE;
        this.cleanUpTime_ = AdvancedSettings.DBCONNECTPOOLCLEANUPPERIOD <= Integer.MAX_VALUE ? (long)AdvancedSettings.DBCONNECTPOOLCLEANUPPERIOD : Integer.MAX_VALUE;
        if (origMaxConnections != this.maxConnections_ || origMaxConWait != this.maxConWait_ || origMinIdleTime != this.minIdleTime_ || origCleanUpTime != this.cleanUpTime_ || !this.bConnectPoolInitialized_) {
            GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
            poolConfig.maxActive = poolConfig.maxIdle = this.maxConnections_;
            poolConfig.minEvictableIdleTimeMillis = this.minIdleTime_;
            poolConfig.maxWait = this.maxConWait_;
            poolConfig.timeBetweenEvictionRunsMillis = this.cleanUpTime_;
            poolConfig.whenExhaustedAction = 1;
            poolConfig.testOnBorrow = true;
            poolConfig.testOnReturn = true;
            poolConfig.testWhileIdle = false;
            poolConfig.numTestsPerEvictionRun = -2;
            this.connectionPool_.setConfig(poolConfig);
            this.connectionNotCheckedPool_.setConfig(poolConfig);
        }
    }

    @Override
    public void updateSettings() {
        this.setPoolProperties();
    }

    public void setProblemReporter(CMStoreConnectionProblemReporter problemReporter) {
        this.problemReporter_ = problemReporter;
    }

    @Override
    public void connectionBroken() {
        if (this.problemReporter_ != null) {
            this.problemReporter_.connectionBroken();
        }
    }

    @Override
    public void connectionInconsistent(CMStoreConnection con) {
        if (this.problemReporter_ != null) {
            this.problemReporter_.connectionInconsistent(con);
        }
    }
}

