/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertyDefXMLImpl;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreNonObjectAddDef;
import com.cognos.cm.dbstore.CMDbStoreNonObjectUpdateDef;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCryptoDataStore;
import com.cognos.cm.store.CMCryptoDataStoreException;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.w3c.dom.Document;

public class CMDbCryptoStore
extends CMCryptoDataStore {
    private static volatile boolean initialized_;
    private static CMDbProperty CRYPTOKEY;
    private static CMDbProperty CRYPTODATA;
    private static String singleKeyWhereClause_;
    private static final String CRYPTOKEYDEF = "<property name='_cryptokey' table='CMCRYPTOKEYS' column='CRYPTOKEY' type='xs:string'/>";
    private static final String CRYPTODATADEF = "<property name='_cryptodata' table='CMCRYPTOKEYS' column='DATA' type='xs:base64Binary'/>";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getData(String key) throws CMCryptoDataStoreException {
        PreparedStatement stmt;
        CMDbConnection con;
        block30: {
            ResultSet rs2333332;
            CMDbCryptoStore.storeInitializedTest();
            con = CMDbCryptoStore.getConnection();
            stmt = null;
            stmt = con.prepareStatement("select DATA from CMCRYPTOKEYS where " + singleKeyWhereClause_);
            CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, CRYPTOKEY, key);
            if (CMDbConnection.getDbmsInfo().readLOBinTransaction()) {
                con.beginTransaction();
            }
            if ((rs2333332 = stmt.executeQuery()).next()) {
                Object data = CMDbStorePropertySerialization.getColumnByProperty(rs2333332, 1, CRYPTODATA);
                if (data == null) {
                    byte[] byArray = null;
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (con.inTransaction()) {
                        try {
                            con.commitTransaction();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    CMDbStoreFactory.releaseConnection(con);
                    return byArray;
                }
                if (data instanceof byte[]) {
                    byte[] byArray = (byte[])data;
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (con.inTransaction()) {
                        try {
                            con.commitTransaction();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    CMDbStoreFactory.releaseConnection(con);
                    return byArray;
                }
                if (data instanceof InputStream) {
                    byte[] byArray = CMStreamUtils.readInputStreamIntoByteArray((InputStream)((InputStream)data));
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (con.inTransaction()) {
                        try {
                            con.commitTransaction();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    CMDbStoreFactory.releaseConnection(con);
                    return byArray;
                }
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (!con.inTransaction()) break block30;
            try {
                con.commitTransaction();
            }
            catch (SQLException rs2333332) {
                // empty catch block
            }
        }
        CMDbStoreFactory.releaseConnection(con);
        return null;
        catch (SQLException ex) {
            CMDbCryptoStore.handleSQLException(con, ex);
            return null;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                throw new CMCryptoDataStoreException(3, ex2);
            }
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            if (con.inTransaction()) {
                try {
                    con.commitTransaction();
                }
                catch (SQLException ex) {}
            }
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(String key, byte[] data) throws CMCryptoDataStoreException {
        CMDbCryptoStore.storeInitializedTest();
        CMDbConnection con = CMDbCryptoStore.getConnection();
        try {
            this.doAdd(con, key, data);
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateData(String key, byte[] data) throws CMCryptoDataStoreException {
        CMDbCryptoStore.storeInitializedTest();
        CMDbConnection con = CMDbCryptoStore.getConnection();
        try {
            boolean bl = this.doUpdate(con, key, data);
            return bl;
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteData(String key) throws CMCryptoDataStoreException, CMException {
        block5: {
            boolean bl;
            CMDbCryptoStore.storeInitializedTest();
            CMDbConnection con = CMDbCryptoStore.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement("delete from CMCRYPTOKEYS where " + singleKeyWhereClause_);
                CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, CRYPTOKEY, key);
                bl = CMDbConnection.executeUpdate(stmt) > 0;
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            catch (SQLException ex) {
                CMDbCryptoStore.handleSQLException(con, ex);
                break block5;
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMDbStoreFactory.releaseConnection(con);
            }
            CMDbStoreFactory.releaseConnection(con);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllDataKeys() throws CMCryptoDataStoreException {
        CMDbCryptoStore.storeInitializedTest();
        CMDbConnection con = CMDbCryptoStore.getConnection();
        Statement stmt = null;
        ArrayList<String> results = new ArrayList<String>();
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select CRYPTOKEY from CMCRYPTOKEYS");
            while (rs.next()) {
                results.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            CMDbCryptoStore.handleSQLException(con, ex);
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            CMDbStoreFactory.releaseConnection(con);
        }
        return results.toArray(new String[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String key, byte[] data) throws CMCryptoDataStoreException {
        CMDbCryptoStore.storeInitializedTest();
        CMDbConnection con = CMDbCryptoStore.getConnection();
        try {
            if (!this.doUpdate(con, key, data)) {
                this.doAdd(con, key, data);
            }
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
    }

    @Override
    public boolean isInitialized() {
        return initialized_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(CMDbConnection con, String key, byte[] data) throws CMCryptoDataStoreException {
        try {
            con.beginTransaction();
            CMDbStoreNonObjectAddDef addDef = new CMDbStoreNonObjectAddDef("CMCRYPTOKEYS", CRYPTOKEY);
            addDef.addColumn(CRYPTODATA, data);
            addDef.execute(con, key);
            con.commitTransaction();
        }
        catch (Exception ex) {
            CMDbCryptoStore.handleSQLException(con, ex);
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUpdate(CMDbConnection con, String key, byte[] data) throws CMCryptoDataStoreException {
        boolean successful = false;
        try {
            con.beginTransaction();
            CMDbStoreNonObjectUpdateDef updateDef = new CMDbStoreNonObjectUpdateDef("CMCRYPTOKEYS", CRYPTOKEY);
            updateDef.addColumn(CRYPTODATA, data);
            successful = updateDef.execute(con, " where " + singleKeyWhereClause_, new CMDbProperty[]{CRYPTOKEY}, new Object[]{key}) > 0;
            con.commitTransaction();
        }
        catch (Exception ex) {
            CMDbCryptoStore.handleSQLException(con, ex);
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
        return successful;
    }

    private static final CMDbConnection getConnection() throws CMCryptoDataStoreException {
        try {
            return CMDbStoreFactory.getAdminConnection();
        }
        catch (CMStoreNotAvailable ex) {
            throw new CMCryptoDataStoreException(2, ex.getException());
        }
    }

    private static final void handleSQLException(CMDbConnection con, Exception ex) throws CMCryptoDataStoreException {
        int code = 3;
        if (ex instanceof SQLException) {
            if (CMIndications.logEnabled("Trace.CM.SQL", 30000)) {
                CMIndications.CMTrace("cmSQLConnectionException", new CMException.Parm[]{new CMException.Parm("Exception", ex.getMessage()), new CMException.Parm("ConID", "null")});
            }
            if (CMDbConnection.isConnectionProblem((SQLException)ex)) {
                code = 2;
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            } else if (CMDbConnection.isConstraintViolation((SQLException)ex)) {
                code = 7;
            }
        }
        throw new CMCryptoDataStoreException(code, ex);
    }

    private static final void storeInitializedTest() throws CMCryptoDataStoreException {
        if (!CMDbStoreFactory.initedContentIndependentAfterLock_) {
            throw new CMCryptoDataStoreException(1);
        }
        if (!initialized_) {
            CMDbCryptoStore.initialize();
        }
    }

    private static final synchronized void initialize() throws CMCryptoDataStoreException {
        if (initialized_) {
            return;
        }
        CMDbConnection con = CMDbCryptoStore.getConnection();
        try {
            Document propDoc = CMXMLUtils.parseString(CRYPTOKEYDEF);
            CMDbPropertyDefXMLImpl propEl = new CMDbPropertyDefXMLImpl(propDoc.getDocumentElement());
            CRYPTOKEY = new CMDbProperty(con.getConnection(), null, propEl);
            propDoc = CMXMLUtils.parseString(CRYPTODATADEF);
            propEl = new CMDbPropertyDefXMLImpl(propDoc.getDocumentElement());
            CRYPTODATA = new CMDbProperty(con.getConnection(), null, propEl);
            boolean ciWrap = false;
            StringBuffer whereClause = new StringBuffer(1024);
            if (CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive()) {
                whereClause.append("UPPER(");
                ciWrap = true;
            }
            whereClause.append(CRYPTOKEY.getColumn(0).getName());
            if (ciWrap) {
                whereClause.append(")");
            }
            if (ciWrap && CMDbConnection.dbms_ == 3) {
                whereClause.append("=UPPER(cast(? as varchar(4000)))");
            } else if (ciWrap && CMDbConnection.dbms_ == 8) {
                whereClause.append("=UPPER(cast(? as lvarchar(4000)))");
            } else {
                whereClause.append(ciWrap ? "=UPPER(?)" : "=?");
            }
            singleKeyWhereClause_ = whereClause.toString();
        }
        catch (Exception ex) {
            throw new CMCryptoDataStoreException(3, ex);
        }
        finally {
            CMDbStoreFactory.releaseConnection(con);
        }
        initialized_ = true;
    }
}

