/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreNonObjectAddDef;
import com.cognos.cm.dbstore.CMDbStoreNonObjectUpdateDef;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMDataUpgrade;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbDataUpgradeStore
implements CMDataUpgrade {
    private static boolean initialized_;
    private static CMDbProperty PLUGINNAME;
    private static CMDbProperty PLUGINVERSION;
    private static String singleKeyWhereClause_;
    private static final String TABLE_NAME = "CMDATAUPGRADE";
    private static final String COLUMN_KEY = "PLUGINNAME";
    private static final String COLUMN_DATA = "VERSION";
    private static final String PLUGINNAMEDEF = "<property name='_pluginname' table='CMDATAUPGRADE' column='PLUGINNAME' type='xs:string'/>";
    private static final String PLUGINVERSIONDEF = "<property name='_pluginversion' table='CMDATAUPGRADE' column='VERSION' type='xs:string'/>";

    public CMDbDataUpgradeStore() {
        try {
            this.initialize();
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
    }

    @Override
    public String get(String pluginName) throws CMException {
        CMDbConnection con;
        PreparedStatement stmt;
        String version;
        block14: {
            if (!initialized_) {
                return "";
            }
            version = "";
            stmt = null;
            con = null;
            try {
                Object data;
                ResultSet rs;
                con = this.getConnection();
                stmt = con.prepareStatement("select VERSION from CMDATAUPGRADE where " + singleKeyWhereClause_);
                CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, PLUGINNAME, pluginName);
                if (CMDbConnection.dbms_ == 3) {
                    con.beginTransaction();
                }
                if (!(rs = stmt.executeQuery()).next() || (data = CMDbStorePropertySerialization.getColumnByProperty(rs, 1, PLUGINVERSION)) == null) break block14;
                version = data.toString();
            }
            catch (SQLException sqlEx) {
                try {
                    throw new CMException(sqlEx, "cmDataUpgradeStoreSQLErr");
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    if (con != null) {
                        if (CMDbConnection.dbms_ == 3) {
                            try {
                                con.commitTransaction();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        CMDbStoreFactory.releaseConnection(con);
                    }
                    throw throwable;
                }
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        if (con != null) {
            if (CMDbConnection.dbms_ == 3) {
                try {
                    con.commitTransaction();
                }
                catch (SQLException rs) {
                    // empty catch block
                }
            }
            CMDbStoreFactory.releaseConnection(con);
        }
        return version;
    }

    @Override
    public boolean update(String pluginName, String version) throws CMException {
        if (!initialized_) {
            return false;
        }
        boolean bUpdated = false;
        CMDbConnection con = null;
        try {
            con = this.getConnection();
            con.beginTransaction();
            CMDbStoreNonObjectUpdateDef updateDef = new CMDbStoreNonObjectUpdateDef(TABLE_NAME, PLUGINNAME);
            updateDef.addColumn(PLUGINVERSION, version);
            bUpdated = updateDef.execute(con, " where " + singleKeyWhereClause_, new CMDbProperty[]{PLUGINNAME}, new Object[]{pluginName}) > 0;
            con.commitTransaction();
        }
        catch (SQLException sqlEx) {
            throw new CMException(sqlEx, "cmDataUpgradeStoreSQLErr");
        }
        finally {
            if (con.inTransaction()) {
                try {
                    con.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
            CMDbStoreFactory.releaseConnection(con);
        }
        return bUpdated;
    }

    @Override
    public void add(String key, String version) throws CMException {
        if (!initialized_) {
            return;
        }
        CMDbConnection con = null;
        try {
            con = this.getConnection();
            con.beginTransaction();
            CMDbStoreNonObjectAddDef addDef = new CMDbStoreNonObjectAddDef(TABLE_NAME, PLUGINNAME);
            addDef.addColumn(PLUGINVERSION, version);
            addDef.execute(con, key);
            con.commitTransaction();
        }
        catch (SQLException sqlEx) {
            throw new CMException(sqlEx, "cmDataUpgradeStoreSQLErr");
        }
        finally {
            if (con != null) {
                if (con.inTransaction()) {
                    try {
                        con.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
                CMDbStoreFactory.releaseConnection(con);
            }
        }
    }

    @Override
    public void set(String pluginName, String version) throws CMException {
        block2: {
            try {
                this.add(pluginName, version);
            }
            catch (CMException ex) {
                if (!ex.getCode().equals("cmDataUpgradeStoreSQLErr")) break block2;
                this.update(pluginName, version);
            }
        }
    }

    @Override
    public boolean delete(String key) throws CMException {
        if (!initialized_) {
            return false;
        }
        boolean bDeleted = false;
        CMDbConnection con = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("delete from CMDATAUPGRADE where " + singleKeyWhereClause_);
            CMDbStorePropertySerialization.bindParameterByProperty(stmt, 1, PLUGINNAME, key);
            bDeleted = CMDbConnection.executeUpdate(stmt) > 0;
        }
        catch (SQLException sqlEx) {
            try {
                throw new CMException(sqlEx, "cmDataUpgradeStoreSQLErr");
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMDbStoreFactory.releaseConnection(con);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        CMDbStoreFactory.releaseConnection(con);
        return bDeleted;
    }

    private void initialize() throws CMException {
        if (initialized_) {
            return;
        }
        CMDbConnection con = null;
        try {
            con = this.getConnection();
            PLUGINNAME = new CMDbProperty(con.getConnection(), PLUGINNAMEDEF);
            PLUGINVERSION = new CMDbProperty(con.getConnection(), PLUGINVERSIONDEF);
            boolean ciWrap = false;
            StringBuffer whereClause = new StringBuffer(512);
            if (CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive()) {
                whereClause.append("UPPER(");
                ciWrap = true;
            }
            whereClause.append(PLUGINNAME.getColumn(0).getName());
            if (ciWrap) {
                whereClause.append(")");
            }
            if (ciWrap && CMDbConnection.dbms_ == 3) {
                whereClause.append("=UPPER(cast(? as varchar(64)))");
            } else if (ciWrap && CMDbConnection.dbms_ == 8) {
                whereClause.append("=UPPER(cast(? as lvarchar(64)))");
            } else {
                whereClause.append(ciWrap ? "=UPPER(?)" : "=?");
            }
            singleKeyWhereClause_ = whereClause.toString();
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmDataUpgradeStoreFailedInit");
        }
        finally {
            if (con != null) {
                CMDbStoreFactory.releaseConnection(con);
            }
        }
        initialized_ = true;
    }

    private CMDbConnection getConnection() throws CMException {
        return CMDbStoreFactory.getAdminConnection();
    }
}

