/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbPropertyDef;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class CMDbEnumeration {
    private String name_;
    private HashMap<String, EnumValue> valuesMap_;
    private int idOffset_;
    private EnumValue[] valuesArray_;
    private final int BIT_UNSET = -1;
    private int maxBitIndex_ = -1;

    public CMDbEnumeration(CMDbPropertyDef enumDef) {
        this.name_ = enumDef.getAttribute("name");
        if (this.name_.length() == 0) {
            throw new IllegalStateException("Missing enumeration name");
        }
        boolean hasUniqueBitField = CMXMLUtils.isBooleanAttrTrue(enumDef.getAttribute("hasUniqueBitField"));
        HashSet<String> uniqueBitIndex = null;
        if (hasUniqueBitField) {
            uniqueBitIndex = new HashSet<String>();
        }
        Iterator<CMDbPropertyDef> it = enumDef.getSubpropertyIterator();
        ArrayList<EnumValue> items = new ArrayList<EnumValue>();
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        while (it.hasNext()) {
            CMDbPropertyDef item = it.next();
            String name = item.getAttribute("value");
            String sid = item.getAttribute("id");
            String sDeprecated = item.getAttribute("isDeprecated");
            if (name.length() == 0 || sid.length() == 0) {
                throw new IllegalStateException("Invalid enumeration definition: " + this.name_);
            }
            int id = Integer.parseInt(sid);
            boolean isDeprecated = CMXMLUtils.isBooleanAttrTrue(sDeprecated);
            int bitIndex = -1;
            if (hasUniqueBitField) {
                String sBit = item.getAttribute("bitIndex");
                bitIndex = Integer.parseInt(sBit);
                int n = this.maxBitIndex_ = bitIndex > this.maxBitIndex_ ? bitIndex : this.maxBitIndex_;
                if (!isDeprecated) {
                    this.validateBitField(uniqueBitIndex, sBit, name);
                }
            }
            EnumValue value = new EnumValue(name, id, isDeprecated, bitIndex);
            items.add(value);
            if (min > id) {
                min = id;
            }
            if (max >= id) continue;
            max = id;
        }
        this.idOffset_ = min;
        this.valuesMap_ = new HashMap((items.size() * 4 + 1) / 3);
        this.valuesArray_ = new EnumValue[max -= min - 1];
        for (EnumValue value : items) {
            this.valuesMap_.put(value.value_, value);
            this.valuesArray_[((EnumValue)value).id_ - this.idOffset_] = value;
        }
    }

    private void validateBitField(HashSet<String> uniqueBitIndex, String sBit, String name) throws IllegalStateException {
        if (uniqueBitIndex.contains(sBit)) {
            String errorMsg = "The bitIndex " + sBit + " for enum " + name + " is already in use.";
            throw new IllegalStateException(errorMsg);
        }
        int bit = Integer.parseInt(sBit);
        if (bit < 0 || bit > this.maxBitIndex_) {
            String errorMsg = "The bitIndex " + sBit + " for enum " + name + " exceeds the max bitIndex value of " + Integer.toString(this.maxBitIndex_);
            throw new IllegalStateException(errorMsg);
        }
        uniqueBitIndex.add(sBit);
    }

    public CMDbEnumeration(ArrayList<?> enums) {
        int j;
        CMDbEnumeration e1;
        int i;
        this.name_ = "unnamed";
        int size = 0;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (i = 0; i < enums.size(); ++i) {
            e1 = (CMDbEnumeration)enums.get(i);
            size += e1.valuesMap_.size();
            if (min > e1.idOffset_) {
                min = e1.idOffset_;
            }
            if (max < e1.idOffset_ + e1.valuesArray_.length) {
                max = e1.idOffset_ + e1.valuesArray_.length;
            }
            for (j = i + 1; j < enums.size(); ++j) {
                CMDbEnumeration e2 = (CMDbEnumeration)enums.get(j);
                int e1_end = e1.idOffset_ + e1.valuesArray_.length;
                int e2_end = e2.idOffset_ + e2.valuesArray_.length;
                if (e2.idOffset_ >= e1_end || e2_end <= e1.idOffset_) continue;
                throw new IllegalStateException("Enumerations " + e1.name_ + " and " + e2.name_ + " have overlapping id ranges.");
            }
        }
        this.idOffset_ = min;
        this.valuesMap_ = new HashMap((size * 4 + 1) / 3);
        this.valuesArray_ = new EnumValue[max - min];
        for (i = 0; i < enums.size(); ++i) {
            e1 = (CMDbEnumeration)enums.get(i);
            for (j = 0; j < e1.valuesArray_.length; ++j) {
                EnumValue value = e1.valuesArray_[j];
                if (value == null) continue;
                if (this.valuesMap_.put(value.value_, value) != null) {
                    throw new IllegalStateException("Duplicate enumeration value: " + value.value_);
                }
                this.valuesArray_[((EnumValue)value).id_ - this.idOffset_] = value;
            }
        }
    }

    public int getID(String name) {
        EnumValue value = this.valuesMap_.get(name);
        return value == null ? -1 : value.id_;
    }

    public String getValue(int id) {
        EnumValue value = this.valuesArray_[id -= this.idOffset_];
        return value == null ? null : value.value_;
    }

    public int getBitIndex(String name) {
        EnumValue value = this.valuesMap_.get(name);
        return value == null ? -1 : value.bitIndex_;
    }

    public String getTypeName(int id) {
        EnumValue value = this.valuesArray_[id -= this.idOffset_];
        return value == null ? null : value.getTypeName();
    }

    public String getTypeName(String name) {
        EnumValue value = this.valuesMap_.get(name);
        return value == null ? null : value.getTypeName();
    }

    public String getName() {
        return this.name_;
    }

    public int getMaxBitIndex() {
        return this.maxBitIndex_;
    }

    public ArrayList<String> getAllSupportedEnumValues() {
        ArrayList<String> ret = new ArrayList<String>();
        for (EnumValue value : this.valuesMap_.values()) {
            if (value.isDeprecated_) continue;
            ret.add(value.value_);
        }
        return ret;
    }

    protected CMDbEnumeration(String name) {
        this.name_ = name;
        this.valuesMap_ = new HashMap();
        this.valuesArray_ = new EnumValue[0];
    }

    protected void addValue(String enumName, int value, int bitIndex) {
        EnumValue enumValue = new EnumValue(enumName, value, false, bitIndex);
        this.valuesMap_.put(enumName, enumValue);
        EnumValue[] oldValuesArray = this.valuesArray_;
        this.valuesArray_ = new EnumValue[oldValuesArray.length + 1];
        System.arraycopy(oldValuesArray, 0, this.valuesArray_, 0, oldValuesArray.length);
        this.valuesArray_[this.valuesArray_.length - 1] = enumValue;
    }

    protected void setMaxBitIndex(int index) {
        this.maxBitIndex_ = index;
    }

    private final class EnumValue {
        private final String value_;
        private final int id_;
        private final boolean isDeprecated_;
        private final int bitIndex_;

        private EnumValue(String value, int id, boolean isDeprecated, int bitIndex) {
            this.value_ = value;
            this.id_ = id;
            this.isDeprecated_ = isDeprecated;
            this.bitIndex_ = bitIndex;
        }

        private String getTypeName() {
            return CMDbEnumeration.this.name_;
        }
    }
}

