/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbEnumeration;
import com.cognos.cm.dbstore.CMDbPropertyDefXMLImpl;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class CMDbEnumerationSet {
    Map<String, CMDbEnumeration> enums_ = new HashMap<String, CMDbEnumeration>(20);

    public void add(CMDbEnumeration dbEnum) {
        CMDbEnumeration old = this.enums_.put(dbEnum.getName(), dbEnum);
        if (old != null) {
            throw new IllegalStateException("Duplicate enumeration: " + dbEnum.getName());
        }
    }

    public CMDbEnumeration get(String name) {
        CMDbEnumeration dbEnum = this.enums_.get(name);
        if (dbEnum == null) {
            throw new IllegalStateException("Enumeration " + name + " not found");
        }
        return dbEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void load(CMDbConnection con) throws Exception {
        Statement stmt = null;
        try {
            if (CMDbConnection.getDbmsInfo().readLOBinTransaction()) {
                con.beginTransaction();
            }
            stmt = con.createStatement();
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            StringBuffer buffer = new StringBuffer();
            buffer.append(sqlGenerator.createSelectSql());
            sqlGenerator.appendColumnNames(new String[]{"PROPID", "NAME", "DEF"}, buffer);
            buffer.append(sqlGenerator.createFromSql());
            buffer.append("CMPROPERTIES");
            buffer.append(sqlGenerator.createOrderBySql());
            buffer.append("PROPID");
            ResultSet rs = stmt.executeQuery(buffer.toString());
            while (rs.next()) {
                String enumName = rs.getString(2);
                InputStream enumDef = null;
                if (CMDbConnection.dbms_ == 1 || CMDbConnection.dbms_ == 4) {
                    enumDef = rs.getBinaryStream(3);
                } else {
                    Blob enumBlob = rs.getBlob(3);
                    if (enumBlob != null) {
                        enumDef = enumBlob.getBinaryStream();
                    }
                }
                if (enumDef == null) {
                    throw new IllegalStateException("Missing definition for enumeration " + enumName);
                }
                try {
                    String xml = new String(CMStreamUtils.readInputStreamIntoByteArray((InputStream)enumDef), "UTF-8");
                    CMDbPropertyDefXMLImpl propDef = new CMDbPropertyDefXMLImpl(xml);
                    this.add(new CMDbEnumeration(propDef));
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Error reading definition of enumeration " + enumName, ex);
                    return;
                }
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con.inTransaction()) {
                try {
                    con.commitTransaction();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

