/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbClassDef;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbObjectClasses;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertyDef;
import com.cognos.cm.dbstore.CMDbPropertySet;
import com.cognos.cm.dbstore.CMDbPropertySets;
import com.cognos.cm.dbstore.CMDbStoreAddArrayDef;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.CMDbStoreBaseTableAddDef;
import com.cognos.cm.dbstore.CMDbStoreDefaultLocalizedStringTablAddDef;
import com.cognos.cm.dbstore.CMDbStoreExternalDataAddDef;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.ICMDbObjectClass;
import com.cognos.cm.dbstore.properties.CMDbStoreRetentionRule;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.util.CMStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class CMDbObjectClass
extends CMObjectClass
implements ICMDbObjectClass {
    private static final String USAGE_FOLDER = "folder";
    private static final String USAGE_OBJECT = "object";
    private static final String USAGE_SUBOBJECT = "subObject";
    private static final String USAGE_BASECLASS = "baseclass";
    private static final String[] USAGES = new String[]{"folder", "object", "subObject", "baseclass"};
    private String[] tables_;
    private String[] arrayTables_;
    private BitSet tableSet_;
    BitSet referenceToThisTables_;
    private CMDbProperty[] propsForCopy_;
    private CMDbClassDef classDef_;
    public static final Comparator<CMDbObjectClass> NAME_COMPARATOR = new Comparator<CMDbObjectClass>(){

        @Override
        public int compare(CMDbObjectClass lhs, CMDbObjectClass rhs) {
            return lhs.name_.compareToIgnoreCase(rhs.name_);
        }
    };
    public static final Comparator<CMDbObjectClass> ID_COMPARATOR = new Comparator<CMDbObjectClass>(){

        @Override
        public int compare(CMDbObjectClass lhs, CMDbObjectClass rhs) {
            return lhs.getID() - rhs.getID();
        }
    };

    static final int getUsageID(String usage) {
        return Arrays.binarySearch(USAGES, usage);
    }

    public CMDbStoreAddDef[] getAddDefs(int objectParentID) {
        int numTables = this.tables_.length + (this.arrayTables_ != null ? this.arrayTables_.length : 0) + 2;
        CMDbStoreAddDef[] addDefs = new CMDbStoreAddDef[numTables];
        addDefs[0] = new CMDbStoreBaseTableAddDef(objectParentID, this);
        addDefs[1] = new CMDbStoreDefaultLocalizedStringTablAddDef("CMOBJNAMES");
        for (int index = 0; index < this.tables_.length; ++index) {
            addDefs[index + 2] = CMDbProperty.isMultilingualPropTable(this.tables_[index]) ? new CMDbStoreDefaultLocalizedStringTablAddDef(this.tables_[index]) : (CMDbProperty.isExternalizablePropTable(this.tables_[index]) && ConfigurationFactory.getConfig().isExternalObjectStoreEnabled() ? new CMDbStoreExternalDataAddDef(this.tables_[index], objectParentID) : new CMDbStoreAddDef(this.tables_[index]));
        }
        index += 2;
        if (this.arrayTables_ != null) {
            for (int i = 0; i < this.arrayTables_.length; ++i) {
                addDefs[index + i] = new CMDbStoreAddArrayDef(this.arrayTables_[i]);
            }
        }
        return addDefs;
    }

    public CMDbObjectClass(CMDbObjectClasses classes, int id, String name, int usage, CMDbClassDef classDef) {
        this.objectClasses_ = classes;
        this.setClassID(id);
        this.sCacheLiteral_ = ":" + id + ":";
        this.name_ = name;
        this.baName_ = CMStringUtils.getUTF8BytesFromString(this.name_);
        this.classDef_ = classDef;
        this.isInternal_ = classDef.getAttribute("isInternal").length() > 0;
        boolean bl = this.isObsolete_ = classDef.getAttribute("isObsolete").length() > 0;
        if (this.isObsolete_) {
            this.isInternal_ = true;
        }
        this.hasCognosNSID_ = classDef.getAttribute("hasCognosNSID").length() > 0;
        this.isArchivable_ = classDef.getAttribute("isArchivable").length() > 0;
        this.isArchivableVersion_ = classDef.getAttribute("isArchivableVersion").length() > 0;
        this.isIndexable_ = !classDef.getAttribute("isIndexable").equalsIgnoreCase("false");
        this.isSynchromeshable_ = Boolean.valueOf(classDef.getAttribute("isSynchromeshable"));
        this.hasGloballyUniqueName = "global".equals(classDef.getAttribute("scope"));
        if (usage < 0 || usage >= USAGES.length) {
            throw new IllegalStateException("Invalid usage id");
        }
        this.usage_ = USAGES[usage];
    }

    void loadProperties(CMDbConnection con, CMDbPropertySet propSet) throws Exception {
        if (this.setProperties_ != null) {
            return;
        }
        this.initClassData();
        this.derivedClasses_.add(this);
        CMDbClassDef elBase = this.classDef_.getSuperClass("baseClass");
        if (elBase != null) {
            String baseName = elBase.getAttribute("name");
            CMDbObjectClass base = (CMDbObjectClass)this.objectClasses_.getClassByName(baseName);
            if (base == null) {
                throw new IllegalStateException("Invalid baseClass: " + baseName);
            }
            this.baseClass_ = base;
            if (base.setProperties_ == null) {
                base.loadProperties(con, propSet);
            }
            this.propertiesByName_.putAll(base.propertiesByName_);
            this.propertiesByMeaning_.putAll(base.propertiesByMeaning_);
            this.setProperties_.addAll(base.setProperties_);
            while (base != null) {
                base.derivedClasses_.add(this);
                base = (CMDbObjectClass)base.baseClass_;
            }
        }
        Iterator<CMDbPropertyDef> it = this.classDef_.getPropertyIterator();
        while (it.hasNext()) {
            CMDbProperty prop = propSet.loadProperty(con.getConnection(), this, it.next());
            this.propertiesByName_.put(prop.getName(), prop);
            if (prop.getMeaning() != null) {
                this.propertiesByMeaning_.put(prop.getMeaning(), prop);
            }
            if (this.setProperties_.add(prop)) continue;
            throw new IllegalStateException("Duplicate property: " + prop.getName());
        }
        this.properties_ = new CMProperty[this.setProperties_.size()];
        this.setProperties_.toArray(this.properties_);
    }

    void loadClassRefs() {
        CMDbObjectClass base = (CMDbObjectClass)this.baseClass_;
        if (base != null && base.validChildClasses_ != null) {
            this.validChildClasses_.addAll(base.validChildClasses_);
        }
        Iterator<CMDbPropertyDef> refIt = this.classDef_.getClassReferencesIterator();
        while (refIt.hasNext()) {
            CMDbPropertyDef el = refIt.next();
            String str = el.getAttribute("name");
            CMObjectClass cls = this.objectClasses_.getClassByName(str);
            if (cls == null) {
                throw new IllegalStateException("Invalid class reference: " + str);
            }
            str = el.getAttribute("minOccurs");
            int min = str.length() > 0 ? Integer.parseInt(str) : 0;
            str = el.getAttribute("maxOccurs");
            int max = str.length() > 0 ? Integer.parseInt(str) : MAX_OCCURS_UNLIMITED;
            boolean isPerTenantOccur = Boolean.parseBoolean(el.getAttribute("perTenantOccurs"));
            CMDbStoreRetentionRule rule = null;
            CMDbPropertyDef el2 = el.getSubproperty("retentionRule");
            if (el2 != null) {
                str = el2.getAttribute("prop");
                CMProperty prop = cls.getProperty(str);
                if (prop == null) {
                    throw new IllegalStateException("retentionRule has invalid prop attribute: " + str);
                }
                boolean isOptionalRule = el2.getAttribute("isOptional").length() > 0;
                str = el2.getAttribute("maxObjects");
                int maxObjects = str.length() > 0 ? Integer.parseInt(str) : 0;
                str = el2.getAttribute("maxDuration").length() != 0 ? str : null;
                rule = new CMDbStoreRetentionRule(cls, prop, maxObjects, str, isOptionalRule);
                ((CMDbObjectClass)cls).isRetainable_ = true;
            }
            CMObjectClass.ChildClass childClass = new CMObjectClass.ChildClass(cls, min, max, isPerTenantOccur, rule);
            for (int i = 0; i < this.derivedClasses_.size(); ++i) {
                ArrayList validChildren = ((CMDbObjectClass)this.derivedClasses_.get((int)i)).validChildClasses_;
                for (int j = 0; j < validChildren.size(); ++j) {
                    if (((CMObjectClass.ChildClass)validChildren.get((int)j)).theClass_ != childClass.theClass_) continue;
                    throw new IllegalStateException("Duplicate class reference: " + childClass.theClass_.getName());
                }
                validChildren.add(childClass);
            }
        }
    }

    private void addDistinctNameToArrayList(String name, ArrayList<String> list) {
        if (!list.contains(name)) {
            list.add(name);
        }
    }

    void finishLoading() throws CMConfigurationException {
        if (this.tableSet_ != null) {
            return;
        }
        this.loadClassRefs();
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> arrayTables = new ArrayList<String>();
        ArrayList<CMDbProperty> propsForCopy = new ArrayList<CMDbProperty>();
        CMDbPropertySets propSets = CMDbStoreFactory.propertySets_;
        int tableCount = propSets.getTableCount();
        this.tableSet_ = new BitSet(tableCount);
        this.referenceToThisTables_ = new BitSet(tableCount);
        for (int i = 0; i < this.properties_.length; ++i) {
            CMDbProperty property = (CMDbProperty)this.properties_[i];
            if (property.isUpdateable() && property.columnCount() > 0 && !property.isDefaultMultilingualProperty() && property != CMProperty.OWNER && property != CMProperty._OTHERRECIPIENTS) {
                propsForCopy.add(property);
            }
            Iterator<CMProperty> it = property.getIndexProperty() != null ? property.getPropertySubComponents().iterator() : property.getSubpropertiesAndSelf().iterator();
            while (it.hasNext()) {
                CMDbObjectClass[] classRefs;
                String defValue;
                CMDbProperty prop = (CMDbProperty)it.next();
                if (prop.columnCount() <= 0) continue;
                String tableName = prop.getColumn(0).getTable();
                int tabIdx = propSets.getTableIndex(tableName);
                if (tabIdx >= 0) {
                    this.tableSet_.set(tabIdx);
                }
                if (!tableName.equals("CMCLASSES")) {
                    if (prop.isStoredAsArray()) {
                        this.addDistinctNameToArrayList(tableName, arrayTables);
                    } else if (!tableName.equals("CMOBJECTS")) {
                        this.addDistinctNameToArrayList(tableName, tables);
                    }
                }
                if ((defValue = prop.getDefaultValue()) != null) {
                    if (this.propertiesWithDefaultValue_ == null) {
                        this.propertiesWithDefaultValue_ = new HashSet(this.properties_.length * 2);
                    }
                    this.propertiesWithDefaultValue_.add(prop);
                }
                if ((classRefs = prop.getReferences()) == null || !prop.isStoreIDBased()) continue;
                for (int j = 0; j < classRefs.length; ++j) {
                    for (CMDbObjectClass derivedClass : classRefs[j].derivedClasses_) {
                        derivedClass.finishLoading();
                        if (tabIdx < 0) continue;
                        derivedClass.referenceToThisTables_.set(tabIdx);
                    }
                }
            }
        }
        this.tables_ = tables.toArray(new String[tables.size()]);
        if (arrayTables.size() > 0) {
            this.arrayTables_ = arrayTables.toArray(new String[arrayTables.size()]);
        }
        if (propsForCopy.size() != 0) {
            this.propsForCopy_ = new CMDbProperty[propsForCopy.size()];
            propsForCopy.toArray(this.propsForCopy_);
        }
        this.resolveVirtualParent();
        this.classDef_ = null;
    }

    @Override
    public BitSet getReferenceToThisClassTables() {
        return this.referenceToThisTables_;
    }

    BitSet getTableMask() {
        return this.tableSet_;
    }

    @Override
    public CMProperty[] getPropertiesForCopy() {
        return this.propsForCopy_;
    }

    public SortedSet<String> getTables() {
        TreeSet<String> result = new TreeSet<String>();
        for (String table : this.tables_) {
            result.add(table);
        }
        if (this.arrayTables_ != null) {
            for (String table : this.arrayTables_) {
                result.add(table);
            }
        }
        return result;
    }

    private void resolveVirtualParent() {
        String virtualParentStr = this.classDef_.getAttribute("virtualParent");
        if (StringUtils.isNotEmpty((String)virtualParentStr)) {
            String[] vParentList;
            for (String className : vParentList = StringUtils.split((String)virtualParentStr, (char)',')) {
                this.virtualParent_.add(this.objectClasses_.getClassByName(className));
            }
        }
    }
}

