/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbClassDefXMLImpl;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbPropertySet;
import com.cognos.cm.dbstore.ICMDbObjectClasses;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMXMLUtils;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CMDbObjectClasses
extends CMObjectClasses
implements ICMDbObjectClasses {
    protected CMDbObjectClass[] allClassesByID_;
    protected CMDbObjectClass[] allClassesByID_Sparse_;
    protected HashMap<String, CMDbObjectClass> allClassesByName_;
    private CMDbPropertySet propSet_;

    public CMDbObjectClasses(CMDbPropertySet propSet) {
        this.propSet_ = propSet;
    }

    @Override
    public CMObjectClass getClassByName(String name) {
        return this.allClassesByName_.get(name);
    }

    @Override
    public CMObjectClass getClassByName(String name, boolean obsoleteOK) {
        CMObjectClass objClass = this.getClassByName(name);
        if (!obsoleteOK && objClass != null && objClass.isObsolete()) {
            objClass = null;
        }
        return objClass;
    }

    @Override
    public CMObjectClass getClassByID(int id) {
        int index;
        CMDbObjectClass ret = null;
        try {
            ret = this.allClassesByID_Sparse_[id];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((ret == null || ret.getID() != id) && (index = this.getClassIndexByID(id)) >= 0) {
            ret = this.allClassesByID_[index];
        }
        return ret;
    }

    int getClassIndexByID(int id) {
        int hi = this.allClassesByID_.length - 1;
        int lo = 0;
        while (hi >= lo) {
            int mid = (hi + lo) / 2;
            int cmpID = this.allClassesByID_[mid].getID();
            if (cmpID == id) {
                return mid;
            }
            if (cmpID < id) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return -1;
    }

    @Override
    public CMDbObjectClass get(int index) {
        return this.allClassesByID_[index];
    }

    @Override
    public int size() {
        return this.allClassesByID_.length;
    }

    void load(CMDbConnection con) throws Exception {
        int cIdx;
        this.propSet_.load(con, this);
        ArrayList<CMDbObjectClass> classes = this.loadClassesFromDB(con);
        this.initializeMemberArrays(classes);
        this.sysPropsClass_ = this.getClassByName("CMSystemProperties");
        this.verifySpecialClassesAreResolved();
        for (cIdx = 0; cIdx < this.allClassesByID_.length; ++cIdx) {
            this.allClassesByID_[cIdx].loadProperties(con, this.propSet_);
        }
        this.propSet_.finishLoading(con);
        for (cIdx = 0; cIdx < this.allClassesByID_.length; ++cIdx) {
            this.allClassesByID_[cIdx].finishLoading();
        }
        this.setArchivableObjectClasses();
        this.setArchivableVersionObjectClasses();
    }

    private void verifySpecialClassesAreResolved() throws IllegalAccessException {
        HashMap<String, Field> specialClasses = new HashMap<String, Field>();
        Field[] fields = CMObjectClass.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers;
            if (fields[i].getType() != CMObjectClass.class || !Modifier.isPublic(modifiers = fields[i].getModifiers()) || !Modifier.isStatic(modifiers)) continue;
            specialClasses.put(fields[i].getName(), fields[i]);
        }
        for (int cIdx = 0; cIdx < this.allClassesByID_.length; ++cIdx) {
            CMDbObjectClass oc = this.allClassesByID_[cIdx];
            Field field = (Field)specialClasses.remove(oc.getName().toUpperCase(Locale.US));
            if (field == null) continue;
            field.set(null, oc);
        }
        if (specialClasses.size() != 0) {
            String name = (String)specialClasses.keySet().iterator().next();
            throw new IllegalStateException("CMObjectClass." + name + " can't be resolved");
        }
    }

    protected void initializeMemberArrays(ArrayList<CMDbObjectClass> classes) {
        this.allClassesByName_ = new HashMap((classes.size() * 4 + 1) / 3);
        this.allClassesByID_ = new CMDbObjectClass[classes.size()];
        classes.toArray(this.allClassesByID_);
        CMDbObjectClass oc = this.allClassesByID_[this.allClassesByID_.length - 1];
        int nHighClassID = oc.getID();
        this.allClassesByID_Sparse_ = new CMDbObjectClass[nHighClassID + 1];
        for (int cIdx = 0; cIdx < this.allClassesByID_.length; ++cIdx) {
            this.allClassesByID_Sparse_[oc.getID()] = oc = this.allClassesByID_[cIdx];
            this.allClassesByName_.put(oc.getName(), oc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<CMDbObjectClass> loadClassesFromDB(CMDbConnection con) throws SQLException, CMConfigurationException {
        ArrayList<CMDbObjectClass> classes = new ArrayList<CMDbObjectClass>(256);
        Statement stmt = null;
        try {
            if (CMDbConnection.getDbmsInfo().readLOBinTransaction()) {
                con.beginTransaction();
            }
            stmt = con.createStatement();
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            StringBuffer buffer = new StringBuffer();
            buffer.append(sqlGenerator.createSelectSql());
            sqlGenerator.appendColumnNames(new String[]{"CLASSID", "NAME", "USAGE", "DEF"}, buffer);
            buffer.append(sqlGenerator.createFromSql());
            buffer.append("CMCLASSES");
            buffer.append(sqlGenerator.createOrderBySql());
            buffer.append("CLASSID");
            ResultSet rs = stmt.executeQuery(buffer.toString());
            while (rs.next()) {
                int classID = rs.getInt(1);
                String className = rs.getString(2);
                int usage = rs.getInt(3);
                InputStream classDefInput = null;
                if (CMDbConnection.dbms_ == 1 || CMDbConnection.dbms_ == 4) {
                    classDefInput = rs.getBinaryStream(4);
                } else {
                    Blob classBlob = rs.getBlob(4);
                    if (classBlob != null) {
                        classDefInput = classBlob.getBinaryStream();
                    }
                }
                try {
                    if (classDefInput == null) {
                        throw new CMConfigurationException("cmErrorMissingClassDef");
                    }
                    Document doc = CMXMLUtils.parse(new InputSource(classDefInput));
                    Element el = doc.getDocumentElement();
                    CMDbClassDefXMLImpl classDef = new CMDbClassDefXMLImpl(el);
                    CMDbObjectClass newClass = new CMDbObjectClass(this, classID, className, usage, classDef);
                    classes.add(newClass);
                }
                catch (Exception ex) {
                    throw new CMConfigurationException((Throwable)ex, "cmUnexpectedErrorReadingClass", new CMException.Parm("Class", className));
                    return classes;
                }
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con.inTransaction()) {
                try {
                    con.commitTransaction();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public CMPropertySet propertySet() {
        return this.propSet_;
    }

    @Override
    public CMObjectClass[] getAllClasses() {
        return this.allClassesByID_;
    }
}

