/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbEnumeration;
import com.cognos.cm.dbstore.CMDbEnumerationSet;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbObjectClasses;
import com.cognos.cm.dbstore.CMDbPropertyDef;
import com.cognos.cm.dbstore.CMDbPropertySet;
import com.cognos.cm.dbstore.CMDbStoreConsistency;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.binders.AbstractDataBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreBLOBBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreBooleanBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreCLOBBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreFloatBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreIntBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreLongBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreMultilingualStringBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreNameValuePairBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreOldNameValuePairBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreOldTypedNameValuePairBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreRepositoryBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreResolvableBaseClassArrayEntryBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreResolvableBaseClassArrayEntrySearchBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreResolvableBaseClassArraySingletonSearchBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreShortBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreStringBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreTimestampBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreTypedNameValuePairBinder;
import com.cognos.cm.dbstore.serializers.CMDbStoreBaseClassArrayEntrySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreBaseClassArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreBaseClassArraySingletonSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreBooleanSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreContentLocaleSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreDecimalSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreDeploymentReferenceArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreEnumerationSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreFaultDetailArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreFloatSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreIDBasedBaseClassArrayEntrySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreIDBasedBaseClassArraySingletonSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreIntegerSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreLongSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreLongStringSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreMultiLingualStringEntrySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreNameValuePairSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreNavigationPathArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreObjectClassSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreOldNameValuePairSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreOldTypedNameValuePairSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStorePassthruSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStorePoliciesSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreRepositoryRuleSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreResolvableBaseClassArrayEntrySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreResolvedBaseClassArraySingletonSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreRetentionRuleSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringArrayEntrySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringCompressingSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringMapEntryArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringNameValuePairArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreStringSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreTenantIDSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreTimestampSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreTypedNameValuePairArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreTypedNameValuePairSerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreUncheckedArraySerializer;
import com.cognos.cm.dbstore.serializers.CMDbStoreUncheckedComplexScalorSerializer;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.util.CMStringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class CMDbProperty
extends CMProperty {
    public static final String[] BEHAVIOURS = new String[]{"parameterString", "parameterBoolean", "parameterPropertyValue", "matchLocale", "evalPredicate", "evalDBPredicate", "rankLocale", "rankFormat", "isNotNULL", "matchLocaleGetLocale", "basedOn"};
    protected static final String PROP_ATTR_MINVALUE = "minValue";
    protected static final String PROP_ATTR_MINEXCLUSIVEVALUE = "minExclusiveValue";
    protected static final String PROP_ATTR_MAXVALUE = "maxValue";
    protected static final String PROP_ATTR_MAXEXCLUSIVEVALUE = "maxExclusiveValue";
    private static final List<String> MULTILINGUAL_PROP_TABLES = new ArrayList<String>();
    private static final Set<String> EXTERNALIZABLE_PROP_TABLES = new HashSet<String>();
    protected CMProperty multilingualProperty;
    protected CMProperty defaultMultilingualProperty;
    protected String behaviourName_;
    protected List<Object> behaviourParms_ = new ArrayList<Object>();
    protected CMDbPropertySet propSet_;
    protected CMDbEnumeration enumValues_;
    protected CMDbEnumeration enumNames_;
    protected CMDbEnumeration enumTypes_;
    protected boolean isStoredAsArray_;
    protected boolean hasOrdinal_;
    protected String filter_;
    protected boolean requiresCIHandling_;
    protected String defaultValue_;
    protected boolean requiresProxies_;
    protected CMDbStoreDataBinder dataBinder_;
    protected CMDbStoreDataBinder searchDataBinder_;
    protected CMDbStoreDataSerializer dataSerializer_;
    protected boolean storedAsBlob_;
    protected int lobColumnIdx_ = -1;
    protected boolean canBeAttachment_;
    protected ArrayList<CMDbColumn> columns_;
    protected String maxValueStr_;
    protected String minValueStr_;
    protected boolean minExclusive_;
    protected boolean maxExclusive_;
    protected int propID_ = -1;
    protected CMDbObjectClass[] references_;
    protected ArrayList<CMDbProperty> subproperties_ = new ArrayList();
    protected ArrayList<CMDbProperty> subpropertiesAndSelf_ = new ArrayList();
    protected boolean strongValidation_ = true;
    protected CMDbProperty indexProp_;
    protected boolean isArchivingTrigger_;

    static List<String> getMultilingualPropTables() {
        return MULTILINGUAL_PROP_TABLES;
    }

    static boolean isMultilingualPropTable(String tableName) {
        if (tableName != null) {
            return MULTILINGUAL_PROP_TABLES.contains(tableName);
        }
        return false;
    }

    static boolean isExternalizablePropTable(String tableName) {
        return EXTERNALIZABLE_PROP_TABLES.contains(tableName);
    }

    protected CMDbProperty() {
    }

    public CMDbProperty(Connection con, String xml) throws CMConfigurationException, SQLException, SAXException, IOException {
        this(con, null, CMDbStoreUtil.parseXMLPropertyDef(xml));
    }

    public CMDbProperty(Connection con, CMDbPropertySet propSet, CMDbPropertyDef propertyDef) throws SQLException, CMConfigurationException {
        this(con, propSet, null, propertyDef);
    }

    public CMDbProperty(Connection con, CMDbPropertySet propSet, CMDbObjectClass objectClass, CMDbPropertyDef propertyDef) throws SQLException, CMConfigurationException {
        try {
            this.initialize(con, propSet, objectClass, propertyDef, null, true);
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmErrInvalidPropertyDef", new CMException.Parm("Property", this.name_));
        }
        this.validateDatabaseParameters(con);
    }

    public CMDbProperty(Connection con, CMDbPropertyDef propertyDef, CMDbEnumerationSet enumerations, boolean strongValidation) throws SQLException, CMConfigurationException {
        try {
            this.initialize(con, null, null, propertyDef, enumerations, strongValidation);
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmErrInvalidPropertyDef", new CMException.Parm("Property", this.name_));
        }
        this.validateDatabaseParameters(con);
    }

    private void initialize(Connection con, CMDbPropertySet propSet, CMDbObjectClass objectClass, CMDbPropertyDef propertyDef, CMDbEnumerationSet enumerations, boolean strongValidation) throws Exception {
        String propertyHandler;
        String type;
        this.name_ = propertyDef.getAttribute("name");
        this.baName_ = CMStringUtils.getUTF8BytesFromString(this.name_);
        this.strongValidation_ = strongValidation;
        this.objectClass_ = objectClass;
        if (propSet != null) {
            enumerations = propSet.enumerationSet();
        } else if (enumerations == null) {
            enumerations = new CMDbEnumerationSet();
        }
        String dbSpecificTable = "table" + CMDbConnection.getDbmsInfo().getDbmsShortName();
        String table = propertyDef.getAttribute(dbSpecificTable);
        table = table.length() > 0 ? table.toUpperCase() : ((table = propertyDef.getAttribute("table")).length() > 0 ? table.toUpperCase() : null);
        String dbSpecificColumn = "column" + CMDbConnection.getDbmsInfo().getDbmsShortName();
        String column = propertyDef.getAttribute(dbSpecificColumn);
        column = column.length() > 0 ? column.toUpperCase() : ((column = propertyDef.getAttribute("column")).length() > 0 ? column.toUpperCase() : null);
        if (table != null || column != null) {
            if (table == null || column == null) {
                if (table == null) {
                    throw new CMConfigurationException("cmPropDefHasNoTable", new CMException.Parm[]{new CMException.Parm("Column", column), new CMException.Parm("Name", this.name_)});
                }
                if (column == null) {
                    throw new CMConfigurationException("cmPropDefHasNoColumn", new CMException.Parm[]{new CMException.Parm("Table", table), new CMException.Parm("Name", this.name_)});
                }
            }
            this.columns_ = new ArrayList();
            CMDbColumn dbColumn = new CMDbColumn(table, column, this.getName());
            boolean canContainNationalChar = propertyDef.getAttribute("canContainNationalChar").length() != 0;
            dbColumn.setCanContainNationalChar(canContainNationalChar);
            this.columns_.add(dbColumn);
        }
        if ((type = propertyDef.getAttribute("type")).length() == 0) {
            throw new IllegalStateException("Attribute 'type' is missing");
        }
        if (type.startsWith("bibus:")) {
            this.type_ = CMPropertyTypes.findType("http://developer.cognos.com/schemas/bibus/3/", type.substring(6));
        } else if (type.startsWith("xs:")) {
            this.type_ = CMPropertyTypes.findType("http://www.w3.org/2001/XMLSchema", type.substring(3));
        } else {
            throw new IllegalStateException("Unknown type: " + type);
        }
        this.propSet_ = propSet;
        this.setSimplePropertyAttributes(propertyDef);
        String specialMeaningName = propertyDef.getAttribute("specialMeaning");
        if (specialMeaningName != null && specialMeaningName.length() > 0) {
            this.propertyMeaning_ = CMPropertyMeaning.findPropertyMeaning(specialMeaningName);
            if (this.propertyMeaning_ == null) {
                throw new IllegalStateException("Invalid specialMeaning attribute value in property " + this.name_);
            }
        }
        if (this.isExternalizable && table != null) {
            EXTERNALIZABLE_PROP_TABLES.add(table);
        }
        if ((propertyHandler = propertyDef.getAttribute("propertyHandler")) != null && propertyHandler.length() > 0) {
            this.setPropertyHandlerName(propertyHandler);
        }
        String tmpValue = null;
        tmpValue = propertyDef.getAttribute(PROP_ATTR_MINEXCLUSIVEVALUE);
        if (tmpValue.length() > 0) {
            this.minValueStr_ = tmpValue;
            this.minExclusive_ = true;
        } else {
            tmpValue = propertyDef.getAttribute(PROP_ATTR_MINVALUE);
            if (tmpValue.length() > 0) {
                this.minValueStr_ = tmpValue;
            }
        }
        tmpValue = propertyDef.getAttribute(PROP_ATTR_MAXEXCLUSIVEVALUE);
        if (tmpValue.length() > 0) {
            this.maxValueStr_ = tmpValue;
            this.maxExclusive_ = true;
        } else {
            tmpValue = propertyDef.getAttribute(PROP_ATTR_MAXVALUE);
            if (tmpValue.length() > 0) {
                this.maxValueStr_ = tmpValue;
            }
        }
        tmpValue = propertyDef.getAttribute("propID");
        if (tmpValue.length() > 0) {
            this.propID_ = new Integer(tmpValue);
            this.minExclusive_ = true;
        }
        this.parseBehaviour(propertyDef.getAttribute("behaviour").trim());
        if (this.type_.isArray()) {
            this.maxOccurs_ = Integer.MAX_VALUE;
            String maxOccursValue = propertyDef.getAttribute("maxOccurs");
            if (maxOccursValue.length() > 0) {
                this.maxOccurs_ = Integer.parseInt(maxOccursValue);
            }
        }
        this.subpropertiesAndSelf_.add(this);
        Iterator<CMDbPropertyDef> elIt = propertyDef.getSubpropertyIterator();
        while (elIt.hasNext()) {
            CMDbPropertyDef curNode = elIt.next();
            String nodeName = curNode.getNodeName();
            if (nodeName.equals("enumeration")) {
                if (curNode.getSubpropertyIterator().hasNext()) {
                    this.enumValues_ = new CMDbEnumeration(curNode);
                    continue;
                }
                String enumName = curNode.getAttribute("name");
                this.enumValues_ = enumerations.get(enumName);
                continue;
            }
            if (nodeName.equals("dataTypeMap")) {
                Iterator<CMDbPropertyDef> subPropIter;
                String dataType = curNode.getAttribute("name");
                if (dataType.equals("typedNameValuePair") || dataType.equals("stringNameValuePair")) {
                    CMDbPropertyDef elTypes = curNode.getSubproperty("types");
                    if (elTypes == null) {
                        throw new IllegalStateException("Element 'types' is missing");
                    }
                    String typesEnumName = elTypes.getAttribute("name");
                    this.enumTypes_ = enumerations.get(typesEnumName);
                    CMDbPropertyDef elName = curNode.getSubproperty("name");
                    if (elName == null) {
                        throw new IllegalStateException("Element 'name' is missing");
                    }
                    ArrayList<CMDbEnumeration> enums = new ArrayList<CMDbEnumeration>();
                    Iterator<CMDbPropertyDef> it = elName.getSubpropertyIterator("enumeration");
                    while (it.hasNext()) {
                        CMDbPropertyDef myEnum = it.next();
                        if (myEnum.getSubpropertyIterator().hasNext()) {
                            enums.add(new CMDbEnumeration(myEnum));
                            continue;
                        }
                        String enumName = myEnum.getAttribute("name");
                        enums.add(enumerations.get(enumName));
                    }
                    if (enums.size() == 0) {
                        throw new IllegalStateException("Element 'enumeration' is missing");
                    }
                    this.enumNames_ = enums.size() == 1 ? (CMDbEnumeration)enums.get(0) : new CMDbEnumeration(enums);
                }
                if ((subPropIter = curNode.getSubpropertyIterator()).hasNext()) {
                    if (this.columns_ != null) {
                        throw new IllegalStateException("Invalid column information");
                    }
                    this.columns_ = new ArrayList();
                }
                while (subPropIter.hasNext()) {
                    CMDbPropertyDef subProp = subPropIter.next();
                    CMDbPropertyDef columnEl = subProp.getNodeName().equals("column") ? subProp : subProp.getSubproperty("column");
                    if (columnEl == null) continue;
                    column = columnEl.getAttribute("name");
                    table = columnEl.getAttribute("table");
                    CMDbColumn dbColumn = new CMDbColumn(table, column, columnEl.getParent().getNodeName());
                    boolean canContainNationalChar = columnEl.getAttribute("canContainNationalChar").length() != 0;
                    dbColumn.setCanContainNationalChar(canContainNationalChar);
                    this.columns_.add(dbColumn);
                }
                continue;
            }
            if (nodeName.equals("references")) {
                CMDbObjectClasses objClasses = propSet.objectClasses();
                ArrayList<CMObjectClass> list = new ArrayList<CMObjectClass>();
                Iterator<CMDbPropertyDef> it = curNode.getSubpropertyIterator("reference");
                while (it.hasNext()) {
                    CMDbPropertyDef refNode = it.next();
                    String refClass = refNode.getAttribute("class");
                    CMObjectClass cls = objClasses.getClassByName(refClass);
                    if (cls == null) {
                        throw new IllegalStateException("Invalid class reference: " + refClass);
                    }
                    list.add(cls);
                }
                if (list.size() == 0) continue;
                this.references_ = new CMDbObjectClass[list.size()];
                list.toArray(this.references_);
                continue;
            }
            if (nodeName.equals("subproperties")) {
                Iterator<CMDbPropertyDef> it = curNode.getSubpropertyIterator("property");
                while (it.hasNext()) {
                    CMDbPropertyDef elSubproperty = it.next();
                    CMDbProperty subProperty = propSet != null ? propSet.loadProperty(con, objectClass, elSubproperty) : new CMDbProperty(con, elSubproperty, enumerations, this.strongValidation_);
                    this.subproperties_.add(subProperty);
                    this.subpropertiesAndSelf_.add(subProperty);
                    if (!subProperty.isStoreIDBased()) continue;
                    this.hasStoreIDBasedSubproperty_ = true;
                }
                continue;
            }
            if (!nodeName.equals("index")) continue;
            CMDbPropertyDef elProperty = curNode.getSubproperty("property");
            CMDbProperty indexProperty = propSet != null ? propSet.loadProperty(con, objectClass, elProperty) : new CMDbProperty(con, elProperty, enumerations, this.strongValidation_);
            this.indexProp_ = indexProperty;
        }
        this.validateConsistency(table);
    }

    private void validateConsistency(String table) throws Exception {
        if (this.isStoredAsArray() && !CMDbStoreConsistency.isMissingCmidAllowed(table)) {
            throw new Exception("Table: " + table + " needs to be added to the CMDbStoreConsistency class");
        }
    }

    protected void setSimplePropertyAttributes(CMDbPropertyDef propertyDef) {
        this.updateable_ = propertyDef.getAttribute("isReadOnly").length() == 0;
        this.searchable_ = propertyDef.getAttribute("isSearchable").length() != 0;
        this.countable_ = propertyDef.getAttribute("isCountable").length() != 0;
        this.inheritable_ = propertyDef.getAttribute("isAcquirable").length() != 0;
        this.disabled_ = propertyDef.getAttribute("isDisabled").length() != 0;
        this.isInternal_ = propertyDef.getAttribute("isInternal").length() != 0;
        this.isExternal_ = propertyDef.getAttribute("isExternal").equals("1");
        this.isExternalizable = propertyDef.getAttribute("isExternalizable").length() != 0;
        this.isRefsSecurity_ = propertyDef.getAttribute("isRefsSecurity").length() != 0;
        this.requiresReadAccess_ = propertyDef.getAttribute("isAvailableFree").length() == 0;
        this.isSpecial_ = propertyDef.getAttribute("isSpecial").length() != 0;
        this.isStoreIDBased_ = propertyDef.getAttribute("storeIDBased").length() != 0;
        this.filter_ = propertyDef.getAttribute("filter");
        this.canBeAttachment_ = propertyDef.getAttribute("canBeAttachment").length() != 0;
        this.hasOrdinal_ = propertyDef.getAttribute("hasOrdinal").length() != 0;
        this.isStoredAsArray_ = propertyDef.getAttribute("isStoredAsArray").length() != 0;
        this.trustAccessLevel_ = propertyDef.getAttribute("trustAccessLevel");
        this.isArchivingTrigger_ = propertyDef.getAttribute("isArchivingTrigger").length() != 0;
        this.mustBeSysAdminToSet = propertyDef.getAttribute("mustBeSysAdminToSet").length() != 0;
        this.isIndexable_ = propertyDef.getAttribute("isIndexable").equals("1");
        this.isSynchromeshMonitored_ = Boolean.valueOf(propertyDef.getAttribute("isSynchromeshMonitored"));
        this.isSynchromeshPayload_ = Boolean.valueOf(propertyDef.getAttribute("isSynchromeshPayload"));
        boolean bl = this.affectsModTime_ = !"false".equals(propertyDef.getAttribute("affectsModTime"));
        if (!this.inheritable_) {
            this.defaultValue_ = propertyDef.getAttribute("defaultValue");
            if (this.defaultValue_.length() == 0) {
                this.defaultValue_ = null;
            }
        }
        boolean bl2 = this.isObsolete_ = propertyDef.getAttribute("isObsolete").length() != 0;
        if (this.isObsolete_) {
            this.isInternal_ = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void validateDatabaseParameters(Connection con) throws SQLException, CMConfigurationException {
        if (this.columns_ != null) {
            int blobType;
            HashMap<String, Object> columnProps = null;
            int length = -1;
            int scale = -1;
            for (int colIdx = 0; colIdx != this.columns_.size(); ++colIdx) {
                CMDbColumn columnDef = this.getColumn(colIdx);
                columnProps = CMDbStoreFactory.getColumnProperties(columnDef.getTable(), columnDef.getName(), con);
                if (columnProps == null) {
                    throw new CMConfigurationException("cmNoTableColumnInfo", new CMException.Parm[]{new CMException.Parm("Table", columnDef.getTable()), new CMException.Parm("Column", columnDef.getName()), new CMException.Parm("Name", this.name_)});
                }
                String typeName = (String)columnProps.get("TYPE_NAME");
                int dbType = this.getNumberProp(columnProps, "DATA_TYPE", 0);
                length = this.getNumberProp(columnProps, "COLUMN_SIZE", 0);
                scale = this.getNumberProp(columnProps, "DECIMAL_DIGITS", 0);
                int nullable = this.getNumberProp(columnProps, "NULLABLE", 2);
                if (nullable == 0) {
                    columnDef.setIsNullable(false);
                }
                if (dbType == 12) {
                    this.maxLength_ = length;
                }
                if ((dbType = CMDbStoreUtil.correctColumnType(typeName, dbType)) == 2005 || dbType == 2004 || dbType == -4 || dbType == -1 || dbType == -16 || dbType == -10) {
                    this.lobColumnIdx_ = colIdx;
                }
                columnDef.setDbType(dbType);
                columnDef.setLength(length);
            }
            if (!this.isStoredAsArray_ && (this.type_.isArray() && this.maxOccurs_ > 1 && this.lobColumnIdx_ != 0 || this.isStoreIDBased_)) {
                this.isStoredAsArray_ = true;
            }
            this.storedAsBlob_ = this.lobColumnIdx_ != -1;
            int baseType = this.columnCount() == 1 ? this.getColumn(0).getDbType() : Integer.MAX_VALUE;
            int n = blobType = this.storedAsBlob_ ? this.columns_.get(this.lobColumnIdx_).getDbType() : Integer.MAX_VALUE;
            if (baseType != Integer.MAX_VALUE) {
                if ((baseType == 3 || baseType == 2) && scale == 0) {
                    baseType = length == 1 ? -7 : (length == 3 ? -6 : (length == 5 ? 5 : 4));
                }
                if (CMDbConnection.dbms_ == 1) {
                    if (baseType == -9) {
                        baseType = 12;
                    } else if (baseType == -10) {
                        baseType = -1;
                    }
                }
                if (CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive()) {
                    this.requiresCIHandling_ = CMDbConnection.dbms_ == 8 ? baseType == -1 : baseType == 12;
                }
            }
            try {
                Double minValue;
                if (this.isEnumeration()) {
                    this.dataBinder_ = new CMDbStoreShortBinder();
                    this.dataSerializer_ = new CMDbStoreEnumerationSerializer(this);
                } else if (this.hasMeaning(CMPropertyMeaning.TENANTID)) {
                    this.dataSerializer_ = new CMDbStoreTenantIDSerializer();
                } else if (this.behaviourName_ == "matchLocale") {
                    this.requiresCIHandling_ = CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive();
                    this.dataSerializer_ = new CMDbStoreMultiLingualStringEntrySerializer();
                    this.dataBinder_ = new CMDbStoreMultilingualStringBinder(true);
                } else if (this.behaviourName_ == "matchLocaleGetLocale") {
                    if (this.minValueStr_ == null) {
                        this.minValueStr_ = "0";
                    }
                    this.dataSerializer_ = this.constructIntegerSerializer();
                    this.dataBinder_ = new CMDbStoreIntBinder();
                } else if (this.type_ == CMPropertyTypes.BIBUS_RETENTIONRULEARRAY) {
                    this.dataSerializer_ = new CMDbStoreRetentionRuleSerializer();
                } else if (this.type_ == CMPropertyTypes.BIBUS_REPOSITORYRULEARRAY) {
                    this.dataSerializer_ = new CMDbStoreRepositoryRuleSerializer();
                } else if (this.type_ == CMPropertyTypes.BIBUS_RUNOPTIONARRAY || this.type_ == CMPropertyTypes.BIBUS_DEPLOYMENTOPTIONARRAY || this.type_ == CMPropertyTypes.BIBUS_GOVERNORARRAY || this.type_ == CMPropertyTypes.BIBUS_POWERPLAYOPTIONARRAY) {
                    if (this.isStoredAsArray_) {
                        if (this.storedAsBlob_ && (blobType == 2004 || blobType == -4)) {
                            this.dataSerializer_ = new CMDbStoreTypedNameValuePairSerializer(this);
                            this.dataBinder_ = new CMDbStoreTypedNameValuePairBinder();
                        } else {
                            this.dataSerializer_ = new CMDbStoreOldTypedNameValuePairSerializer(this);
                            this.dataBinder_ = new CMDbStoreOldTypedNameValuePairBinder();
                        }
                    } else {
                        this.dataSerializer_ = new CMDbStoreTypedNameValuePairArraySerializer(this);
                    }
                } else if (this.type_ == CMPropertyTypes.BIBUS_OPTIONARRAY) {
                    this.dataSerializer_ = new CMDbStoreStringNameValuePairArraySerializer(this);
                } else if (this.type_ == CMPropertyTypes.BIBUS_NAVIGATIONPATHARRAY) {
                    this.dataSerializer_ = new CMDbStoreNavigationPathArraySerializer(this);
                    this.isComplexType_ = true;
                } else if (this.type_ == CMPropertyTypes.BIBUS_DEPLOYMENTREFERENCEARRAY) {
                    this.dataSerializer_ = new CMDbStoreDeploymentReferenceArraySerializer(this);
                    this.isComplexType_ = true;
                } else if (this.type_ == CMPropertyTypes.BIBUS_FAULTDETAILARRAY) {
                    this.dataSerializer_ = new CMDbStoreFaultDetailArraySerializer();
                } else if (this.type_ == CMPropertyTypes.BIBUS_PARAMETERVALUEARRAY) {
                    if (!this.isStoredAsArray_) throw new IllegalStateException("ParameterValueArray not supported as scalar");
                    if (this.storedAsBlob_ && (blobType == 2004 || blobType == -4)) {
                        this.dataSerializer_ = new CMDbStoreNameValuePairSerializer();
                        this.dataBinder_ = new CMDbStoreNameValuePairBinder();
                    } else {
                        this.dataSerializer_ = new CMDbStoreOldNameValuePairSerializer();
                        this.dataBinder_ = new CMDbStoreOldNameValuePairBinder();
                    }
                } else if (CMPropertyTypes.isUncheckedArrayType(this.type_)) {
                    this.dataSerializer_ = new CMDbStoreUncheckedArraySerializer(this.type_);
                } else if (this.type_ == CMPropertyTypes.BIBUS_STRINGARRAY || this.type_ == CMPropertyTypes.BIBUS_TOKENARRAY || this.type_ == CMPropertyTypes.BIBUS_EVENTTYPEENUMARRAY || this.type_ == CMPropertyTypes.BIBUS_UICOMPONENTENUMARRAY || this.type_ == CMPropertyTypes.BIBUS_ANYURIARRAY) {
                    this.dataSerializer_ = this.isStoredAsArray_ ? new CMDbStoreStringArrayEntrySerializer() : new CMDbStoreStringArraySerializer();
                } else if (this.type_ == CMPropertyTypes.BIBUS_BASECLASSARRAY) {
                    if (this.isStoreIDBased_) {
                        boolean bl = this.requiresProxies_ = this.isRefsSecurity_;
                        if (this.maxOccurs_ > 1) {
                            this.dataSerializer_ = new CMDbStoreIDBasedBaseClassArrayEntrySerializer();
                            this.searchDataBinder_ = new CMDbStoreIntBinder();
                        } else {
                            this.dataSerializer_ = new CMDbStoreIDBasedBaseClassArraySingletonSerializer();
                            this.searchDataBinder_ = new CMDbStoreIntBinder();
                        }
                    } else {
                        boolean preIDBasedResolvedReference;
                        boolean bl = preIDBasedResolvedReference = baseType == 4 || baseType == 3 || this.columnCount() == 2;
                        if (preIDBasedResolvedReference) {
                            this.requiresProxies_ = true;
                            if (this.maxOccurs_ == 1) {
                                this.dataSerializer_ = new CMDbStoreResolvedBaseClassArraySingletonSerializer();
                                this.searchDataBinder_ = new CMDbStoreResolvableBaseClassArraySingletonSearchBinder();
                            } else if (this.isStoredAsArray_) {
                                this.dataSerializer_ = new CMDbStoreResolvableBaseClassArrayEntrySerializer();
                                this.dataBinder_ = new CMDbStoreResolvableBaseClassArrayEntryBinder();
                                this.searchDataBinder_ = new CMDbStoreResolvableBaseClassArrayEntrySearchBinder();
                            } else {
                                this.dataSerializer_ = new CMDbStoreBaseClassArraySerializer();
                            }
                        } else {
                            this.requiresProxies_ = false;
                            this.dataSerializer_ = this.maxOccurs_ == 1 ? new CMDbStoreBaseClassArraySingletonSerializer() : (this.isStoredAsArray_ ? new CMDbStoreBaseClassArrayEntrySerializer() : new CMDbStoreBaseClassArraySerializer());
                        }
                    }
                } else if (this.type_ == CMPropertyTypes.BIBUS_CLASSENUM) {
                    this.dataSerializer_ = new CMDbStoreObjectClassSerializer();
                } else if (this.type_ == CMPropertyTypes.XML_BOOLEAN) {
                    this.dataSerializer_ = new CMDbStoreBooleanSerializer();
                    this.dataBinder_ = new CMDbStoreBooleanBinder();
                } else if (this.type_ == CMPropertyTypes.XML_DATETIME) {
                    this.dataSerializer_ = new CMDbStoreTimestampSerializer();
                } else if (this.type_ == CMPropertyTypes.XML_INT || this.type_ == CMPropertyTypes.XML_INTEGER) {
                    this.dataSerializer_ = this.constructIntegerSerializer();
                } else if (this.type_ == CMPropertyTypes.XML_NONNEGATIVEINTEGER) {
                    if (this.minValueStr_ == null) {
                        this.minValueStr_ = "0";
                    }
                    if (this.hasMeaning(CMPropertyMeaning.DATASIZE) || this.hasMeaning(CMPropertyMeaning.DATASETSIZE)) {
                        this.dataSerializer_ = this.constructLongSerializer();
                        this.dataBinder_ = new CMDbStoreLongBinder();
                    } else {
                        this.dataSerializer_ = this.constructIntegerSerializer();
                    }
                } else if (this.type_ == CMPropertyTypes.XML_POSITIVEINTEGER) {
                    if (this.minValueStr_ == null) {
                        this.minValueStr_ = "1";
                    }
                    this.dataSerializer_ = this.constructIntegerSerializer();
                } else if (this.type_ == CMPropertyTypes.XML_FLOAT) {
                    minValue = null;
                    Double maxValue = null;
                    if (this.minValueStr_ != null) {
                        minValue = new Double(this.parseDoubleAttribute(this.minExclusive_ ? PROP_ATTR_MINEXCLUSIVEVALUE : PROP_ATTR_MINVALUE, this.minValueStr_));
                    }
                    if (this.maxValueStr_ != null) {
                        maxValue = new Double(this.parseDoubleAttribute(this.maxExclusive_ ? PROP_ATTR_MAXEXCLUSIVEVALUE : PROP_ATTR_MAXVALUE, this.maxValueStr_));
                    }
                    this.dataSerializer_ = new CMDbStoreFloatSerializer(minValue, maxValue, this.minExclusive_, this.maxExclusive_, this.name_);
                } else if (this.type_ == CMPropertyTypes.XML_DECIMAL) {
                    minValue = null;
                    Double maxValue = null;
                    if (this.minValueStr_ != null) {
                        minValue = new Double(this.parseDoubleAttribute(this.minExclusive_ ? PROP_ATTR_MINEXCLUSIVEVALUE : PROP_ATTR_MINVALUE, this.minValueStr_));
                    }
                    if (this.maxValueStr_ != null) {
                        maxValue = new Double(this.parseDoubleAttribute(this.maxExclusive_ ? PROP_ATTR_MAXEXCLUSIVEVALUE : PROP_ATTR_MAXVALUE, this.maxValueStr_));
                    }
                    this.dataSerializer_ = new CMDbStoreDecimalSerializer(minValue, maxValue, this.minExclusive_, this.maxExclusive_, this.name_);
                } else if (this.type_ == CMPropertyTypes.XML_STRING || this.type_ == CMPropertyTypes.XML_ANYURI || this.type_ == CMPropertyTypes.XML_TOKEN || this.type_ == CMPropertyTypes.XML_NMTOKEN || this.type_ == CMPropertyTypes.XML_NCNAME || this.type_ == CMPropertyTypes.BIBUS_GUID || this.type_ == CMPropertyTypes.BIBUS_METADATAMODELITEMNAME || this.type_ == CMPropertyTypes.BIBUS_SEARCHPATHSINGLEOBJECT || this.type_ == CMPropertyTypes.BIBUS_ADDRESSSMTP || this.type_ == CMPropertyTypes.XML_DURATION || this.type_ == CMPropertyTypes.XML_TIME) {
                    this.dataSerializer_ = new CMDbStoreStringSerializer();
                } else if (this.type_ == CMPropertyTypes.XML_LANGUAGE) {
                    this.dataSerializer_ = baseType == 5 ? new CMDbStoreContentLocaleSerializer() : new CMDbStoreStringSerializer();
                } else if (this.type_ == CMPropertyTypes.XML_BASE64BINARY || this.type_ == CMPropertyTypes.BIBUS_BASE64BINARYMIME) {
                    this.dataSerializer_ = new CMDbStorePassthruSerializer();
                } else if (this.type_ == CMPropertyTypes.BIBUS_POLICYARRAY || this.type_ == CMPropertyTypes.BIBUS_USERCAPABILITYPOLICYARRAY) {
                    this.dataSerializer_ = new CMDbStorePoliciesSerializer();
                } else if (this.type_ == CMPropertyTypes.BIBUS_MULTILINGUALSTRING || this.type_ == CMPropertyTypes.BIBUS_MULTILINGUALTOKEN) {
                    this.requiresCIHandling_ = CMDbConnection.getDbmsInfo().getDbmsIsCaseSensitive() && this.isStoredAsArray_;
                    this.dataSerializer_ = new CMDbStoreMultiLingualStringEntrySerializer();
                    this.dataBinder_ = new CMDbStoreMultilingualStringBinder(false);
                    String tableName = this.getColumn(0).getTable();
                    if (!MULTILINGUAL_PROP_TABLES.contains(tableName)) {
                        MULTILINGUAL_PROP_TABLES.add(new String(tableName));
                    }
                    if (!tableName.equals("CMOBJNAMES")) {
                        this.propNameInTable_ = new String(this.name_);
                    }
                } else if (this.type_ == CMPropertyTypes.BIBUS_STRINGMAPENTRYARRAY) {
                    this.dataSerializer_ = new CMDbStoreStringMapEntryArraySerializer();
                } else if (this.type_ == CMPropertyTypes.XML_ANYTYPE || this.type_ == CMPropertyTypes.BIBUS_ANYTYPEMIME || this.type_ == CMPropertyTypes.BIBUS_DATASOURCECOMMANDBLOCK || this.type_ == CMPropertyTypes.BIBUS_POWERPLAYDATABLOCKARRAY || this.type_ == CMPropertyTypes.BIBUS_QUERYSPECIFICATION || this.type_ == CMPropertyTypes.BIBUS_XMLENCODEDXML || this.type_ == CMPropertyTypes.BIBUS_XMLENCODEDXMLMIME) {
                    this.dataSerializer_ = baseType == 2004 || baseType == -4 ? new CMDbStoreStringCompressingSerializer() : (baseType == 2005 ? new CMDbStoreLongStringSerializer() : new CMDbStoreStringSerializer());
                } else {
                    if (this.type_ != CMPropertyTypes.BIBUS_DATAINTEGRATIONSERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_PLANNINGTASKSERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_INDEXUPDATESERVICESERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_DATAMOVEMENTSERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_MIGRATIONSERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_REPORTDATASERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_PLANNINGADMINISTRATIONCONSOLESERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_POWERPLAYSERVICESPECIFICATION && this.type_ != CMPropertyTypes.BIBUS_REPORTSERVICEDRILLTHROUGHSPECIFICATION) throw new IllegalStateException("Unknown property type for property " + this.name_);
                    this.dataSerializer_ = new CMDbStoreUncheckedComplexScalorSerializer(this.type_);
                }
                if (this.dataBinder_ == null) {
                    if (baseType == Integer.MAX_VALUE) {
                        throw new IllegalStateException("Cannot select a default binder for properties represented by more than one column");
                    }
                    if (baseType == 4) {
                        this.dataBinder_ = new CMDbStoreIntBinder();
                    } else if (baseType == 8 || baseType == 6) {
                        this.dataBinder_ = new CMDbStoreFloatBinder();
                    } else if (baseType == 12 || baseType == -1 || baseType == 1 || baseType == -16) {
                        this.dataBinder_ = new CMDbStoreStringBinder();
                    } else if (baseType == 5 || baseType == -6) {
                        this.dataBinder_ = new CMDbStoreShortBinder();
                    } else if (baseType == 2004 || baseType == -4) {
                        this.dataBinder_ = this.chooseBlobBinder();
                    } else if (baseType == 2005) {
                        this.dataBinder_ = new CMDbStoreCLOBBinder();
                    } else if (baseType == 93 || baseType == 91) {
                        this.dataBinder_ = new CMDbStoreTimestampBinder();
                    } else {
                        if (baseType != -7) throw new IllegalStateException("Illegal baseType.");
                        this.dataBinder_ = new CMDbStoreBooleanBinder();
                    }
                }
                if (this.searchDataBinder_ == null && this.searchable_) {
                    this.searchDataBinder_ = this.dataBinder_;
                }
                if (!this.isStoreIDBased_ || this.references_ != null || !this.strongValidation_) return;
                throw new IllegalStateException("Missing referenced classes in definition of ID-based reference property " + this.name_ + ".");
            }
            catch (Exception ex) {
                throw new CMConfigurationException((Throwable)ex, "cmErrInvalidPropertyDef", new CMException.Parm("Property", this.getName()));
            }
        }
        if (this.behaviourName_ != "evalDBPredicate") return;
        try {
            this.dataSerializer_ = new CMDbStoreBooleanSerializer();
            this.dataBinder_ = new CMDbStoreBooleanBinder();
            return;
        }
        catch (Exception ex) {
            throw new CMConfigurationException((Throwable)ex, "cmErrInvalidPropertyDef", new CMException.Parm("Property", this.getName()));
        }
    }

    private int getNumberProp(Map<String, Object> columnProps, String propName, int defaultValue) {
        int intValue = defaultValue;
        Number propValue = (Number)columnProps.get(propName);
        if (propValue != null) {
            intValue = propValue.intValue();
        }
        return intValue;
    }

    public boolean allowNullValues() {
        if (!this.isScalor() || this.behaviourName_ != null) {
            return true;
        }
        CMDbColumn column0 = this.getColumn(0);
        return column0 != null ? column0.isNullable() : true;
    }

    CMDbStoreDataBinder chooseBlobBinder() {
        AbstractDataBinder binder = this.isExternalizable() ? new CMDbStoreRepositoryBinder() : new CMDbStoreBLOBBinder();
        return binder;
    }

    protected boolean isEOSEnabled() {
        return ConfigurationFactory.getConfig().isExternalObjectStoreEnabled();
    }

    private CMDbStoreDataSerializer constructIntegerSerializer() throws CMException {
        Integer minValue = null;
        Integer maxValue = null;
        if (this.minValueStr_ != null) {
            minValue = new Integer(this.parseIntAttribute(this.minExclusive_ ? PROP_ATTR_MINEXCLUSIVEVALUE : PROP_ATTR_MINVALUE, this.minValueStr_));
        }
        if (this.maxValueStr_ != null) {
            maxValue = new Integer(this.parseIntAttribute(this.maxExclusive_ ? PROP_ATTR_MAXEXCLUSIVEVALUE : PROP_ATTR_MAXVALUE, this.maxValueStr_));
        }
        return new CMDbStoreIntegerSerializer(minValue, maxValue, this.minExclusive_, this.maxExclusive_, this.name_);
    }

    private CMDbStoreDataSerializer constructLongSerializer() throws CMException {
        Long minValue = null;
        Long maxValue = null;
        if (this.minValueStr_ != null) {
            minValue = new Long(this.parseLongAttribute(this.minExclusive_ ? PROP_ATTR_MINEXCLUSIVEVALUE : PROP_ATTR_MINVALUE, this.minValueStr_));
        }
        if (this.maxValueStr_ != null) {
            maxValue = new Long(this.parseLongAttribute(this.maxExclusive_ ? PROP_ATTR_MAXEXCLUSIVEVALUE : PROP_ATTR_MAXVALUE, this.maxValueStr_));
        }
        return new CMDbStoreLongSerializer(minValue, maxValue, this.minExclusive_, this.maxExclusive_, this.name_);
    }

    private int parseIntAttribute(String attribute, String attrValue) throws CMException {
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException ex) {
            throw new CMException((Exception)ex, "cmBadAttrValue", new CMException.Parm("Value", attrValue), new CMException.Parm("Attribute", attribute));
        }
    }

    private long parseLongAttribute(String attribute, String attrValue) throws CMException {
        try {
            return Long.parseLong(attrValue);
        }
        catch (NumberFormatException ex) {
            throw new CMException((Exception)ex, "cmBadAttrValue", new CMException.Parm("Value", attrValue), new CMException.Parm("Attribute", attribute));
        }
    }

    private double parseDoubleAttribute(String attribute, String attrValue) throws CMException {
        try {
            return Double.parseDouble(attrValue);
        }
        catch (NumberFormatException ex) {
            throw new CMException((Exception)ex, "cmBadAttrValue", new CMException.Parm("Value", attrValue), new CMException.Parm("Attribute", attribute));
        }
    }

    @Override
    public String getBehaviourName() {
        return this.behaviourName_;
    }

    @Override
    public List<Object> getBehaviourParms() {
        return this.behaviourParms_;
    }

    public String getFilter() {
        return this.filter_;
    }

    public CMDbObjectClass[] getReferences() {
        return this.references_;
    }

    private void parseBehaviour(String behaviourStr) {
        if (behaviourStr.length() == 0) {
            return;
        }
        int pos = behaviourStr.indexOf(40);
        if (pos < 0) {
            throw new IllegalStateException("Malformed behaviour");
        }
        String bName = behaviourStr.substring(0, pos).trim();
        for (int bIdx = 0; bIdx != BEHAVIOURS.length; ++bIdx) {
            if (!BEHAVIOURS[bIdx].equals(bName)) continue;
            this.behaviourName_ = BEHAVIOURS[bIdx];
        }
        if (this.behaviourName_ == null) {
            throw new IllegalStateException("Unknown behaviour " + bName);
        }
        int startOfName = pos + 1;
        pos = behaviourStr.lastIndexOf(41);
        if (pos < 0) {
            throw new IllegalStateException("bad behaviour");
        }
        String parm = behaviourStr.substring(startOfName, pos).trim();
        if (parm.length() > 0) {
            this.behaviourParms_.add(parm);
        }
    }

    public void finishLoading(CMDbConnection con) throws Exception {
        if (this.behaviourName_ == null) {
            return;
        }
        if (this.behaviourParms_.size() == 0) {
            throw new IllegalStateException("behaviour " + this.behaviourName_ + ": missing argument");
        }
        String param = (String)this.behaviourParms_.get(0);
        if (this.behaviourName_ == "matchLocale" || this.behaviourName_ == "isNotNULL" || this.behaviourName_ == "matchLocaleGetLocale" || this.behaviourName_ == "basedOn") {
            List<CMProperty> props = this.propSet_.getProperties(param);
            if (props == null) {
                throw new IllegalStateException("matchLocale: bad property name");
            }
            CMDbProperty prop = (CMDbProperty)props.get(0);
            if (this.behaviourName_ == "matchLocale") {
                this.setMultilingualProperty(prop);
                prop.setDefaultMultilingualProperty(this);
            }
            if (!(this.behaviourName_ != "matchLocale" && this.behaviourName_ != "matchLocaleGetLocale" || param.equals("name"))) {
                this.propNameInTable_ = param;
            }
            this.columns_ = prop.columns_;
            this.validateDatabaseParameters(con.getConnection());
        } else if (this.behaviourName_ == "evalPredicate" || this.behaviourName_ == "evalDBPredicate") {
            StringReader reader = new StringReader(param);
            CMPathStepTokenizer toker = new CMPathStepTokenizer(reader);
            try {
                CMStorePathPredicate thePred = new CMStorePathPredicate(toker, -1);
                this.behaviourParms_.set(0, thePred);
            }
            catch (Exception ex) {
                throw new IllegalStateException("evalPredicate: invalid predicate " + ex.toString());
            }
        } else if (this.behaviourName_ == "rankLocale") {
            List<CMProperty> props = this.propSet_.getProperties(param);
            if (props == null) {
                throw new IllegalStateException("rankLocale: bad property name");
            }
            CMDbProperty prop = (CMDbProperty)props.get(0);
            this.columns_ = prop.columns_;
            this.validateDatabaseParameters(con.getConnection());
        } else if (this.behaviourName_ == "rankFormat") {
            List<CMProperty> props = this.propSet_.getProperties(param);
            if (props == null) {
                throw new IllegalStateException("rankFormat: bad property name");
            }
            CMDbProperty prop = (CMDbProperty)props.get(0);
            this.columns_ = prop.columns_;
            this.validateDatabaseParameters(con.getConnection());
        }
    }

    public int columnCount() {
        if (this.columns_ == null) {
            return 0;
        }
        return this.columns_.size();
    }

    public CMDbColumn getColumn(int index) {
        return this.columns_.get(index);
    }

    @Override
    public CMPropertySet getPropertySet() {
        return this.propSet_;
    }

    @Override
    public boolean isCached() {
        return this == CMProperty.DEFAULTNAME || this == CMProperty.NAME || this == CMProperty.ANCESTORS || this == CMProperty.OBJECTCLASS || this == CMProperty.HASCHILDREN || this == CMProperty.DISPATCHERPATH || this == CMProperty.TASKID || this == CMProperty.EVENTID || this == CMProperty._ISBURSTOUTPUT || this == CMProperty.PARENT || this == CMProperty.DISABLED || this == CMProperty.SEARCHPATH || this == CMProperty.STOREID || this == CMProperty.ID || this == CMProperty.TENANTID || this == CMProperty.VERSION || this == CMProperty.DOCUMENTID;
    }

    public boolean isStoredAsArray() {
        return this.isStoredAsArray_;
    }

    public boolean isExternalizable() {
        return this.isExternalizable && this.isEOSEnabled();
    }

    @Override
    public boolean isEnumeration() {
        return this.enumValues_ != null;
    }

    @Override
    public boolean isValidEnumValue(CMObjectClass objectClass, String value) {
        if (this.enumValues_ != null) {
            return this.enumValues_.getID(value) != -1;
        }
        return false;
    }

    public short getEnumID(String value) {
        return (short)this.enumValues_.getID(value);
    }

    public String getEnumValue(short ID2) {
        return this.enumValues_.getValue(ID2);
    }

    public short getNameEnumID(String name) {
        return (short)this.enumNames_.getID(name);
    }

    public String getNameEnumType(String name) {
        return this.enumNames_.getTypeName(name);
    }

    public String getNameEnumString(short ID2) {
        return this.enumNames_.getValue(ID2);
    }

    public short getTypeEnumID(String name) {
        return (short)this.enumTypes_.getID(name);
    }

    public String getTypeEnumString(short ID2) {
        return this.enumTypes_.getValue(ID2);
    }

    @Override
    public int getEnumValueBitIndex(String value) {
        return this.enumValues_.getBitIndex(value);
    }

    public boolean hasOrdinal() {
        return this.hasOrdinal_;
    }

    public boolean canContainNationalChar() {
        boolean canContainNationalChar = false;
        if (this.columns_ != null) {
            for (int i = 0; !canContainNationalChar && i < this.columns_.size(); ++i) {
                canContainNationalChar = this.columns_.get(i).getCanContainNationalChar();
            }
        }
        return canContainNationalChar;
    }

    public final boolean requiresCIHandling() {
        return this.requiresCIHandling_;
    }

    public final boolean storedAsBlob() {
        return this.storedAsBlob_;
    }

    public int getLOBColumnIndex() {
        return this.lobColumnIdx_;
    }

    @Override
    public final boolean canBeAttachment() {
        return this.canBeAttachment_;
    }

    public CMDbStoreDataBinder getDataBinder() {
        return this.dataBinder_;
    }

    public CMDbStoreDataBinder getSearchDataBinder() {
        return this.searchDataBinder_;
    }

    @Override
    public CMDbStoreDataSerializer getDataSerializer() {
        return this.dataSerializer_;
    }

    public String getDefaultValue() {
        return this.defaultValue_;
    }

    @Override
    public boolean requiresProxies() {
        return this.requiresProxies_;
    }

    public boolean hasPropertyID() {
        return this.propID_ >= 0;
    }

    public int getPropertyID() {
        return this.propID_;
    }

    @Override
    public boolean hasSubproperties() {
        return this.subproperties_.size() > 0;
    }

    @Override
    public ArrayList<? extends CMProperty> getSubproperties() {
        return this.subproperties_;
    }

    @Override
    public ArrayList<? extends CMProperty> getSubpropertiesAndSelf() {
        return this.subpropertiesAndSelf_;
    }

    @Override
    public CMProperty getIndexProperty() {
        return this.indexProp_;
    }

    public List<CMProperty> getPropertySubComponents() {
        ArrayList<CMProperty> propertySubComponents = new ArrayList<CMProperty>();
        propertySubComponents.add(this);
        CMProperty indexProp = this.getIndexProperty();
        if (indexProp != null) {
            propertySubComponents.add(indexProp);
        }
        propertySubComponents.addAll(this.getSubproperties());
        return propertySubComponents;
    }

    @Override
    public boolean canReferenceClass(CMObjectClass objectClass) {
        if (this.references_ == null || objectClass == null) {
            return false;
        }
        for (int i = 0; i < this.references_.length; ++i) {
            if (this.references_[i] == null || !objectClass.subclassof(this.references_[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<String> getSupportedEnumValues() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.isEnumeration()) {
            ret = this.enumValues_.getAllSupportedEnumValues();
        }
        return ret;
    }

    protected void setDefaultMultilingualProperty(CMProperty defaultMultilingual) {
        this.defaultMultilingualProperty = defaultMultilingual;
    }

    @Override
    public CMProperty getDefaultMultilingualProperty() {
        return this.defaultMultilingualProperty;
    }

    protected void setMultilingualProperty(CMProperty multilingual) {
        this.multilingualProperty = multilingual;
    }

    @Override
    public CMProperty getMultilingualProperty() {
        return this.multilingualProperty;
    }

    protected boolean isArchivingTrigger() {
        return this.isArchivingTrigger_;
    }

    public String toString() {
        return this.getObjectClass() + "." + this.getName();
    }

    @Override
    public int getMaxBitIndex() {
        return this.enumValues_.getMaxBitIndex();
    }
}

