/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.connectors.SDSConnector.SDSConnector;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbEnumerationSet;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbObjectClasses;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertyDef;
import com.cognos.cm.dbstore.CMDbPropertySets;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CMDbPropertySet
extends CMPropertySet {
    private CMDbEnumerationSet enumSet_ = new CMDbEnumerationSet();
    private CMDbPropertySets psets_;
    private int propCount_;
    private CMDbObjectClasses objectClasses_;
    private List<CMProperty> replicateSDSProps_;
    private Map<String, CMProperty> specialProps_;

    public CMDbPropertySet(CMSOAPConstants.XMLNamespace namespace, CMDbPropertySets psets) {
        this.psets_ = psets;
        this.namespace_ = namespace;
        this.properties_ = new CMProperty[200];
        this.mPropertiesByName_ = new HashMap();
        this.mPropertiesByMeaning_ = new HashMap();
        this.replicateSDSProps_ = new ArrayList<CMProperty>();
        this.propCount_ = 0;
        this.specialProps_ = new HashMap<String, CMProperty>();
    }

    void load(CMDbConnection con, CMDbObjectClasses classes) throws Exception {
        this.objectClasses_ = classes;
        this.enumSet_.load(con);
    }

    void finishLoading(CMDbConnection con) throws Exception {
        int i;
        Field[] fields = CMProperty.class.getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            int modifiers;
            if (fields[i].getType() != CMProperty.class || !Modifier.isPublic(modifiers = fields[i].getModifiers()) || !Modifier.isStatic(modifiers)) continue;
            Object value = null;
            try {
                value = fields[i].get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value != null) continue;
            throw new IllegalStateException("CMProperty." + fields[i].getName() + " is unresolved");
        }
        if (this.propCount_ < this.properties_.length) {
            CMProperty[] newArray = new CMProperty[this.propCount_];
            System.arraycopy(this.properties_, 0, newArray, 0, this.propCount_);
            this.properties_ = newArray;
        }
        if (this.replicateSDSProps_.size() != 0) {
            CMProperty[] array = new CMProperty[this.replicateSDSProps_.size()];
            this.replicateSDSProps_.toArray(array);
            SDSConnector.setReplicateProps(array);
            this.replicateSDSProps_ = null;
        }
        this.specialProps_ = null;
        for (i = 0; i < this.propCount_; ++i) {
            ((CMDbProperty)this.properties_[i]).finishLoading(con);
        }
        CMDbStoreFactory.afterMetadataIsLoaded();
    }

    CMDbProperty loadProperty(Connection con, CMDbObjectClass objectClass, CMDbPropertyDef propertyElem) throws SQLException, Exception {
        boolean updatePropertyOnCopy;
        String name;
        CMDbProperty prop;
        boolean isSpecial;
        boolean bl = isSpecial = propertyElem.getAttribute("isSpecial").length() != 0;
        if (isSpecial && (prop = (CMDbProperty)this.specialProps_.get(name = propertyElem.getAttribute("name"))) != null) {
            return prop;
        }
        CMDbProperty prop2 = new CMDbProperty(con, this, objectClass, propertyElem);
        if (isSpecial) {
            this.specialProps_.put(prop2.getName(), prop2);
            String fieldName = prop2.getName().toUpperCase(Locale.US);
            try {
                Field field = CMProperty.class.getField(fieldName);
                field.set(null, prop2);
            }
            catch (Exception ex) {
                throw new CMConfigurationException("cmMissingPropField", new CMException.Parm("Field", fieldName));
            }
        }
        if (propertyElem.getAttribute("replicateSDS").length() != 0) {
            this.replicateSDSProps_.add(prop2);
        }
        this.properties_[this.propCount_++] = prop2;
        this.addPropertyToMap(this.mPropertiesByName_, prop2.getName(), prop2, isSpecial);
        CMPropertyMeaning propertyMeaning = prop2.getMeaning();
        if (propertyMeaning != null) {
            this.addPropertyToMap(this.mPropertiesByMeaning_, propertyMeaning, prop2, isSpecial);
        }
        if (this.propCount_ == this.properties_.length) {
            CMProperty[] newArray = new CMProperty[this.propCount_ + 50];
            System.arraycopy(this.properties_, 0, newArray, 0, this.propCount_);
            this.properties_ = newArray;
        }
        boolean bl2 = updatePropertyOnCopy = prop2.isStoreIDBased() && !prop2.getName().equals("owner");
        if (prop2.columnCount() > 0 && this.psets_ != null) {
            for (int colIdx = 0; colIdx != prop2.columnCount(); ++colIdx) {
                this.psets_.addTable(prop2.getColumn(colIdx).getTable(), updatePropertyOnCopy);
            }
        }
        return prop2;
    }

    private <T> void addPropertyToMap(Map<T, List<CMProperty>> map, T key, CMProperty value, boolean isSpecial) {
        List<CMProperty> propertyArray = map.get(key);
        if (propertyArray == null) {
            propertyArray = new ArrayList<CMProperty>();
            propertyArray.add(value);
            map.put(key, propertyArray);
        } else if (isSpecial) {
            map.put(key, propertyArray);
            propertyArray.add(0, value);
        } else {
            propertyArray.add(value);
        }
    }

    public CMDbEnumerationSet enumerationSet() {
        return this.enumSet_;
    }

    public CMDbObjectClasses objectClasses() {
        return this.objectClasses_;
    }
}

