/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreMetadataUtil;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.SqlBuilder;
import com.cognos.cm.server.CMException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class CMDbSizeExecutable {
    protected CMDbStore store;

    protected CMDbSizeExecutable(CMDbStore store) {
        this.store = store;
    }

    protected void execute(Set<String> tables) throws CMException {
        boolean changedIsolationLevel = false;
        int defaultIsolation = -1;
        CMDbConnection con = this.store.getConnection();
        SqlBuilder sql = new SqlBuilder(con.getSqlGenerator());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        CMDbStore.ReadTransactionHandle rtHandle = null;
        try {
            if (this.useDirtyRead() && CMDbConnection.getDbmsInfo().getDbms() != 2) {
                defaultIsolation = con.getConnection().getTransactionIsolation();
                con.getConnection().setTransactionIsolation(1);
                changedIsolationLevel = true;
            }
            this.prepare(con);
            for (String table : tables) {
                boolean keepGoingWithTable;
                HashMap<String, HashMap<String, Object>> columns;
                sql.clear();
                if (!CMDbStoreMetadataUtil.containsCMIDColumn(table) || (columns = CMDbStoreFactory.getTableColumnProperties(table, con.getConnection())) == null || !(keepGoingWithTable = this.appendSqlForTable(sql, table, columns))) continue;
                stmt = con.prepareStatement(sql.toString());
                this.bindParameters(stmt);
                rtHandle = this.store.beginReadTransaction();
                rs = stmt.executeQuery();
                this.extractResult(rs);
                CMDbStoreUtil.safeCloseStatement(stmt);
                if (rtHandle == null) continue;
                CMDbStore.releaseReadTransaction(rtHandle);
            }
        }
        catch (SQLException ex) {
            throw new CMException(ex);
        }
        finally {
            if (stmt != null) {
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            CMDbStore.releaseReadTransaction(rtHandle);
            if (changedIsolationLevel) {
                try {
                    con.getConnection().setTransactionIsolation(defaultIsolation);
                }
                catch (SQLException e) {
                    throw new CMException(e);
                }
            }
        }
    }

    protected void prepare(CMDbConnection con) throws CMException, SQLException {
    }

    protected abstract boolean appendSqlForTable(SqlBuilder var1, String var2, Map<String, HashMap<String, Object>> var3) throws CMException, SQLException;

    protected abstract void bindParameters(PreparedStatement var1) throws SQLException;

    protected abstract void extractResult(ResultSet var1) throws SQLException;

    protected boolean useDirtyRead() {
        return false;
    }

    protected boolean appendSizeColumnsSql(SqlBuilder sql, Map<String, HashMap<String, Object>> columnsMap) {
        boolean bFirst = true;
        Set<String> columnNames = columnsMap.keySet();
        for (String columnName : columnNames) {
            Map columnProps = columnsMap.get(columnName);
            if (columnProps == null) continue;
            String typeName = (String)columnProps.get("TYPE_NAME");
            BigDecimal intProp = (BigDecimal)columnProps.get("DATA_TYPE");
            int dbType = 0;
            if (intProp != null) {
                dbType = intProp.intValue();
            }
            if (!this.columnTypeIsSizable(dbType = CMDbStoreUtil.correctColumnType(typeName, dbType))) continue;
            if (!bFirst) {
                sql.plus();
            }
            sql.sum();
            sql.cast();
            sql.coalesce();
            sql.length().aliasedColumn("s", columnName).closeBracket();
            sql.separator().append("0");
            sql.closeBracket();
            sql.as().append(CMDbStoreUtil.getBigintDatatypeName()).closeBracket();
            sql.closeBracket();
            bFirst = false;
        }
        return !bFirst;
    }

    protected boolean columnTypeIsSizable(int dbType) {
        return (dbType == 2005 || dbType == 2004) && CMDbConnection.getDbmsInfo().getLobLengthQuerySupported() || dbType == -4 || dbType == -1 || dbType == -16 || dbType == -10;
    }

    protected CMDbStore getStore() {
        return this.store;
    }
}

