/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.CAM.AAAException;
import com.cognos.cm.cache.CacheFactory;
import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.cam.AAAProvider;
import com.cognos.cm.connectors.SDSConnector.SDSConnector;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbLargeResultSet;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbObjectClasses;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbPropertySets;
import com.cognos.cm.dbstore.CMDbStoreAddArrayDef;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.CMDbStoreAddResults;
import com.cognos.cm.dbstore.CMDbStoreArrayTableUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreBaseTableAddDef;
import com.cognos.cm.dbstore.CMDbStoreBaseTableUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreConsistency;
import com.cognos.cm.dbstore.CMDbStoreCopyCacheObjects;
import com.cognos.cm.dbstore.CMDbStoreCopyDef;
import com.cognos.cm.dbstore.CMDbStoreCopyOwnerToRecipsDef;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreDefaultLocalizedStringTableUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreDefaultNamesTableUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreDelCacheObjects;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreExternalDataUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreIDReferencesUtil;
import com.cognos.cm.dbstore.CMDbStoreLockUtil;
import com.cognos.cm.dbstore.CMDbStoreMembership;
import com.cognos.cm.dbstore.CMDbStoreMoveCacheObjects;
import com.cognos.cm.dbstore.CMDbStoreMultiCacheComplexQueryResults;
import com.cognos.cm.dbstore.CMDbStoreMultipleCMsUtil;
import com.cognos.cm.dbstore.CMDbStoreMultipleLocalizedStringTableBatchUpdate;
import com.cognos.cm.dbstore.CMDbStoreMultipleLocalizedStringTableUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.CMDbStorePolicyResultSet;
import com.cognos.cm.dbstore.CMDbStorePrepStmtCache;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreProxyFactory;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreSysProperties;
import com.cognos.cm.dbstore.CMDbStoreTAAddToCache;
import com.cognos.cm.dbstore.CMDbStoreTAUpdateCache;
import com.cognos.cm.dbstore.CMDbStoreTransactionAction;
import com.cognos.cm.dbstore.CMDbStoreUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMDbTempTableId;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.CMUserCapabilityPoliciesHandler;
import com.cognos.cm.dbstore.DbStoreModule;
import com.cognos.cm.dbstore.ICMDbConnection;
import com.cognos.cm.dbstore.ICMDbObjectClasses;
import com.cognos.cm.dbstore.ICMDbStore;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.NameUniqueness;
import com.cognos.cm.dbstore.StubFolder;
import com.cognos.cm.dbstore.UpdateCacheVersionNumbersTransactionAction;
import com.cognos.cm.dbstore.notification.CMDbStoreNotification;
import com.cognos.cm.dbstore.notification.CMDbStoreNotificationObservers;
import com.cognos.cm.dbstore.notification.CMDbStoreNotificationTA;
import com.cognos.cm.dbstore.plugins.Plugin;
import com.cognos.cm.dbstore.plugins.PluginFactory;
import com.cognos.cm.dbstore.plugins.PropertyPlugin;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.externalRepository.ExternalObjectStoreConnectionProvider;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.multipart.RequestAttachment;
import com.cognos.cm.multipart.RequestFileAttachment;
import com.cognos.cm.multitenancy.CMTenantIDConflictException;
import com.cognos.cm.multitenancy.MultiTenancyUtils;
import com.cognos.cm.multitenancy.TenantIdCopyAction;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.notification.DelayedNotificationTA;
import com.cognos.cm.notification.Notification;
import com.cognos.cm.notification.NotificationBuilder;
import com.cognos.cm.notification.NotificationTA;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectClasses;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertySets;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.server.executioncontext.UserAccountInfo;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreCompoundResults;
import com.cognos.cm.store.CMStoreConnectionProblemReporter;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreMultiQueryResults;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.ArchivingUtil;
import com.cognos.cm.util.ArrayUtils;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMDeferredInitActionUtils;
import com.cognos.cm.util.CMIPFData;
import com.cognos.cm.util.CMIntList;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMMethodInvoker;
import com.cognos.cm.util.CMObjectID;
import com.cognos.cm.util.CMProxyAccountData;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMUUID;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.date.DateUtils;
import com.cognos.cmutils.hash.HashUtil;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class CMDbStore
implements ICMDbStore {
    private static final String REPOSITORY_URL_SUFFIX = "/content";
    private static final String REPOSITORY_URL_PREFIX = "/repository/sid/cm/oid/";
    private static boolean dbgGetReadTransStackTrace_;
    private static final String sDebugReadTransKey_ = "CM.debugReadTrans";
    static final int fetchIncremental = 100000;
    private static boolean g_bDoneStaticInit;
    private static int cognosNSId_;
    private static String selectOwnerStatement_;
    private CMDbTempTableId tempTableId_;
    private boolean bInitialized_;
    private CMStoreMetadata metadata_;
    private final PluginFactory pluginFactory_;
    protected CMDbConnection connection_;
    protected CMCache cache_;
    private final List<CMDbStoreTransactionAction> transactionActions = new ArrayList<CMDbStoreTransactionAction>();
    private final List<CMDbStoreTransactionAction> postTransactionActions = new ArrayList<CMDbStoreTransactionAction>();
    private int readTransactionCount_;
    private boolean baseTableLock_ = false;
    protected boolean isRepositoryIntegrationInstalled_NeedsInitialValue_ = true;
    private boolean isRepositoryIntegrationInstalled_;
    private TenantRegistry tenantRegistry;
    protected DbStoreModule module;
    private HashMap<ReadTransactionHandle, String> readTrans_;
    private static final short BO_BOTH_PROPS_CLEARED = -2;
    private static final short BO_ONLY_ONE_PROP_CLEARED = -1;
    private static String m_directoryStoreID;

    public CMDbStore(CMStoreMetadata metadata, PluginFactory factory, TenantRegistry tenantRegistry) {
        this(metadata, factory, tenantRegistry, new DbStoreModule());
    }

    public CMDbStore(CMStoreMetadata metadata, PluginFactory factory, TenantRegistry tenantRegistry, DbStoreModule dbStoreModule) {
        this.metadata_ = metadata;
        this.pluginFactory_ = factory;
        if (metadata != null && factory != null && tenantRegistry != null) {
            this.bInitialized_ = true;
        }
        this.tempTableId_ = null;
        this.tenantRegistry = tenantRegistry;
        this.module = dbStoreModule;
    }

    public int getInternalIdFromCAMID(String camid) throws CMException {
        CMStoreXPath path = new CMStoreXPath("/directory//*[@id='" + CMStoreXPath.attributeEncodeString(camid) + "']", 10);
        CMCacheQueryInstance query2 = null;
        try {
            CMExecutionContext.checkCancelOrTimeOut();
            query2 = this.getCache().executeAdminQuery(path, 0);
            int[] results = query2.resultObjects();
            if (results.length == 1) {
                int n = results[0];
                return n;
            }
        }
        catch (CMCacheAccessDenied results) {
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cache exception");
        }
        finally {
            if (query2 != null) {
                try {
                    query2.release();
                }
                catch (Exception exception) {}
            }
        }
        return 0;
    }

    int lockInternalIdFromCAMID(String camid) throws CMException {
        CMStoreXPath path = new CMStoreXPath("/directory//*[@id='" + CMStoreXPath.attributeEncodeString(camid) + "']", 10);
        CMStoreQueryResults results = null;
        try {
            CMProperty[] props = new CMProperty[]{CMProperty.OBJECTCLASS};
            results = this.executeQuery(path, props, null, 0, 41472, null, 0, 1);
            if (results.next()) {
                int cmid;
                int n = cmid = results.getObjectID();
                return n;
            }
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "lockInternalIdFromCAMID");
        }
        finally {
            if (results != null) {
                try {
                    results.release();
                }
                catch (Exception exception) {}
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getOwnerObjectID(int srcObjectID) throws CMException {
        int selectString222;
        ICMDbStoreSqlGenerator sqlGenerator = this.getConnection().getSqlGenerator();
        int objectID = this.getCache().CMCacheGetIntegerProperty(srcObjectID, 17);
        if (-1 == objectID) {
            return 0;
        }
        if (-2 != objectID) return objectID;
        PreparedStatement stmt = null;
        try {
            if (selectOwnerStatement_ == null) {
                CMDbProperty ownerProperty = (CMDbProperty)CMProperty.OWNER;
                StringBuffer selectString222 = new StringBuffer();
                selectString222.append(sqlGenerator.createSelectSql());
                selectString222.append(ownerProperty.getColumn(0).getName());
                selectString222.append(sqlGenerator.createFromSql());
                selectString222.append(ownerProperty.getColumn(0).getTable());
                selectString222.append(sqlGenerator.createWhereSql());
                selectString222.append("CMID");
                selectString222.append(sqlGenerator.createEqualsBindParameterSymbol());
                if (ownerProperty.hasPropertyID()) {
                    selectString222.append(sqlGenerator.createAndSql());
                    selectString222.append("PROPID");
                    selectString222.append(sqlGenerator.createEqualsSql());
                    selectString222.append(ownerProperty.getPropertyID());
                }
                selectOwnerStatement_ = selectString222.toString();
            }
            stmt = this.getConnection().prepareStatement(selectOwnerStatement_);
            stmt.setInt(1, srcObjectID);
            CMExecutionContext.checkCancelOrTimeOut();
            ResultSet rs = stmt.executeQuery();
            objectID = 0;
            if (rs.next()) {
                objectID = rs.getInt(1);
                if (rs.wasNull()) {
                    objectID = 0;
                }
            }
            if (objectID != 0) {
                this.getCache().CMCacheUpdateIntProperty(srcObjectID, 17, objectID);
            } else {
                this.getCache().CMCacheUpdateIntProperty(srcObjectID, 17, -1);
            }
            selectString222 = objectID;
        }
        catch (SQLException e) {
            try {
                CMException cmex = new CMException((Exception)e, "cmErrSQLIn", new CMException.Parm("Location", "hasChildren"));
                CMIndications.logException(cmex);
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                throw throwable;
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            return 0;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return selectString222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getCreationTimeObjectID(int srcObjectID) throws CMException {
        PreparedStatement stmt;
        block4: {
            Timestamp timestamp;
            ICMDbStoreSqlGenerator sqlGenerator = this.getConnection().getSqlGenerator();
            StringBuffer selectString = new StringBuffer();
            selectString.append(sqlGenerator.createSelectSql());
            selectString.append("CREATED");
            selectString.append(sqlGenerator.createFromSql());
            selectString.append("CMOBJECTS");
            selectString.append(sqlGenerator.createWhereSql());
            selectString.append("CMID");
            selectString.append(sqlGenerator.createEqualsBindParameterSymbol());
            stmt = null;
            try {
                stmt = this.getConnection().prepareStatement(selectString.toString());
                stmt.setInt(1, srcObjectID);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                Timestamp ts = rs.getTimestamp(1);
                if (rs.wasNull()) break block4;
                timestamp = ts;
            }
            catch (SQLException e) {
                try {
                    CMException cmex = new CMException((Exception)e, "cmErrSQLIn", new CMException.Parm("Location", "hasChildren"));
                    CMIndications.logException(cmex);
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    throw throwable;
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
            CMDbStoreUtil.safeCloseStatement(stmt);
            return timestamp;
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        return null;
    }

    ReadTransactionHandle beginReadTransaction() throws CMException, SQLException {
        if (this.inTransaction()) {
            return null;
        }
        if (this.readTransactionCount_ == 0 && (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 5 || CMDbConnection.dbms_ == 8)) {
            this.getConnection().beginTransaction();
        }
        ++this.readTransactionCount_;
        return new ReadTransactionHandleImpl();
    }

    void endReadTransaction() throws CMException, SQLException {
        CMDbConnection con;
        if (this.readTransactionCount_ <= 0) {
            throw new IllegalStateException("Read transaction not active");
        }
        --this.readTransactionCount_;
        if (this.readTransactionCount_ == 0 && (CMDbConnection.dbms_ == 3 || CMDbConnection.dbms_ == 5 || CMDbConnection.dbms_ == 8) && (con = this.getConnection()) != null && con.inTransaction()) {
            con.commitTransaction();
        }
    }

    @Override
    public CMStoreQueryResults executeQuery(String searchPath, CMProperty[] properties, OrderByField[] orderBy, int opQuery, int permLock, List<String> extraPermission) throws CMException {
        return this.executeQuery(new CMStoreXPath(searchPath), properties, orderBy, opQuery, permLock, extraPermission);
    }

    @Override
    public CMStoreQueryResults executeQuery(ICMStorePath context, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission) throws CMException {
        CMStoreQueryResults results = this.executeQuery(context, properties, orderBy, operation, permissions, extraPermission, -1, -1);
        return results;
    }

    /*
     * Exception decompiling
     */
    @Override
    public CMStoreQueryResults executeQuery(ICMStorePath context, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, int skipObjects, int maxObjects) throws CMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InternalStoreId getInternalStoreId(int cmid) {
        return this.getCache().getInternalStoreId(cmid);
    }

    @Override
    public CMStoreQueryResults executeQuery(Collection<InternalStoreId> store_ids, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission) throws CMException {
        int[] cmids = this.getCache().resolveStoreIDs(store_ids);
        return this.executeQuery(cmids, properties, null, orderBy, operation, permissions, extraPermission);
    }

    @Override
    public CMStoreQueryResults executeQuery(int[] object_ids, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission) throws CMException {
        return this.executeQuery(object_ids, properties, null, orderBy, operation, permissions, extraPermission);
    }

    @Override
    public CMStoreQueryResults executeQuery(int[] object_ids, CMProperty[] properties, CMStorePath query2, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission) throws CMException {
        CMExecutionContext.checkCancelOrTimeOut();
        try {
            return new CMDbStoreCacheQueryResults(this, object_ids, query2, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpected");
        }
        catch (CMCacheAccessDenied e) {
            CMDbStoreSecurityUtil.convertAccessDeniedException(this.getCache(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMStoreQueryResults executeCompoundQuery(ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission) throws CMException {
        CMStoreCompoundResults compound_results = null;
        CMStoreQueryResults part_results = null;
        boolean success = false;
        try {
            compound_results = orderBy == null ? new CMStoreMultiQueryResults(this) : new CMDbStoreMultiCacheComplexQueryResults(this, orderBy);
            List<ICMStorePath> searchPaths = query2.getUnion();
            for (int i = 0; i < searchPaths.size(); ++i) {
                ICMStorePath path = searchPaths.get(i);
                CMExecutionContext.checkCancelOrTimeOut();
                part_results = this.executeQuery(path, properties, orderBy, operation, permissions, extraPermission, -1, -1);
                compound_results.add(path, part_results);
                part_results = null;
            }
            compound_results.fixate();
            success = true;
            CMStoreCompoundResults cMStoreCompoundResults = compound_results;
            return cMStoreCompoundResults;
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(part_results);
            if (!success) {
                CMQueryUtils.safeQueryResultsRelease(compound_results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMStoreQueryResults addObject(CMStorePath parentPath, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues) throws CMException {
        int pid;
        if (!this.inTransaction()) {
            throw new IllegalStateException("addObject must be called from within a transaction");
        }
        CMCacheQueryInstance query2 = null;
        try {
            String passPortID = null;
            CMExecutionContext currentContext = CMExecutionContext.get();
            if (currentContext.requireAccessCheck()) {
                passPortID = currentContext.getAccManPassportID();
            }
            ICacheAccessMan accMan = this.getCache().newAccessMan(passPortID);
            CMExecutionContext.checkCancelOrTimeOut();
            query2 = this.getCache().executeQuery(parentPath, 1, accMan);
            if (query2.count() == 0) {
                throw new CMStoreObjectNotFound(CMQueryUtils.getPath((CMStore)this, parentPath));
            }
            if (query2.count() > 1) {
                throw new CMStoreUnexpected(null, "cmStoreUnexpectedParentPathOver1");
            }
            pid = query2.resultObjects()[0];
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedNoParentInCache");
        }
        catch (CMCacheAccessDenied e) {
            CMDbStoreSecurityUtil.convertAccessDeniedException(this.getCache(), e);
            CMStoreQueryResults cMStoreQueryResults = null;
            return cMStoreQueryResults;
        }
        finally {
            try {
                if (query2 != null) {
                    query2.release();
                }
            }
            catch (CMCacheException cMCacheException) {}
        }
        CMExecutionContext.checkCancelOrTimeOut();
        return this.createObject(pid, name, objectClass, properties, propValues);
    }

    @Override
    public CMStoreQueryResults addObject(int pid, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues) throws CMException {
        return this.addObject(pid, name, objectClass, properties, propValues, new HashMap<String, Object>());
    }

    @Override
    public CMStoreQueryResults addObject(int pid, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues, Map<String, Object> additionalParameters) throws CMException {
        return this.createObject(pid, name, objectClass, properties, propValues, additionalParameters);
    }

    @Override
    public CMStoreQueryResults addObject(int pid, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues, boolean checkNameUniqueness) throws CMException {
        return this.createObject(pid, -1, name, objectClass, properties, propValues, checkNameUniqueness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean objectInCognosNamespace(int obj_id) throws CMException {
        if (cognosNSId_ == -1) {
            CMStoreQueryResults qresults;
            block7: {
                String sCognosNSPath = "/directory//*[@id=':']";
                CMStoreXPath cognosNSPath = new CMStoreXPath(null, "/directory//*[@id=':']", false, 10);
                qresults = null;
                try {
                    qresults = this.executeQuery(cognosNSPath, null, null, 0, 512, null);
                    if (!qresults.next()) break block7;
                    cognosNSId_ = qresults.getObjectID();
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(qresults);
                    throw throwable;
                }
            }
            CMQueryUtils.safeQueryResultsRelease(qresults);
        }
        if (obj_id == cognosNSId_) {
            return true;
        }
        try {
            int[] ancestors = this.getCache().CMCacheGetAncestorObjects(obj_id);
            for (int i = 0; i < ancestors.length; ++i) {
                if (ancestors[i] != cognosNSId_) continue;
                return true;
            }
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cache exception");
        }
        return false;
    }

    @Override
    public CMPropertySets getPropertySets() {
        return CMDbStoreFactory.propertySets_;
    }

    public CMDbPropertySets getDbPropertySets() {
        return CMDbStoreFactory.propertySets_;
    }

    @Override
    public CMObjectClasses getObjectClasses() {
        return CMDbStoreFactory.objectClasses_;
    }

    @Override
    public int delete2(CMStoreQueryResults objects, boolean clearInvalidReferences, Integer maxObjsInTransaction) throws CMException {
        int numOfObjectsDeleted = 0;
        if (objects.getClass() == CMDbStoreCacheQueryResults.class) {
            CMDbStoreObjects theObjects = ((CMDbStoreCacheQueryResults)objects).getObjects();
            numOfObjectsDeleted = theObjects.delete2(clearInvalidReferences, maxObjsInTransaction);
        }
        return numOfObjectsDeleted;
    }

    @Override
    public int delete(CMStoreQueryResults objects, boolean clearInvalidReferences) throws CMException {
        return this.delete2(objects, clearInvalidReferences, null);
    }

    @Override
    public int delete(CMDbStoreObjects objects, boolean clearInvalidReferences) throws CMException {
        return this.delete2(objects, clearInvalidReferences, null);
    }

    @Override
    public int delete2(CMDbStoreObjects objects, boolean clearInvalidReferences, Integer maxObjsInTransaction) throws CMException {
        if (!this.inTransaction()) {
            throw new IllegalStateException("The delete operation must be called within a transaction");
        }
        int numOfObjectsDeleted = 0;
        CMCacheQueryInstance query2 = objects.getQuery();
        Statement delStmt = null;
        try {
            CMDbStoreIDReferencesUtil helper;
            int[] objectsToMove;
            NotificationBuilder builder;
            List<Notification> notificationsList;
            int[] objectIDs;
            int[] objectsToDelete = query2.resultObjects();
            if (objectsToDelete.length == 0) {
                int n = 0;
                return n;
            }
            int[] objIds = (int[])objectsToDelete.clone();
            int[] objectClasses = query2.resultClassIds();
            CMDbObjectClasses classes = CMDbStoreFactory.objectClasses_;
            int accountClassIdx = classes.getClassIndexByID(CMObjectClass.ACCOUNT.getID());
            int scheduleClassIdx = !SDSConnector.currentRequestIsFromSDS() ? classes.getClassIndexByID(CMObjectClass.SCHEDULE.getID()) : -1;
            int groupClassIdx = classes.getClassIndexByID(CMObjectClass.GROUP.getID());
            int roleClassIdx = classes.getClassIndexByID(CMObjectClass.ROLE.getID());
            int distributionListIdx = classes.getClassIndexByID(CMObjectClass.DISTRIBUTIONLIST.getID());
            int contactIdx = classes.getClassIndexByID(CMObjectClass.CONTACT.getID());
            int dispatcherClassIdx = classes.getClassIndexByID(CMObjectClass.DISPATCHER.getID());
            ArrayList<CMDbStoreNotification> notifications = null;
            CMIntList accountObjectIDs = new CMIntList();
            CMIntList groupsAndRolesIDs = new CMIntList();
            CMIntList scheduleObjectIDs = scheduleClassIdx != -1 ? new CMIntList() : null;
            CMIntList dispatcherObjectIDs = new CMIntList();
            CMDbConnection con = this.getConnection();
            this.lockBaseTable();
            String[] delQueries = CMDbStorePrepStmtCache.deletePropsStmts_;
            BitSet tableMask = new BitSet(delQueries.length);
            BitSet currentClasses = new BitSet(CMDbStoreFactory.objectClasses_.size());
            delStmt = con.createStatement();
            CMIntList allIds = new CMIntList(256);
            int numToDelete = objectsToDelete.length;
            CMCache cache = this.getCache();
            boolean firstPass = true;
            IntArray parents = new IntArray(objectsToDelete.length / 2);
            IntArray nextParents = new IntArray(objectsToDelete.length / 4);
            ArrayList<CMIntList> levelIds = new ArrayList<CMIntList>();
            do {
                int i;
                CMIntList currentIds = new CMIntList(256);
                if (firstPass) {
                    for (i = 0; i < objectsToDelete.length; ++i) {
                        int x;
                        int idx;
                        allIds.add(objectsToDelete[i]);
                        int classIdx = classes.getClassIndexByID(objectClasses[i]);
                        if (!currentClasses.get(classIdx)) {
                            currentClasses.set(classIdx);
                            tableMask.or(classes.get(classIdx).getTableMask());
                        }
                        if (classIdx == accountClassIdx) {
                            accountObjectIDs.add(objectsToDelete[i]);
                        } else if (classIdx == scheduleClassIdx) {
                            scheduleObjectIDs.add(objectsToDelete[i]);
                        } else if (classIdx == roleClassIdx || classIdx == groupClassIdx || classIdx == distributionListIdx || classIdx == contactIdx) {
                            groupsAndRolesIDs.add(objectsToDelete[i]);
                        } else if (classIdx == dispatcherClassIdx) {
                            dispatcherObjectIDs.add(objectsToDelete[i]);
                        }
                        if (!cache.CMCacheGetHasChildren(objectsToDelete[i])) {
                            currentIds.add(objectsToDelete[i]);
                            --numToDelete;
                        }
                        if ((idx = Arrays.binarySearch(objectsToDelete, x = query2.objectParent(i))) < 0) continue;
                        parents.add(idx);
                    }
                    firstPass = false;
                } else {
                    nextParents.size_ = 0;
                    for (i = 0; i < parents.size_; ++i) {
                        int parentId = query2.objectParent(parents.array_[i]);
                        int idx = Arrays.binarySearch(objectsToDelete, parentId);
                        if (idx < 0) continue;
                        nextParents.add(idx);
                    }
                    parents.subtract(nextParents);
                    for (i = 0; i < parents.size_; ++i) {
                        int idx = parents.array_[i];
                        currentIds.add(objectsToDelete[idx]);
                        --numToDelete;
                    }
                    IntArray tmp = nextParents;
                    nextParents = parents;
                    parents = tmp;
                }
                if (currentIds.size() <= 0) continue;
                levelIds.add(currentIds);
            } while (numToDelete > 0);
            if (scheduleObjectIDs != null && scheduleObjectIDs.size() > 0) {
                notifications = this.getDeletedScheduleNotifications(scheduleObjectIDs);
            }
            if (dispatcherObjectIDs.size() > 0) {
                objectIDs = dispatcherObjectIDs.toArray();
                CMDbStoreMultipleCMsUtil.getInstance().executeDeleteCapacityStatement(delStmt, objectIDs);
            }
            if (allIds.size() > 0) {
                objectIDs = allIds.toArray();
                numOfObjectsDeleted = CMDbStoreUtil.deleteFromTables(this.getConnection(), delQueries, tableMask, objectIDs, levelIds, maxObjsInTransaction, this.isRepositoryIntegrationInstalled());
            }
            if (dispatcherObjectIDs.size() > 0) {
                CMDbStoreMultipleCMsUtil.getInstance().makeUniqueDefaultContentManagerService(this.getConnection());
            }
            if (objIds != null && objectClasses != null && (notificationsList = (builder = this.module.newNotificationBuilder(this)).getNotifications(objIds, objectClasses, null, "delete", new HashMap<String, Object>())) != null && notificationsList.size() > 0) {
                this.addPostTransactionAction(this.module.newNotificationTA(notificationsList));
            }
            if ((objectsToMove = (helper = new CMDbStoreIDReferencesUtil()).findReferencedObjects(this, objectsToDelete, query2.getDistinctSelectedClasses())) != null) {
                if (!clearInvalidReferences) {
                    throw new CMException("cmFailedToDeleteReferencedObject", new CMException.Parm("cmids", Arrays.toString(objectsToMove)));
                }
                StubFolder.addObjects(this, objectsToMove);
                CMIntList objectsToDeleteNoRef = new CMIntList();
                for (int i = 0; i < objectsToDelete.length; ++i) {
                    boolean isReferenced = false;
                    for (int j = 0; j < objectsToMove.length; ++j) {
                        if (objectsToDelete[i] != objectsToMove[j]) continue;
                        isReferenced = true;
                        break;
                    }
                    if (isReferenced) continue;
                    objectsToDeleteNoRef.add(objectsToDelete[i]);
                }
                objectsToDelete = objectsToDeleteNoRef.toArray();
            }
            this.addTransactionAction(this.module.newCacheDeleteTA(this, objectsToDelete));
            if (notifications != null && notifications.size() > 0) {
                this.addTransactionAction(this.module.newLegacyNotificationTA(notifications));
            }
            CMDbStoreUtil.safeCloseStatement(delStmt);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(this.getConnection(), ex, "cmStoreUnexpectedErrDeleteObjs");
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedErrDeleteObjs");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(delStmt);
        }
        return numOfObjectsDeleted;
    }

    @Override
    public void update(CMStoreQueryResults objects, List<CMProperty> properties, List<Object> values) throws CMException {
        CMDbStoreObjects theObjects = ((CMDbStoreCacheQueryResults)objects).getObjects();
        theObjects.update(properties, values, new HashMap<String, Object>());
    }

    @Override
    public void update(CMStoreQueryResults objects, List<CMProperty> properties, List<Object> values, Map<String, Object> additionalParameters) throws CMException {
        CMDbStoreObjects theObjects = ((CMDbStoreCacheQueryResults)objects).getObjects();
        theObjects.update(properties, values, additionalParameters);
    }

    @Override
    public CMStoreQueryResults move(CMStoreQueryResults objects, int parent_objid, String sNewFileName) throws CMException {
        CMStoreQueryResults results = null;
        CMDbStoreObjects theObjects = ((CMDbStoreCacheQueryResults)objects).getObjects();
        results = theObjects.move(parent_objid, sNewFileName);
        return results;
    }

    @Override
    public CMStoreQueryResults copy(CMStoreQueryResults objects, int objectCount, int parent_objid, String sNewFileName, boolean bRecursive, CMIntList sourceIds, CMIntList targetIds, CMIntList correctOwnerIds, TenantIdCopyAction copyAction) throws CMException {
        return this.copy(objects, objectCount, parent_objid, sNewFileName, bRecursive, true, sourceIds, targetIds, correctOwnerIds, copyAction);
    }

    public CMStoreQueryResults copy(CMStoreQueryResults objects, int objectCount, int parent_objid, String sNewFileName, boolean bRecursive, boolean checkNameUniqueness, CMIntList sourceIds, CMIntList targetIds, CMIntList correctOwnerIds, TenantIdCopyAction copyAction) throws CMException {
        return this.copy(objects, objectCount, parent_objid, sNewFileName, bRecursive, checkNameUniqueness, sourceIds, targetIds, correctOwnerIds, false, copyAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMStoreQueryResults copy(CMStoreQueryResults objects, int objectCount, int parent_objid, String sNewFileName, boolean bRecursive, boolean checkNameUniqueness, CMIntList sourceIds, CMIntList targetIds, CMIntList correctOwnerIds, boolean copyUserLocaleNameOnly, TenantIdCopyAction copyAction) throws CMException {
        int iCopied = 0;
        int[] copiedObjects = null;
        try {
            if (!this.inTransaction()) {
                throw new IllegalStateException("The copy operation must be called within a transaction");
            }
            copiedObjects = new int[objectCount];
            if (!objects.next()) {
                CMStoreQueryResults cMStoreQueryResults = null;
                return cMStoreQueryResults;
            }
            CMDbStoreLocalizedStringArray names = null;
            if (sNewFileName != null && sNewFileName.length() > 0) {
                CMStringLocale userLocale = CMExecutionContext.get().getCurrentUserContentLocale();
                names = this.getLocalizedStringArray(userLocale, sNewFileName);
                copyUserLocaleNameOnly = false;
            }
            do {
                CMLocalizedStringArray srcName;
                CMObjectClass srcObjectClass = objects.getObjectClass();
                CMObjectClass targetObjectClass = this.getObjectClasses().getClassByID(this.getCache().CMCacheGetClass(parent_objid));
                int sourceId = objects.getObjectID();
                int parentTenantId = this.getCache().CMCacheGetTenantID(parent_objid);
                int sourceTenantId = objects.getTenantID();
                int targetTenantIDInt = copyAction.getTenantIdValue(parentTenantId, sourceTenantId);
                int targetId = -1;
                if (targetObjectClass.isMaxOccursPerTenant(srcObjectClass)) {
                    srcName = this.getAllObjectNames(sourceId);
                    String suffix = this.tenantRegistry.getTenantIdStringFromInt(targetTenantIDInt);
                    int count = 0;
                    boolean unique = false;
                    while (!unique) {
                        names = this.createUniqueTargetNameForAllLocales(srcName, suffix + (count == 0 ? "" : String.valueOf(count)));
                        ++count;
                        try {
                            targetId = this.createCopyObject(sourceId, null, parent_objid, names, checkNameUniqueness, targetTenantIDInt);
                            unique = true;
                        }
                        catch (CMStoreDuplicateObject cMStoreDuplicateObject) {}
                    }
                } else {
                    srcName = null;
                    if (copyUserLocaleNameOnly) {
                        srcName = (CMLocalizedStringArray)objects.getValue(0);
                        names = this.getLocalizedStringArray(srcName);
                    }
                    targetId = this.createCopyObject(sourceId, srcName, parent_objid, names, checkNameUniqueness, targetTenantIDInt);
                }
                copiedObjects[iCopied] = targetId;
                ++iCopied;
                sourceIds.add(sourceId);
                targetIds.add(targetId);
                correctOwnerIds.add(targetId);
                this.copyEOSDataIfRequired(sourceId, srcObjectClass, targetId);
                if (names != null) {
                    ArrayList<String> namesForCache = new ArrayList<String>();
                    ArrayList<Integer> localesForCache = new ArrayList<Integer>();
                    int strCount = names.getSize();
                    for (int strIdx = 0; strIdx != strCount; ++strIdx) {
                        CMDbStoreLocalizedString str = (CMDbStoreLocalizedString)names.get(strIdx);
                        namesForCache.add(str.getValue());
                        localesForCache.add(new Integer(str.getLocaleIDForCache()));
                    }
                    this.getCache().CMCacheSetAllNames(copiedObjects[iCopied - 1], namesForCache, localesForCache);
                }
                if (!bRecursive) continue;
                this.copyChildObjects(objects.getSearchPath(), copiedObjects[iCopied - 1], checkNameUniqueness, sourceIds, targetIds, correctOwnerIds, copyAction);
            } while (objects.next() && iCopied < objectCount);
            objects.reset();
            CMDbStoreAddResults cMDbStoreAddResults = new CMDbStoreAddResults(this, copiedObjects);
            return cMDbStoreAddResults;
        }
        finally {
            if (iCopied > 0) {
                this.addTransactionAction(new CMDbStoreCopyCacheObjects(this, objects, copiedObjects, parent_objid));
                this.addNotificationsForCopy(copiedObjects, parent_objid);
            } else if (objects != null) {
                objects.release();
            }
        }
    }

    private CMDbStoreLocalizedStringArray getLocalizedStringArray(CMStringLocale locale, String name) {
        CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
        names.add(new CMDbStoreLocalizedString(locale, name));
        names.computeDefaults();
        return names;
    }

    private CMDbStoreLocalizedStringArray getLocalizedStringArray(CMLocalizedStringArray srcName) {
        CMStringLocale locale = CMExecutionContext.get().getCurrentUserContentLocale();
        CMLocalizedString name = srcName.get(locale);
        if (name == null && (name = srcName.get(locale = locale.getMappedLocale())) == null) {
            return null;
        }
        return this.getLocalizedStringArray(locale, name.getValue());
    }

    private CMDbStoreLocalizedStringArray createUniqueTargetNameForAllLocales(CMLocalizedStringArray srcName, String uniqueSuffix) {
        CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
        for (int i = 0; i < srcName.getSize(); ++i) {
            CMLocalizedString name = (CMLocalizedString)srcName.getItem(i);
            StringBuilder newNameBuilder = new StringBuilder(name.getValue()).append(" - ").append(uniqueSuffix);
            String newName = CMStringUtils.normalizeApostropheAndQuote(newNameBuilder.toString());
            names.add(new CMDbStoreLocalizedString(name.getLocale(), newName));
        }
        names.computeDefaults();
        return names;
    }

    private void copyEOSDataIfRequired(int sourceId, CMObjectClass srcObjectClass, int targetId) throws CMException {
        try {
            if (srcObjectClass.hasProperty(CMPropertyMeaning.DATAPATHINFO) && ConfigurationFactory.getConfig().isExternalObjectStoreEnabled()) {
                String origStoreID = this.getCache().getInternalStoreId(sourceId).toString();
                RepositoryConnection repository_conn = ExternalObjectStoreConnectionProvider.getInstance().getRepositoryConnection();
                if (repository_conn.objectExists(origStoreID)) {
                    String targetStoreID = this.getCache().getInternalStoreId(targetId).toString();
                    repository_conn.copyData(origStoreID, targetStoreID);
                }
            }
        }
        catch (RepositoryException e) {
            throw new CMException((Exception)((Object)e));
        }
    }

    public void copyChildObjects(String srcPath, int destID, boolean checkNameUniqueness, CMIntList sourceIds, CMIntList targetIds, CMIntList correctOwnerIds, TenantIdCopyAction copyAction) throws CMException {
        CMStoreQueryResults resultsSrc = null;
        CMStoreXPath childQuery = null;
        try {
            childQuery = new CMStoreXPath(srcPath + "/*", 16);
        }
        catch (CMStoreParseException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedNoCopyChildrenBadPath");
        }
        CMProperty[] srcprops = new CMProperty[]{CMProperty.DEFAULTNAME, CMProperty.OBJECTCLASS};
        int objectCount = 0;
        try {
            resultsSrc = this.executeQuery(childQuery, srcprops, null, 3, 1024, null);
            while (resultsSrc.next()) {
                CMObjectClass objectClass = (CMObjectClass)resultsSrc.getValue(1);
                int srcObjectID = resultsSrc.getObjectID();
                if (objectClass != null && (objectClass.isExternal() && !this.objectInCognosNamespace(srcObjectID) || objectClass == CMObjectClass.SCHEDULE || objectClass == CMObjectClass.HISTORY)) {
                    resultsSrc.exclude();
                    continue;
                }
                ++objectCount;
            }
            resultsSrc.reset();
            this.copy(resultsSrc, objectCount, destID, null, true, checkNameUniqueness, sourceIds, targetIds, correctOwnerIds, copyAction);
        }
        catch (CMStoreObjectNotFound objectClass) {
        }
        catch (CMException e) {
            if (resultsSrc != null) {
                resultsSrc.release();
            }
            throw e;
        }
    }

    @Override
    public CMStoreQueryResults move(CMCacheQueryInstance query2, int parent_objid, String sNewFileName) throws CMException {
        if (!this.inTransaction()) {
            throw new IllegalStateException("The move operation must be called within a transaction");
        }
        CMExecutionContext.checkCancelOrTimeOut();
        try {
            int[] objectsToMove = query2.resultObjects();
            CMDbStoreArrayTableUpdateDef updateNames = null;
            CMDbStoreLocalizedStringArray names = null;
            if (sNewFileName != null && sNewFileName.trim().length() > 0) {
                if (objectsToMove.length > 1) {
                    throw new CMStoreDuplicateObject();
                }
                names = new CMDbStoreLocalizedStringArray();
                String userLocale = CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE);
                names.add(new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(userLocale), sNewFileName));
                names.computeDefaults();
                updateNames = new CMDbStoreArrayTableUpdateDef("CMOBJNAMES");
                updateNames.addColumn((CMDbProperty)CMProperty.NAME, names);
            }
            for (int i = 0; i < objectsToMove.length; ++i) {
                if (!this.getCache().CMCacheIsChild(parent_objid, objectsToMove[i])) continue;
                throw new CMStoreUnexpected(null, "cmStoreUnexpectedBadSelMovedChild");
            }
            boolean checkNameUniqueness = true;
            CMDbStoreBaseTableUpdateDef updateDef = new CMDbStoreBaseTableUpdateDef(false);
            updateDef.execute(this.getConnection(), "PCMID = " + parent_objid, objectsToMove);
            if (updateNames != null) {
                ((CMDbStoreUpdateDef)updateNames).execute(this.getConnection(), objectsToMove);
            }
            NameUniqueness.check(this, objectsToMove, parent_objid);
            this.addTransactionAction(new CMDbStoreMoveCacheObjects(this, objectsToMove, parent_objid, names));
            this.addNotificationsForMove(objectsToMove, query2.resultClassIds(), parent_objid);
            return new CMDbStoreAddResults(this, objectsToMove);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLExceptionForNewObject(this.getConnection(), ex, "cmStoreUnexpectedNoMove", false, -1, null, null);
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedNoMove");
        }
        return null;
    }

    private void addNotificationsForCopy(int[] copiedObjects, int parentCMID) throws CMException {
        int[] objs = ArrayUtils.appendToArray(copiedObjects, parentCMID);
        int[] cls = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            cls[i] = this.getCache().CMCacheGetClass(objs[i]);
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        additionalParameters.put("copiedObjects", copiedObjects);
        NotificationBuilder builder = this.module.newNotificationBuilder(this);
        this.addPostTransactionAction(new DelayedNotificationTA(builder, objs, cls, "copy", additionalParameters));
    }

    private void addNotificationsForMove(int[] objectsToMove, int[] classes, int newParentCMID) throws CMException {
        int[] objs = ArrayUtils.appendToArray(objectsToMove, newParentCMID);
        int[] oldParents = this.getParents(objectsToMove);
        objs = ArrayUtils.appendToArray(objs, oldParents);
        int[] cls = ArrayUtils.appendToArray(classes, this.getCache().CMCacheGetClass(newParentCMID));
        int[] oldParentClasses = this.getClasses(oldParents);
        cls = ArrayUtils.appendToArray(cls, oldParentClasses);
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        additionalParameters.put("movedObjects", objectsToMove);
        NotificationBuilder builder = this.module.newNotificationBuilder(this);
        this.addPostTransactionAction(new DelayedNotificationTA(builder, objs, cls, "move", additionalParameters));
    }

    private int[] getClasses(int[] objects) throws CMCacheException {
        int[] classes = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = this.getCache().CMCacheGetClass(objects[i]);
        }
        return classes;
    }

    private int[] getParents(int[] objects) {
        int[] parents = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            parents[i] = this.getCache().CMCacheGetParent(objects[i]);
        }
        return parents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(CMDbStoreObjects objects, List<CMProperty> props, List<Object> values, Map<String, Object> additionalParameters) throws CMException {
        int[] classIds;
        int[] objectIds;
        if (!this.inTransaction()) {
            throw new IllegalStateException("The update operation must be called within a transaction");
        }
        CMCacheQueryInstance query2 = objects.getQuery();
        boolean updatedModifiedTime = false;
        int numDbProps = 0;
        CMDbStoreDMLDef[] updateDefs = new CMDbStoreUpdateDef[75];
        int numUpdates = 1;
        ArrayList<Object> streamProps = null;
        boolean updatingOwner = false;
        Object ownerValue = null;
        CMDbProperty burstProperty = null;
        int burstPropCounter = 0;
        updateDefs[0] = new CMDbStoreBaseTableUpdateDef(true);
        Timestamp modificationTime = null;
        boolean updatingCapacity = false;
        Object capacityObject = null;
        boolean updatingDefaultActiveCM = false;
        Object defaultActiveCMObject = null;
        boolean updatingDispatcherPath = false;
        Object dispatcherPathObject = null;
        ArrayList<String> oldDispatcherPaths = null;
        boolean updatingDefaultName = false;
        boolean updatingName = false;
        String newDefaultName = null;
        CMDbStoreLocalizedStringArray newName = null;
        boolean checkNameUniqueness = false;
        String newStoreId = null;
        boolean settingArchivingTriggerProp = false;
        CMExecutionContext.checkCancelOrTimeOut();
        for (int i = 0; i < props.size(); ++i) {
            int k;
            String table;
            CMDbProperty prop = (CMDbProperty)props.get(i);
            if (prop == null) continue;
            if (prop == CMProperty.MODIFICATIONTIME) {
                Date date = DateUtils.parse((String)values.get(i).toString());
                boolean isDerby = CMDbConnection.dbms_ == 5;
                modificationTime = CMDateUtils.getTimestamp(date, isDerby);
                updatedModifiedTime = true;
                continue;
            }
            if (prop == CMProperty.CAPACITY) {
                capacityObject = values.get(i);
                if (capacityObject != null) {
                    updatingCapacity = true;
                }
            } else if (prop == CMProperty.STARTASACTIVE) {
                defaultActiveCMObject = values.get(i);
                if (defaultActiveCMObject != null) {
                    updatingDefaultActiveCM = true;
                }
            } else if (prop == CMProperty.DISPATCHERPATH) {
                dispatcherPathObject = values.get(i);
                if (dispatcherPathObject != null) {
                    updatingDispatcherPath = true;
                }
            } else if (prop == CMProperty.STOREID) {
                newStoreId = (String)values.get(i);
                if (!this.reserveStoreId(newStoreId, query2)) {
                    newStoreId = null;
                    continue;
                }
            } else if (prop == CMProperty._ARCHIVESTATUS && values.get(i) == null) {
                values.set(i, ArchivingUtil.getArchiveStatusForDatabaseDefault());
            }
            if (this.isRepositoryIntegrationInstalled() && !settingArchivingTriggerProp) {
                settingArchivingTriggerProp = this.settingArchivingTriggerProperty(prop, values.get(i));
            }
            if (!updatedModifiedTime && prop.affectsModificationTime()) {
                boolean isDerby = CMDbConnection.dbms_ == 5;
                modificationTime = CMDateUtils.getTimestamp(isDerby);
                updatedModifiedTime = true;
            }
            if (prop.columnCount() <= 0) continue;
            Object value = values.get(i);
            ArrayList<? extends CMProperty> subpropertiesAndSelf = prop.getSubpropertiesAndSelf();
            for (int subpropertyIdx = 0; subpropertyIdx < subpropertiesAndSelf.size(); ++subpropertyIdx) {
                int j;
                CMDbProperty currentProperty = (CMDbProperty)subpropertiesAndSelf.get(subpropertyIdx);
                if (currentProperty.columnCount() <= 0) continue;
                table = currentProperty.getColumn(0).getTable();
                ++numDbProps;
                for (j = 0; j < numUpdates && !updateDefs[j].getTableName().equalsIgnoreCase(table); ++j) {
                }
                if (currentProperty.isMultilingualRelated() && updateDefs[j] != null && (currentProperty.isStoredAsArray() && updateDefs[j].getClass() != CMDbStoreMultipleLocalizedStringTableUpdateDef.class || !currentProperty.isStoredAsArray() && updateDefs[j].getClass() != CMDbStoreDefaultLocalizedStringTableUpdateDef.class)) {
                    j = numUpdates;
                }
                if (updateDefs[j] == null) {
                    updateDefs[j] = currentProperty.isStoredAsArray() ? (currentProperty.isMultilingualRelated() ? (CMDbConnection.dbms_ != 3 ? new CMDbStoreMultipleLocalizedStringTableUpdateDef(table) : new CMDbStoreMultipleLocalizedStringTableBatchUpdate(table)) : new CMDbStoreArrayTableUpdateDef(table)) : (table.equals("CMOBJNAMES") || table.equals("cmobjectnames") ? new CMDbStoreDefaultNamesTableUpdateDef(table) : (CMDbProperty.isExternalizablePropTable(table) ? new CMDbStoreExternalDataUpdateDef(table, objects.getObjectID()) : (currentProperty.isMultilingualRelated() ? new CMDbStoreDefaultLocalizedStringTableUpdateDef(table) : new CMDbStoreUpdateDef(table))));
                    ++numUpdates;
                }
                if (currentProperty.isStoredAsArray() && value instanceof CMLocalizedStringArray) {
                    CMDbStoreLocalizedStringArray strValues = (CMDbStoreLocalizedStringArray)value;
                    strValues.computeDefaults();
                }
                if (currentProperty == CMProperty.OWNER) {
                    updatingOwner = true;
                    ownerValue = value;
                } else if (currentProperty == CMProperty.RECIPIENTS || prop == CMProperty.RECIPIENTSEMAIL) {
                    burstProperty = currentProperty;
                    burstPropCounter = (short)(burstPropCounter + (value != null ? 1 : -1));
                }
                if (value instanceof RequestAttachment) {
                    RequestAttachment attachment = (RequestAttachment)value;
                    try {
                        value = attachment.getTempInputStream();
                    }
                    catch (Exception ex) {
                        throw new CMException(ex, "Error getting stream for temp file");
                    }
                    if (streamProps == null) {
                        streamProps = new ArrayList<Object>();
                    }
                    streamProps.add(value);
                }
                updateDefs[j].addColumn(currentProperty, value);
                if (!currentProperty.hasMeaning(CMPropertyMeaning.DATA)) continue;
                this.generateDataPathInfoIfRequired(objects.getObjectClass(), objects.getStoreID(), updateDefs);
            }
            if (prop == CMProperty.DEFAULTNAME) {
                updatingDefaultName = true;
                checkNameUniqueness = true;
                newDefaultName = (String)value;
            } else if (prop == CMProperty.NAME) {
                checkNameUniqueness = true;
                if (value instanceof CMDbStoreLocalizedStringArray) {
                    updatingName = true;
                    newName = (CMDbStoreLocalizedStringArray)value;
                }
            }
            if (prop.getIndexProperty() == null) continue;
            CMDbProperty indexProp = (CMDbProperty)prop.getIndexProperty();
            table = indexProp.getColumn(0).getTable();
            ++numDbProps;
            for (k = 0; k < numUpdates && !updateDefs[k].getTableName().equalsIgnoreCase(table); ++k) {
            }
            if (updateDefs[k] == null) {
                updateDefs[k] = new CMDbStoreUpdateDef(table);
                ++numUpdates;
            }
            updateDefs[k].addColumn(indexProp, CMDbStoreUtil.getIndexValue(value));
        }
        if (modificationTime != null) {
            updateDefs[0].addColumn((CMDbProperty)CMProperty.MODIFICATIONTIME, modificationTime);
            ++numDbProps;
        }
        if (numDbProps == 0) {
            return;
        }
        if (this.isRepositoryIntegrationInstalled() && !ArchivingUtil.archivingIsDisabled(additionalParameters)) {
            if (settingArchivingTriggerProp) {
                numUpdates += this.addDMLDefForProperty((CMDbProperty)CMProperty._ARCHIVESTATUS, ArchivingUtil.getArchiveStatusForUpdate(), updateDefs);
            } else {
                additionalParameters = ArchivingUtil.setNotificationParameterForArchivingTriggerPropNotSet(additionalParameters);
            }
        }
        int[] outputToSetOwner = null;
        int[] outputToDeleteOwner = null;
        int[] outputToCopyOwner = null;
        try {
            objectIds = query2.resultObjects();
            classIds = query2.resultClassIds();
            if (burstProperty != null) {
                if (burstPropCounter == -2) {
                    outputToDeleteOwner = CMDbStoreUtil.getBurstOutputObjects(this, query2);
                } else if (burstPropCounter == -1) {
                    if (updatingOwner && ownerValue == null) {
                        outputToSetOwner = CMDbStoreUtil.getBurstOutputObjects(this, query2);
                    } else {
                        outputToDeleteOwner = CMDbStoreUtil.getBurstOutputObjects(this, query2, burstProperty == CMProperty.RECIPIENTS);
                        if (updatingOwner) {
                            outputToSetOwner = CMDbStoreUtil.getBurstOutputObjects(this, query2, burstProperty != CMProperty.RECIPIENTS);
                        }
                    }
                } else if (updatingOwner) {
                    outputToSetOwner = CMDbStoreUtil.getOutputObjects(this, query2);
                } else {
                    outputToCopyOwner = CMDbStoreUtil.getNonBurstOutputObjects(this, query2);
                }
            } else if (updatingOwner && (outputToSetOwner = CMDbStoreUtil.getBurstOutputObjects(this, query2)) != null && outputToSetOwner.length == 0) {
                outputToSetOwner = null;
            }
            if (updatingDispatcherPath) {
                oldDispatcherPaths = this.getDispatcherPaths(objectIds);
            }
        }
        catch (Exception e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedErrUpdateCache");
        }
        CMIntList renameObjIds = new CMIntList();
        if (updatingDefaultName || updatingName) {
            for (int m = 0; m < objectIds.length; ++m) {
                CMDbStoreLocalizedStringArray currName;
                if (updatingDefaultName) {
                    String currDefName = this.getObjectName(objectIds[m]);
                    if (currDefName.equals(newDefaultName)) continue;
                    renameObjIds.add(objectIds[m]);
                    continue;
                }
                if (!updatingName || (currName = this.getAllObjectNames(objectIds[m])).isIdenticalTo(newName)) continue;
                renameObjIds.add(objectIds[m]);
            }
        }
        try {
            CMDbStoreArrayTableUpdateDef updateDef;
            CMExecutionContext.checkCancelOrTimeOut();
            this.sortUpdateDefs(updateDefs);
            this.lockBaseTable();
            for (int k = 0; k < numUpdates; ++k) {
                if (this.isRepositoryIntegrationInstalled() && settingArchivingTriggerProp) {
                    CMDbStoreUtil.verifyObjectsCanBeModified(updateDefs[k].getTableName(), objectIds, this.getConnection());
                }
                if (updatingDefaultName && updateDefs[k] instanceof CMDbStoreDefaultNamesTableUpdateDef && updateDefs[k].getTableName().equalsIgnoreCase("CMOBJNAMES") || updatingName && updateDefs[k] instanceof CMDbStoreArrayTableUpdateDef && updateDefs[k].getTableName().equalsIgnoreCase("CMOBJNAMES")) {
                    if (renameObjIds.size() <= 0) continue;
                    ((CMDbStoreUpdateDef)updateDefs[k]).execute(this.getConnection(), renameObjIds.toArray());
                    continue;
                }
                ((CMDbStoreUpdateDef)updateDefs[k]).execute(this.getConnection(), objectIds);
            }
            if (checkNameUniqueness) {
                if ((updatingDefaultName || updatingName) && renameObjIds.size() > 0) {
                    NameUniqueness.check(this, renameObjIds.toArray());
                } else if (!updatingDefaultName && !updatingName) {
                    NameUniqueness.check(this, objectIds);
                }
            }
            if (outputToSetOwner != null) {
                CMDbProperty recipProp = (CMDbProperty)CMProperty._OTHERRECIPIENTS;
                updateDef = new CMDbStoreArrayTableUpdateDef(recipProp.getColumn(0).getTable());
                updateDef.addColumn(recipProp, ownerValue);
                updateDef.execute(this.getConnection(), outputToSetOwner);
            }
            if (outputToDeleteOwner != null && outputToDeleteOwner.length > 0) {
                CMDbProperty recipProp = (CMDbProperty)CMProperty._OTHERRECIPIENTS;
                updateDef = new CMDbStoreArrayTableUpdateDef(recipProp.getColumn(0).getTable());
                updateDef.addColumn(recipProp, null);
                updateDef.execute(this.getConnection(), outputToDeleteOwner);
            }
            if (outputToCopyOwner != null && outputToCopyOwner.length > 0) {
                CMDbProperty recipProp = (CMDbProperty)CMProperty._OTHERRECIPIENTS;
                CMDbProperty ownerProperty = (CMDbProperty)CMProperty.OWNER;
                CMDbStoreCopyOwnerToRecipsDef updateDef2 = new CMDbStoreCopyOwnerToRecipsDef(recipProp, ownerProperty);
                CMExecutionContext.checkCancelOrTimeOut();
                ((CMDbStoreArrayTableUpdateDef)updateDef2).execute(this.getConnection(), outputToCopyOwner);
            }
            if (updatingCapacity && capacityObject != null) {
                Double capacity = new Double(capacityObject.toString());
                this.updatedCapacityProperty(objectIds, capacity);
            }
            if (updatingDefaultActiveCM && defaultActiveCMObject != null) {
                this.updatedDefaultActiveCMProperty(objectIds);
            }
            if (updatingDispatcherPath && oldDispatcherPaths != null) {
                this.updatedDispatcherPathProperty(oldDispatcherPaths, dispatcherPathObject);
            }
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLExceptionForNewObject(this.getConnection(), ex, "cmStoreUnexpectedObjUpdateFailed", false, -1, null, null);
        }
        finally {
            NotificationBuilder builder;
            List<Notification> notifications;
            UpdateCacheVersionNumbersTransactionAction action = new UpdateCacheVersionNumbersTransactionAction(this.getCache(), objectIds);
            this.addTransactionAction(action);
            this.addTransactionAction(new CMDbStoreTAUpdateCache(this, objectIds, props, values, newStoreId));
            if (streamProps != null) {
                for (int streamIdx = 0; streamIdx < streamProps.size(); ++streamIdx) {
                    Object x = streamProps.get(streamIdx);
                    try {
                        ((InputStream)x).close();
                        continue;
                    }
                    catch (Exception notification) {}
                }
            }
            if (objectIds != null && classIds != null) {
                ArrayList<CMDbStoreNotification> notifications2 = new ArrayList<CMDbStoreNotification>();
                for (int j = 0; j < objectIds.length; ++j) {
                    if (!CMDbStoreNotificationObservers.notifyObject(classIds[j])) continue;
                    CMDbStoreNotification notification = new CMDbStoreNotification(this.getObjectStoreID(objectIds[j]), this.getObjectClasses().getClassByID(classIds[j]), 7);
                    notifications2.add(notification);
                }
                if (!notifications2.isEmpty()) {
                    this.addTransactionAction(this.module.newLegacyNotificationTA(notifications2));
                }
            }
            if (objectIds != null && classIds != null && (notifications = (builder = this.module.newNotificationBuilder(this)).getNotifications(objectIds, classIds, props, "update", additionalParameters)) != null && notifications.size() > 0) {
                this.addPostTransactionAction(new NotificationTA(notifications));
            }
        }
    }

    protected boolean settingArchivingTriggerProperty(CMDbProperty prop, Object value) {
        return prop.isArchivingTrigger() && value != null;
    }

    @Override
    public void release() {
        try {
            try {
                if (this.inTransaction()) {
                    this.rollbackTransaction();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (this.connection_ != null) {
                CMDbStoreFactory.releaseConnection(this.connection_);
                this.connection_ = null;
            }
            if (this.cache_ != null) {
                this.cache_ = null;
            }
        }
    }

    @Override
    public void copyUserAccountTemplate(String sCamID, List<CMObjectClass> objClss) throws CMException {
        this.copyUserAccountTemplate(sCamID, objClss, true);
    }

    public void copyUserAccountTemplate(String sCamID, List<CMObjectClass> objClss, boolean checkNameUniqueness) throws CMException {
        this.copyUserAccountTemplate(sCamID, objClss, checkNameUniqueness, 0);
    }

    public void copyUserAccountTemplate(String sCamID, List<CMObjectClass> objClss, boolean checkNameUniqueness, int tenantID) throws CMException {
        if (!this.copyTenantAccountTemplate(sCamID, objClss, checkNameUniqueness, tenantID) && tenantID != 0) {
            this.copyTenantAccountTemplate(sCamID, objClss, checkNameUniqueness, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyTenantAccountTemplate(String sCamID, List<CMObjectClass> objClss, boolean checkNameUniqueness, int tenantID) throws CMException {
        boolean tenantTemplateExist;
        block26: {
            String tenantIDStr;
            tenantTemplateExist = true;
            if (tenantID < 0) {
                tenantIDStr = "";
                tenantID = 0;
            } else {
                tenantIDStr = this.getTenantRegistry().getTenantIdStringFromInt(tenantID);
            }
            StringBuffer sTemplateSrcPath = new StringBuffer("/configuration/account[@tenantID='" + CMStoreXPath.attributeEncodeString(tenantIDStr) + "']" + "/" + "*");
            if (objClss != null && objClss.size() > 0) {
                sTemplateSrcPath.append("[@objectClass='" + objClss.get(0).getName());
                sTemplateSrcPath.append('\'');
                for (int i = 1; i < objClss.size(); ++i) {
                    sTemplateSrcPath.append(" or @objectClass='" + objClss.get(i).getName());
                    sTemplateSrcPath.append('\'');
                }
                sTemplateSrcPath.append(']');
            }
            CMStoreXPath templateSrcPath = new CMStoreXPath(sTemplateSrcPath.toString(), 16);
            templateSrcPath.setLocksHaveBeenObtained();
            String sUserAccountPath = "/directory//*[@id='" + CMStoreXPath.attributeEncodeString(sCamID, '\'') + "']";
            CMStoreXPath userAccountPath = new CMStoreXPath(null, sUserAccountPath, false, 17);
            userAccountPath.setLocksHaveBeenObtained();
            CMStoreQueryResults qresults = null;
            CMStoreQueryResults templateSrcQry = null;
            CMStoreQueryResults copyResults = null;
            boolean bTransactionExecuted = false;
            try {
                this.beginTransaction();
                qresults = this.executeQuery(userAccountPath, null, null, 5, 512, null);
                if (qresults.next()) {
                    CMProperty[] props = null;
                    boolean copyUserLocaleNameOnly = AdvancedSettings.LIMIT_ACCOUNT_TEMPLATE_NAMES;
                    if (copyUserLocaleNameOnly) {
                        props = new CMProperty[]{CMProperty.NAME};
                    }
                    templateSrcQry = this.executeQuery(templateSrcPath, props, null, 3, 512, null);
                    int objectCount = 0;
                    while (templateSrcQry.next()) {
                        ++objectCount;
                    }
                    templateSrcQry.reset();
                    if (objectCount == 0) {
                        tenantTemplateExist = false;
                    } else {
                        copyResults = this.copy(templateSrcQry, objectCount, qresults.getObjectID(), null, true, checkNameUniqueness, new CMIntList(1), new CMIntList(1), new CMIntList(1), copyUserLocaleNameOnly, TenantIdCopyAction.setFallBackVirtualInheritance(tenantID));
                        bTransactionExecuted = true;
                        this.commitTransaction();
                        if (objClss == null || objClss.contains(CMObjectClass.FOLDER)) {
                            this.copyAccountPortalPages(templateSrcPath.getParent(), userAccountPath);
                        }
                    }
                    break block26;
                }
                if (CMIndicationGlobals.bDebugLogEnabled) {
                    CMIndications.CMDebugTrace("Unable to copy user account template: " + sCamID);
                }
                throw new CMException("cmSearchErrCreateProxy", new CMException.Parm("Account", sCamID));
            }
            catch (CMStoreDuplicateObject cMStoreDuplicateObject) {
            }
            finally {
                if (this.inTransaction()) {
                    try {
                        this.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
                if (qresults != null) {
                    qresults.release();
                }
                if (templateSrcQry != null && !bTransactionExecuted) {
                    templateSrcQry.release();
                }
                if (copyResults != null) {
                    copyResults.release();
                }
                this.getLockManager().releaseLocks();
            }
        }
        return tenantTemplateExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAccountPortalPages(CMStorePath srcAccountPath, CMStorePath destAccountPath) throws CMException {
        this.beginTransaction();
        CMStoreQueryResults accountSrcQuery = null;
        CMStoreQueryResults accountDestQuery = null;
        try {
            accountSrcQuery = this.executeQuery(srcAccountPath, new CMProperty[]{CMProperty.PORTALPAGES}, null, 0, 512, null);
            if (accountSrcQuery == null || !accountSrcQuery.next()) {
                return;
            }
            CMDbStoreBaseClassArray updatedPortalPages = new CMDbStoreBaseClassArray();
            CMDbStoreBaseClassArray portalPages = (CMDbStoreBaseClassArray)accountSrcQuery.getValue(0);
            if (portalPages != null) {
                for (int i = 0; i < portalPages.getSize(); ++i) {
                    CMDbStoreObjectReference ref = (CMDbStoreObjectReference)portalPages.getItem(i);
                    String searchPath = ref.getSearchPath();
                    if (searchPath.startsWith("/configuration/account") || searchPath.startsWith("CAMID(")) {
                        CMStoreXPath path = new CMStoreXPath(searchPath);
                        String portalPageSearchPath = null;
                        if (searchPath.startsWith("/configuration/account") && path.size() > 2) {
                            portalPageSearchPath = destAccountPath.toString() + path.getDescendantSubpath(2);
                        } else if (searchPath.startsWith("CAMID(") && path.size() > 1) {
                            portalPageSearchPath = destAccountPath.toString() + path.getDescendantSubpath(1);
                        }
                        if (portalPageSearchPath == null) continue;
                        CMStoreQueryResults refResults = null;
                        try {
                            refResults = this.executeQuery(new CMStoreXPath(portalPageSearchPath), null, null, 0, 512, null);
                            if (refResults == null || !refResults.next()) continue;
                            updatedPortalPages.add(new CMDbStoreObjectReference(refResults.getObjectID(), refResults.getObjectClass(), null));
                            continue;
                        }
                        finally {
                            if (refResults != null) {
                                refResults.release();
                            }
                        }
                    }
                    updatedPortalPages.add(ref);
                }
            }
            ArrayList<CMProperty> updateProps = new ArrayList<CMProperty>(1);
            ArrayList<Object> updateValues = new ArrayList<Object>(1);
            updateProps.add(CMProperty.PORTALPAGES);
            updateValues.add(updatedPortalPages);
            accountDestQuery = this.executeQuery(destAccountPath, null, null, 7, 512, null);
            if (accountDestQuery.next()) {
                this.update(accountDestQuery, updateProps, updateValues, new HashMap<String, Object>());
            }
            this.commitTransaction();
        }
        finally {
            if (accountSrcQuery != null) {
                accountSrcQuery.release();
            }
            if (accountDestQuery != null) {
                accountDestQuery.release();
            }
            if (this.inTransaction()) {
                try {
                    this.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserAccountObjID(String sCamID) throws CMException {
        if (sCamID == null) {
            return -1;
        }
        String sUserAccountPath = "/directory//*[@id='" + CMStoreXPath.attributeEncodeString(sCamID, '\'') + "']";
        CMStoreXPath userAccountPath = new CMStoreXPath(null, sUserAccountPath, false, 10);
        CMStoreQueryResults qresults = null;
        qresults = this.executeQuery(userAccountPath, null, null, 0, 512, null);
        int accountObjectID = -1;
        try {
            if (qresults.next()) {
                accountObjectID = qresults.getObjectID();
            }
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
        }
        return accountObjectID;
    }

    @Override
    public int createSecurityProxyObject(String sCamID, List<String> arrAncestors, CMObjectClass clsObject) throws CMException {
        return this.createSecurityProxyObject(sCamID, arrAncestors, clsObject, false, true);
    }

    @Override
    public CMProxyAccountData createSecurityProxyObject(String sCamID, List<String> arrAncestors, CMObjectClass clsObject, int tenantID, boolean isImport) throws CMException {
        return this.createSecurityProxyObject(sCamID, arrAncestors, clsObject, false, true, tenantID, isImport);
    }

    @Override
    public int createSecurityProxyObject(String sCamID, List<String> arrAncestors, CMObjectClass clsObject, boolean createUpdateLock, boolean createMyDefaults) throws CMException {
        CMProxyAccountData proxy = this.createSecurityProxyObject(sCamID, arrAncestors, clsObject, false, true, -1, false);
        return proxy.getObjectID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMProxyAccountData createSecurityProxyObject(String sCamID, List<String> arrAncestors, CMObjectClass clsObject, boolean createUpdateLock, boolean createMyDefaults, int tenantID, boolean isImport) throws CMException {
        CMStoreQueryResults qresults;
        boolean bAccountExisted;
        String searchPath;
        CMAncestors ancestors;
        int existingTenantID;
        int retObjID;
        block33: {
            CMStoreXPath proxyPath;
            boolean useTransactions;
            block32: {
                CMProxyAccountData cMProxyAccountData;
                retObjID = -1;
                existingTenantID = -1;
                ancestors = null;
                searchPath = null;
                bAccountExisted = false;
                if (sCamID == null || sCamID.startsWith(":") || CMExecutionContext.get().executingStaticRequest()) {
                    return new CMProxyAccountData(retObjID, existingTenantID, bAccountExisted, ancestors, searchPath);
                }
                useTransactions = !this.inTransaction();
                String sProxyPath = arrAncestors != null ? arrAncestors.get(arrAncestors.size() - 1) : "/directory//*[@id='" + CMStoreXPath.attributeEncodeString(sCamID, '\'') + "']";
                proxyPath = new CMStoreXPath(null, sProxyPath, false);
                qresults = null;
                try {
                    String namespaceID = CMCAMIDHelper.getNamespaceIDFromCAMID(sCamID);
                    CMStoreXPath directoryPath = new CMStoreXPath("/directory/namespace[@id='" + CMStoreXPath.attributeEncodeString(namespaceID) + "']");
                    directoryPath.setLockManagerUsageFlag(11);
                    CMStoreXPath templateSrcPath = new CMStoreXPath("/configuration/account/*", 16);
                    if (clsObject == CMObjectClass.ACCOUNT || clsObject == null) {
                        ArrayList<ICMStorePath> locks = new ArrayList<ICMStorePath>(2);
                        locks.add(directoryPath);
                        locks.add(templateSrcPath);
                        this.getLockManager().requestLocks(locks);
                    } else {
                        this.getLockManager().requestLocks(directoryPath);
                    }
                    CMProperty[] existQueryProps = new CMProperty[]{CMProperty.ANCESTORS};
                    qresults = this.executeQuery(proxyPath, existQueryProps, null, 0, 512, null);
                    if (qresults.next()) {
                        retObjID = qresults.getObjectID();
                        existingTenantID = qresults.getTenantID();
                        clsObject = qresults.getObjectClass();
                        ancestors = (CMAncestors)qresults.getValue(0);
                        searchPath = qresults.getSearchPath();
                        if (clsObject == CMObjectClass.ACCOUNT) {
                            bAccountExisted = true;
                            if (isImport) {
                                this.verifyProxyAccountTenancy(qresults, ancestors, sProxyPath, retObjID, existingTenantID, tenantID, true, false);
                            }
                            if (this.verifyAccountChildren(sProxyPath, null)) {
                                createMyDefaults = false;
                            }
                        }
                    }
                    qresults.release();
                    qresults = null;
                    if (retObjID < 0 || createMyDefaults) break block32;
                    this.getLockManager().releaseLocks();
                    if (createUpdateLock) {
                        proxyPath.setLockManagerUsageFlag(13);
                        this.getLockManager().requestLocks(proxyPath);
                    }
                    cMProxyAccountData = new CMProxyAccountData(retObjID, existingTenantID, bAccountExisted, ancestors, searchPath);
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(qresults);
                    throw throwable;
                }
                CMQueryUtils.safeQueryResultsRelease(qresults);
                return cMProxyAccountData;
            }
            if (!CMExecutionContext.get().proxyCreationEnabled()) break block33;
            if (arrAncestors == null) {
                try {
                    if (sCamID.equalsIgnoreCase(CMExecutionContext.get().getCurrentUser())) {
                        arrAncestors = CMExecutionContext.get().getCurrentUserAncestors();
                    } else {
                        AccMan.AncestorOrSelfResult accManResults = AccMan.getAncestorsAndSelf(sCamID, clsObject == null);
                        if (accManResults == null) {
                            throw new CMException("cmSearchErrCreateProxy", new CMException.Parm("Account", sCamID));
                        }
                        if (clsObject == null) {
                            clsObject = accManResults.getObjectClass();
                        }
                        arrAncestors = accManResults.getAncestorCamIDs();
                    }
                }
                catch (AAAException ex) {
                    CMException cmex = new CMException((Exception)((Object)ex), "cmErrAddUserPolicy");
                    throw cmex;
                }
            }
            CMDbStoreProxyFactory proxyFactory = new CMDbStoreProxyFactory();
            proxyFactory.buildSecurityProxyObject(this, arrAncestors, clsObject, tenantID);
            CMStoreQueryResults resultsTarget = null;
            CMProperty[] targetprops = new CMProperty[]{CMProperty.OBJECTCLASS, CMProperty.TENANTID};
            try {
                resultsTarget = this.executeQuery(proxyPath, targetprops, null, 5, 512, null);
                if (resultsTarget.next()) {
                    retObjID = resultsTarget.getObjectID();
                    existingTenantID = resultsTarget.getTenantID();
                }
                resultsTarget.reset();
                if (clsObject == CMObjectClass.ACCOUNT && !sCamID.equals("::Anonymous")) {
                    ArrayList<CMProperty> names = new ArrayList<CMProperty>();
                    ArrayList<Object> values = new ArrayList<Object>();
                    names.add(CMProperty.OWNER);
                    CMDbStoreBaseClassArray owner = new CMDbStoreBaseClassArray();
                    owner.add(new CMDbStoreObjectReference(retObjID, clsObject, "CAMID(\"" + sCamID + "\")"));
                    values.add(owner);
                    if (useTransactions) {
                        this.beginTransaction();
                    }
                    this.update(resultsTarget, names, values, new HashMap<String, Object>());
                    if (useTransactions) {
                        this.commitTransaction();
                    }
                }
            }
            finally {
                if (useTransactions && this.inTransaction()) {
                    try {
                        this.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                }
                if (resultsTarget != null) {
                    resultsTarget.release();
                }
            }
        }
        CMQueryUtils.safeQueryResultsRelease(qresults);
        if (clsObject == CMObjectClass.ACCOUNT && createMyDefaults) {
            boolean checkNameUniqueness = bAccountExisted;
            this.copyUserAccountTemplate(sCamID, null, checkNameUniqueness, tenantID);
        }
        return new CMProxyAccountData(retObjID, existingTenantID, bAccountExisted, ancestors, searchPath);
    }

    @Override
    public String getObjectName(int objectID) throws CMException {
        String name;
        try {
            name = this.getCache().CMCacheGetName(objectID, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmErrCache");
        }
        return name;
    }

    public CMDbStoreLocalizedStringArray getAllObjectNames(int objectID) throws CMException {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<Integer> locales = new ArrayList<Integer>();
        try {
            this.getCache().CMCacheGetAllNames(objectID, values, locales);
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmErrCache");
        }
        CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
        int nameCount = values.size();
        for (int nameIdx = 0; nameIdx != nameCount; ++nameIdx) {
            names.add(new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale((short)((Integer)locales.get(nameIdx)).intValue()), (String)values.get(nameIdx)));
        }
        return names;
    }

    @Override
    public String getObjectSearchPath(int objectID) throws CMException {
        String searchPath;
        try {
            searchPath = this.getCache().CMCacheGetSearchPath(objectID, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmErrCache");
        }
        return searchPath;
    }

    @Override
    public String getObjectStoreID(int objectID) throws CMException {
        String searchPath;
        try {
            searchPath = this.getCache().CMCacheGetStoreId(objectID, false);
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmErrCache");
        }
        return CMCAMIDHelper.normalizeStoreID(searchPath);
    }

    @Override
    public String getObjectSecurityReference(int objectID) throws CMException {
        String searchPath;
        try {
            searchPath = this.getCache().CMCacheGetSecurityReference(objectID);
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmErrCache");
        }
        return searchPath;
    }

    @Override
    public CMObjectClass getObjectClass(int objectID) throws CMException {
        CMObjectClass objectClass;
        try {
            int classID = this.getCache().CMCacheGetClass(objectID);
            objectClass = CMDbStoreFactory.objectClasses_.getClassByID(classID);
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmErrCache");
        }
        return objectClass;
    }

    @Override
    public boolean isObjectIDValid(int objectID) throws CMException {
        try {
            return this.getCache().CMCacheIsObjectValid(objectID);
        }
        catch (CMCacheException ex) {
            throw new CMException(ex, "cmErrCache");
        }
    }

    @Override
    public boolean isInitialized() {
        return this.bInitialized_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserAccountObjectID(String sCamID, List<String> arrAncestors, String trustedCredentials, int tenantID) throws CMException {
        int accountObjectID;
        block33: {
            UserAccountInfo userAccountInfo = CMExecutionContext.get().getCurrentUserAccountInfo();
            accountObjectID = userAccountInfo.getAccountObjId();
            if (sCamID == null) {
                userAccountInfo.release();
                return accountObjectID;
            }
            boolean useTransactions = !this.inTransaction();
            boolean newAccountCreated = false;
            try {
                if (accountObjectID > 0) {
                    String sCurrentUserCAMID;
                    int internalObjID = this.verifyProxyAccount(userAccountInfo, tenantID != -1);
                    if ((internalObjID < 0 || internalObjID != accountObjectID) && CMCAMIDHelper.CAMIDIsExternal(sCamID)) {
                        this.repairAccountAncestors(userAccountInfo, arrAncestors, trustedCredentials);
                    }
                    if (sCamID.equals(sCurrentUserCAMID = CMExecutionContext.get().getCurrentUser())) {
                        this.verifyAndCreateMyDefaults(sCamID);
                    }
                } else {
                    accountObjectID = this.createSecurityProxyObject(sCamID, arrAncestors, CMObjectClass.ACCOUNT, trustedCredentials != null, true, tenantID, false).getObjectID();
                    newAccountCreated = true;
                }
                if (trustedCredentials == null || accountObjectID == -1) break block33;
                if (!newAccountCreated) {
                    int[] lockObj = new int[]{accountObjectID};
                    this.getLockManager().requestLocksToObjects(lockObj, 11);
                }
                CMCacheQueryInstance credentialObject = null;
                try {
                    int[] accountObjects = new int[]{accountObjectID};
                    CMStoreXPath newPath = new CMStoreXPath("/*/credential");
                    credentialObject = this.getCache().executeAdminQuery(accountObjects, 1, newPath, 0);
                    ArrayList<CMProperty> names = new ArrayList<CMProperty>();
                    ArrayList<Object> values = new ArrayList<Object>();
                    names.add(CMProperty.CREDENTIALS);
                    values.add(trustedCredentials);
                    names.add(CMProperty.NAME);
                    values.add(CMLocaleUtils.getLocalizedStringsForMessageID("cmNameCredential"));
                    if (useTransactions) {
                        this.beginTransaction();
                    }
                    if (credentialObject.count() > 0) {
                        this.updateCredentialObject(credentialObject, names, values);
                    } else {
                        CMExecutionContext currContext = CMExecutionContext.get();
                        int backedUpTenant = currContext.getStaticTenantId();
                        this.checkAndChangeCurrentTenantId(currContext);
                        try {
                            this.createCredentialObject(accountObjectID, names, values);
                        }
                        finally {
                            currContext.setStaticTenantId(backedUpTenant);
                        }
                    }
                    if (useTransactions) {
                        this.commitTransaction();
                    }
                }
                catch (CMCacheException e) {
                    throw new CMStoreUnexpected(e, "cmStoreUnexpectedCacheQuery");
                }
                finally {
                    if (useTransactions && this.inTransaction()) {
                        try {
                            this.rollbackTransaction();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        if (credentialObject != null) {
                            credentialObject.release();
                        }
                    }
                    catch (CMCacheException e) {
                        throw new CMStoreUnexpected(e, "cmStoreUnexpectedCacheQuery");
                    }
                }
            }
            catch (Throwable e) {
                throw new CMException(e, "cmSearchErrCreateProxy", new CMException.Parm("Account", userAccountInfo.getCAMID()));
            }
            finally {
                this.getLockManager().releaseLocks();
                userAccountInfo.release();
            }
        }
        return accountObjectID;
    }

    private void checkAndChangeCurrentTenantId(CMExecutionContext currContext) throws CMException {
        CMStore store = currContext.getStore();
        int accountTenantId = store.getCache().CMCacheGetTenantID(currContext.getCurrentUserAccountObjectID());
        if (currContext.getStaticTenantId() != accountTenantId && currContext.getCurrentUserIsAdministrator()) {
            currContext.setStaticTenantId(accountTenantId);
        }
    }

    private void createCredentialObject(int accountObjectID, ArrayList<CMProperty> names, ArrayList<Object> values) throws CMException {
        String credentialNameStr = CMError.getMessage("cmNameCredential", null, CMExecutionContext.get().getRequestLocale("contentLocale").toLocale());
        this.createObject(accountObjectID, new CMDbStoreString(credentialNameStr), CMObjectClass.CREDENTIAL, names, values).release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCredentialObject(CMCacheQueryInstance credentialObject, ArrayList<CMProperty> names, ArrayList<Object> values) throws CMException {
        CMDbStoreCacheQueryResults updateObjs = null;
        try {
            updateObjs = new CMDbStoreCacheQueryResults(this, credentialObject.resultObjects(), null, null, null, 0, 512, null, null);
            this.update(updateObjs, names, values, new HashMap<String, Object>());
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(updateObjs);
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(updateObjs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyProxyAccount(UserAccountInfo userAccountInfo, boolean fixTenancy) throws CMException {
        CMStoreQueryResults qresults;
        int internalObjID;
        block5: {
            int accountObjectID = userAccountInfo.getAccountObjId();
            if (accountObjectID < 0) {
                return accountObjectID;
            }
            String internalPathStr = userAccountInfo.getInternalSearchPath();
            if (internalPathStr == null) {
                return -1;
            }
            CMStoreXPath internalPath = new CMStoreXPath(internalPathStr);
            CMProperty[] properties = new CMProperty[]{CMProperty.TENANTID};
            this.getLockManager().requestLocks(internalPath);
            internalObjID = -1;
            qresults = null;
            try {
                qresults = this.executeQuery(internalPath, properties, null, 0, 512, null);
                if (!qresults.next()) break block5;
                internalObjID = qresults.getObjectID();
                if (fixTenancy) {
                    int queriedTenantID = qresults.getTenantID();
                    int expectedTenantID = CMExecutionContext.get().getCurrentUserTenantId();
                    this.verifyProxyAccountTenancy(qresults, null, internalPathStr, internalObjID, queriedTenantID, expectedTenantID, false, true);
                }
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(qresults);
                this.getLockManager().releaseLocks();
                throw throwable;
            }
        }
        CMQueryUtils.safeQueryResultsRelease(qresults);
        this.getLockManager().releaseLocks();
        return internalObjID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyProxyAccountTenancy(CMStoreQueryResults qresults, CMAncestors ancestors, String internalPathStr, int internalObjID, int queriedTenantID, int expectedTenantID, boolean isImport, boolean releaseLocks) throws CMException {
        boolean useTransactions;
        CMStoreQueryResults accountDescendants;
        block13: {
            if (queriedTenantID == expectedTenantID) {
                return;
            }
            if (isImport && queriedTenantID != 0) {
                String expectedTenantIDStr = this.getTenantRegistry().getTenantIdStringFromInt(expectedTenantID);
                String queriedTenantIDStr = this.getTenantRegistry().getTenantIdStringFromInt(queriedTenantID);
                throw new CMTenantIDConflictException("cmImportTenantIDConflict", new CMException.Parm[]{new CMException.Parm("searchPath", qresults.getSearchPath()), new CMException.Parm("archiveTenantID", expectedTenantIDStr), new CMException.Parm("targetTenantID", queriedTenantIDStr)}, qresults.getSearchPath(), ancestors);
            }
            accountDescendants = null;
            useTransactions = !this.inTransaction();
            try {
                if (useTransactions) {
                    this.beginTransaction();
                }
                if (releaseLocks) {
                    this.getLockManager().releaseLocks();
                }
                int lockType = 13;
                if (0 != queriedTenantID && !isImport) {
                    lockType = 15;
                }
                CMStoreXPath storePath = new CMStoreXPath(internalPathStr + "/descendant::*", lockType);
                this.getLockManager().requestLocks(storePath);
                accountDescendants = this.executeQuery(storePath, null, null, 2, 512, null);
                ArrayList<CMProperty> propertyList = new ArrayList<CMProperty>();
                propertyList.add(CMProperty.TENANTID);
                ArrayList<Object> propertyValueList = new ArrayList<Object>();
                propertyValueList.add(this.getTenantRegistry().getTenantIdStringFromInt(expectedTenantID));
                if (0 != queriedTenantID && !isImport) {
                    this.delete(accountDescendants, true);
                } else {
                    this.update(accountDescendants, propertyList, propertyValueList);
                }
                this.getLockManager().requestLocksToObjects(new int[]{internalObjID}, 13);
                this.update(qresults, propertyList, propertyValueList);
                if (!useTransactions) break block13;
                this.commitTransaction();
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(accountDescendants);
                if (useTransactions && this.inTransaction()) {
                    this.rollbackTransaction();
                }
                if (releaseLocks) {
                    this.getLockManager().releaseLocks();
                }
                throw throwable;
            }
        }
        CMQueryUtils.safeQueryResultsRelease(accountDescendants);
        if (useTransactions && this.inTransaction()) {
            this.rollbackTransaction();
        }
        if (releaseLocks) {
            this.getLockManager().releaseLocks();
        }
    }

    private void repairAccountAncestors(UserAccountInfo userAccountInfo, List<String> camAncestors, String trustedCredentials) throws CMException {
        block7: {
            int accountObjectID = userAccountInfo.getAccountObjId();
            CMIndications.CMDebugTrace("verifyProxyAccount: proxy account ancestors have changed: " + userAccountInfo.getCAMID());
            CMCacheQueryInstance cacheQuery = null;
            try {
                String parentCAMID = userAccountInfo.getParentCAMID();
                List<String> parentAncestors = camAncestors.subList(0, camAncestors.size() - 1);
                int parentObjectID = this.createSecurityProxyObject(parentCAMID, parentAncestors, CMObjectClass.NAMESPACEFOLDER, trustedCredentials != null, true);
                int[] targetObjects = new int[]{accountObjectID};
                CMStoreXPath path = new CMStoreXPath("/*");
                String cacheQueryPath = path.getCacheQueryPath();
                CMExecutionContext.checkCancelOrTimeOut();
                this.getLockManager().requestLocksToObjects(targetObjects, 13);
                cacheQuery = this.getCache().executeAdminQuery(targetObjects, targetObjects.length, cacheQueryPath, 4, CMDbStoreLockUtil.getLockUsageFromAction(4), true);
                int[] resultObjects = cacheQuery.resultObjects();
                int numResults = resultObjects.length;
                if (numResults > 0) {
                    this.beginTransaction();
                    this.move(cacheQuery, parentObjectID, null);
                    this.commitTransaction();
                    CMIndications.CMDebugTrace("verifyProxyAccount: account (" + accountObjectID + ") moved to new proxy location (" + parentObjectID + ")");
                    break block7;
                }
                String internalPathStr = userAccountInfo.getInternalSearchPath();
                IllegalStateException state = new IllegalStateException("CAMID=" + userAccountInfo.getCAMID() + ", internalPathStr=" + internalPathStr + ", numResults<=0, parentObjectID=" + parentObjectID);
                CMIndications.logException(state);
                throw new CMException("cmSearchErrCreateProxy", new CMException.Parm("Account", userAccountInfo.getCAMID()));
            }
            catch (Throwable t) {
                CMIndications.logException(t);
                throw new CMException(t, "cmSearchErrCreateProxy", new CMException.Parm("Account", userAccountInfo.getCAMID()));
            }
            finally {
                if (cacheQuery != null) {
                    cacheQuery.release();
                }
                this.getLockManager().releaseLocks();
            }
        }
    }

    @Override
    public void verifyAndCreateMyDefaults(String sCamID) throws CMException {
        boolean bNeedCreateChildren;
        ArrayList<CMObjectClass> listObjToCreate = new ArrayList<CMObjectClass>();
        String sProxyPath = "/directory//*[@id='" + CMStoreXPath.attributeEncodeString(sCamID, '\'') + "']";
        boolean bl = bNeedCreateChildren = !this.verifyAccountChildren(sProxyPath, listObjToCreate);
        if (bNeedCreateChildren) {
            this.copyUserAccountTemplate(sCamID, listObjToCreate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyAccountChildren(String sProxyPath, List<CMObjectClass> listObjToCreate) throws CMException {
        if (sProxyPath == null || sProxyPath.length() == 0) {
            return false;
        }
        if (listObjToCreate == null) {
            listObjToCreate = new ArrayList<CMObjectClass>();
        }
        CMStoreXPath userAccountDescendantsPath = (CMStoreXPath)CMStoreXPath.parse(sProxyPath + "/*[@objectClass='folder' or @objectClass='mruFolder' or @objectClass='subscriptionFolder']");
        userAccountDescendantsPath.setLockManagerUsageFlag(10);
        this.getLockManager().requestLocks(userAccountDescendantsPath);
        CMStoreQueryResults qresults = null;
        try {
            CMExecutionContext.checkCancelOrTimeOut();
            qresults = this.executeQuery(userAccountDescendantsPath, null, null, 0, 512, null);
            listObjToCreate.add(CMObjectClass.FOLDER);
            listObjToCreate.add(CMObjectClass.MRUFOLDER);
            listObjToCreate.add(CMObjectClass.SUBSCRIPTIONFOLDER);
            while (qresults != null && !listObjToCreate.isEmpty() && qresults.next()) {
                if (qresults.getObjectClass() == CMObjectClass.FOLDER) {
                    listObjToCreate.remove(CMObjectClass.FOLDER);
                    continue;
                }
                if (qresults.getObjectClass() == CMObjectClass.MRUFOLDER) {
                    listObjToCreate.remove(CMObjectClass.MRUFOLDER);
                    continue;
                }
                if (qresults.getObjectClass() != CMObjectClass.SUBSCRIPTIONFOLDER) continue;
                listObjToCreate.remove(CMObjectClass.SUBSCRIPTIONFOLDER);
            }
            if (listObjToCreate.isEmpty()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (qresults != null) {
                qresults.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void createSessionStorage() throws CMException {
        block64: {
            CMExecutionContext ctx = CMExecutionContext.get();
            String passportID = ctx.getAccManPassportID();
            boolean bCreateSessionsFolder = false;
            boolean bupdatePolicy = false;
            CMStoreQueryResults qresults = null;
            String sCAMID = ctx.getCurrentUser();
            if (this.inTransaction()) {
                throw new IllegalStateException("createSessionStorage CANNOT be called from within a transaction");
            }
            try {
                CMStoreXPath sessionFolderPath = new CMStoreXPath("~~", 10);
                try {
                    this.getLockManager().requestLocks(sessionFolderPath);
                    CMProperty[] props = new CMProperty[]{CMProperty.OBJECTCLASS, CMProperty.POLICIES};
                    qresults = this.executeQuery(sessionFolderPath, props, null, 2, 512, null);
                    if (!qresults.next()) {
                        bCreateSessionsFolder = true;
                    } else {
                        ctx.setCurrentUserSessionObjectID(qresults.getObjectID());
                        if ((qresults.getValue(1) == null || qresults.wasAcquired()) && !sCAMID.equals("::Anonymous")) {
                            bupdatePolicy = true;
                        }
                    }
                }
                finally {
                    if (qresults != null) {
                        qresults.reset();
                    }
                    this.getLockManager().releaseLocks();
                }
                CMCacheQueryInstance cacheQuery = null;
                byte[] userSessionPolicy = null;
                if (bCreateSessionsFolder || bupdatePolicy) {
                    CMException cmex;
                    try {
                        byte[] accountTemplatePolicy;
                        CMStoreXPath path = new CMStoreXPath("/configuration/account");
                        cacheQuery = this.getCache().executeAdminQuery(path, 0);
                        if (cacheQuery.count() > 0 && (accountTemplatePolicy = this.getPolicy(cacheQuery.resultObjects()[0])) != null) {
                            userSessionPolicy = AccMan.createUserSessionPolicyFromTemplate(sCAMID, accountTemplatePolicy);
                        }
                    }
                    catch (CMCacheAccessDenied path) {
                    }
                    catch (AAAException e) {
                        cmex = new CMException((Exception)((Object)e), "cmErrAddUserPolicy");
                        CMIndications.logException(cmex);
                    }
                    catch (CMCacheException e) {
                        cmex = new CMException(e, "cmErrCache");
                        CMIndications.logException(cmex);
                    }
                    catch (Exception e) {
                        cmex = new CMException(e, "cmErrAddUserPolicy");
                        CMIndications.logException(cmex);
                    }
                    finally {
                        try {
                            cacheQuery.release();
                        }
                        catch (Throwable e) {}
                        this.getLockManager().releaseLocks();
                    }
                }
                if (bCreateSessionsFolder) {
                    CMStoreQueryResults addResults;
                    block63: {
                        addResults = null;
                        ArrayList<CMProperty> names2232322322 = new ArrayList<CMProperty>();
                        ArrayList<Object> values = new ArrayList<Object>();
                        names2232322322.add(CMProperty.POLICIES);
                        values.add(userSessionPolicy);
                        names2232322322.add(CMProperty.OWNER);
                        values.add(null);
                        CMStoreXPath userFolderPath = new CMStoreXPath(null, ctx.getCurrentUserInternalPath(), true, 11);
                        this.getLockManager().requestLocks(userFolderPath);
                        this.beginTransaction();
                        HashUtil hasher = new HashUtil();
                        addResults = this.addObject(userFolderPath, (CMBasePropertyValue)new CMDbStoreString(hasher.hash(passportID)), CMObjectClass.SESSION, names2232322322, values);
                        addResults.next();
                        ctx.setCurrentUserSessionObjectID(addResults.getObjectID());
                        this.commitTransaction();
                        if (!this.inTransaction()) break block63;
                        try {
                            this.rollbackTransaction();
                        }
                        catch (Exception names2232322322) {
                            // empty catch block
                        }
                    }
                    if (addResults != null) {
                        addResults.release();
                    }
                    this.getLockManager().releaseLocks();
                    break block64;
                    catch (CMStoreDuplicateObject names2232322322) {
                        if (this.inTransaction()) {
                            try {
                                this.rollbackTransaction();
                            }
                            catch (Exception names2232322322) {
                                // empty catch block
                            }
                        }
                        if (addResults != null) {
                            addResults.release();
                        }
                        this.getLockManager().releaseLocks();
                        break block64;
                        catch (Throwable throwable) {
                            if (this.inTransaction()) {
                                try {
                                    this.rollbackTransaction();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (addResults != null) {
                                addResults.release();
                            }
                            this.getLockManager().releaseLocks();
                            throw throwable;
                        }
                    }
                }
                if (!bupdatePolicy) break block64;
                try {
                    sessionFolderPath.clearLocksHaveBeenObtained();
                    sessionFolderPath.setLockManagerUsageFlag(13);
                    this.getLockManager().requestLocks(sessionFolderPath);
                    ArrayList<CMProperty> addProps = new ArrayList<CMProperty>(1);
                    ArrayList<Object> addValues = new ArrayList<Object>(1);
                    addProps.add(CMProperty.POLICIES);
                    addValues.add(null);
                    this.beginTransaction();
                    addValues.set(0, userSessionPolicy);
                    this.update(qresults, addProps, addValues, new HashMap<String, Object>());
                    this.commitTransaction();
                }
                finally {
                    if (this.inTransaction()) {
                        try {
                            this.rollbackTransaction();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            finally {
                if (qresults != null) {
                    qresults.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getObjectID(ICMStorePath name) throws CMException {
        CMCacheQueryInstance query2;
        block16: {
            if (name.size() == 0) {
                return 0;
            }
            query2 = null;
            query2 = this.getCache().executeAdminQuery(name, 0);
            int numObjects = query2.count();
            if (numObjects != 1) break block16;
            int n = query2.resultObjects()[0];
            try {
                if (query2 != null) {
                    query2.release();
                }
            }
            catch (CMCacheException cMCacheException) {
                // empty catch block
            }
            return n;
        }
        try {
            try {
                throw new CMStoreObjectNotFound(CMQueryUtils.getPath((CMStore)this, name));
            }
            catch (CMCacheException e) {
                throw new CMStoreUnexpected(e, "cmStoreUnexpectedCacheQuery");
            }
            catch (CMCacheAccessDenied e) {
                CMDbStoreSecurityUtil.convertAccessDeniedException(this.getCache(), e);
                int n = 0;
                return n;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                if (query2 != null) {
                    query2.release();
                }
            }
            catch (CMCacheException cMCacheException) {}
        }
    }

    protected CMDbStoreAddDef getAddDef(String table, CMDbStoreAddDef[] addDefs) {
        return (CMDbStoreAddDef)this.getDMLDef(table, addDefs);
    }

    private CMDbStoreDMLDef getDMLDef(String table, CMDbStoreDMLDef[] dmlDefs) {
        int tableIdx;
        for (tableIdx = 0; tableIdx < dmlDefs.length && dmlDefs[tableIdx] != null && !table.equals(dmlDefs[tableIdx].getTableName()); ++tableIdx) {
        }
        if (tableIdx == dmlDefs.length) {
            return null;
        }
        return dmlDefs[tableIdx];
    }

    protected int addDMLDefForProperty(CMDbProperty prop, Object value, CMDbStoreDMLDef[] dmlDefs) {
        int propIdx;
        int numDMLDefsAdded = 0;
        String table = prop.getColumn(0).getTable();
        CMDbStoreDMLDef dmlDef = this.getDMLDef(table, dmlDefs);
        if (dmlDef == null) {
            if (dmlDefs instanceof CMDbStoreAddDef[]) {
                dmlDef = new CMDbStoreAddDef(table);
            } else if (dmlDefs instanceof CMDbStoreUpdateDef[]) {
                dmlDef = new CMDbStoreUpdateDef(table);
            } else {
                throw new IllegalStateException("Unsupported dmlDefs array type");
            }
            for (int i = 0; i < dmlDefs.length; ++i) {
                if (dmlDefs[i] != null) continue;
                dmlDefs[i] = dmlDef;
                ++numDMLDefsAdded;
                break;
            }
        }
        for (propIdx = 0; propIdx < dmlDef.numProps_; ++propIdx) {
            if (dmlDef.properties_[propIdx] != prop) continue;
            dmlDef.values_[propIdx] = value;
            break;
        }
        if (propIdx == dmlDef.numProps_) {
            dmlDef.addColumn(prop, value);
        }
        return numDMLDefsAdded;
    }

    protected boolean reserveStoreId(String storeId, CMCacheQueryInstance query2) throws CMCacheException {
        if (storeId == null || query2.count() != 1) {
            throw new IllegalStateException("Failed attempt to update storeID: storeID=" + storeId + ";objects count=" + query2.count());
        }
        int[] obj_ids = query2.resultObjects();
        return this.getCache().CMCacheReserveStoreId(obj_ids[0], storeId);
    }

    CMStoreQueryResults createObject(int parentID, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues, Map<String, Object> additionalParameters) throws CMException {
        return this.createObject(parentID, -1, name, objectClass, properties, propValues, true, additionalParameters);
    }

    CMStoreQueryResults createObject(int parentID, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues) throws CMException {
        return this.createObject(parentID, -1, name, objectClass, properties, propValues, true, new HashMap<String, Object>());
    }

    public CMStoreQueryResults createObject(int parentID, int objectID, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues, boolean checkNameUniqueness) throws CMException {
        return this.createObject(parentID, objectID, name, objectClass, properties, propValues, checkNameUniqueness, new HashMap<String, Object>());
    }

    /*
     * Could not resolve type clashes
     */
    CMStoreQueryResults createObject(int parentID, int objectID, CMBasePropertyValue name, CMObjectClass objectClass, List<CMProperty> properties, List<Object> propValues, boolean checkNameUniqueness, Map<String, Object> additionalParameters) throws CMException {
        block106: {
            if (!this.inTransaction()) {
                throw new IllegalStateException("createObject must be called from within a transaction");
            }
            ArrayList<Object> streamProps = null;
            CMCache cache = null;
            CMDbStoreTransactionAction addAction = null;
            if (!CMDbConnection.schemaHasParentFK()) {
                for (int i = 0; i < this.transactionActions.size(); ++i) {
                    CMDbStoreTransactionAction transactionAction = this.transactionActions.get(i);
                    if (!(transactionAction instanceof CMDbStoreDelCacheObjects)) continue;
                    int[] deletedObjIDs = ((CMDbStoreDelCacheObjects)transactionAction).objectsToDelete_;
                    for (int j = 0; j < deletedObjIDs.length; ++j) {
                        if (deletedObjIDs[j] != parentID) continue;
                        throw new CMStoreObjectNotFound();
                    }
                }
            }
            try {
                CMDbProperty propSTOREID;
                CMDbStoreAddDef addDefSTOREID;
                String currentUser;
                CMDbStoreLocalizedString defaultName = null;
                if (name != null) {
                    if (name.getType().isArray()) {
                        CMDbStoreLocalizedStringArray nameArray = (CMDbStoreLocalizedStringArray)name;
                        CMStringLocale userLocale = this.getUserLocale();
                        defaultName = new CMDbStoreLocalizedString(userLocale, nameArray.getDefault(userLocale));
                    } else {
                        String contentLocalePref = CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE);
                        CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
                        defaultName = new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(contentLocalePref), name.toString());
                        names.add(defaultName);
                        name = names;
                    }
                }
                CMDbStoreDMLDef[] addDefs = ((CMDbObjectClass)objectClass).getAddDefs(parentID);
                boolean hasPolicies = false;
                boolean hasUCPolicies = false;
                int fDisabled = 0;
                ArrayList<RequestFileAttachment> dataTempFiles = new ArrayList<RequestFileAttachment>();
                long dataFileSize = 0L;
                ArrayList<Long> dataFileSizes = new ArrayList<Long>();
                ArrayList<CMDbProperty> dataFileProperties = new ArrayList<CMDbProperty>();
                String externalObjectID = null;
                boolean hasOwner = false;
                Object ownerValue = null;
                boolean hasRecipients = false;
                boolean hasRecipientsEMail = false;
                boolean settingCreateTime = false;
                boolean hasCredNamespaces = false;
                int outputLocale = 0;
                int outputFormat = 255;
                short deployedObjectUsage = 0;
                boolean hasMessage = false;
                HashSet<CMProperty> propsWithDefaultValue = null;
                String storeId = null;
                boolean needToGenerateStoreId = true;
                boolean settingArchivingTriggerProp = false;
                boolean hasTenantId = false;
                int tenantIDInt = CMExecutionContext.get().getCurrentUserTenantId();
                String tenantIDStr = this.tenantRegistry.getTenantIdStringFromInt(tenantIDInt);
                if (properties == null) {
                    properties = new ArrayList<CMProperty>();
                    propValues = new ArrayList<Object>();
                }
                propsWithDefaultValue = objectClass.getCopyOfPropertiesWithDefaultValue();
                for (int i = 0; i < properties.size(); ++i) {
                    CMDbProperty prop = (CMDbProperty)properties.get(i);
                    if ((prop == CMProperty.ID || prop == CMProperty.DISPATCHERPATH || prop == CMProperty.TASKID || prop == CMProperty.EVENTID || prop == CMProperty.DOCUMENTID) && propValues.get(i) != null) {
                        externalObjectID = propValues.get(i).toString();
                    } else {
                        if (prop == CMProperty.STOREID) {
                            if (propValues.get(i) == null) continue;
                            storeId = propValues.get(i).toString();
                            needToGenerateStoreId = false;
                            continue;
                        }
                        if (prop == CMProperty.POLICIES) {
                            if (propValues.get(i) != null) {
                                hasPolicies = true;
                            }
                        } else if (prop == CMProperty.USERCAPABILITYPOLICIES) {
                            if (propValues.get(i) != null) {
                                hasUCPolicies = true;
                            }
                        } else if (prop == CMProperty.DISABLED) {
                            if (propValues.get(i) != null) {
                                boolean disabled = CMXMLUtils.parseBooleanAttribute(propValues.get(i).toString());
                                fDisabled = disabled ? 1 : 2;
                            }
                        } else if (prop == CMProperty.OWNER) {
                            hasOwner = true;
                            ownerValue = propValues.get(i);
                        } else {
                            if (prop == CMProperty.NAME || prop == CMProperty.DEFAULTNAME) {
                                if (name != null) continue;
                                CMBasePropertyValue dataValue = (CMBasePropertyValue)propValues.get(i);
                                if (dataValue.getType().isArray()) {
                                    CMDbStoreLocalizedStringArray nameArray = (CMDbStoreLocalizedStringArray)dataValue;
                                    CMStringLocale userLocale = this.getUserLocale();
                                    defaultName = new CMDbStoreLocalizedString(userLocale, nameArray.getDefault(userLocale));
                                    name = dataValue;
                                    continue;
                                }
                                String contentLocalePref = CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE);
                                CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
                                defaultName = new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(contentLocalePref), dataValue.toString());
                                names.add(defaultName);
                                name = names;
                                continue;
                            }
                            if (prop == CMProperty.RECIPIENTS) {
                                if (propValues.get(i) != null) {
                                    hasRecipients = true;
                                }
                            } else if (prop == CMProperty.RECIPIENTSEMAIL) {
                                if (propValues.get(i) != null) {
                                    hasRecipientsEMail = true;
                                }
                            } else if (prop == CMProperty.CREDENTIALNAMESPACES) {
                                if (propValues.get(i) != null) {
                                    hasCredNamespaces = true;
                                }
                            } else {
                                if (prop == CMProperty.CREATIONTIME) {
                                    boolean isDerby = CMDbConnection.dbms_ == 5;
                                    Timestamp createTime = CMDateUtils.getTimestamp(DateUtils.parse((String)propValues.get(i).toString()), isDerby);
                                    ((CMDbStoreBaseTableAddDef)addDefs[0]).setCreationDate(createTime);
                                    settingCreateTime = true;
                                    continue;
                                }
                                if (prop == CMProperty.MODIFICATIONTIME) {
                                    boolean isDerby = CMDbConnection.dbms_ == 5;
                                    Timestamp modTime = CMDateUtils.getTimestamp(DateUtils.parse((String)propValues.get(i).toString()), isDerby);
                                    ((CMDbStoreBaseTableAddDef)addDefs[0]).setModificationDate(modTime);
                                    continue;
                                }
                                if (prop == CMProperty.LOCALE) {
                                    Object propValue = propValues.get(i);
                                    if (propValue != null) {
                                        CMDbStoreStringLocale locale = null;
                                        locale = propValue.getClass() != CMDbStoreStringLocale.class ? (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(propValue.toString()) : (CMDbStoreStringLocale)propValue;
                                        if (locale != null) {
                                            CMDbStoreStringLocale mappedLocale = (CMDbStoreStringLocale)locale.getMappedLocale();
                                            outputLocale = locale.getInternalID() | (mappedLocale == null ? (short)0 : mappedLocale.getInternalID()) << 16;
                                        }
                                    }
                                } else if (prop == CMProperty.FORMAT) {
                                    Short sValue;
                                    Object propValue = propValues.get(i);
                                    if (propValue != null && (sValue = (Short)prop.getDataSerializer().serialize(propValue)) != null) {
                                        outputFormat = sValue.intValue();
                                    }
                                } else if (prop.hasMeaning(CMPropertyMeaning.DATASIZE) || prop.hasMeaning(CMPropertyMeaning.DATASETSIZE)) {
                                    Long sValue;
                                    Object propValue = propValues.get(i);
                                    if (propValue != null && (sValue = (Long)prop.getDataSerializer().serialize(propValue)) != null) {
                                        dataFileSize = sValue;
                                    }
                                } else if (prop == CMProperty.DEPLOYEDOBJECTUSAGE) {
                                    Object propValue = propValues.get(i);
                                    if (propValue != null) {
                                        deployedObjectUsage = prop.getEnumID(propValue.toString());
                                    }
                                } else if (prop == CMProperty.MESSAGE) {
                                    Object propValue = propValues.get(i);
                                    if (propValue != null) {
                                        hasMessage = true;
                                    }
                                } else if (prop == CMProperty.TENANTID) {
                                    hasTenantId = true;
                                    Object propValue = propValues.get(i);
                                    MultiTenancyUtils.validateTenantId(tenantIDStr, objectClass, false, this.tenantRegistry);
                                    tenantIDStr = propValue != null ? propValue.toString() : null;
                                    tenantIDInt = this.tenantRegistry.getTenantIdIntFromString(tenantIDStr, false);
                                }
                            }
                        }
                    }
                    if (this.isRepositoryIntegrationInstalled() && !settingArchivingTriggerProp) {
                        settingArchivingTriggerProp = this.settingArchivingTriggerProperty(prop, propValues.get(i));
                    }
                    if (prop.columnCount() > 0) {
                        ArrayList<? extends CMProperty> subpropertiesAndSelf = prop.getSubpropertiesAndSelf();
                        for (int subpropertyIdx = 0; subpropertyIdx < subpropertiesAndSelf.size(); ++subpropertyIdx) {
                            CMDbProperty currentProperty = (CMDbProperty)subpropertiesAndSelf.get(subpropertyIdx);
                            if (currentProperty.columnCount() <= 0) continue;
                            CMDbStoreAddDef addDef = this.getAddDef(currentProperty.getColumn(0).getTable(), (CMDbStoreAddDef[])addDefs);
                            if (addDef == null) {
                                throw new IllegalStateException("property references table not associated with class-" + prop.getName());
                            }
                            Object value = propValues.get(i);
                            if (value instanceof RequestAttachment) {
                                if (streamProps == null) {
                                    streamProps = new ArrayList<Object>();
                                }
                                RequestAttachment attachment = (RequestAttachment)value;
                                try {
                                    value = attachment.getTempInputStream();
                                }
                                catch (Exception e) {
                                    throw new CMException(e, "failed to get stream from temp file");
                                }
                                streamProps.add(value);
                                if (attachment.isFile() && attachment instanceof RequestFileAttachment) {
                                    RequestFileAttachment fileAttachment = (RequestFileAttachment)attachment;
                                    fileAttachment.ensureFileNameExists();
                                    dataTempFiles.add(fileAttachment);
                                    dataFileProperties.add(currentProperty);
                                    dataFileSizes.add(new Long(dataFileSize));
                                    dataFileSize = 0L;
                                }
                            }
                            addDef.addColumn(currentProperty, value);
                        }
                        if (prop.getIndexProperty() != null) {
                            CMDbProperty indexProp = (CMDbProperty)prop.getIndexProperty();
                            CMDbStoreAddDef addDef = this.getAddDef(indexProp.getColumn(0).getTable(), (CMDbStoreAddDef[])addDefs);
                            Object value = propValues.get(i);
                            addDef.addColumn(indexProp, CMDbStoreUtil.getIndexValue(value));
                        }
                        if (propsWithDefaultValue == null) continue;
                        propsWithDefaultValue.remove(prop);
                        continue;
                    }
                    throw new IllegalStateException("Attempting to set a property that is not backed by the database: " + prop.getName());
                }
                if (name == null) {
                    throw new IllegalStateException("Cannot create an object without a name");
                }
                CMDbProperty nameProperty = (CMDbProperty)CMProperty.NAME;
                CMDbStoreAddDef nAddDef = this.getAddDef(nameProperty.getColumn(0).getTable(), (CMDbStoreAddDef[])addDefs);
                nAddDef.addColumn(nameProperty, name);
                if (!hasOwner && (currentUser = CMExecutionContext.get().getCurrentUser()) != null) {
                    CMDbStoreBaseClassArray bcArray = new CMDbStoreBaseClassArray();
                    int objID = CMExecutionContext.get().getCurrentUserAccountObjectID();
                    CMObjectClass objClass = CMExecutionContext.get().getStore().getObjectClass(objID);
                    bcArray.add(new CMDbStoreObjectReference(objID, objClass, CMCAMIDHelper.SelectFromCAMID(currentUser)));
                    ownerValue = bcArray;
                    CMDbProperty prop = (CMDbProperty)CMProperty.OWNER;
                    CMDbStoreAddDef addDef = this.getAddDef(prop.getColumn(0).getTable(), (CMDbStoreAddDef[])addDefs);
                    if (addDef == null) {
                        throw new IllegalStateException("property references table not associated with class-" + prop.getName());
                    }
                    addDef.addColumn(prop, ownerValue);
                }
                if (propsWithDefaultValue != null && !propsWithDefaultValue.isEmpty()) {
                    for (CMDbProperty defValueProp : propsWithDefaultValue) {
                        String defValue;
                        CMDbStoreAddDef addDef;
                        if (defValueProp.columnCount() <= 0 || (addDef = this.getAddDef(defValueProp.getColumn(0).getTable(), (CMDbStoreAddDef[])addDefs)) == null || (defValue = defValueProp.getDefaultValue()) == null) continue;
                        addDef.addColumn(defValueProp, defValue);
                    }
                }
                tenantIDInt = this.handleTenantIdForCreateObject(hasTenantId, tenantIDInt, tenantIDStr, parentID, (CMDbStoreAddDef[])addDefs);
                if (this.isRepositoryIntegrationInstalled() && !ArchivingUtil.archivingIsDisabled(additionalParameters)) {
                    additionalParameters = ArchivingUtil.setNotificationParameterForAdd(additionalParameters);
                    if (settingArchivingTriggerProp) {
                        this.addDMLDefForProperty((CMDbProperty)CMProperty._ARCHIVESTATUS, ArchivingUtil.getArchiveStatusForAdd(), addDefs);
                    } else {
                        additionalParameters = ArchivingUtil.setNotificationParameterForArchivingTriggerPropNotSet(additionalParameters);
                    }
                }
                cache = this.getCache();
                CMDbStoreStringLocale defaultNameLocale = (CMDbStoreStringLocale)defaultName.getLocale();
                boolean bObjectIDCreated = false;
                if (objectID < 0) {
                    objectID = cache.CMCacheCreateObject(tenantIDInt, defaultName.getValue(), defaultNameLocale.getInternalID(), hasRecipients, null, objectClass.getID(), hasPolicies, fDisabled, externalObjectID, hasCredNamespaces, outputLocale, outputFormat, hasRecipientsEMail);
                    RequestFileAttachment[] files = new RequestFileAttachment[dataTempFiles.size()];
                    files = dataTempFiles.toArray(files);
                    CMProperty[] fileProperties = new CMProperty[dataFileProperties.size()];
                    fileProperties = dataFileProperties.toArray(fileProperties);
                    Long[] fileSizes = new Long[dataFileSizes.size()];
                    fileSizes = dataFileSizes.toArray(fileSizes);
                    addAction = new CMDbStoreTAAddToCache(this, objectID, fileProperties, files, fileSizes);
                    bObjectIDCreated = true;
                }
                if (!needToGenerateStoreId && !cache.CMCacheSetStoreId(objectID, storeId)) {
                    needToGenerateStoreId = true;
                }
                if (needToGenerateStoreId) {
                    while (!cache.CMCacheSetStoreId(objectID, storeId = CMDbStore.generateStoreId())) {
                    }
                }
                if ((addDefSTOREID = this.getAddDef((propSTOREID = (CMDbProperty)CMProperty.STOREID).getColumn(0).getTable(), (CMDbStoreAddDef[])addDefs)) == null) {
                    throw new IllegalStateException("property storeID is missing from class definition");
                }
                addDefSTOREID.addColumn(propSTOREID, storeId);
                this.generateDataPathInfoIfRequired(objectClass, storeId, addDefs);
                CMDbStoreAddDef baseTableDef = (CMDbStoreAddDef)this.sortUpdateDefs(addDefs);
                this.lockBaseTable();
                if (checkNameUniqueness && name instanceof CMDbStoreLocalizedStringArray) {
                    CMDbStoreLocalizedStringArray namesArray = (CMDbStoreLocalizedStringArray)name;
                    NameUniqueness.check(this, objectID, namesArray, parentID);
                }
                for (int i = 0; i < addDefs.length; ++i) {
                    ((CMDbStoreAddDef)addDefs[i]).execute(this.getConnection(), objectID);
                }
                if ((hasRecipients || hasRecipientsEMail) && ownerValue != null) {
                    CMDbProperty prop = (CMDbProperty)CMProperty._OTHERRECIPIENTS;
                    CMDbStoreAddArrayDef addDef = new CMDbStoreAddArrayDef(prop.getColumn(0).getTable());
                    addDef.addColumn(prop, ownerValue);
                    ((CMDbStoreAddDef)addDef).execute(this.getConnection(), objectID);
                }
                ArrayList<String> namesForCache = new ArrayList<String>();
                ArrayList<Integer> localesForCache = new ArrayList<Integer>();
                CMArrayPropertyValue theNames = (CMArrayPropertyValue)name;
                int strCount = theNames.getSize();
                for (int strIdx = 0; strIdx != strCount; ++strIdx) {
                    CMDbStoreLocalizedString str = (CMDbStoreLocalizedString)theNames.getItem(strIdx);
                    namesForCache.add(str.getValue());
                    localesForCache.add(new Integer(str.getLocaleIDForCache()));
                }
                if (bObjectIDCreated) {
                    cache.CMCacheSetAllNames(objectID, namesForCache, localesForCache);
                }
                if (hasUCPolicies) {
                    CMUserCapabilityPoliciesHandler.policyUpdated(new Integer(objectID), !hasUCPolicies);
                }
                if (objectClass == CMObjectClass.DEPLOYMENTDETAIL) {
                    cache.CMCacheUpdateBooleanProperty(objectID, 13, hasMessage);
                    cache.CMCacheUpdateIntProperty(objectID, 14, deployedObjectUsage);
                }
                if (!settingCreateTime && bObjectIDCreated && baseTableDef != null) {
                    CMDbStoreBaseTableUpdateDef parentUpdate = new CMDbStoreBaseTableUpdateDef(false);
                    parentUpdate.addColumn((CMDbProperty)CMProperty.MODIFICATIONTIME, ((CMDbStoreBaseTableAddDef)baseTableDef).getCreationDate());
                    parentUpdate.execute(this.getConnection(), parentID);
                }
                if (bObjectIDCreated && baseTableDef != null) {
                    NotificationBuilder builder;
                    List<Notification> notifications;
                    long creationTime = CMDateUtils.getUTCTimeFromTimestamp(((CMDbStoreBaseTableAddDef)baseTableDef).getCreationDate()) / 1000L * 1000L;
                    String sCAMID = null;
                    if (externalObjectID == null && objectClass.needCognosNSCAMID()) {
                        sCAMID = this.getCache().CMCacheGetInternalCAMID(objectID, creationTime);
                    }
                    cache.CMCacheCommitObject(objectID, parentID, sCAMID);
                    if (sCAMID != null) {
                        this.updateInternalCAMIDInDB(sCAMID, objectID);
                    }
                    this.addTransactionAction(addAction);
                    addAction = null;
                    if (CMDbStoreNotificationObservers.notifyObject(objectClass.getID())) {
                        CMDbStoreNotification notification = new CMDbStoreNotification(storeId, objectClass, 1);
                        this.addTransactionAction(new CMDbStoreNotificationTA(notification));
                    }
                    if ((notifications = (builder = this.module.newNotificationBuilder(this)).getNotifications(objectClass, properties, "add", objectID, parentID, additionalParameters)) != null && notifications.size() > 0) {
                        this.addPostTransactionAction(new NotificationTA(notifications));
                    }
                }
                CMDbStoreAddResults cMDbStoreAddResults = new CMDbStoreAddResults(this, objectID);
                return cMDbStoreAddResults;
            }
            catch (SQLException e) {
                String searchPath = null;
                try {
                    searchPath = cache.CMCacheGetNameOnlyPath(objectID, CMDbStoreCacheUtil.getCacheSearchLocales());
                }
                catch (CMCacheException cMCacheException) {
                    // empty catch block
                }
                CMDbStoreExceptionUtil.handleSQLExceptionForNewObject(this.getConnection(), e, "cmStoreUnexpectedCreateObj", true, objectID, searchPath, "cmFailedToRollbackAdd");
            }
            catch (CMCacheException e) {
                CMException cmex = new CMException("cmErrCacheIn", new CMException.Parm("Location", "createObject"));
                CMIndications.logException(cmex);
                throw new CMStoreUnexpected(e, "cmStoreUnexpectedCreateObj");
            }
            finally {
                if (addAction != null) {
                    addAction.rollback();
                }
                if (streamProps == null) break block106;
                for (int streamIdx = 0; streamIdx < streamProps.size(); ++streamIdx) {
                    Object x = streamProps.get(streamIdx);
                    try {
                        ((InputStream)x).close();
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return null;
    }

    private CMStringLocale getUserLocale() {
        String advSettingsDefLocale;
        CMStringLocale userLocale = CMExecutionContext.get().getCurrentUserContentLocale();
        if (userLocale == null && (advSettingsDefLocale = AdvancedSettings.DEFAULTLOCALE).length() != 0) {
            userLocale = CMDbStoreStringLocales.findLocale(advSettingsDefLocale);
        }
        return userLocale;
    }

    private int handleTenantIdForCreateObject(boolean hasTenantId, int tenantIDInt, String tenantIDStr, int parentID, CMDbStoreAddDef[] addDefs) throws CMException {
        int parentTenantId = this.getCache().CMCacheGetTenantID(parentID);
        CMExecutionContext context = CMExecutionContext.get();
        if (!hasTenantId) {
            if (context.applyTenantIdVirtualInheritance()) {
                tenantIDInt = MultiTenancyUtils.determineTenantIdWithVirtualInheritance(parentTenantId, tenantIDInt);
                tenantIDStr = this.tenantRegistry.getTenantIdStringFromInt(tenantIDInt);
            }
            CMDbProperty propTENANTID = (CMDbProperty)CMProperty.TENANTID;
            CMDbStoreAddDef addDefTENANTID = this.getAddDef(propTENANTID.getColumn(0).getTable(), addDefs);
            addDefTENANTID.addColumn(propTENANTID, tenantIDStr);
        }
        if (!MultiTenancyUtils.isValidContainment(parentTenantId, tenantIDInt)) {
            if (CMExecutionContext.get().repairInvalidContainment()) {
                tenantIDInt = parentTenantId;
                tenantIDStr = this.tenantRegistry.getTenantIdStringFromInt(tenantIDInt);
                this.addDMLDefForProperty((CMDbProperty)CMProperty.TENANTID, tenantIDStr, addDefs);
                DeploymentExecutionContext.get().setInvalidContainmentObject(true);
            } else {
                this.throwInvalidContainmentException(parentID, parentTenantId, tenantIDInt);
            }
        }
        return tenantIDInt;
    }

    private void throwInvalidContainmentException(int parentID, int parentTenantId, int tenantId) throws CMException {
        String tenantIdString = this.tenantRegistry.getTenantIdStringFromInt(tenantId);
        String parentTenantIdString = this.tenantRegistry.getTenantIdStringFromInt(parentTenantId);
        String parentSearchPath = this.getObjectSearchPath(parentID);
        throw new CMException("cmInvalidTenantContainment", new CMException.Parm("tenant", tenantIdString), new CMException.Parm("path", parentSearchPath), new CMException.Parm("parentTenant", parentTenantIdString));
    }

    protected void generateDataPathInfoIfRequired(CMObjectClass objectClass, String storeId, CMDbStoreDMLDef[] defs) {
        CMDbStoreDMLDef def;
        CMDbProperty prop = (CMDbProperty)objectClass.getProperty(CMPropertyMeaning.DATAPATHINFO);
        if (prop != null && (def = this.getDMLDef(prop.getColumn(0).getTable(), defs)) != null) {
            this.generateDataPathInfoDMLDef(prop, def, storeId);
        }
    }

    protected void generateDataPathInfoDMLDef(CMDbProperty prop, CMDbStoreDMLDef def, String storeId) {
        StringBuilder builder = new StringBuilder(REPOSITORY_URL_PREFIX);
        builder.append(storeId);
        builder.append(REPOSITORY_URL_SUFFIX);
        def.addColumn(prop, builder.toString());
    }

    private void updateInternalCAMIDInDB(String sCAMID, int objectID) throws SQLException, CMException {
        CMDbProperty prop = (CMDbProperty)CMProperty.ID;
        CMDbStoreUpdateDef updateDef = new CMDbStoreUpdateDef(prop.getColumn(0).getTable());
        updateDef.addColumn(prop, sCAMID);
        updateDef.execute(this.getConnection(), objectID);
    }

    int createCopyObject(int srcID, CMLocalizedStringArray srcName, int parentID, CMLocalizedStringArray newname, boolean checkNameUniqueness, int tenantId) throws CMException {
        CMDbStorePrepStmtCache stmtCache = this.getConnection().stmtCache_;
        Statement stmt = null;
        Statement stmt2 = null;
        int objectID = -1;
        boolean successful = false;
        CMCache cache = null;
        String searchPath = null;
        CMDbObjectClasses classes = (CMDbObjectClasses)this.getObjectClasses();
        try {
            String srcCAMID;
            String targetCAMID;
            cache = this.getCache();
            CMObjectClass srcObjectClass = this.getObjectClasses().getClassByID(cache.CMCacheGetClass(srcID));
            objectID = cache.CMCacheDuplicateObject(srcID, null, tenantId);
            PreparedStatement copyBaseStmt = stmtCache.getPreparedStatement(2);
            copyBaseStmt.setInt(1, objectID);
            copyBaseStmt.setInt(2, parentID);
            copyBaseStmt.setInt(3, tenantId);
            copyBaseStmt.setInt(4, srcID);
            CMDbConnection.executeUpdate(copyBaseStmt);
            if (newname != null) {
                CMDbStoreArrayTableUpdateDef newName = new CMDbStoreArrayTableUpdateDef("CMOBJNAMES");
                newName.addColumn((CMDbProperty)CMProperty.NAME, newname);
                newName.execute(this.getConnection(), objectID);
            } else {
                PreparedStatement copyNameStmt = stmtCache.getPreparedStatement(1);
                copyNameStmt.setInt(1, objectID);
                copyNameStmt.setInt(2, srcID);
                CMDbConnection.executeUpdate(copyNameStmt);
            }
            if (checkNameUniqueness) {
                if (srcName == null) {
                    srcName = newname;
                }
                if (srcName != null) {
                    NameUniqueness.check(this, objectID, srcName, parentID);
                } else {
                    NameUniqueness.check(this, new int[]{objectID}, parentID);
                }
            }
            CMDbObjectClass currentObjectClass = (CMDbObjectClass)classes.getClassByID(cache.CMCacheGetClass(srcID));
            BitSet tableMask = currentObjectClass.getTableMask();
            for (int i = 0; i < stmtCache.getStmtArraySize(1001); ++i) {
                PreparedStatement copyStmt = stmtCache.getPreparedStatement(1001, i);
                if (!tableMask.get(stmtCache.getTableIndex(i))) continue;
                copyStmt.setInt(1, objectID);
                copyStmt.setInt(2, srcID);
                CMDbConnection.executeUpdate(copyStmt);
            }
            if (this.isRepositoryIntegrationInstalled() && currentObjectClass.isArchivable()) {
                CMDbStoreDMLDef[] updateDefs = new CMDbStoreUpdateDef[1];
                this.addDMLDefForProperty((CMDbProperty)CMProperty._ARCHIVESTATUS, ArchivingUtil.getArchiveStatusForCopy(), updateDefs);
                ((CMDbStoreUpdateDef)updateDefs[0]).execute(this.getConnection(), objectID);
            }
            String storeId = null;
            while (!cache.CMCacheSetStoreId(objectID, storeId = CMDbStore.generateStoreId())) {
            }
            CMDbProperty storeIdProp = (CMDbProperty)CMProperty.STOREID;
            CMDbStoreUpdateDef updateIdDef = new CMDbStoreUpdateDef(storeIdProp.getColumn(0).getTable());
            updateIdDef.addColumn(storeIdProp, storeId);
            updateIdDef.execute(this.getConnection(), objectID);
            this.updateDataPathInfoIfRequired(objectID, srcObjectClass, storeId);
            if (!cache.CMCacheIsObjectExternal(srcID) && srcObjectClass.needCognosNSCAMID() && (targetCAMID = CMCAMIDHelper.replaceObjIDInInternalCAMID(objectID, srcCAMID = CMCAMIDHelper.CAMIDFromSearchPath(cache.CMCacheGetSecurityReference(srcID)))) != null) {
                this.updateInternalCAMIDInDB(targetCAMID, objectID);
            }
            successful = true;
            int n = objectID;
            return n;
        }
        catch (SQLException e) {
            try {
                if (newname == null) {
                    searchPath = cache.CMCacheGetNameOnlyPath(srcID, CMDbStoreCacheUtil.getCacheSearchLocales());
                } else {
                    searchPath = cache.CMCacheGetNameOnlyPath(parentID, CMDbStoreCacheUtil.getCacheSearchLocales());
                    searchPath = searchPath + "/" + newname.getDefault(CMExecutionContext.get().getCurrentUserContentLocale());
                }
            }
            catch (CMCacheException copyBaseStmt) {
                // empty catch block
            }
            CMDbStoreExceptionUtil.handleSQLExceptionForNewObject(this.getConnection(), e, "cmStoreUnexpectedNoCopyNoParent", true, objectID, searchPath, "cmFailedToRollbackAdd");
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException("cmErrCacheIn", new CMException.Parm("Location", "createCopyObject"));
            CMIndications.logException(cmex);
            throw new CMStoreUnexpected(e, "cmStoreUnexpectedCreateObj");
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            CMDbStoreUtil.safeCloseStatement(stmt2);
            if (!successful && objectID > 0) {
                try {
                    cache.CMCacheDeleteObject(objectID);
                }
                catch (CMCacheException e) {}
            }
        }
        return -1;
    }

    private void updateDataPathInfoIfRequired(int objectID, CMObjectClass srcObjectClass, String storeId) throws SQLException, CMException {
        CMDbProperty prop = (CMDbProperty)srcObjectClass.getProperty(CMPropertyMeaning.DATAPATHINFO);
        if (prop != null) {
            CMDbStoreUpdateDef def = new CMDbStoreUpdateDef(prop.getColumn(0).getTable());
            this.generateDataPathInfoDMLDef(prop, def, storeId);
            def.execute(this.getConnection(), objectID);
        }
    }

    @Override
    public void copyReferencesInGroup(Object groupsSet, int group, CMIntList sourceIdsList, CMIntList targetIdsList, CMIntList correctOwnerIdsList, CMStorePath ownerUser) throws CMException {
        CMDbConnection con = this.getConnection();
        int[] sourceIds = sourceIdsList.toArray();
        int[] targetIds = targetIdsList.toArray();
        int[] correctOwnerIds = correctOwnerIdsList.toArray();
        try {
            String currentUser;
            CMDbStoreCopyDef.insertCopyCMIDs(con, group, sourceIds, targetIds, this.getTempTableId());
            CMDbPropertySets propSets = this.getDbPropertySets();
            List<String> tables = propSets.getUpdateOnCopyTables();
            CMDbProperty ownerProperty = (CMDbProperty)CMProperty.OWNER;
            CMDbProperty otherrecipientsProperty = (CMDbProperty)CMProperty._OTHERRECIPIENTS;
            int numExclude = 0;
            if (ownerProperty.hasPropertyID()) {
                ++numExclude;
            }
            if (otherrecipientsProperty.hasPropertyID()) {
                ++numExclude;
            }
            int[] excludePROPIDs = new int[numExclude];
            numExclude = 0;
            if (ownerProperty.hasPropertyID()) {
                excludePROPIDs[numExclude++] = ownerProperty.getPropertyID();
            }
            if (otherrecipientsProperty.hasPropertyID()) {
                excludePROPIDs[numExclude++] = otherrecipientsProperty.getPropertyID();
            }
            for (String table : tables) {
                new CMDbStoreCopyDef(table).copyCorrectedReferences(con, group, null, excludePROPIDs, this.getTempTableId());
            }
            int objID = 0;
            if (ownerUser != null) {
                currentUser = ownerUser.getCAMIDFromFirstStep();
                for (int size = ownerUser.size(); size > 1; --size) {
                    ownerUser = ownerUser.removeStep(size - 1);
                }
                CMStorePath internalPath = CMCAMIDHelper.getInternalPathFromCAMID(ownerUser);
                objID = this.getObjectID(internalPath);
            } else {
                currentUser = CMExecutionContext.get().getCurrentUser();
                if (currentUser != null) {
                    objID = CMExecutionContext.get().getCurrentUserAccountObjectID();
                }
            }
            if (correctOwnerIds.length > 0 && currentUser != null) {
                CMDbStoreBaseClassArray owner = new CMDbStoreBaseClassArray();
                CMObjectClass objClass = CMExecutionContext.get().getStore().getObjectClass(objID);
                owner.add(new CMDbStoreObjectReference(objID, objClass, CMCAMIDHelper.SelectFromCAMID(currentUser)));
                CMDbProperty prop = (CMDbProperty)CMProperty.OWNER;
                CMDbStoreArrayTableUpdateDef updater = new CMDbStoreArrayTableUpdateDef(prop.getColumn(0).getTable());
                updater.addColumn(prop, owner);
                updater.execute(this.getConnection(), correctOwnerIds);
                int[] tempBurstOutputs = new int[targetIds.length];
                int burstCount = 0;
                for (int i = 0; i < targetIds.length; ++i) {
                    boolean isBurst;
                    if (!correctOwnerIdsList.contains(targetIds[i]) || !(isBurst = this.getCache().CMCacheGetBooleanProperty(sourceIds[i], 1))) continue;
                    tempBurstOutputs[burstCount++] = targetIds[i];
                }
                if (burstCount > 0) {
                    int[] burstOutputs = new int[burstCount];
                    System.arraycopy(tempBurstOutputs, 0, burstOutputs, 0, burstCount);
                    CMDbProperty recipProp = (CMDbProperty)CMProperty._OTHERRECIPIENTS;
                    CMDbStoreArrayTableUpdateDef updateDef = new CMDbStoreArrayTableUpdateDef(recipProp.getColumn(0).getTable());
                    updateDef.addColumn(recipProp, owner);
                    updateDef.execute(this.getConnection(), burstOutputs);
                }
            }
        }
        catch (SQLException ex) {
            throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
        }
    }

    @Override
    public void updateReferencesBetweenGroups(Object groupsSet) throws CMException {
        CMDbConnection con = this.getConnection();
        try {
            CMDbPropertySets propSets = this.getDbPropertySets();
            List<String> tables = propSets.getUpdateOnCopyTables();
            CMDbProperty ownerProperty = (CMDbProperty)CMProperty.OWNER;
            CMDbProperty otherrecipientsProperty = (CMDbProperty)CMProperty._OTHERRECIPIENTS;
            int numExclude = 0;
            if (ownerProperty.hasPropertyID()) {
                ++numExclude;
            }
            if (otherrecipientsProperty.hasPropertyID()) {
                ++numExclude;
            }
            int[] excludePROPIDs = new int[numExclude];
            numExclude = 0;
            if (ownerProperty.hasPropertyID()) {
                excludePROPIDs[numExclude++] = ownerProperty.getPropertyID();
            }
            if (otherrecipientsProperty.hasPropertyID()) {
                excludePROPIDs[numExclude++] = otherrecipientsProperty.getPropertyID();
            }
            for (String table : tables) {
                new CMDbStoreCopyDef(table).updateCorrectedReferences(con, null, excludePROPIDs, this.getTempTableId());
            }
        }
        catch (SQLException ex) {
            throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
        }
    }

    @Override
    public void cleanReferenceGroups() throws CMException {
        CMDbConnection con = this.getConnection();
        try {
            CMDbStoreCopyDef.deleteCopyCMIDs(con, this.getTempTableId());
        }
        catch (SQLException ex) {
            throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
        }
    }

    public CMDbConnection getConnection() throws CMException {
        if (!this.isConnectionValid()) {
            this.connection_ = CMDbStoreFactory.getConnection();
            this.connection_.setStore(this);
        }
        return this.connection_;
    }

    private boolean isConnectionValid() {
        try {
            return this.connection_ != null && !this.connection_.isClosed();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public CMDbTempTableId getTempTableId() throws CMException {
        if (this.tempTableId_ == null) {
            this.tempTableId_ = this.getConnection().getTmpTableId();
        }
        return this.tempTableId_;
    }

    public void releaseConnection() {
        if (this.connection_ != null) {
            CMDbStoreFactory.releaseConnection(this.connection_);
            this.connection_.setStore(null);
            this.connection_ = null;
        }
    }

    @Override
    public void doRollbackTransaction() {
        this.rollbackActions();
        this.resetTransactionState();
    }

    private void resetTransactionState() {
        this.readTransactionCount_ = 0;
        this.clearTransactionActions();
        this.baseTableLock_ = false;
    }

    @Override
    public void releaseICMDbConnection() throws CMException {
        this.releaseConnection();
    }

    @Override
    public ICMDbConnection getICMDbConnection() throws CMException {
        return this.getConnection();
    }

    @Override
    public CMCache getCache() {
        if (this.cache_ == null) {
            this.cache_ = CacheFactory.newCache(this);
        }
        return this.cache_;
    }

    String getRootObjectPath(CMObjectClass objectClass) throws CMException {
        try {
            CMCache cache = this.getCache();
            int objectID = cache.CMCacheGetConfigurationObject(objectClass.getID());
            String name = cache.CMCacheGetName(objectID, CMDbStoreCacheUtil.getCacheSearchLocales());
            return "/" + name;
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
        }
    }

    @Override
    public void initializeContentIndependentBeforeLock() throws CMException {
        if (!CMDbStoreFactory.initedContentIndependentBeforeLock_) {
            Connection con = CMDbStoreFactory.initContentIndependentBeforeLock();
            CMDbStoreSysProperties.initializeSysPropTable(con);
            CMDbStoreFactory.closeInitialConnection(con);
        }
    }

    @Override
    public void initializeContentIndependentAfterLock(boolean readOnly, CMStoreConnectionProblemReporter connectionProblemReporter) throws CMException {
        if (!CMDbStoreFactory.initedContentIndependentAfterLock_) {
            CMDbStoreFactory.initContentIndependentAfterLock(connectionProblemReporter);
        }
        if (!CMDbStoreFactory.initedContentDependent_) {
            CMDbStoreFactory.initContentDependent(true);
        }
        if (AdvancedSettings.PROTOTYPE_ENABLESTANDBYREADERS) {
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMDbStoreUtil.CMDbStoreMethodInvoker(CMDbStoreSelectDef.class, CMDbStoreSelectDef.class.getDeclaredMethod("init", new Class[0]), null), "PRECACHEINITACTIONS", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            CMDeferredInitActionUtils.executeDeferredInitActions(this.getConnection(), "PRECACHEINITACTIONS");
            this.initializeCache();
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreMembership.class.getDeclaredMethod("initialize", new Class[0]), null), "POSTINITACTIONS", null);
            }
            catch (Exception ex) {
                throw new CMStoreUnexpected(ex, "cmUnexpectedError");
            }
            CMDeferredInitActionUtils.executeDeferredInitActions(this.getConnection(), "POSTINITACTIONS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int initializeContentDependent(boolean readOnly, CMStoreConnectionProblemReporter connectionProblemReporter) throws CMException {
        try {
            CMDbStoreConsistency consistency;
            Object con2;
            if (!CMDbStoreFactory.initedContentIndependentBeforeLock_) {
                con2 = CMDbStoreFactory.initContentIndependentBeforeLock();
                CMDbStoreSysProperties.initializeSysPropTable((Connection)con2);
                CMDbStoreFactory.closeInitialConnection((Connection)con2);
            }
            if (!CMDbStoreFactory.initedContentIndependentAfterLock_) {
                CMDbStoreFactory.initContentIndependentAfterLock(connectionProblemReporter);
            }
            if (!CMDbStoreFactory.initedContentDependent_) {
                CMDbStoreFactory.initContentDependent(readOnly);
            }
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMDbStoreUtil.CMDbStoreMethodInvoker(CMDbStoreSelectDef.class, CMDbStoreSelectDef.class.getDeclaredMethod("init", new Class[0]), null), "PRECACHEINITACTIONS", null);
            }
            catch (Exception con2) {
                // empty catch block
            }
            CMDeferredInitActionUtils.executeDeferredInitActions(this.getConnection(), "PRECACHEINITACTIONS");
            if (CMDbStoreFactory.dbInitializationState_ != 2) {
                con2 = this.getConnection();
                consistency = new CMDbStoreConsistency((CMDbConnection)con2);
                consistency.performConsistencyCheckAtStartup();
            }
            CMDbStoreFactory.createTenantRegistry();
            this.initializeCache();
            try {
                CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreMembership.class.getDeclaredMethod("initialize", new Class[0]), null), "POSTINITACTIONS", null);
            }
            catch (Exception ex) {
                throw new CMStoreUnexpected(ex, "cmUnexpectedError");
            }
            CMDeferredInitActionUtils.executeDeferredInitActions(this.getConnection(), "POSTINITACTIONS");
            if (CMDbStoreFactory.dbInitializationState_ == 2) {
                con2 = this.getConnection();
                consistency = new CMDbStoreConsistency((CMDbConnection)con2);
                consistency.performConsistencyCheckAtUpgrade();
            }
        }
        finally {
            this.releaseConnection();
        }
        return CMDbStoreFactory.dbInitializationState_;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeCache() throws CMException {
        if (!g_bDoneStaticInit) {
            g_bDoneStaticInit = true;
        }
        Statement stmt = null;
        ResultSet rs = null;
        IConfiguration config = ConfigurationFactory.getConfig();
        CMCache cache = this.getCache();
        String serverLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
        int serverLocaleID = -2;
        int serverLocaleIDMapped = -2;
        if (serverLocale != null) {
            CMDbStoreStringLocale sysLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(serverLocale);
            serverLocaleID = sysLocale.getInternalID();
            serverLocaleIDMapped = sysLocale.getMappedID();
            if (serverLocaleIDMapped == -1) {
                serverLocaleIDMapped = -2;
            }
        }
        cache.CMCacheInitSystemLocale(serverLocaleID, serverLocaleIDMapped, 0);
        stmt = this.getConnection().createStatement();
        rs = stmt.executeQuery(this.getConnection().getSqlGenerator().createCacheInitClassTableSelectSql());
        cache.CMCacheInitReferenceTable(0, rs);
        stmt.close();
        rs = null;
        String sCheckPolicies = config.getInternalProp("CMCheckPolicies");
        if (sCheckPolicies != null && sCheckPolicies.equals("1")) {
            cache.initAccMan(CMServlet.getAccManInitializeDocument());
        }
        long cacheLoadTime = System.currentTimeMillis();
        int iNumObjects = AdvancedSettings.USE_LEGACY_CACHE_INIT ? this.loadCacheDataOld(cache) : this.loadCacheDataNew(cache);
        cacheLoadTime = System.currentTimeMillis() - cacheLoadTime;
        CMIndications.Audit_Message_FreeFormText("cmCacheInitComplete", new CMException.Parm[]{new CMException.Parm("NumObjects", Integer.toString(iNumObjects)), new CMException.Parm("seconds", String.format("%.2f", (double)cacheLoadTime / 1000.0))}, 50000, "StartService", "ContentManagerService", "", "Info", null);
        CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        try {
            CMDeferredInitActionUtils.addDeferredAction(new CMMethodInvoker(null, CMDbStoreMembership.class.getDeclaredMethod("initialize", new Class[0]), null), "POSTINITACTIONS", null);
            return;
        }
        catch (Exception ex) {
            throw new CMStoreUnexpected(ex, "cmUnexpectedError");
        }
        catch (CMCacheException e) {
            try {
                CMException cmex;
                if (e.getCode().equals("cmInvalidTenantContainmentOnStartup")) {
                    cmex = e;
                    throw cmex;
                }
                CMConfigurationException configE = new CMConfigurationException((Throwable)e, "cmErrCacheOnLoad");
                cmex = new CMException(configE, "cmNoCache");
                CMIndications.logException(cmex);
                throw cmex;
                catch (SQLException e2) {
                    CMException configE2 = new CMException(e2, "cmErrCacheOnLoad");
                    CMIndications.logException(configE2);
                    CMException ex = CMDbStoreExceptionUtil.analyzeSQLException(this.getConnection(), e2, "cmNoCache");
                    if (!(ex instanceof CMStoreNotAvailable)) throw new CMConfigurationException((Throwable)configE2, "cmNoCache");
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadCacheDataOld(CMCache cache) throws SQLException, CMException {
        int n;
        ResultSet rs = null;
        Statement stmt = null;
        CMDbConnection con = this.getConnection();
        try {
            String cacheInitSelectString = this.getCacheInitSelectString(con);
            String useCMLargeResultSet = System.getProperty("useCMLargeResultSet");
            if ("true".equalsIgnoreCase(useCMLargeResultSet)) {
                rs = new CMDbLargeResultSet(cacheInitSelectString, con, "order by b.CMID", "and b.cmid >=  ? and b.cmid < ?");
                ((CMDbLargeResultSet)rs).setFetchIncremental(100000);
            } else {
                stmt = con.createStatement();
                rs = stmt.executeQuery(cacheInitSelectString);
            }
            n = cache.initialize(rs);
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        return n;
    }

    private int loadCacheDataNew(CMCache cache) throws CMException {
        return cache.initialize(this.getConnection());
    }

    private void deinitializeCache() throws CMException {
        if (!g_bDoneStaticInit) {
            g_bDoneStaticInit = true;
        }
        try {
            CMCache cache = this.getCache();
            cache.CMCacheClear();
        }
        catch (CMCacheException e) {
            CMConfigurationException configE = new CMConfigurationException((Throwable)e, "cmErrCacheOnLoad");
            CMException cmex = new CMException(configE, "cmNoCache");
            CMIndications.logException(cmex);
            throw cmex;
        }
    }

    private String getCacheInitSelectString(CMDbConnection dbConnection) {
        return dbConnection.getSqlGenerator().createCacheInitSelectSql();
    }

    @Override
    public void deinitializeContentDependent() throws CMException {
        this.deinitializeCache();
        CMDbStoreFactory.dbInitializationState_ = 0;
    }

    @Override
    public ResultSet getCacheObjectChildren(int obj_idParent) throws CMException {
        ResultSet rs;
        try {
            PreparedStatement stmt = this.getConnection().prepareStatement(this.getConnection().getSqlGenerator().createCacheGetChildrenSql());
            stmt.setInt(1, obj_idParent);
            stmt.setInt(2, obj_idParent);
            CMExecutionContext.checkCancelOrTimeOut();
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            CMException configE = new CMException(e, "cmErrCacheOnLoad");
            CMIndications.logException(configE);
            CMException ex = CMDbStoreExceptionUtil.analyzeSQLException(this.getConnection(), e, "cmErrCacheOnLoad");
            if (ex instanceof CMStoreNotAvailable) {
                throw ex;
            }
            throw new CMConfigurationException((Throwable)configE, "cmNoCache");
        }
        return rs;
    }

    @Override
    public ResultSet getCacheObjects(int obj_idStart, int obj_idEnd) throws CMException {
        ResultSet rs;
        try {
            PreparedStatement stmt = this.getConnection().prepareStatement(this.getConnection().getSqlGenerator().createCacheGetObjectsSql());
            stmt.setInt(1, obj_idStart);
            stmt.setInt(2, obj_idEnd);
            stmt.setInt(3, obj_idStart);
            stmt.setInt(4, obj_idEnd);
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            CMException configE = new CMException(e, "cmErrCacheOnLoad");
            CMIndications.logException(configE);
            CMException ex = CMDbStoreExceptionUtil.analyzeSQLException(this.getConnection(), e, "cmNoCache");
            if (ex instanceof CMStoreNotAvailable) {
                throw ex;
            }
            throw new CMConfigurationException((Throwable)configE, "cmNoCache");
        }
        return rs;
    }

    @Override
    public void beginTransaction() throws CMException {
        if (this.readTransactionCount_ != 0) {
            Collection<String> col;
            if (this.readTransactionCount_ == -1) {
                throw new IllegalStateException("Transaction already started");
            }
            String msg = "In a read transaction";
            if (dbgGetReadTransStackTrace_ && this.readTrans_ != null && (col = this.readTrans_.values()) != null) {
                Iterator<String> iter = col.iterator();
                while (iter.hasNext()) {
                    msg = msg + "Read transaction started at -\n" + iter.next() + "\n";
                }
                msg = msg + "End of read transaction list\n";
            }
            throw new IllegalStateException(msg);
        }
        try {
            this.getConnection().beginTransaction();
            this.readTransactionCount_ = -1;
        }
        catch (SQLException e) {
            CMDbStoreExceptionUtil.handleSQLException(this.getConnection(), e, "cmUnexpectedTransactionFailure");
        }
    }

    @Override
    public void commitTransaction() throws CMException {
        if (!this.inTransaction()) {
            throw new IllegalStateException("Not in a transaction");
        }
        try {
            this.getConnection().commitTransaction();
            this.commitActions();
        }
        catch (SQLException e) {
            this.rollbackActions();
            CMDbStoreExceptionUtil.handleSQLException(this.getConnection(), e, "cmUnexpectedTransactionFailure");
        }
        finally {
            this.resetTransactionState();
        }
    }

    @Override
    public void rollbackTransaction() throws CMException {
        if (!this.inTransaction()) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.doRollbackTransaction();
        try {
            this.getConnection().rollbackTransaction();
        }
        catch (SQLException e) {
            try {
                CMDbStoreExceptionUtil.handleSQLException(this.getConnection(), e, "cmUnexpectedTransactionFailure");
            }
            catch (Exception ex) {
                CMIndications.logException(ex);
            }
        }
        catch (Exception ce) {
            CMIndications.logException(ce);
        }
    }

    @Override
    public void rollbackOpenTransaction() throws CMException {
        if (this.inTransaction()) {
            this.rollbackTransaction();
        }
    }

    private void clearTransactionActions() {
        this.transactionActions.clear();
        this.postTransactionActions.clear();
    }

    @Override
    public boolean inTransaction() {
        return this.readTransactionCount_ == -1;
    }

    void addTransactionAction(CMDbStoreTransactionAction action) {
        this.transactionActions.add(action);
    }

    void addPostTransactionAction(CMDbStoreTransactionAction action) {
        this.postTransactionActions.add(action);
    }

    void commitActions() {
        this.commitActions(this.transactionActions);
        this.commitActions(this.postTransactionActions);
    }

    private void commitActions(List<CMDbStoreTransactionAction> actions) {
        for (CMDbStoreTransactionAction action : actions) {
            action.commit();
        }
    }

    void rollbackActions() {
        this.rollbackActions(this.postTransactionActions);
        this.rollbackActions(this.transactionActions);
    }

    private void rollbackActions(List<CMDbStoreTransactionAction> actions) {
        for (int i = actions.size() - 1; i >= 0; --i) {
            CMDbStoreTransactionAction action = actions.get(i);
            action.rollback();
        }
    }

    static void releaseReadTransaction(ReadTransactionHandle handle) {
        try {
            if (handle != null) {
                handle.release();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] getPolicy(int obj_id) {
        ReadTransactionHandle rtHandle;
        PreparedStatement stmt;
        byte[] policy;
        block6: {
            Integer objectID = new Integer(obj_id);
            if (!this.getCache().CMCacheGetBooleanProperty(obj_id, 4)) {
                return null;
            }
            policy = CMDbStoreFactory.policyCache_.get(objectID);
            if (policy != null) {
                return policy;
            }
            ResultSet rs = null;
            stmt = null;
            rtHandle = null;
            try {
                rtHandle = this.beginReadTransaction();
                stmt = this.getConnection().prepareStatement(this.getConnection().getSqlGenerator().createGetPoliciesOfOneObjectSql());
                stmt.setInt(1, obj_id);
                rs = stmt.executeQuery();
                if (!rs.next() || (policy = (byte[])CMDbStorePropertySerialization.getColumnByProperty(rs, 2, CMProperty.POLICIES)) == null) break block6;
                CMDbStoreFactory.policyCache_.add(objectID, policy);
            }
            catch (Exception exception) {
                CMDbStoreUtil.safeCloseStatement(stmt);
                CMDbStore.releaseReadTransaction(rtHandle);
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    CMDbStore.releaseReadTransaction(rtHandle);
                    throw throwable;
                }
            }
        }
        CMDbStoreUtil.safeCloseStatement(stmt);
        CMDbStore.releaseReadTransaction(rtHandle);
        return policy;
    }

    @Override
    public ResultSet getPolicies(int[] obj_ids) throws Exception {
        if (obj_ids.length == 0) {
            return null;
        }
        CMDbStorePolicyResultSet policyRS = new CMDbStorePolicyResultSet();
        int[] noCachedPolicyObjectIDs = new int[obj_ids.length];
        int noCachedPolicyObjectIDsCount = 0;
        for (int i = 0; i < obj_ids.length; ++i) {
            Integer objectID = new Integer(obj_ids[i]);
            if (!this.getCache().CMCacheGetBooleanProperty(obj_ids[i], 4)) continue;
            byte[] policy = CMDbStoreFactory.policyCache_.get(objectID);
            if (policy == null) {
                noCachedPolicyObjectIDs[noCachedPolicyObjectIDsCount++] = obj_ids[i];
                continue;
            }
            policyRS.addEntry(objectID, policy);
        }
        if (noCachedPolicyObjectIDsCount == 0) {
            return policyRS;
        }
        ResultSet rs = null;
        ReadTransactionHandle rtHandle = null;
        PreparedStatement stmt = null;
        try {
            rtHandle = this.beginReadTransaction();
            int previousBindObjectIDsNumber = -1;
            StringBuffer command = new StringBuffer();
            int maxObjectsInGroup = CMDbConnection.getMaxObjectsInline();
            for (int j = 0; j < noCachedPolicyObjectIDsCount; j += maxObjectsInGroup) {
                int maxObjectIndex = Math.min(noCachedPolicyObjectIDsCount, j + maxObjectsInGroup);
                int bindObjectIDsNumber = maxObjectIndex - j;
                if (bindObjectIDsNumber != previousBindObjectIDsNumber) {
                    CMDbStoreDMLDef.constructStatementWithCMIDBindVariables(this.getConnection(), command, this.getConnection().getSqlGenerator().createGetPoliciesBeginSql(), bindObjectIDsNumber);
                    previousBindObjectIDsNumber = bindObjectIDsNumber;
                    CMDbStoreUtil.safeCloseStatement(stmt);
                    stmt = this.getConnection().prepareStatement(command.toString());
                }
                CMDbStoreDMLDef.bindCMIDs(1, stmt, noCachedPolicyObjectIDs, j, maxObjectIndex);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Integer objectID = new Integer(rs.getInt(1));
                    byte[] policy = (byte[])CMDbStorePropertySerialization.getColumnByProperty(rs, 2, CMProperty.POLICIES);
                    if (policy == null) continue;
                    CMDbStoreFactory.policyCache_.add(objectID, policy);
                    policyRS.addEntry(objectID, policy);
                }
            }
        }
        catch (SQLException ex) {
            CMException exception = CMDbStoreExceptionUtil.analyzeSQLException(this.getConnection(), ex, "cmStoreUnexpectedErrAquirePolicy");
            if (exception instanceof CMStoreNotAvailable) {
                this.releaseConnection();
            }
            throw exception;
        }
        finally {
            CMDbStoreUtil.safeCloseStatement(stmt);
            CMDbStore.releaseReadTransaction(rtHandle);
        }
        return policyRS;
    }

    @Override
    public String getPathUsingId(int id) throws CMException {
        try {
            CMCache cache = this.getCache();
            String cpath = cache.CMCacheGetNameOnlyPath(id, CMDbStoreCacheUtil.getCacheSearchLocales());
            return cpath;
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cache exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean currentUserCanAccessCredential(String credentialPath, boolean pathIsAccount) throws CMException {
        boolean bFoundCredential = false;
        CMStoreQueryResults credentialresults = null;
        try {
            Object credentialValueObject;
            CMProperty[] props;
            CMStoreXPath credentialContext;
            if (pathIsAccount) {
                credentialPath = credentialPath + "/credential";
            }
            if ((credentialresults = this.executeQuery(credentialContext = new CMStoreXPath(credentialPath + "[permission(\"read\") or permission(\"execute\")]", 10), props = new CMProperty[]{CMProperty.CREDENTIALS}, null, 0, 16384, null)) != null && credentialresults.next() && (credentialValueObject = credentialresults.getValue(0)) != null) {
                bFoundCredential = true;
            }
        }
        finally {
            if (credentialresults != null) {
                credentialresults.release();
            }
        }
        return bFoundCredential;
    }

    @Override
    public int[] getAncestorObjects(ICMStorePath storePath) throws CMException {
        CMCacheQueryInstance cachQinst = null;
        try {
            cachQinst = this.getCache().executeAdminQuery(storePath, 0);
            if (cachQinst.count() > 0) {
                int[] nArray = cachQinst.getAncestorObjects(0);
                return nArray;
            }
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cache exception");
        }
        catch (CMCacheAccessDenied exad) {
            throw new CMStoreUnexpected(exad, "cache denial exception");
        }
        finally {
            try {
                if (cachQinst != null) {
                    cachQinst.release();
                }
            }
            catch (CMCacheException cMCacheException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDescendantOrSelf(ICMStorePath storePathA, ICMStorePath storePathB) throws CMException {
        try {
            CMCacheQueryInstance cachQinst = null;
            int objectBId = 0;
            try {
                cachQinst = this.getCache().executeAdminQuery(storePathB, 0);
                if (cachQinst.count() != 1) {
                    boolean bl = false;
                    return bl;
                }
                objectBId = cachQinst.resultObjects()[0];
            }
            finally {
                try {
                    if (cachQinst != null) {
                        cachQinst.release();
                    }
                }
                catch (CMCacheException cMCacheException) {}
            }
            cachQinst = null;
            try {
                cachQinst = this.getCache().executeAdminQuery(storePathA, 0);
                if (cachQinst.count() != 1) {
                    boolean bl = false;
                    return bl;
                }
                int objectAId = cachQinst.resultObjects()[0];
                if (objectAId != 0 && objectAId == objectBId) {
                    boolean bl = true;
                    return bl;
                }
                int[] ancestors = cachQinst.getAncestorObjects(0);
                if (ancestors == null) return false;
                int i = 0;
                while (i < ancestors.length) {
                    if (ancestors[i] == objectBId) {
                        boolean bl = true;
                        return bl;
                    }
                    ++i;
                }
                return false;
            }
            finally {
                try {
                    if (cachQinst != null) {
                        cachQinst.release();
                    }
                }
                catch (CMCacheException cMCacheException) {}
            }
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cache exception");
        }
        catch (CMCacheAccessDenied exad) {
            throw new CMStoreUnexpected(exad, "cache denial exception");
        }
    }

    @Override
    public String getDisplayPathFromSearchPath(CMStorePath storePath) throws CMException {
        CMIPFData data = this.getIPFDataFromSearchPath(storePath);
        if (data == null) {
            return null;
        }
        return data.getDisplayPath();
    }

    @Override
    public CMIPFData getIPFDataFromSearchPath(CMStorePath storePath) throws CMException {
        try {
            CMIPFData data = this.getCache().getIPFDataFromSearchPath(storePath, CMDbStoreCacheUtil.getCacheSearchLocales());
            return data;
        }
        catch (CMCacheAccessDenied e) {
            CMDbStoreSecurityUtil.convertAccessDeniedException(this.getCache(), e);
            return null;
        }
    }

    @Override
    public void terminate() throws CMException {
        CMDbStoreFactory.terminate();
    }

    @Override
    public String getRunningContentStoreName() throws CMException {
        return CMDbStoreMultipleCMsUtil.getInstance().getRunningContentStoreName();
    }

    @Override
    public void addedContentManagerService(int obj_id, Object dispatcherPath, Object dispatcherCapacity) throws CMException {
        if (dispatcherPath != null) {
            String path = dispatcherPath.toString();
            CMDbConnection con = this.getConnection();
            CMDbStoreMultipleCMsUtil.getInstance().addedContententManagerService(con, obj_id, path, dispatcherCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatedCapacityProperty(int[] objectIds, Double capacity) throws CMException {
        for (int i = 0; i < objectIds.length; ++i) {
            String searchPath = this.getObjectSearchPath(objectIds[i]);
            CMStoreXPath path = new CMStoreXPath(searchPath);
            CMStoreXPath descendantQuery = new CMStoreXPath(path, "descendant-or-self::*[@objectClass = 'dispatcher']", false);
            boolean operation = false;
            int permissions = 512;
            CMProperty[] properties = new CMProperty[]{CMProperty.DISPATCHERPATH, CMProperty.CAPACITY};
            CMStoreQueryResults descendantResults = this.executeQuery(descendantQuery, properties, null, 0, permissions, null);
            CMDbConnection con = this.getConnection();
            PreparedStatement updateStmt = null;
            try {
                updateStmt = CMDbStoreMultipleCMsUtil.getInstance().createUpdateCapacityStatement(con);
                while (descendantResults.next()) {
                    Object dispatcherPathObject = descendantResults.getValue(0);
                    if (dispatcherPathObject == null) continue;
                    Object dispatcherCapacityObject = descendantResults.getValue(1);
                    Double dispatcherCapacity = dispatcherCapacityObject == null ? capacity : new Double(dispatcherCapacityObject.toString());
                    CMDbStoreMultipleCMsUtil.getInstance().executeUpdateCapacityStatement(updateStmt, dispatcherPathObject.toString(), dispatcherCapacity);
                }
                continue;
            }
            finally {
                CMDbStoreUtil.safeCloseStatement(updateStmt);
                descendantResults.release();
            }
        }
    }

    private void updatedDispatcherPathProperty(ArrayList<String> oldDispatcherPathes, Object newDispatcherPathObject) throws CMException {
        CMDbConnection con = this.getConnection();
        for (int i = 0; i < oldDispatcherPathes.size(); ++i) {
            CMDbStoreMultipleCMsUtil.getInstance().updatedDispatcherPath(con, oldDispatcherPathes.get(i), newDispatcherPathObject.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getDispatcherPaths(int[] objectIds) throws CMException {
        ArrayList<String> dispatcherPaths = new ArrayList<String>();
        CMProperty[] properties = new CMProperty[]{CMProperty.DISPATCHERPATH};
        CMStoreQueryResults queryResults = this.executeQuery(objectIds, properties, null, 0, 512, null);
        try {
            while (queryResults.next()) {
                Object valueObject = queryResults.getValue(0);
                String dispatcherPathValue = null;
                if (valueObject == null) continue;
                if (valueObject instanceof Reader) {
                    Reader stream = null;
                    stream = (Reader)valueObject;
                    try {
                        dispatcherPathValue = CMStreamUtils.readReaderIntoString((Reader)stream);
                        stream.close();
                        stream = null;
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    dispatcherPathValue = valueObject.toString();
                }
                if (dispatcherPathValue == null) continue;
                dispatcherPaths.add(dispatcherPathValue);
            }
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(queryResults);
        }
        return dispatcherPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatedDefaultActiveCMProperty(int[] objectIds) throws CMException {
        CMDbConnection con = this.getConnection();
        for (int i = 0; i < objectIds.length; ++i) {
            String contentManagerServicePathString = this.getObjectSearchPath(objectIds[i]);
            if (contentManagerServicePathString == null) continue;
            CMStoreXPath dispatcherPath = new CMStoreXPath(contentManagerServicePathString + "/..");
            CMProperty[] properties = new CMProperty[]{CMProperty.DISPATCHERPATH};
            CMStoreQueryResults cmQresults = null;
            cmQresults = this.executeQuery(dispatcherPath, properties, null, 0, 512, null);
            try {
                if (cmQresults == null || !cmQresults.next()) continue;
                Object valueObject = cmQresults.getValue(0);
                String dispatcherPathValue = null;
                if (valueObject == null) continue;
                if (valueObject instanceof Reader) {
                    Reader stream = null;
                    stream = (Reader)valueObject;
                    try {
                        dispatcherPathValue = CMStreamUtils.readReaderIntoString((Reader)stream);
                        stream.close();
                        stream = null;
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                } else {
                    dispatcherPathValue = valueObject.toString();
                }
                if (dispatcherPathValue == null) continue;
                CMDbStoreMultipleCMsUtil.getInstance().makeUniqueDefaultContentManagerService(con, objectIds[i], dispatcherPathValue);
                continue;
            }
            finally {
                CMQueryUtils.safeQueryResultsRelease(cmQresults);
            }
        }
    }

    public static String generateStoreId() {
        CMUUID uuid = new CMUUID();
        return uuid.toStoreID().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getDirectoryStoreID() throws CMException {
        if (null == m_directoryStoreID) {
            CMStoreQueryResults results;
            block3: {
                results = null;
                try {
                    CMStoreXPath xpath = new CMStoreXPath("/directory");
                    results = this.executeQuery(xpath, null, null, 0, 512, null);
                    if (!results.next()) break block3;
                    m_directoryStoreID = this.getObjectStoreID(results.getObjectID());
                }
                catch (Throwable throwable) {
                    CMQueryUtils.safeQueryResultsRelease(results);
                    throw throwable;
                }
            }
            CMQueryUtils.safeQueryResultsRelease(results);
        }
        return m_directoryStoreID;
    }

    @Override
    public CMException analyzeException(Exception ex) {
        if (ex instanceof CMException) {
            return (CMException)ex;
        }
        if (ex instanceof SQLException) {
            try {
                CMException e = CMDbStoreExceptionUtil.analyzeSQLException(this.getConnection(), (SQLException)ex, "cmUnexpectedError");
                return e;
            }
            catch (CMException cmex) {
                return cmex;
            }
        }
        return new CMStoreUnexpected(ex, "cmUnexpectedError");
    }

    private CMDbStoreDMLDef sortUpdateDefs(CMDbStoreDMLDef[] addDefs) {
        int i;
        Object[] addDefsSorted = new Object[addDefs.length];
        int count = 0;
        CMDbStoreDMLDef CMOBJECTSDef = null;
        for (int i2 = 0; i2 < addDefs.length; ++i2) {
            if (addDefs[i2] == null || !addDefs[i2].getTableName().equalsIgnoreCase("CMOBJECTS")) continue;
            addDefsSorted[count] = addDefs[i2];
            ++count;
            CMOBJECTSDef = addDefs[i2];
        }
        int startSortFrom = count;
        for (i = 0; i < addDefs.length; ++i) {
            if (addDefs[i] == null || addDefs[i].getTableName().equalsIgnoreCase("CMOBJECTS")) continue;
            addDefsSorted[count] = addDefs[i];
            ++count;
        }
        i = startSortFrom;
        int t = 1;
        while (i < count - 1) {
            for (int j = startSortFrom; j < count - t; ++j) {
                if (((CMDbStoreDMLDef)addDefsSorted[j + 1]).getTableName().compareTo(((CMDbStoreDMLDef)addDefsSorted[j]).getTableName()) >= 0) continue;
                Object tmp = addDefsSorted[j + 1];
                addDefsSorted[j + 1] = addDefsSorted[j];
                addDefsSorted[j] = tmp;
            }
            ++i;
            ++t;
        }
        for (i = 0; i < addDefs.length; ++i) {
            addDefs[i] = (CMDbStoreDMLDef)addDefsSorted[i];
        }
        return CMOBJECTSDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<CMDbStoreNotification> getDeletedScheduleNotifications(CMIntList scheduleObjectIDs) throws CMException {
        ArrayList<CMDbStoreNotification> notifications = null;
        CMStoreQueryResults scheduleResults = null;
        try {
            scheduleResults = this.executeQuery(scheduleObjectIDs.toArray(), new CMProperty[]{CMProperty.STOREID, CMProperty.TASKID}, null, 0, 512, null);
            if (scheduleResults != null && scheduleResults.next()) {
                do {
                    String storeID = null;
                    Object value = scheduleResults.getValue(0);
                    if (value != null) {
                        storeID = value.toString();
                    }
                    String taskID = null;
                    value = scheduleResults.getValue(1);
                    if (value != null) {
                        taskID = value.toString();
                    }
                    if (storeID == null || storeID.length() <= 0 || taskID == null || taskID.length() <= 0) continue;
                    HashMap<CMProperty, Object> propValues = new HashMap<CMProperty, Object>();
                    propValues.put(CMProperty.TASKID, taskID);
                    CMDbStoreNotification notification = new CMDbStoreNotification(storeID, CMObjectClass.SCHEDULE, 2, propValues);
                    if (notifications == null) {
                        notifications = new ArrayList<CMDbStoreNotification>();
                    }
                    notifications.add(notification);
                } while (scheduleResults.next());
            }
        }
        finally {
            if (scheduleResults != null) {
                scheduleResults.release();
            }
        }
        return notifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<CMObjectID> getIDs(CMStorePathStep firstStep, OrderByField[] orderByFields) throws CMException {
        ArrayList<CMObjectID> IDList = new ArrayList<CMObjectID>();
        ResultSet rs = null;
        try {
            CMProperty[] props = new CMProperty[]{CMProperty.STOREID};
            CMDbStoreSelectDef descendantQuery = new CMDbStoreSelectDef(this.getConnection(), firstStep, props, orderByFields, false, false, null, false, null, null, true, 0);
            rs = descendantQuery.execute(this.getConnection());
            while (rs.next()) {
                CMObjectID idObj = new CMObjectID(rs.getInt(1), rs.getString(2));
                IDList.add(idObj);
            }
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(this.getConnection(), ex, "cmUnexpectedResultProcessingFailure");
        }
        finally {
            CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
        }
        return IDList;
    }

    void lockBaseTable() throws SQLException, CMException {
        if (!this.inTransaction()) {
            throw new IllegalStateException("The lockBaseTable() method must be called within a transaction");
        }
        if (!this.baseTableLock_) {
            String lockTableStr = null;
            if (CMDbConnection.dbms_ == 5) {
                lockTableStr = "lock table CMOBJECTS in exclusive mode";
            }
            if (lockTableStr != null) {
                PreparedStatement lockStmt = null;
                try {
                    lockStmt = this.getConnection().prepareStatement(lockTableStr);
                    lockStmt.execute();
                }
                catch (Throwable throwable) {
                    CMDbStoreUtil.safeCloseStatement(lockStmt);
                    throw throwable;
                }
                CMDbStoreUtil.safeCloseStatement(lockStmt);
            }
            this.baseTableLock_ = true;
        }
    }

    @Override
    public void lockObjectsInDatabase(int[] objectIds) throws CMException {
        String msg = "The lockObjectsInDatabase method must be called within a transaction";
        if (!this.inTransaction()) {
            throw new IllegalStateException("The lockObjectsInDatabase method must be called within a transaction");
        }
        try {
            CMDbStoreUtil.lockObjectsInDatabase(this.getConnection(), objectIds);
        }
        catch (SQLException ex) {
            CMException cmex = CMDbStoreExceptionUtil.analyzeSQLException(this.getConnection(), ex, "cmStoreUnexpected");
            throw cmex;
        }
    }

    @Override
    public CMStoreMetadata getMetadata() {
        if (this.metadata_ == null) {
            this.metadata_ = CMDbStoreFactory.getMetadata();
        }
        if (this.metadata_ == null) {
            throw new IllegalStateException("CMStoreMetadata has not been initialized");
        }
        return this.metadata_;
    }

    public CMDbProperty getDbProperty(CMProperty prop) {
        return (CMDbProperty)prop;
    }

    @Override
    public Plugin getSearchPathFunction(String funcName) {
        Plugin function = this.pluginFactory_.getSearchPathFunction(this, funcName);
        return function;
    }

    @Override
    public PropertyPlugin getPropertyFunction(String propName) {
        PropertyPlugin function = this.pluginFactory_.getPropertyFunction(this, propName);
        return function;
    }

    @Override
    public CMProperty getProperty(String propName, CMObjectClass objectClass) {
        return CMDbStoreFactory.propertySets_.getPropertySet().getProperty(propName, objectClass);
    }

    public AAAProvider getAAA() {
        return CMServlet.AAA;
    }

    @Override
    public ICMLockManager getLockManager() {
        return this.getCache().getLockManager();
    }

    @Override
    public String getImplementation() {
        return "CMDbStore - " + this.getCache().getImplementation();
    }

    @Override
    public int removeReferencesToNonexistentObjects() throws CMException {
        CMDbStoreIDReferencesUtil IDReferencesHelper = new CMDbStoreIDReferencesUtil();
        return IDReferencesHelper.deleteInconsistentReferences(this);
    }

    @Override
    public ICMDbObjectClasses getICMDbObjectClasses() {
        return CMDbStoreFactory.objectClasses_;
    }

    @Override
    public String generateUniqueName(int objId) {
        return this.getCache().CMCacheGenerateUniqueName(objId);
    }

    protected boolean isRepositoryIntegrationInstalled() {
        if (this.isRepositoryIntegrationInstalled_NeedsInitialValue_) {
            this.isRepositoryIntegrationInstalled_ = this.getRepositoryIntegrationInstallStatus();
            this.isRepositoryIntegrationInstalled_NeedsInitialValue_ = false;
        }
        return this.isRepositoryIntegrationInstalled_;
    }

    protected boolean getRepositoryIntegrationInstallStatus() {
        ArchivingUtil archivingUtil = new ArchivingUtil();
        return archivingUtil.isRepositoryIntegrationInstalled();
    }

    @Override
    public TenantRegistry getTenantRegistry() {
        return this.tenantRegistry;
    }

    static {
        g_bDoneStaticInit = false;
        cognosNSId_ = -1;
        Properties sysProps = System.getProperties();
        dbgGetReadTransStackTrace_ = sysProps.containsKey(sDebugReadTransKey_);
    }

    public static class IntArray {
        public int[] array_;
        public int size_;

        public IntArray(int size) {
            this.array_ = new int[size];
        }

        public int search(int id) {
            int lo = 0;
            int hi = this.size_ - 1;
            int mid = 0;
            while (hi >= lo) {
                mid = (hi + lo) / 2;
                if (this.array_[mid] == id) {
                    return mid;
                }
                if (this.array_[mid] < id) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            if (this.size_ > 0 && id > this.array_[mid]) {
                ++mid;
            }
            return -mid - 1;
        }

        public boolean add(int id) {
            int index = this.search(id);
            if (index >= 0) {
                return false;
            }
            index = -(index + 1);
            int[] array = this.array_;
            if (this.size_ + 1 > this.array_.length) {
                array = new int[this.array_.length + 10];
                System.arraycopy(this.array_, 0, array, 0, index);
            }
            System.arraycopy(this.array_, index, array, index + 1, this.size_ - index);
            array[index] = id;
            ++this.size_;
            if (array != this.array_) {
                this.array_ = array;
            }
            return true;
        }

        public void remove(int id) {
            int index = this.search(id);
            if (index < 0) {
                return;
            }
            --this.size_;
            if (index != this.size_) {
                System.arraycopy(this.array_, index + 1, this.array_, index, this.size_ - index);
            }
        }

        public void subtract(IntArray subtrahend) {
            for (int i = 0; i < subtrahend.size_; ++i) {
                this.remove(subtrahend.array_[i]);
            }
        }
    }

    final class ReadTransactionHandleImpl
    extends ReadTransactionHandle {
        private boolean released_;

        ReadTransactionHandleImpl() {
            if (dbgGetReadTransStackTrace_) {
                if (CMDbStore.this.readTrans_ == null) {
                    CMDbStore.this.readTrans_ = new HashMap();
                }
                CMDbStore.this.readTrans_.put(this, CMIndications.getStacktraceText_Trimmed());
            }
        }

        @Override
        public void release() throws CMException, SQLException {
            try {
                if (!this.released_) {
                    CMDbStore.this.endReadTransaction();
                }
            }
            finally {
                this.released_ = true;
            }
            if (dbgGetReadTransStackTrace_) {
                CMDbStore.this.readTrans_.remove(this);
            }
        }
    }

    static abstract class ReadTransactionHandle {
        ReadTransactionHandle() {
        }

        public abstract void release() throws CMException, SQLException;
    }
}

