/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMAcquiredPropertySubscriber;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreAcquiredValue;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class CMDbStoreAcquiredPropertiesHandler {
    CMProperty[] properties_;
    CMDbStoreSelectDef acquiredQuery_;
    CMDbStoreSelectDef selectStmt_;
    HashMap<Integer, CMDbStoreAcquiredValue[]> cachedValues_ = new HashMap();
    CMDbStore store_;
    private ArrayList<CMProperty> requiresAcquiredValue_ = new ArrayList();
    private HashMap<CMProperty, CMAcquiredPropertySubscriber> acquiredValueSubscribers_;
    private HashMap<CMProperty, CMDbStoreAcquiredValue> acquiredValues_;
    private HashMap<CMProperty, CMProperty> mappedProperties = new HashMap();

    CMDbStoreAcquiredPropertiesHandler(CMDbStore store, CMDbStoreSelectDef baseQuery) {
        this.selectStmt_ = baseQuery;
        this.store_ = store;
    }

    private void updateCache(int objectID, CMDbStoreAcquiredValue[] values) {
        if (values == null) {
            return;
        }
        if (this.cachedValues_.get(objectID) != null) {
            this.cachedValues_.put(objectID, values);
        }
    }

    void subscribeToAcquiredValue(CMProperty prop, CMAcquiredPropertySubscriber handler) {
        if (this.acquiredValueSubscribers_ == null) {
            this.acquiredValueSubscribers_ = new HashMap();
        }
        this.acquiredValueSubscribers_.put(this.getMappedProperty(prop), handler);
    }

    void requiresAcquiredValue(CMProperty prop) {
        this.requiresAcquiredValue_.add(this.getMappedProperty(prop));
    }

    void addAcquiredValue(CMProperty prop, Object value, int acquiredFrom) {
        if (this.acquiredValues_ == null) {
            this.acquiredValues_ = new HashMap();
        }
        this.acquiredValues_.put(this.getMappedProperty(prop), new CMDbStoreAcquiredValue(value, acquiredFrom));
    }

    private void init() throws CMException {
        if (this.acquiredQuery_ == null) {
            this.acquiredQuery_ = this.selectStmt_.getInheritanceQuery(this.store_.getConnection());
            if (this.acquiredQuery_ != null) {
                this.properties_ = this.acquiredQuery_.getProperties();
            }
        }
    }

    private boolean requiresPopulation() {
        return this.requiresAcquiredValue_ != null && this.requiresAcquiredValue_.size() > 0;
    }

    private boolean requiresPopulation(CMProperty prop) {
        return this.requiresAcquiredValue_.remove(prop);
    }

    protected void publishValue(CMProperty prop, CMDbStoreAcquiredValue value) {
        CMProperty targetProp = this.getMappedProperty(prop);
        if (this.acquiredValueSubscribers_ != null && this.acquiredValueSubscribers_.containsKey(targetProp)) {
            this.acquiredValueSubscribers_.get(targetProp).acquiredValuePublished(value);
            this.acquiredValueSubscribers_.remove(targetProp);
        }
    }

    private boolean hasPreviouslyAcquiredValue(CMProperty prop) {
        return this.acquiredValues_ != null && this.acquiredValues_.containsKey(this.getMappedProperty(prop));
    }

    public HashMap<CMProperty, CMDbStoreAcquiredValue> populateAcquiredValues(int objectId, Object[] values, BitSet acquiredSet) throws CMException {
        if (!this.requiresPopulation()) {
            return null;
        }
        int[] columnMap = this.selectStmt_.getDbPropertyMap();
        CMProperty[] properties = this.selectStmt_.getProperties();
        HashMap<CMProperty, CMDbStoreAcquiredValue> acquiredProps = null;
        CMDbConnection con = this.store_.getConnection();
        try {
            int[] ancestors = this.getAncestorIDs(objectId);
            CMDbStoreAcquiredValue[] ancestorValues = this.getValues(ancestors);
            if (ancestors != null && ancestors.length > 0 && ancestorValues != null) {
                int[] inheritedPropertyMap = this.selectStmt_.getInheritedPropertyMap();
                CMDbStoreAcquiredValue[] curValues = new CMDbStoreAcquiredValue[ancestorValues.length];
                for (int propIdx = 0; propIdx != ancestorValues.length; ++propIdx) {
                    int valueIdx = inheritedPropertyMap[propIdx];
                    CMProperty iProp = properties[columnMap[valueIdx]];
                    CMDbStoreAcquiredValue acquiredProp = new CMDbStoreAcquiredValue(values[valueIdx], objectId);
                    if (this.requiresPopulation(iProp)) {
                        acquiredProp = this.hasPreviouslyAcquiredValue(iProp) ? this.acquiredValues_.get(iProp) : ancestorValues[propIdx];
                        acquiredSet.set(valueIdx);
                        if (acquiredProps == null) {
                            acquiredProps = new HashMap<CMProperty, CMDbStoreAcquiredValue>();
                        }
                        acquiredProps.put(iProp, acquiredProp);
                        values[valueIdx] = acquiredProp.getValue();
                        this.publishValue(iProp, acquiredProp);
                    }
                    curValues[propIdx] = acquiredProp;
                }
                this.updateCache(objectId, curValues);
            }
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmUnexpectedResultProcessingFailure");
        }
        this.reset();
        return acquiredProps;
    }

    protected int[] getAncestorIDs(int objectId) throws CMCacheException {
        return this.store_.getCache().CMCacheGetAncestorObjects(objectId);
    }

    private void reset() {
        if (this.requiresAcquiredValue_ != null) {
            this.requiresAcquiredValue_.clear();
        }
        if (this.acquiredValueSubscribers_ != null) {
            this.acquiredValueSubscribers_.clear();
        }
        if (this.acquiredValues_ != null) {
            this.acquiredValues_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CMDbStoreAcquiredValue[] getValues(int[] ancestors) throws SQLException, CMCacheException, CMException {
        this.init();
        int oldestAncestorNotToGet = ancestors.length;
        CMDbStoreAcquiredValue[] lastValues = null;
        for (int ancestorIdx = 0; ancestorIdx != ancestors.length; ++ancestorIdx) {
            Integer key = new Integer(ancestors[ancestorIdx]);
            lastValues = this.cachedValues_.get(key);
            if (lastValues != null && !this.acquiredQuery_.retrievingLobs()) {
                if (ancestorIdx == 0) {
                    return lastValues;
                }
                oldestAncestorNotToGet = ancestorIdx;
                break;
            }
            int classID = this.store_.getCache().CMCacheGetClass(ancestors[ancestorIdx]);
            CMObjectClass objectClass = this.store_.getObjectClasses().getClassByID(classID);
            if (objectClass == null) {
                throw new IllegalStateException("CMDbStoreAquiredPropertiesHandler.getValues: Invalid classID (" + String.valueOf(classID) + ")");
            }
            boolean hasAtLeastOne = false;
            for (int propIdx = 0; propIdx < this.properties_.length && !hasAtLeastOne; ++propIdx) {
                hasAtLeastOne = hasAtLeastOne || this.store_.getProperty(this.properties_[propIdx].getName(), objectClass) != null;
            }
            if (hasAtLeastOne) continue;
            oldestAncestorNotToGet = ancestorIdx;
            break;
        }
        if (oldestAncestorNotToGet > 0) {
            int[] ancestorObjectIDs = ancestors;
            if (oldestAncestorNotToGet < ancestors.length) {
                ancestorObjectIDs = new int[oldestAncestorNotToGet];
                System.arraycopy(ancestors, 0, ancestorObjectIDs, 0, ancestorObjectIDs.length);
            }
            CMDbStoreAcquiredValue[][] results = new CMDbStoreAcquiredValue[ancestorObjectIDs.length][];
            ResultSet rs = this.acquiredQuery_.execute(this.store_.getConnection(), ancestorObjectIDs);
            try {
                while (rs.next()) {
                    int objectID = rs.getInt(1);
                    CMDbStoreAcquiredValue[] dataRow = null;
                    for (int ancestorPos = 0; ancestorPos != ancestorObjectIDs.length; ++ancestorPos) {
                        if (ancestorObjectIDs[ancestorPos] != objectID) continue;
                        dataRow = new CMDbStoreAcquiredValue[this.properties_.length];
                        results[ancestorPos] = dataRow;
                        break;
                    }
                    if (dataRow == null) {
                        throw new IllegalStateException("CMDbStoreAquiredPropertiesHandler.getValues: ancestor in result set does not match one of the ancestors being queried");
                    }
                    int offset = 2;
                    for (int propIdx = 0; propIdx != this.properties_.length; ++propIdx) {
                        CMDbProperty prop = (CMDbProperty)this.properties_[propIdx];
                        dataRow[propIdx] = new CMDbStoreAcquiredValue(CMDbStorePropertySerialization.getColumnByProperty(rs, propIdx + offset, prop), objectID);
                        offset += prop.columnCount() - 1;
                    }
                    this.cachedValues_.put(new Integer(objectID), dataRow);
                }
            }
            finally {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
            if (lastValues != null) {
                CMDbStoreAcquiredValue[] dataRow = results[oldestAncestorNotToGet - 1];
                for (int propIdx = 0; propIdx != this.properties_.length; ++propIdx) {
                    if (dataRow[propIdx].getValue() != null) continue;
                    dataRow[propIdx] = lastValues[propIdx];
                }
            }
            if (oldestAncestorNotToGet - 1 > 0) {
                for (int rowIdx = oldestAncestorNotToGet - 2; rowIdx >= 0; --rowIdx) {
                    CMDbStoreAcquiredValue[] childRow = results[rowIdx];
                    CMDbStoreAcquiredValue[] parentRow = results[rowIdx + 1];
                    if (childRow == null || parentRow == null) {
                        throw new CMException("cmFailedToReadAcquiredProperty");
                    }
                    for (int propIdx = 0; propIdx != this.properties_.length; ++propIdx) {
                        if (childRow[propIdx].getValue() != null) continue;
                        childRow[propIdx] = parentRow[propIdx];
                    }
                }
            }
            if (results[0] != null && this.acquiredQuery_.retrievingLobs() && AdvancedSettings.ENABLEDB2PATCH2FIX) {
                CMDbStoreAcquiredValue[] resultValues = results[0];
                results[0] = this.readLOBValues(resultValues);
            }
            return results[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMDbStoreAcquiredValue[] readLOBValues(CMDbStoreAcquiredValue[] resultValues) throws SQLException, CMException {
        this.init();
        ResultSet rs = null;
        int foundLOBPropertyIdx = -1;
        ArrayList<CMProperty> lobProperties = new ArrayList<CMProperty>(this.properties_.length);
        BitSet fetched = new BitSet(this.properties_.length);
        do {
            foundLOBPropertyIdx = -1;
            lobProperties.clear();
            int[] lobValueIdx = new int[this.properties_.length];
            int nextLobValueIdx = 0;
            for (int propIdx = 0; propIdx != this.properties_.length; ++propIdx) {
                CMDbProperty dbProperty;
                if (fetched.get(propIdx) || !(this.properties_[propIdx] instanceof CMDbProperty) || !(dbProperty = (CMDbProperty)this.properties_[propIdx]).storedAsBlob() || resultValues[propIdx].getValue() == null) continue;
                if (foundLOBPropertyIdx < 0) {
                    foundLOBPropertyIdx = propIdx;
                    lobProperties.add(this.properties_[propIdx]);
                    fetched.set(propIdx);
                    lobValueIdx[nextLobValueIdx++] = propIdx;
                    continue;
                }
                if (resultValues[propIdx].getAcquiredFrom() != resultValues[foundLOBPropertyIdx].getAcquiredFrom()) continue;
                lobProperties.add(this.properties_[propIdx]);
                fetched.set(propIdx);
                lobValueIdx[nextLobValueIdx++] = propIdx;
            }
            if (foundLOBPropertyIdx < 0) continue;
            CMProperty[] aProps = new CMProperty[lobProperties.size()];
            lobProperties.toArray(aProps);
            CMDbStoreSelectDef lobSelectDef = new CMDbStoreSelectDef(this.store_.getConnection(), null, aProps, null);
            int[] lobObjectIDs = new int[]{resultValues[foundLOBPropertyIdx].getAcquiredFrom()};
            nextLobValueIdx = 0;
            rs = lobSelectDef.execute(this.store_.getConnection(), lobObjectIDs);
            try {
                while (rs.next()) {
                    int offset = 2;
                    for (int lobIdx = 0; lobIdx != aProps.length; ++lobIdx) {
                        CMDbProperty prop = (CMDbProperty)aProps[lobIdx];
                        Object inValue = CMDbStorePropertySerialization.getColumnByProperty(rs, lobIdx + offset, prop);
                        Object outValue = null;
                        if (inValue != null) {
                            try {
                                outValue = CMDbStoreAcquiredPropertiesHandler.readLobIntoMemory(inValue);
                            }
                            catch (IOException e) {
                                throw new CMException((Exception)e, "cmFailedToReadAcquiredLobProperty", new CMException.Parm("Property", prop.getName()));
                            }
                            finally {
                                if (inValue instanceof Reader) {
                                    CMStreamUtils.quietClose((Reader)((Reader)inValue));
                                } else if (inValue instanceof InputStream) {
                                    CMStreamUtils.quietClose((InputStream)((InputStream)inValue));
                                }
                            }
                        }
                        resultValues[lobValueIdx[nextLobValueIdx++]].setValue(outValue);
                        offset += prop.columnCount() - 1;
                    }
                }
            }
            finally {
                CMDbStoreUtil.safeCloseStatementViaResultSet(rs);
            }
        } while (foundLOBPropertyIdx >= 0);
        return resultValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object readLobIntoMemory(Object in) throws IOException {
        Object out = in;
        if (in instanceof Reader) {
            Reader reader = (Reader)in;
            String s = CMStreamUtils.readReaderIntoString((Reader)reader);
            out = new StringReader(s);
        } else if (in instanceof InputStream) {
            CMTempOutputStream tempOutStream = null;
            try {
                tempOutStream = new CMTempOutputStream();
                CMStreamUtils.copyStream((InputStream)((InputStream)in), (OutputStream)tempOutStream);
            }
            finally {
                if (tempOutStream != null) {
                    try {
                        tempOutStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            out = tempOutStream.getInputStream();
        }
        return out;
    }

    protected void addMapping(CMDbProperty fromProp, CMDbProperty toProp) {
        this.mappedProperties.put(fromProp, toProp);
    }

    private CMProperty getMappedProperty(CMProperty prop) {
        CMProperty mappedProp = this.mappedProperties.get(prop);
        if (mappedProp == null) {
            mappedProp = prop;
        }
        return mappedProp;
    }
}

