/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreAddDef;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMIDBasedReferencesUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class CMDbStoreAddArrayDef
extends CMDbStoreAddDef {
    public CMDbStoreAddArrayDef(String tableName) {
        super(tableName);
    }

    protected final void setBlobProperties(ResultSet rs, Object value) throws SQLException, CMException {
        int bindPos = 0;
        for (int i = 0; i != this.numBlobs_; ++i) {
            CMDbStorePropertySerialization.bindParameterByProperty(rs, ++bindPos, this.properties_[this.blobProps_[i]], value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CMDbConnection con, int objectID) throws SQLException, CMException {
        if (this.numProps_ <= 0) {
            return;
        }
        CMDbProperty firstProperty = this.properties_[0];
        int bindOffset = 2;
        StringBuffer stmt = new StringBuffer(500);
        StringBuffer values = new StringBuffer(100);
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        sqlGenerator.appendInsertIntoTableWithCMID(this.tableName_, stmt);
        sqlGenerator.appendValuesForInsertIntoTableWithCMID(values);
        int ORDColIdx = -1;
        int PROPIDColIdx = -1;
        if (firstProperty.hasOrdinal()) {
            stmt.append(sqlGenerator.createColumnsSeparator());
            stmt.append("ORD");
            sqlGenerator.appendBindParametersSeparatorAndSymbol(values);
            ORDColIdx = bindOffset++;
        }
        if (firstProperty.hasPropertyID()) {
            stmt.append(sqlGenerator.createColumnsSeparator());
            stmt.append("PROPID");
            sqlGenerator.appendBindParametersSeparatorAndSymbol(values);
            PROPIDColIdx = bindOffset++;
        }
        this.completeCommand(con, stmt, values, true, true);
        PreparedStatement insertStmt = null;
        PreparedStatement blobInsert = null;
        try {
            insertStmt = con.prepareStatement(stmt.toString());
            CMDbStoreDataSerializer serializer = null;
            if (this.numBlobs_ > 0) {
                StringBuffer blobInsertStmt = new StringBuffer();
                blobInsertStmt.append(this.generateBlobSelectWithBindForObject(con));
                if (firstProperty.hasPropertyID()) {
                    blobInsertStmt.append(sqlGenerator.createAndSql());
                    sqlGenerator.appendColumnEqualsBindParameterSymbol("PROPID", blobInsertStmt);
                }
                if (firstProperty.hasOrdinal()) {
                    blobInsertStmt.append(sqlGenerator.createAndSql());
                    sqlGenerator.appendColumnEqualsBindParameterSymbol("ORD", blobInsertStmt);
                }
                blobInsert = con.prepareStatement(blobInsertStmt.toString());
            }
            for (int propIdx = 0; propIdx < this.numProps_; ++propIdx) {
                Object value;
                int i;
                CMArrayPropertyValue arrayValue = (CMArrayPropertyValue)this.values_[propIdx];
                CMDbProperty property = this.properties_[propIdx];
                if ((arrayValue = (CMArrayPropertyValue)CMIDBasedReferencesUtils.getComplexTypeSubpropertyValue(arrayValue)) != null && arrayValue.getSize() != 0 && arrayValue instanceof CMDbStoreBaseClassArray) {
                    for (i = 0; i < arrayValue.getSize(); ++i) {
                        value = arrayValue.getItem(i);
                        if (value == null || !(value instanceof CMDbStoreObjectReference)) continue;
                        CMDbStoreObjectReference reference = (CMDbStoreObjectReference)value;
                        if (property.columnCount() >= 2) {
                            CMObjectClass refClass = reference.getObjectClass();
                            if (reference.getObjectID() < 0 && (refClass == CMObjectClass.ACCOUNT || refClass == CMObjectClass.GROUP || refClass == CMObjectClass.ROLE || refClass == null)) {
                                throw new CMException("cmAddReferenceFailed", new CMException.Parm("Property", property.getName()), new CMException.Parm("path", reference.getSearchPath()));
                            }
                        }
                        if (!property.isStoreIDBased() || reference.getObjectID() >= 0) continue;
                        throw new CMException("cmAddReferenceFailed", new CMException.Parm("Property", property.getName()), new CMException.Parm("path", reference.getSearchPath()));
                    }
                }
                if (arrayValue == null || arrayValue.getSize() == 0) continue;
                for (i = 0; i < arrayValue.getSize(); ++i) {
                    ResultSet rs;
                    value = arrayValue.getItem(i);
                    if (value == null && property.isStoreIDBased()) continue;
                    insertStmt.setInt(1, objectID);
                    if (property.hasOrdinal()) {
                        insertStmt.setInt(ORDColIdx, i);
                    }
                    if (property.hasPropertyID()) {
                        insertStmt.setInt(PROPIDColIdx, property.getPropertyID());
                    }
                    CMDbStorePropertySerialization.bindParameterByProperty(insertStmt, bindOffset, property, value);
                    if (this.numBlobs_ > 0) {
                        serializer = property.getDataSerializer();
                        insertStmt.setInt(bindOffset + property.columnCount() - 1, serializer.lobIsNull(value) ? 0 : 1);
                    }
                    CMDbConnection.executeUpdate(insertStmt);
                    if (blobInsert == null) continue;
                    blobInsert.setInt(1, objectID);
                    if (property.hasOrdinal()) {
                        blobInsert.setInt(ORDColIdx, i);
                    }
                    if (property.hasPropertyID()) {
                        blobInsert.setInt(PROPIDColIdx, i);
                    }
                    if (!(rs = blobInsert.executeQuery()).next()) continue;
                    this.setBlobProperties(rs, value);
                }
            }
        }
        catch (Throwable throwable) {
            CMDbStoreUtil.safeCloseStatement(insertStmt);
            CMDbStoreUtil.safeCloseStatement(blobInsert);
            throw throwable;
        }
        CMDbStoreUtil.safeCloseStatement(insertStmt);
        CMDbStoreUtil.safeCloseStatement(blobInsert);
    }
}

