/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDMLDef;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.server.CMException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class CMDbStoreAddDef
extends CMDbStoreDMLDef {
    protected int numBlobs_;
    protected int[] blobProps_;

    public CMDbStoreAddDef(String tableName) {
        super(tableName);
    }

    protected final void completeCommand(CMDbConnection con, StringBuffer stmt, StringBuffer values, boolean optionalLOB) {
        this.completeCommand(con, stmt, values, optionalLOB, false);
    }

    protected final void completeCommand(CMDbConnection con, StringBuffer stmt, StringBuffer values, boolean optionalLOB, boolean firstPropertyOnly) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        if (this.numProps_ > 0) {
            int equalSign;
            int numProps = firstPropertyOnly ? 1 : this.numProps_;
            for (int i = 0; i < numProps; ++i) {
                CMDbProperty currentProp = this.properties_[i];
                Object value = this.values_[i];
                int colCount = currentProp.columnCount();
                for (int colIdx = 0; colIdx != colCount; ++colIdx) {
                    CMDbColumn currentCol = currentProp.getColumn(colIdx);
                    CMDbStoreDataSerializer serializer = currentProp.getDataSerializer();
                    stmt.append(sqlGenerator.createColumnsSeparator());
                    stmt.append(currentCol.getName());
                    if (currentCol.isLob() && CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver() && (optionalLOB || !serializer.lobIsNull(value)) && !currentProp.isExternalizable()) {
                        if (this.numBlobs_ == 0) {
                            this.blobProps_ = new int[this.numProps_];
                        }
                        this.blobProps_[this.numBlobs_++] = i;
                        if (optionalLOB) {
                            values.append(sqlGenerator.createBindParametersSeparator());
                            values.append(sqlGenerator.createCase1EqualsThenSql());
                            sqlGenerator.appendEmptyLob(currentCol.getDbType(), values);
                            values.append(sqlGenerator.createElseNullEndSql());
                            continue;
                        }
                        values.append(sqlGenerator.createBindParametersSeparator());
                        sqlGenerator.appendEmptyLob(currentCol.getDbType(), values);
                        continue;
                    }
                    sqlGenerator.appendBindParametersSeparatorAndSymbol(values);
                }
            }
            String filter = CMDbStoreUtil.substituteVars(this.properties_[0].getFilter(), null, null);
            if (filter != null && filter.length() > 0 && (equalSign = filter.indexOf(61)) > 0) {
                stmt.append(sqlGenerator.createColumnsSeparator());
                stmt.append(filter.substring(0, equalSign));
                values.append(sqlGenerator.createBindParametersSeparator());
                values.append(filter.substring(equalSign + 1));
            }
        }
        stmt.append(sqlGenerator.createClosingBracket());
        stmt.append(values);
        stmt.append(sqlGenerator.createClosingBracket());
    }

    protected final void generateBlobSelect(CMDbConnection con, StringBuffer stmt) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        stmt.append(sqlGenerator.createSelectSql());
        for (int i = 0; i != this.numBlobs_; ++i) {
            CMDbProperty currentProp = this.properties_[this.blobProps_[i]];
            int colCount = currentProp.columnCount();
            for (int colIdx = 0; colIdx != colCount; ++colIdx) {
                CMDbColumn currentCol = currentProp.getColumn(colIdx);
                if (!currentCol.isLob()) continue;
                if (i > 0) {
                    stmt.append(sqlGenerator.createColumnsSeparator());
                }
                stmt.append(currentCol.getName());
            }
        }
        stmt.append(sqlGenerator.createFromSql());
        stmt.append(this.tableName_);
    }

    protected final String generateBlobSelectWithBindForObject(CMDbConnection con) {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        StringBuffer stmt = new StringBuffer(1024);
        this.generateBlobSelect(con, stmt);
        stmt.append(sqlGenerator.createWhereSql());
        sqlGenerator.appendColumnEqualsBindParameterSymbol("CMID", stmt);
        return stmt.toString();
    }

    protected final void setBlobProperties(ResultSet rs) throws SQLException, CMException {
        int bindPos = 0;
        for (int i = 0; i != this.numBlobs_; ++i) {
            CMDbStorePropertySerialization.bindParameterByProperty(rs, ++bindPos, this.properties_[this.blobProps_[i]], this.values_[this.blobProps_[i]]);
        }
    }

    protected final void bindParameters(PreparedStatement stmt, int parmOffset) throws SQLException, CMException {
        int paramPos = parmOffset;
        for (int i = 0; i < this.numProps_; ++i) {
            boolean boundBlob = false;
            if (this.blobProps_ != null && this.properties_[i].storedAsBlob()) {
                for (int j = 0; j < this.numBlobs_; ++j) {
                    if (this.blobProps_[j] != i) continue;
                    boundBlob = true;
                    break;
                }
            }
            if (!boundBlob) {
                this.bindParameter(stmt, paramPos, this.properties_[i], this.values_[i]);
            }
            paramPos += this.properties_[i].columnCount() - (boundBlob ? 1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CMDbConnection con, int objectID) throws SQLException, CMException {
        PreparedStatement blobStmt;
        PreparedStatement insertStmt;
        block3: {
            StringBuffer stmt = new StringBuffer(500);
            StringBuffer values = new StringBuffer(100);
            ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
            sqlGenerator.appendInsertIntoTableWithCMID(this.tableName_, stmt);
            sqlGenerator.appendValuesForInsertIntoTableWithCMID(values);
            this.completeCommand(con, stmt, values, false);
            insertStmt = null;
            blobStmt = null;
            try {
                insertStmt = con.prepareStatement(stmt.toString());
                insertStmt.setInt(1, objectID);
                this.bindParameters(insertStmt, 2);
                CMDbConnection.executeUpdate(insertStmt);
                insertStmt.close();
                insertStmt = null;
                if (this.numBlobs_ <= 0) break block3;
                blobStmt = con.prepareStatement(this.generateBlobSelectWithBindForObject(con));
                blobStmt.setInt(1, objectID);
                ResultSet rs = blobStmt.executeQuery();
                if (rs.next()) {
                    this.setBlobProperties(rs);
                }
            }
            catch (Throwable throwable) {
                CMDbStoreUtil.safeCloseStatement(insertStmt);
                CMDbStoreUtil.safeCloseStatement(blobStmt);
                throw throwable;
            }
        }
        CMDbStoreUtil.safeCloseStatement(insertStmt);
        CMDbStoreUtil.safeCloseStatement(blobStmt);
    }
}

