/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;

public class CMDbStoreAddResults
implements CMStoreQueryResults {
    private CMDbStore store_;
    private int objectId_ = -1;
    private int[] objectIds_;
    private int index_;

    public CMDbStoreAddResults(CMDbStore store, int objectId) {
        this.objectIds_ = new int[1];
        this.objectIds_[0] = objectId;
        this.store_ = store;
        this.objectId_ = -1;
        this.index_ = -1;
    }

    public CMDbStoreAddResults(CMDbStore store, int[] objectIds) {
        this.objectIds_ = objectIds;
        this.store_ = store;
        this.objectId_ = -1;
        this.index_ = -1;
    }

    @Override
    public boolean next() throws CMException {
        ++this.index_;
        if (this.objectIds_ == null || this.index_ >= this.objectIds_.length) {
            return false;
        }
        this.objectId_ = this.objectIds_[this.index_];
        return true;
    }

    @Override
    public Object getValue(int index) throws CMException {
        throw new IllegalStateException("getValue cannot be called on CMDbStoreAddResults");
    }

    @Override
    public Object getValue(CMProperty prop) throws CMException {
        throw new IllegalStateException("getValue cannot be called on CMDbStoreAddResults");
    }

    @Override
    public boolean wasAcquired() {
        return false;
    }

    @Override
    public int getObjectID() {
        return this.objectId_;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public String getSearchPath() {
        if (this.objectId_ < 0) {
            return null;
        }
        try {
            return this.store_.getCache().CMCacheGetSearchPath(this.objectId_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public String getSecurityReference() {
        if (this.objectId_ < 0) {
            return null;
        }
        try {
            return this.store_.getCache().CMCacheGetSecurityReference(this.objectId_);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public int getParentObjectID() {
        int parentID = this.store_.getCache().CMCacheGetIntegerProperty(this.objectId_, 5);
        return parentID;
    }

    @Override
    public String getParentSearchPath() {
        try {
            int parentID = this.store_.getCache().CMCacheGetIntegerProperty(this.objectId_, 5);
            return this.store_.getCache().CMCacheGetSearchPath(parentID, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException e) {
            CMException cmex = new CMException((Exception)e, "cmErrCacheAddRollBack", new CMException.Parm("Location", "CacheObjects.getSearchPath"));
            CMIndications.logException(cmex);
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.objectId_ < 0) {
            return null;
        }
        try {
            return this.store_.getCache().CMCacheGetName(this.objectId_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public CMObjectClass getObjectClass() {
        if (this.objectId_ < 0) {
            return null;
        }
        try {
            int classId = this.store_.getCache().CMCacheGetClass(this.objectId_);
            return this.store_.getObjectClasses().getClassByID(classId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public int getTenantID() {
        if (this.objectId_ < 0) {
            return 0;
        }
        return this.store_.getCache().CMCacheGetTenantID(this.objectId_);
    }

    @Override
    public boolean hasPermission(String permission) {
        return false;
    }

    @Override
    public boolean hasExternalProperty(CMProperty property) {
        throw new IllegalStateException("hasExternalProperty cannot be called on CMDbStoreAddResults");
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public void exclude() {
    }

    @Override
    public void reset() {
        this.index_ = -1;
    }

    @Override
    public void release() {
        this.index_ = -1;
    }

    @Override
    public void rewind() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsRewind() {
        return false;
    }

    @Override
    public CMAncestors getAncestors() {
        try {
            return this.store_.getCache().getAncestors(this.objectId_, CMDbStoreCacheUtil.getCacheSearchLocales());
        }
        catch (CMCacheException ex) {
            return null;
        }
        catch (CMException ex) {
            return null;
        }
    }

    @Override
    public boolean supportsSkipObjects() {
        return false;
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }
}

