/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbColumn;
import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.CMDbStoreDeleteDef;
import com.cognos.cm.dbstore.CMDbStorePropertySerialization;
import com.cognos.cm.dbstore.CMDbStoreUpdateDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.util.CMIDBasedReferencesUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CMDbStoreArrayTableUpdateDef
extends CMDbStoreUpdateDef {
    private int bindPropIdx_ = -1;
    private int bindValueIdx_ = -1;
    private int ORDIdx_ = -1;
    private int PROPIDIdx_ = -1;
    private int bindOffset_ = 1;
    private int blobParmIdx_ = -1;

    public CMDbStoreArrayTableUpdateDef(String table) {
        super(table);
    }

    @Override
    void execute(CMDbConnection con, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        int[] objectIDs = new int[]{objectID};
        this.execute(con, objectIDs);
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, int objectID) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    @Override
    void execute(CMDbConnection con, String additionToSetClause, String additionToWhereClause, int[] objectIDs) throws SQLException, CMException, CMStoreUnexpected {
        throw new IllegalStateException("Function is not implemented");
    }

    @Override
    void execute(CMDbConnection con, int[] objectIDs) throws SQLException, CMException {
        CMDbProperty prop;
        int propIdx;
        int equalSign;
        String filter;
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        if (this.numProps_ == 0) {
            return;
        }
        CMDbProperty firstProp = this.properties_[0];
        StringBuffer insertSQL = new StringBuffer(1024);
        StringBuffer parmList = new StringBuffer(this.numProps_ * 2);
        insertSQL.append(sqlGenerator.createInsertIntoTableWithCMIDSql(this.getTableName()));
        this.bindOffset_ = 1;
        if (firstProp.hasOrdinal()) {
            insertSQL.append(sqlGenerator.createColumnsSeparator());
            insertSQL.append("ORD");
            sqlGenerator.appendBindParametersSeparatorAndIntegerSymbol(parmList);
            this.ORDIdx_ = this.bindOffset_++;
        }
        if (firstProp.hasPropertyID()) {
            insertSQL.append(sqlGenerator.createColumnsSeparator());
            insertSQL.append("PROPID");
            sqlGenerator.appendBindParametersSeparatorAndIntegerSymbol(parmList);
            this.PROPIDIdx_ = this.bindOffset_++;
        }
        if (firstProp.getFilter().length() > 0 && (filter = CMDbStoreUtil.substituteVars(firstProp.getFilter(), null, null)) != null && filter.length() > 0 && (equalSign = filter.indexOf("=")) > 0) {
            insertSQL.append(sqlGenerator.createColumnsSeparator());
            insertSQL.append(filter.substring(0, equalSign));
            parmList.append(sqlGenerator.createBindParametersSeparator());
            parmList.append(filter.substring(equalSign + 1));
        }
        this.blobParmIdx_ = -1;
        int numParms = 0;
        int numColumnProps = firstProp.isStoreIDBased() ? 1 : this.numProps_;
        for (propIdx = 0; propIdx != numColumnProps; ++propIdx) {
            prop = this.properties_[propIdx];
            for (int colIdx = 0; colIdx != prop.columnCount(); ++colIdx) {
                ++numParms;
                insertSQL.append(sqlGenerator.createColumnsSeparator());
                CMDbColumn col = prop.getColumn(colIdx);
                insertSQL.append(col.getName());
                sqlGenerator.appendBindParameterSymbolWithCast(col.getDbType(), col.getLength(), col.isLob(), parmList);
                if (CMDbConnection.dbms_ != 2 || !CMDbConnection.getDbmsInfo().getIsThinDriver() || !col.isLob() || prop.isExternalizable()) continue;
                this.blobParmIdx_ = numParms - 1;
            }
        }
        insertSQL.append(sqlGenerator.createClosingBracket());
        insertSQL.append(sqlGenerator.createSelectForInsertSql());
        insertSQL.append("CMID");
        insertSQL.append(parmList.toString());
        insertSQL.append(sqlGenerator.createFromSql());
        insertSQL.append("CMOBJECTS");
        insertSQL.append(sqlGenerator.createWhereSql());
        for (propIdx = 0; propIdx != this.numProps_; ++propIdx) {
            prop = this.properties_[propIdx];
            CMArrayPropertyValue values = (CMArrayPropertyValue)this.values_[propIdx];
            if ((values = (CMArrayPropertyValue)CMIDBasedReferencesUtils.getComplexTypeSubpropertyValue(values)) != null && values.getSize() != 0 && values instanceof CMDbStoreBaseClassArray) {
                CMDbStoreBaseClassArray dbValues = (CMDbStoreBaseClassArray)values;
                if (prop.isStoreIDBased()) {
                    for (int i = 0; i < dbValues.getSize(); ++i) {
                        CMDbStoreObjectReference reference = (CMDbStoreObjectReference)dbValues.getReference(i);
                        if (reference == null || reference.getObjectID() >= 0) continue;
                        throw new CMException("cmAddReferenceFailed", new CMException.Parm("Property", prop.getName()), new CMException.Parm("path", reference.getSearchPath()));
                    }
                }
            }
            this.clearExistingEntries(con, objectIDs, prop);
        }
        this.bindPropIdx_ = -1;
        this.bindValueIdx_ = -1;
        this.executeNTimesInGroups(con, insertSQL.toString(), objectIDs, null);
        this.postExecute(con);
    }

    @Override
    protected void resetBindParameters() throws SQLException {
        this.bindPropIdx_ = -1;
        this.bindValueIdx_ = -1;
        this.blobStmts_ = null;
    }

    private void nextProperty() {
        this.bindPropIdx_ = this.bindPropIdx_ < 0 ? 0 : ++this.bindPropIdx_;
        this.bindValueIdx_ = 0;
        this.blobStmts_ = null;
    }

    @Override
    protected boolean executeNTimesInGroupsNext(CMDbConnection con) throws SQLException, CMException {
        CMDbProperty prop = null;
        CMArrayPropertyValue values = null;
        if (this.bindPropIdx_ < 0) {
            this.nextProperty();
        } else {
            ++this.bindValueIdx_;
        }
        boolean bFound = false;
        while (!bFound && this.bindPropIdx_ < this.numProps_) {
            if (this.bindValueIdx_ > 0 && this.bindValueIdx_ >= ((CMArrayPropertyValue)this.values_[this.bindPropIdx_]).getSize()) {
                this.nextProperty();
            }
            if (this.bindValueIdx_ == 0) {
                while (this.bindPropIdx_ < this.numProps_ && (this.values_[this.bindPropIdx_] == null || ((CMArrayPropertyValue)this.values_[this.bindPropIdx_]).getSize() == 0)) {
                    this.nextProperty();
                }
            }
            if (this.bindPropIdx_ < this.numProps_ && this.properties_[this.bindPropIdx_].isStoreIDBased()) {
                prop = this.properties_[this.bindPropIdx_];
                values = (CMArrayPropertyValue)this.values_[this.bindPropIdx_];
                values = (CMArrayPropertyValue)CMIDBasedReferencesUtils.getComplexTypeSubpropertyValue(values);
                while (this.bindValueIdx_ < values.getSize() && values.getItem(this.bindValueIdx_) == null) {
                    ++this.bindValueIdx_;
                }
            }
            if (this.bindPropIdx_ >= this.numProps_ || this.bindValueIdx_ >= ((CMArrayPropertyValue)this.values_[this.bindPropIdx_]).getSize()) continue;
            bFound = true;
        }
        if (this.bindPropIdx_ < this.numProps_) {
            if (prop == null) {
                prop = this.properties_[this.bindPropIdx_];
            }
            if (values == null) {
                values = (CMArrayPropertyValue)this.values_[this.bindPropIdx_];
                values = (CMArrayPropertyValue)CMIDBasedReferencesUtils.getComplexTypeSubpropertyValue(values);
            }
            if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver() && prop.storedAsBlob() && this.blobStmts_ == null && !prop.isExternalizable()) {
                CMDbStoreDataSerializer serializer = prop.getDataSerializer();
                this.blobStmts_ = new Integer[values.getSize()];
                int valueCount = values.getSize();
                for (int valueIdx = 0; valueIdx != valueCount; ++valueIdx) {
                    Object entryValue = values.getItem(valueIdx);
                    if (serializer.lobIsNull(entryValue)) continue;
                    this.blobStmts_[valueIdx] = con.storeTempBlob(prop, entryValue);
                }
            }
        }
        return this.bindPropIdx_ < this.numProps_;
    }

    @Override
    protected int bindParametersNext(int bindOffset, PreparedStatement stmt) throws SQLException, CMException {
        int nextBindOffset = bindOffset;
        if (this.bindPropIdx_ < 0 || this.bindValueIdx_ < 0 || this.bindPropIdx_ >= this.numProps_ || this.values_[this.bindPropIdx_] == null || ((CMArrayPropertyValue)this.values_[this.bindPropIdx_]).getSize() == 0 || this.bindValueIdx_ >= ((CMArrayPropertyValue)this.values_[this.bindPropIdx_]).getSize()) {
            throw new IllegalStateException("No next bind value");
        }
        if (bindOffset != 1) {
            throw new IllegalStateException("Cannot handle bind offset");
        }
        CMDbProperty prop = this.properties_[this.bindPropIdx_];
        CMArrayPropertyValue values = (CMArrayPropertyValue)this.values_[this.bindPropIdx_];
        Object value = (values = (CMArrayPropertyValue)CMIDBasedReferencesUtils.getComplexTypeSubpropertyValue(values)).getItem(this.bindValueIdx_);
        if (value == null && prop.isStoreIDBased()) {
            throw new IllegalStateException("Null value item was not skipped for ID-based property.");
        }
        if (prop.hasOrdinal()) {
            stmt.setInt(this.ORDIdx_, this.bindValueIdx_);
        }
        if (prop.hasPropertyID()) {
            stmt.setInt(this.PROPIDIdx_, prop.getPropertyID());
        }
        nextBindOffset = CMDbStorePropertySerialization.bindParameterByProperty(stmt, this.bindOffset_, prop, value);
        if (this.blobParmIdx_ >= 0) {
            Integer blobStmt = this.blobStmts_[this.bindValueIdx_];
            if (blobStmt != null) {
                stmt.setInt(this.bindOffset_ + this.blobParmIdx_, blobStmt);
            } else {
                stmt.setNull(this.bindOffset_ + this.blobParmIdx_, 4);
            }
        }
        return nextBindOffset;
    }

    void clearExistingEntries(CMDbConnection con, int[] objectIDs, CMDbProperty prop) throws SQLException, CMException {
        ICMDbStoreSqlGenerator sqlGenerator = con.getSqlGenerator();
        StringBuffer buffer = new StringBuffer();
        boolean bBufferIsEmpty = true;
        CMDbStoreDeleteDef deleteDef = new CMDbStoreDeleteDef(this.getTableName());
        if (prop.getFilter().length() > 0) {
            buffer.append(CMDbStoreUtil.substituteVars(prop.getFilter(), null, null));
            bBufferIsEmpty = false;
        }
        if (prop.hasPropertyID()) {
            if (!bBufferIsEmpty) {
                buffer.append(sqlGenerator.createAndSql());
            }
            sqlGenerator.appendColumnEqualsBindParameterSymbol("PROPID", buffer);
            deleteDef.addBindVariable(new Integer(prop.getPropertyID()));
            bBufferIsEmpty = false;
        }
        deleteDef.execute(con, bBufferIsEmpty ? null : buffer.toString(), objectIDs);
    }

    void postExecute(CMDbConnection con) throws SQLException {
    }
}

